/*
 * Decompiled with CFR 0.152.
 */
package nl.lxtreme.ols.io.serial;

import java.io.Closeable;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.Flushable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.microedition.io.CommConnection;
import purejavacomm.SerialPort;

final class CommConnectionImpl
implements CommConnection {
    private static final Logger LOG = Logger.getLogger(CommConnectionImpl.class.getName());
    private volatile InputStream is;
    private volatile OutputStream os;
    private SerialPort port;

    public CommConnectionImpl(SerialPort aPort) throws IllegalArgumentException {
        if (aPort == null) {
            throw new IllegalArgumentException("Port cannot be null!");
        }
        this.port = aPort;
    }

    private static boolean closeResource(Closeable aResource) {
        boolean result = false;
        if (aResource != null) {
            try {
                if (aResource instanceof Flushable) {
                    ((Flushable)((Object)aResource)).flush();
                }
            }
            catch (IOException exception) {
                LOG.log(Level.WARNING, "I/O exception during flush!", exception);
            }
            finally {
                try {
                    aResource.close();
                    result = true;
                }
                catch (IOException exception) {
                    LOG.log(Level.WARNING, "I/O exception during close!", exception);
                }
            }
        }
        return result;
    }

    @Override
    public void close() throws IOException {
        try {
            CommConnectionImpl.closeResource(this.is);
            CommConnectionImpl.closeResource(this.os);
            if (this.port != null) {
                this.port.close();
            }
        }
        finally {
            this.is = null;
            this.os = null;
            this.port = null;
        }
    }

    @Override
    public int getBaudRate() {
        return this.port.getBaudRate();
    }

    @Override
    public DataInputStream openDataInputStream() throws IOException {
        return new DataInputStream(this.openInputStream());
    }

    @Override
    public DataOutputStream openDataOutputStream() throws IOException {
        return new DataOutputStream(this.openOutputStream());
    }

    @Override
    public InputStream openInputStream() throws IOException {
        if (this.is != null) {
            return this.is;
        }
        this.is = this.port.getInputStream();
        return this.is;
    }

    @Override
    public OutputStream openOutputStream() throws IOException {
        if (this.os != null) {
            return this.os;
        }
        this.os = this.port.getOutputStream();
        return this.os;
    }

    @Override
    public int setBaudRate(int aBaudRate) {
        int oldBaudRate = this.getBaudRate();
        return oldBaudRate;
    }
}

