/*
 * Decompiled with CFR 0.152.
 */
package nl.lxtreme.ols.io.socket;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

final class SocketOptions {
    private static final Pattern SCHEMA_REGEX = Pattern.compile("^socket:(?://)?([^:;]*)(?::(\\d+))?(?:;([^\\r\\n]+))*$");
    private static final Pattern OPTION_REGEX = Pattern.compile("(timeout)=([\\.\\d\\w_-]+)", 2);
    private String address = null;
    private int port;
    private int timeout = 0;

    public SocketOptions(String aURI) throws IllegalArgumentException {
        this.parseURI(aURI);
    }

    public String getAddress() {
        return this.address;
    }

    public int getPort() {
        return this.port;
    }

    public int getTimeout() {
        return this.timeout;
    }

    public boolean hasTimeout() {
        return this.timeout > 0;
    }

    public boolean isRemoteSocket() {
        return this.address != null && !this.address.trim().isEmpty();
    }

    private int parseTimeout(String aStr) {
        int result = 0;
        try {
            result = Integer.parseInt(aStr);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return result;
    }

    private void parseURI(String aURI) throws IllegalArgumentException {
        String options;
        String portValue;
        if (aURI == null) {
            throw new IllegalArgumentException("URI cannot be null!");
        }
        Matcher schemaMatcher = SCHEMA_REGEX.matcher(aURI);
        if (!schemaMatcher.matches()) {
            throw new IllegalArgumentException("URI invalid!");
        }
        String addressValue = schemaMatcher.group(1);
        if (addressValue != null && !addressValue.isEmpty()) {
            this.address = addressValue;
        }
        if ((portValue = schemaMatcher.group(2)) != null && !portValue.isEmpty()) {
            this.port = Integer.parseInt(portValue) & 0xFFFF;
        }
        if ((options = schemaMatcher.group(3)) == null || options.trim().isEmpty()) {
            return;
        }
        Matcher optionMatcher = OPTION_REGEX.matcher(options);
        while (optionMatcher.find()) {
            int parsedValue;
            String key = optionMatcher.group(1).toLowerCase();
            String value = optionMatcher.group(2);
            if (!"timeout".equals(key) || (parsedValue = this.parseTimeout(value)) < 0) continue;
            this.timeout = parsedValue;
        }
    }
}

