/*
 * Decompiled with CFR 0.152.
 */
package org.noos.xing.mydoggy.plaf.actions;

import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import org.noos.xing.mydoggy.ToolWindow;
import org.noos.xing.mydoggy.ToolWindowAction;
import org.noos.xing.mydoggy.ToolWindowAnchor;
import org.noos.xing.mydoggy.ToolWindowType;
import org.noos.xing.mydoggy.plaf.actions.PlafToolWindowAction;
import org.noos.xing.mydoggy.plaf.ui.util.DynamicPropertyChangeListener;
import org.noos.xing.mydoggy.plaf.ui.util.SwingUtil;

public class MoveToToolWindowAction
extends ToolWindowAction
implements PlafToolWindowAction {
    protected JMenu moveTo;
    protected JMenuItem right;
    protected JMenuItem left;
    protected JMenuItem top;
    protected JMenuItem bottom;
    protected PropertyChangeListener propertyChangeListener;

    public MoveToToolWindowAction() {
        super("MOVE_TO_ACTION_ID");
        this.setTooltipText(SwingUtil.getString("@@tool.tooltip.floatingLive"));
        this.setVisibleOnMenuBar(true);
        this.setVisibleOnTitleBar(false);
    }

    public void setToolWindow(ToolWindow toolWindow) {
        if (toolWindow == null) {
            this.toolWindow.getTypeDescriptor(ToolWindowType.FLOATING_LIVE).removePropertyChangeListener("enabled", this.propertyChangeListener);
            this.propertyChangeListener = null;
            super.setToolWindow(toolWindow);
        } else {
            super.setToolWindow(toolWindow);
            this.propertyChangeListener = new PropertyListener();
            this.setActionName("toolWindow.popup.floatingLive." + toolWindow.getId());
            toolWindow.getTypeDescriptor(ToolWindowType.FLOATING_LIVE).addPropertyChangeListener("enabled", this.propertyChangeListener);
        }
    }

    public void actionPerformed(ActionEvent e) {
        String actionCommand = e.getActionCommand();
        if ("move.right".equals(actionCommand)) {
            this.toolWindow.setAnchor(ToolWindowAnchor.RIGHT);
        } else if ("move.left".equals(actionCommand)) {
            this.toolWindow.setAnchor(ToolWindowAnchor.LEFT);
        } else if ("move.top".equals(actionCommand)) {
            this.toolWindow.setAnchor(ToolWindowAnchor.TOP);
        } else if ("move.bottom".equals(actionCommand)) {
            this.toolWindow.setAnchor(ToolWindowAnchor.BOTTOM);
        }
    }

    public JMenuItem getMenuItem() {
        if (this.moveTo == null) {
            this.moveTo = new JMenu();
            this.moveTo.getPopupMenu().setLightWeightPopupEnabled(false);
            this.moveTo.setText(SwingUtil.getString("@@tool.moveTo"));
            this.right = new JMenuItem();
            this.right.setText(SwingUtil.getString("@@tool.move.right"));
            this.right.setActionCommand("move.right");
            this.right.addActionListener(this);
            this.left = new JMenuItem();
            this.left.setText(SwingUtil.getString("@@tool.move.left"));
            this.left.setActionCommand("move.left");
            this.left.addActionListener(this);
            this.top = new JMenuItem();
            this.top.setText(SwingUtil.getString("@@tool.move.top"));
            this.top.setActionCommand("move.top");
            this.top.addActionListener(this);
            this.bottom = new JMenuItem();
            this.bottom.setText(SwingUtil.getString("@@tool.move.bottom"));
            this.bottom.setActionCommand("move.bottom");
            this.bottom.addActionListener(this);
            this.moveTo.add(this.right);
            this.moveTo.add(this.left);
            this.moveTo.add(this.top);
            this.moveTo.add(this.bottom);
        }
        if (this.toolWindow.isLockedOnAnchor()) {
            ToolWindowAnchor[] anchors = this.toolWindow.getRepresentativeAnchorDescriptor().getLockingAnchors();
            if (anchors.length == 0) {
                this.moveTo.setVisible(false);
                return this.moveTo;
            }
            this.left.setVisible(false);
            this.right.setVisible(false);
            this.top.setVisible(false);
            this.bottom.setVisible(false);
            block6: for (ToolWindowAnchor anchor : anchors) {
                switch (anchor) {
                    case LEFT: {
                        this.left.setVisible(true);
                        continue block6;
                    }
                    case RIGHT: {
                        this.right.setVisible(true);
                        continue block6;
                    }
                    case TOP: {
                        this.top.setVisible(true);
                        continue block6;
                    }
                    case BOTTOM: {
                        this.bottom.setVisible(true);
                    }
                }
            }
        } else {
            ToolWindowAnchor anchor = this.toolWindow.getAnchor();
            if (anchor == ToolWindowAnchor.LEFT) {
                this.left.setVisible(false);
                this.right.setVisible(true);
                this.top.setVisible(true);
                this.bottom.setVisible(true);
            } else if (anchor == ToolWindowAnchor.RIGHT) {
                this.left.setVisible(true);
                this.right.setVisible(false);
                this.top.setVisible(true);
                this.bottom.setVisible(true);
            } else if (anchor == ToolWindowAnchor.BOTTOM) {
                this.left.setVisible(true);
                this.right.setVisible(true);
                this.top.setVisible(true);
                this.bottom.setVisible(false);
            } else if (anchor == ToolWindowAnchor.TOP) {
                this.left.setVisible(true);
                this.right.setVisible(true);
                this.top.setVisible(false);
                this.bottom.setVisible(true);
            }
        }
        return this.moveTo;
    }

    public class PropertyListener
    extends DynamicPropertyChangeListener {
        public void onEnabled(PropertyChangeEvent evt) {
            MoveToToolWindowAction.this.setVisibleOnMenuBar((Boolean)evt.getNewValue());
        }
    }
}

