/*
 * Decompiled with CFR 0.152.
 */
package org.noos.xing.mydoggy.plaf.ui.cmp;

import java.awt.Component;
import java.awt.datatransfer.Transferable;
import org.noos.xing.mydoggy.AggregationPosition;
import org.noos.xing.mydoggy.Content;
import org.noos.xing.mydoggy.ContentManager;
import org.noos.xing.mydoggy.Dockable;
import org.noos.xing.mydoggy.ToolWindowAnchor;
import org.noos.xing.mydoggy.plaf.MyDoggyToolWindowManager;
import org.noos.xing.mydoggy.plaf.ui.cmp.DockableDropPanel;
import org.noos.xing.mydoggy.plaf.ui.cmp.DockablePanel;
import org.noos.xing.mydoggy.plaf.ui.cmp.MultiSplitDockableContainer;
import org.noos.xing.mydoggy.plaf.ui.cmp.MultiSplitTabbedContentContainer;
import org.noos.xing.mydoggy.plaf.ui.cmp.TabbedContentPane;
import org.noos.xing.mydoggy.plaf.ui.cmp.event.TabbedContentPaneEvent;
import org.noos.xing.mydoggy.plaf.ui.cmp.event.TabbedContentPaneListener;
import org.noos.xing.mydoggy.plaf.ui.drag.MyDoggyTransferable;
import org.noos.xing.mydoggy.plaf.ui.util.SwingUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ContentWindowMultiSplitContainer
extends MultiSplitTabbedContentContainer<Content> {
    public ContentWindowMultiSplitContainer(MyDoggyToolWindowManager toolWindowManager) {
        super(toolWindowManager);
    }

    @Override
    protected DockableDropPanel createDockableDropPanel() {
        return new ContentWindowDockableDropPanel();
    }

    @Override
    protected boolean isWrapRequest(Dockable dockable, MultiSplitDockableContainer.Action action) {
        switch (action) {
            case ADD_DOCK: {
                if (this.getDockableCount() == 0) {
                    return false;
                }
                return this.getDockableCount() >= 1;
            }
            case REMOVE_DOCK: {
                if (this.getDockableCount() <= 1) {
                    return false;
                }
                return this.getDockableCount() > 1;
            }
        }
        return false;
    }

    @Override
    protected Component forceWrapperForComponent(Dockable dockable, Component component) {
        TabbedContentPane tabbedContentPane = (TabbedContentPane)super.forceWrapperForComponent(dockable, component);
        tabbedContentPane.setShowDetach(false);
        tabbedContentPane.setShowMaximize(false);
        tabbedContentPane.setShowMinimize(false);
        tabbedContentPane.addTabbedContentPaneListener(new TabbedContentPaneListener(){

            public void tabbedContentPaneEventFired(TabbedContentPaneEvent event) {
                Content content = event.getContent();
                switch (event.getActionId()) {
                    case ON_CLOSE: {
                        content.setDetached(false);
                        break;
                    }
                }
            }
        });
        return tabbedContentPane;
    }

    public class ContentWindowDockableDropPanel
    extends MultiSplitTabbedContentContainer.MultiSplitTabbedDockableDropPanel {
        public ContentWindowDockableDropPanel() {
            super(ContentWindowMultiSplitContainer.this);
        }

        public boolean drop(Transferable transferable) {
            block13: {
                if (transferable.isDataFlavorSupported(MyDoggyTransferable.CONTENT_ID_DF)) {
                    try {
                        ContentManager contentManager = ContentWindowMultiSplitContainer.this.toolWindowManager.getContentManager();
                        Content content = contentManager.getContent(transferable.getTransferData(MyDoggyTransferable.CONTENT_ID_DF));
                        if (content == null) break block13;
                        boolean rejectDrop = false;
                        Content onDockable = (Content)this.getOnDockable();
                        Content refDockable = (Content)this.getRefDockable();
                        ToolWindowAnchor onAnchor = this.getOnAnchor();
                        int onIndex = this.getOnIndex();
                        if (onDockable == null) {
                            if (refDockable != null && SwingUtil.getBoolean("dnd.content.outside.frame", true)) {
                                content.detachByReference(refDockable, onAnchor == null ? null : AggregationPosition.valueOf(onAnchor.toString()));
                                return true;
                            }
                            return false;
                        }
                        if (content == onDockable) {
                            if (onIndex == -1) {
                                rejectDrop = true;
                            } else {
                                DockablePanel dockablePanel;
                                Component onDockableContainer = this.getOnDockableContainer();
                                if (onDockableContainer instanceof TabbedContentPane) {
                                    TabbedContentPane tabbedContentPane = (TabbedContentPane)onDockableContainer;
                                    int size = tabbedContentPane.getTabCount();
                                    for (int i = 0; i < size; ++i) {
                                        DockablePanel dockablePanel2 = (DockablePanel)tabbedContentPane.getComponentAt(i);
                                        if (dockablePanel2.getDockable() != onDockable || i != onIndex) continue;
                                        rejectDrop = true;
                                        break;
                                    }
                                } else if (onDockableContainer instanceof DockablePanel && (dockablePanel = (DockablePanel)onDockableContainer).getDockable() == onDockable) {
                                    rejectDrop = true;
                                }
                            }
                        }
                        if (!rejectDrop && SwingUtil.getBoolean("dnd.content.outside.frame", true)) {
                            content.detach(onDockable, onIndex, onAnchor == null ? null : AggregationPosition.valueOf(onAnchor.toString()));
                            return true;
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        return false;
                    }
                }
            }
            return false;
        }
    }
}

