/*
 * Decompiled with CFR 0.152.
 */
package nl.lxtreme.ols.tool.linedecoder.impl;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.Action;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.SpringLayout;
import nl.lxtreme.ols.api.UserSettings;
import nl.lxtreme.ols.api.acquisition.AcquisitionDataListener;
import nl.lxtreme.ols.api.acquisition.AcquisitionResult;
import nl.lxtreme.ols.api.tools.Tool;
import nl.lxtreme.ols.api.tools.ToolContext;
import nl.lxtreme.ols.api.tools.ToolTask;
import nl.lxtreme.ols.tool.base.BaseToolDialog;
import nl.lxtreme.ols.tool.base.ToolDialog;
import nl.lxtreme.ols.tool.base.ToolUtils;
import nl.lxtreme.ols.tool.linedecoder.LineDecoder;
import nl.lxtreme.ols.tool.linedecoder.impl.LineDecoderTask;
import nl.lxtreme.ols.tool.linedecoder.impl.LineDecoderTool;
import nl.lxtreme.ols.util.NumberUtils;
import nl.lxtreme.ols.util.osgi.WhiteboardHelper;
import nl.lxtreme.ols.util.swing.SpringLayoutUtils;
import nl.lxtreme.ols.util.swing.SwingComponentUtils;
import org.osgi.framework.BundleContext;

public class LineDecoderToolDialog
extends BaseToolDialog<AcquisitionResult> {
    private static final long serialVersionUID = 1L;
    private final WhiteboardHelper<AcquisitionDataListener> acquisitionDataListenerHelper;
    private JComboBox lineDecoders;
    private JComboBox[] lines = new JComboBox[0];
    private JCheckBox inverted;
    private JCheckBox recoverClock;
    private JTextField clockSpeed;
    private Action closeAction;
    private ToolUtils.RestorableAction runAnalysisAction;

    public LineDecoderToolDialog(Window aOwner, ToolContext aContext, BundleContext aBundleContext, Tool<AcquisitionResult> aTool) {
        super(aOwner, aContext, aBundleContext, aTool);
        this.acquisitionDataListenerHelper = new WhiteboardHelper(aBundleContext, AcquisitionDataListener.class);
        this.initDialog();
        this.setLocationRelativeTo(this.getOwner());
    }

    public void readPreferences(UserSettings aSettings) {
        this.lineDecoders.setSelectedIndex(aSettings.getInt("decoder", this.lineDecoders.getSelectedIndex()));
        this.clockSpeed.setText(aSettings.get("clockSpeed", this.clockSpeed.getText()));
        this.inverted.setSelected(aSettings.getBoolean("inverted", this.inverted.isSelected()));
        this.recoverClock.setSelected(aSettings.getBoolean("recoverClock", this.recoverClock.isSelected()));
        for (int i = 0; i < this.lines.length; ++i) {
            this.setComboBoxIndex(this.lines[i], aSettings, "decoder.line." + i);
        }
    }

    public void reset() {
        this.runAnalysisAction.restore();
    }

    public void writePreferences(UserSettings aSettings) {
        aSettings.putInt("decoder", this.lineDecoders.getSelectedIndex());
        aSettings.put("clockSpeed", this.clockSpeed.getText());
        aSettings.putBoolean("inverted", this.inverted.isSelected());
        aSettings.putBoolean("recoverClock", this.recoverClock.isSelected());
        for (int i = 0; i < this.lines.length; ++i) {
            aSettings.putInt("decoder.line." + i, this.lines[i].getSelectedIndex());
        }
    }

    protected final LineDecoder[] getLineDecoders() {
        return ((LineDecoderTool)this.getTool()).getLineDecoders();
    }

    protected void onToolEnded(final AcquisitionResult aResult) {
        this.acquisitionDataListenerHelper.accept((WhiteboardHelper.Visitor)new WhiteboardHelper.Visitor<AcquisitionDataListener>(){

            public void visit(AcquisitionDataListener aService) {
                if (aResult != null) {
                    aService.acquisitionComplete(aResult);
                }
            }
        });
        this.closeAction.setEnabled(true);
        this.runAnalysisAction.restore();
        this.acquisitionDataListenerHelper.close();
    }

    protected void onToolStarted() {
        this.closeAction.setEnabled(false);
        this.acquisitionDataListenerHelper.open();
    }

    protected void prepareToolTask(ToolTask<AcquisitionResult> aToolTask) {
        int[] channels = new int[this.lines.length];
        for (int i = 0; i < channels.length; ++i) {
            channels[i] = this.lines[i].getSelectedIndex();
        }
        int clockSpeed = NumberUtils.safeParseInt((String)this.clockSpeed.getText());
        LineDecoderTask toolTask = (LineDecoderTask)aToolTask;
        toolTask.setLineDecoder((LineDecoder)this.lineDecoders.getSelectedItem());
        toolTask.setChannels(channels);
        toolTask.setInverted(this.inverted.isSelected());
        toolTask.setRecoverClock(this.recoverClock.isSelected());
        toolTask.setClockSpeed(clockSpeed);
    }

    protected void updateSettingsPane(JPanel aPanel, LineDecoder aLineDecoder) {
        aPanel.removeAll();
        SpringLayoutUtils.addSeparator((Container)aPanel, (String)"Decoder settings");
        this.clockSpeed = new JTextField();
        this.recoverClock = new JCheckBox("", false);
        this.recoverClock.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent aEvent) {
                LineDecoderToolDialog.this.clockSpeed.setEnabled(!LineDecoderToolDialog.this.recoverClock.isSelected());
            }
        });
        if (aLineDecoder.canRecoverClock()) {
            aPanel.add(SwingComponentUtils.createRightAlignedLabel((String)"Recover clock?"));
            aPanel.add(this.recoverClock);
            aPanel.add(SwingComponentUtils.createRightAlignedLabel((String)"Clock speed"));
            aPanel.add(this.clockSpeed);
        }
        int channelCount = this.getData().getChannels();
        String[] lines = aLineDecoder.getLineNames();
        this.lines = new JComboBox[lines.length];
        this.inverted = new JCheckBox("", false);
        if (aLineDecoder.canHandleInversion()) {
            aPanel.add(SwingComponentUtils.createRightAlignedLabel((String)"Inverted?"));
            aPanel.add(this.inverted);
        }
        for (int i = 0; i < lines.length; ++i) {
            this.lines[i] = SwingComponentUtils.createChannelSelector((int)channelCount);
            String label = "Channel " + (i + 1);
            if (lines[i] != null && !"".equals(lines[i].trim())) {
                label = lines[i];
            }
            aPanel.add(SwingComponentUtils.createRightAlignedLabel((String)label));
            aPanel.add(this.lines[i]);
        }
        SpringLayoutUtils.makeEditorGrid((Container)aPanel, (int)10, (int)4);
    }

    private JComponent createSettingsPane(final JPanel aSubSettingsPanel) {
        JPanel panel = new JPanel(new SpringLayout());
        SpringLayoutUtils.addSeparator((Container)panel, (String)"General settings");
        panel.add(SwingComponentUtils.createRightAlignedLabel((String)"Line Decoder"));
        this.lineDecoders = new JComboBox<LineDecoder>(this.getLineDecoders());
        this.lineDecoders.setRenderer(new LineDecoderComboBoxRenderer());
        this.lineDecoders.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent aEvent) {
                LineDecoder lineDecoder = (LineDecoder)aEvent.getItem();
                LineDecoderToolDialog.this.updateSettingsPane(aSubSettingsPanel, lineDecoder);
                LineDecoderToolDialog.this.validate();
            }
        });
        panel.add(this.lineDecoders);
        SpringLayoutUtils.makeEditorGrid((Container)panel, (int)10, (int)4);
        return panel;
    }

    private void initDialog() {
        this.setMinimumSize(new Dimension(640, 480));
        JPanel subSettingsPane = new JPanel(new SpringLayout());
        JComponent settingsPane = this.createSettingsPane(subSettingsPane);
        this.updateSettingsPane(subSettingsPane, (LineDecoder)this.lineDecoders.getSelectedItem());
        JPanel contentPane = new JPanel(new GridBagLayout());
        contentPane.add((Component)settingsPane, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 11, 0, new Insets(2, 0, 2, 0), 0, 0));
        contentPane.add((Component)subSettingsPane, new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 11, 0, new Insets(2, 0, 2, 0), 0, 0));
        JButton runAnalysisButton = ToolUtils.createRunAnalysisButton((ToolDialog)this);
        this.runAnalysisAction = (ToolUtils.RestorableAction)runAnalysisButton.getAction();
        JButton closeButton = ToolUtils.createCloseButton();
        this.closeAction = closeButton.getAction();
        JComponent buttonPane = SwingComponentUtils.createButtonPane((JButton[])new JButton[]{runAnalysisButton, closeButton});
        SwingComponentUtils.setupWindowContentPane((Window)((Object)this), (Component)contentPane, (Component)buttonPane, (JButton)runAnalysisButton);
        this.pack();
    }

    private static final class LineDecoderComboBoxRenderer
    extends DefaultListCellRenderer {
        private static final long serialVersionUID = 1L;

        private LineDecoderComboBoxRenderer() {
        }

        @Override
        public Component getListCellRendererComponent(JList aList, Object aValue, int aIndex, boolean aIsSelected, boolean aCellHasFocus) {
            String text = ((LineDecoder)aValue).getName();
            return super.getListCellRendererComponent((JList<?>)aList, text, aIndex, aIsSelected, aCellHasFocus);
        }
    }
}

