/*
 * Decompiled with CFR 0.152.
 */
package nl.lxtreme.ols.logging;

import java.util.logging.Level;
import nl.lxtreme.ols.logging.ConsoleLogger;
import nl.lxtreme.ols.logging.LogHandler;
import org.apache.felix.dm.Dependency;
import org.apache.felix.dm.DependencyActivatorBase;
import org.apache.felix.dm.DependencyManager;
import org.osgi.framework.BundleContext;
import org.osgi.service.log.LogService;

public class Activator
extends DependencyActivatorBase {
    private static final String PROPERTY_LOG_LEVEL = "nl.lxtreme.ols.logLevel";
    private static final String PROPERTY_LOG_TO_CONSOLE = "nl.lxtreme.ols.logToConsole";
    private static final String PROPERTY_FILTER_JDKUI_LOGS = "nl.lxtreme.ols.filterJdkUiLogs";

    public static Level getJavaLogLevel() {
        int level = Activator.getOsgiLogLevel();
        switch (level) {
            case 0: {
                return Level.OFF;
            }
            case 1: {
                return Level.SEVERE;
            }
            case 2: {
                return Level.WARNING;
            }
            case 3: {
                return Level.INFO;
            }
            case 4: {
                return Level.FINE;
            }
            case 5: {
                return Level.FINER;
            }
        }
        return Level.FINEST;
    }

    public static int getOsgiLogLevel() {
        int level = 3;
        try {
            level = Integer.getInteger(PROPERTY_LOG_LEVEL, level);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return level;
    }

    public static boolean isDebugMode() {
        return Boolean.parseBoolean(System.getProperty(PROPERTY_LOG_TO_CONSOLE, "false"));
    }

    public static boolean isFilterJdkUILogs() {
        return Boolean.parseBoolean(System.getProperty(PROPERTY_FILTER_JDKUI_LOGS, "true"));
    }

    public void destroy(BundleContext aContext, DependencyManager aManager) throws Exception {
    }

    public void init(BundleContext aContext, DependencyManager aManager) throws Exception {
        aManager.add(this.createComponent().setInterface(LogService.class.getName(), null).setImplementation(ConsoleLogger.class));
        aManager.add(this.createComponent().setImplementation(LogHandler.class).add((Dependency)this.createServiceDependency().setService(LogService.class).setRequired(false)));
    }
}

