/*
 * Decompiled with CFR 0.152.
 */
package nl.lxtreme.ols.logging;

import nl.lxtreme.ols.logging.Activator;
import org.osgi.framework.ServiceReference;
import org.osgi.service.log.LogService;

public class ConsoleLogger
implements LogService {
    private static String[] LEVEL = new String[]{"", "ERROR", "WARN ", "INFO ", "DEBUG"};

    public void log(int level, String message) {
        this.log(null, level, message, null);
    }

    public void log(int level, String message, Throwable throwable) {
        this.log(null, level, message, throwable);
    }

    public void log(ServiceReference reference, int level, String message) {
        this.log(reference, level, message, null);
    }

    public void log(ServiceReference reference, int level, String message, Throwable throwable) {
        String msg;
        if (!Activator.isDebugMode() || level > Activator.getOsgiLogLevel()) {
            return;
        }
        String bundle = " [   ]";
        String service = " ";
        if (reference != null) {
            bundle = "00" + reference.getBundle().getBundleId();
            bundle = " [" + bundle.substring(bundle.length() - 3) + "]";
            Object objectClass = reference.getProperty("objectClass");
            if (objectClass instanceof String[]) {
                StringBuffer buffer = new StringBuffer();
                String[] objClassArr = (String[])objectClass;
                for (int i = 0; i < objClassArr.length; ++i) {
                    String svc = objClassArr[i];
                    if (buffer.length() > 0) {
                        buffer.append(';');
                    }
                    buffer.append(svc);
                    service = buffer.toString() + ": ";
                }
            } else {
                service = objectClass.toString() + ": ";
            }
        }
        if (!(msg = "[" + LEVEL[level] + "]" + bundle + service + message).contains("org.slf4j.helpers") && !message.contains("TRACE")) {
            System.out.println(msg);
        }
        if (throwable != null) {
            throwable.printStackTrace(System.out);
        }
    }
}

