/*
 * Decompiled with CFR 0.152.
 */
package nl.lxtreme.ols.logging;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogManager;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import nl.lxtreme.ols.logging.Activator;
import org.osgi.service.log.LogService;

public class LogHandler
extends Handler {
    private volatile LogService logService;
    private volatile Level originalLevel;
    private final List<Handler> originalRootHandlers = new ArrayList<Handler>();

    @Override
    public void close() throws SecurityException {
    }

    @Override
    public void flush() {
    }

    @Override
    public void publish(LogRecord aRecord) {
        if (aRecord.getLevel() == Level.OFF || this.isBannedLogger(aRecord)) {
            return;
        }
        Object[] params = aRecord.getParameters();
        String message = aRecord.getMessage();
        if (params != null && params.length > 0) {
            message = MessageFormat.format(message, params);
        }
        Throwable thrownException = aRecord.getThrown();
        this.logService.log(this.mapLevel(aRecord.getLevel()), aRecord.getLoggerName() + " " + message, thrownException);
    }

    public void start() throws Exception {
        LogManager logManager = LogManager.getLogManager();
        Logger logger = logManager.getLogger("");
        this.originalLevel = logger.getLevel();
        this.replaceLogHandlers(logger, this.originalRootHandlers);
    }

    public void stop() throws Exception {
        LogManager logManager = LogManager.getLogManager();
        Logger logger = logManager.getLogger("");
        this.restoreLogHandler(logger, this.originalRootHandlers);
    }

    private boolean isBannedLogger(LogRecord aRecord) {
        String name = aRecord.getLoggerName();
        if (name == null || !Activator.isFilterJdkUILogs()) {
            return false;
        }
        return name.startsWith("java.awt.") || name.startsWith("sun.awt.") || name.startsWith("javax.swing.");
    }

    private int mapLevel(Level aLevel) {
        int value = aLevel.intValue();
        if (value >= Level.SEVERE.intValue()) {
            return 1;
        }
        if (value >= Level.WARNING.intValue()) {
            return 2;
        }
        if (value >= Level.INFO.intValue()) {
            return 3;
        }
        return 4;
    }

    private void replaceLogHandlers(Logger aLogger, List<Handler> aHandlerList) {
        Handler[] hs;
        if (aLogger == null) {
            return;
        }
        for (Handler h : hs = aLogger.getHandlers()) {
            aLogger.removeHandler(h);
            aHandlerList.add(h);
        }
        aLogger.setLevel(Activator.getJavaLogLevel());
        aLogger.addHandler(this);
    }

    private void restoreLogHandler(Logger aLogger, List<Handler> aHandlerList) {
        if (aLogger == null) {
            return;
        }
        aLogger.removeHandler(this);
        aLogger.setLevel(this.originalLevel);
        for (Handler h : aHandlerList) {
            aLogger.addHandler(h);
        }
        aHandlerList.clear();
    }
}

