/*
 * Decompiled with CFR 0.152.
 */
package nl.lxtreme.ols.api.data;

import java.util.List;
import nl.lxtreme.ols.api.acquisition.AcquisitionResult;

public class CapturedData
implements AcquisitionResult {
    private final int[] values;
    private final long[] timestamps;
    private final long triggerPosition;
    private final int rate;
    private final int channels;
    private final int enabledChannels;
    private final long absoluteLength;

    public CapturedData(int[] values, long triggerPosition, int rate, int channels, int enabledChannels) {
        this.triggerPosition = triggerPosition;
        this.rate = rate;
        this.channels = channels;
        this.enabledChannels = enabledChannels;
        int tmp = values[0];
        int count = 1;
        for (int value : values) {
            if (tmp != value) {
                ++count;
            }
            tmp = value;
        }
        this.timestamps = new long[count];
        this.values = new int[count];
        this.timestamps[0] = 0L;
        this.values[0] = values[0];
        tmp = values[0];
        count = 1;
        for (int i = 1; i < values.length; ++i) {
            if (tmp != values[i]) {
                this.timestamps[count] = i;
                this.values[count] = values[i];
                ++count;
            }
            tmp = values[i];
        }
        long absLength = this.timestamps[this.timestamps.length - 1];
        if (values.length > 1) {
            absLength -= this.timestamps[0];
        }
        this.absoluteLength = absLength;
    }

    public CapturedData(int[] aValues, long[] aTimestamps, long aTriggerPosition, int aRate, int aChannels, int aEnabledChannels, long aAbsLen) {
        if (aValues.length != aTimestamps.length) {
            throw new IllegalArgumentException("Values and timestamps size mismatch!");
        }
        long absLength = aAbsLen < 0L ? aTimestamps[aTimestamps.length - 1] : Math.max(aAbsLen, aTimestamps[aTimestamps.length - 1]);
        if (aValues.length > 0) {
            boolean addExtraSample;
            int count = 1;
            int oldValue = aValues[0];
            long lastTimestamp = aTimestamps[0];
            for (int i = 1; i < aValues.length; ++i) {
                if (aValues[i] != oldValue) {
                    ++count;
                    lastTimestamp = aTimestamps[i];
                }
                oldValue = aValues[i];
            }
            boolean bl = addExtraSample = lastTimestamp != absLength || count < 2;
            if (addExtraSample) {
                ++count;
            }
            this.values = new int[count];
            this.timestamps = new long[count];
            this.values[0] = aValues[0];
            this.timestamps[0] = aTimestamps[0];
            oldValue = aValues[0];
            int j = 1;
            for (int i = 1; i < aValues.length; ++i) {
                if (aValues[i] != oldValue) {
                    this.values[j] = aValues[i];
                    this.timestamps[j] = aTimestamps[i];
                    ++j;
                }
                oldValue = aValues[i];
            }
            if (addExtraSample) {
                this.values[count - 1] = aValues[aValues.length - 1];
                this.timestamps[count - 1] = absLength;
            }
        } else {
            this.values = new int[0];
            this.timestamps = new long[0];
        }
        this.triggerPosition = aTriggerPosition;
        this.rate = aRate;
        this.channels = aChannels;
        this.enabledChannels = aEnabledChannels;
        this.absoluteLength = absLength;
    }

    public CapturedData(List<Integer> aValues, List<Long> aTimestamps, long aTriggerPosition, int aRate, int aChannels, int aEnabledChannels, long aAbsoluteLength) {
        if (aValues.size() != aTimestamps.size()) {
            throw new IllegalArgumentException("Values and timestamps size mismatch!");
        }
        long absLength = aAbsoluteLength < 0L ? aTimestamps.get(aTimestamps.size() - 1) : Math.max(aAbsoluteLength, aTimestamps.get(aTimestamps.size() - 1));
        if (!aValues.isEmpty()) {
            boolean addExtraSample;
            int size = aValues.size();
            int count = 1;
            Integer oldValue = aValues.get(0);
            Long lastTimestamp = aTimestamps.get(0);
            for (int i = 1; i < size; ++i) {
                Integer value = aValues.get(i);
                if (value.compareTo(oldValue) != 0) {
                    ++count;
                    lastTimestamp = aTimestamps.get(i);
                }
                oldValue = value;
            }
            boolean bl = addExtraSample = lastTimestamp != absLength || count < 2;
            if (addExtraSample) {
                ++count;
            }
            this.values = new int[count];
            this.timestamps = new long[count];
            this.values[0] = aValues.get(0);
            this.timestamps[0] = aTimestamps.get(0);
            oldValue = aValues.get(0);
            int j = 1;
            for (int i = 1; i < size; ++i) {
                Integer value = aValues.get(i);
                Long timestamp = aTimestamps.get(i);
                if (value.compareTo(oldValue) != 0) {
                    this.values[j] = value;
                    this.timestamps[j] = timestamp;
                    ++j;
                }
                oldValue = value;
            }
            if (addExtraSample) {
                this.values[count - 1] = aValues.get(size - 1);
                this.timestamps[count - 1] = absLength;
            }
        } else {
            this.values = new int[0];
            this.timestamps = new long[0];
        }
        this.triggerPosition = aTriggerPosition;
        this.rate = aRate;
        this.channels = aChannels;
        this.enabledChannels = aEnabledChannels;
        this.absoluteLength = aAbsoluteLength;
    }

    static final int binarySearch(long[] aArray, int aFromIndex, int aToIndex, Long aKey) {
        int mid = -1;
        int low = aFromIndex;
        int high = aToIndex - 1;
        while (low <= high) {
            mid = low + high >>> 1;
            Long midVal = aArray[mid];
            int c = aKey.compareTo(midVal);
            if (c > 0) {
                low = mid + 1;
                continue;
            }
            if (c < 0) {
                high = mid - 1;
                continue;
            }
            return mid;
        }
        if (mid < 0) {
            return low;
        }
        if (mid < aToIndex - 1 && aKey > aArray[mid]) {
            return mid + 1;
        }
        return mid;
    }

    @Override
    public final long getAbsoluteLength() {
        return this.absoluteLength;
    }

    @Override
    public final int getChannels() {
        return this.channels;
    }

    @Override
    public final int getEnabledChannels() {
        return this.enabledChannels;
    }

    @Override
    public final int getSampleIndex(long abs) {
        return CapturedData.binarySearch(this.timestamps, 0, this.timestamps.length, abs);
    }

    @Override
    public final int getSampleRate() {
        return this.rate;
    }

    @Override
    public final long[] getTimestamps() {
        return this.timestamps;
    }

    @Override
    public final long getTriggerPosition() {
        return this.triggerPosition;
    }

    @Override
    public final int[] getValues() {
        return this.values;
    }

    @Override
    public final boolean hasTimingData() {
        return this.rate != -1;
    }

    @Override
    public final boolean hasTriggerData() {
        return this.triggerPosition != -1L;
    }
}

