/*
 * Decompiled with CFR 0.152.
 */
package nl.lxtreme.ols.api.util;

import java.awt.Font;
import java.awt.GraphicsEnvironment;
import java.util.logging.Logger;
import javax.swing.UIManager;

public final class Unit {
    private static final char SPACE = ' ';
    private static final char NB = '\u00a0';
    private static final char THIN = '\u2009';
    private static final char HAIR = '\u200a';
    private static final Character SEPARATOR;

    static String format(double aValue, int aScale, String aUnit) {
        if (Double.isNaN(aValue) || Double.isInfinite(aValue)) {
            return "-";
        }
        String formatSpec = String.format("%%.%df%c%%s", aScale, SEPARATOR);
        return String.format(formatSpec, aValue, aUnit);
    }

    static String format(String aValue, String aUnit) {
        return String.format("%s%c%s", aValue, SEPARATOR, aUnit);
    }

    static {
        int sep;
        Logger logger = Logger.getLogger(Unit.class.getName());
        if (GraphicsEnvironment.isHeadless()) {
            logger.fine("Using SPACE (headless fallback)...");
            sep = 32;
        } else {
            Font font = UIManager.getFont("Label.font");
            if (font.canDisplay('\u200a')) {
                logger.fine("Using HAIR...");
                sep = 8202;
            } else if (font.canDisplay('\u2009')) {
                logger.fine("Using THIN...");
                sep = 8201;
            } else if (font.canDisplay('\u00a0')) {
                logger.fine("Using NB...");
                sep = 160;
            } else {
                logger.fine("Using SPACE (fallback)...");
                sep = 32;
            }
        }
        SEPARATOR = Character.valueOf((char)sep);
    }

    public static enum Time {
        S("", 1.0),
        MS("m", 0.001),
        US("\u03bc", 1.0E-6),
        NS("n", 1.0E-9),
        PS("p", 1.0E-12),
        FS("f", 1.0E-15);

        public static final double ZERO_THRESHOLD = 1.0E-16;
        private static final String BASE_UNIT = "s";
        private final String displayName;
        private final double factor;

        private Time(String aPrefix, double aFactor) {
            this.displayName = aPrefix.concat(BASE_UNIT);
            this.factor = aFactor;
        }

        public static String format(double aTime) {
            return Time.toUnit(aTime).format(aTime, 2);
        }

        public static Time toUnit(double aTimeValue) {
            int i;
            double absTime = Math.abs(aTimeValue);
            Time[] values = Time.values();
            for (i = 0; i < values.length && !(absTime >= values[i].getFactor()); ++i) {
            }
            return values[Math.min(i, values.length - 1)];
        }

        public String format(double aTime, int aScale) {
            if (Math.abs(aTime) < 1.0E-16) {
                return Unit.format(0.0, aScale, S.getDisplayName());
            }
            return Unit.format(aTime / this.getFactor(), aScale, this.getDisplayName());
        }

        public String formatHumanReadable(double aTime) {
            if (Math.abs(aTime) < 1.0E-16) {
                return Unit.format(0.0, 1, S.getDisplayName());
            }
            Double time = aTime / this.getFactor();
            String formattedTime = String.format("%.9f", time);
            formattedTime = formattedTime.replaceAll("(\\d)0+$", "$1");
            return Unit.format(formattedTime, this.getDisplayName());
        }

        public String getDisplayName() {
            return this.displayName;
        }

        public double getFactor() {
            return this.factor;
        }

        public Time predecessor() {
            int i = this.ordinal();
            return i < 1 ? null : Time.values()[i - 1];
        }

        public Time successor() {
            Time[] values = Time.values();
            int i = this.ordinal();
            if (i >= values.length - 1) {
                return null;
            }
            return values[i + 1];
        }
    }

    public static enum SizeSI {
        B("", 1.0),
        KB("k", 1024.0),
        MB("M", 1048576.0),
        GB("G", 1.073741824E9),
        TB("T", 1.099511627776E12);

        public static final double ZERO_THRESHOLD = 0.1;
        private static final String BASE_UNIT = "B";
        private final String displayName;
        private final double factor;

        private SizeSI(String aPrefix, double aFactor) {
            this.displayName = aPrefix.concat(BASE_UNIT);
            this.factor = aFactor;
        }

        public static String format(double aSize) {
            return SizeSI.toUnit(aSize).format(aSize, 2);
        }

        public static SizeSI toUnit(double aSize) {
            int i;
            SizeSI[] sizes = SizeSI.values();
            double size = Math.abs(aSize);
            for (i = sizes.length - 1; i >= 0 && !(size >= sizes[i].getFactor()); --i) {
            }
            return sizes[Math.max(i, 0)];
        }

        public String format(double aSize, int aScale) {
            if (Math.abs(aSize) < 0.1) {
                return Unit.format(0.0, aScale, B.getDisplayName());
            }
            return Unit.format(aSize / this.getFactor(), aScale, this.getDisplayName());
        }

        public String getDisplayName() {
            return this.displayName;
        }

        public double getFactor() {
            return this.factor;
        }
    }

    public static enum Frequency {
        MiHZ("m", 0.001),
        HZ("", 1.0),
        KHZ("k", 1000.0),
        MHZ("M", 1000000.0),
        GHZ("G", 1.0E9),
        THZ("T", 1.0E12);

        public static final double ZERO_THRESHOLD = 1.0E-5;
        private static final String BASE_UNIT = "Hz";
        private final String displayName;
        private final double factor;

        private Frequency(String aPrefix, double aFactor) {
            this.displayName = aPrefix.concat(BASE_UNIT);
            this.factor = aFactor;
        }

        public static String format(double aFrequency) {
            return Frequency.toUnit(aFrequency).format(aFrequency, 3);
        }

        public static Frequency toUnit(double aFrequency) {
            int i;
            Frequency[] freqs = Frequency.values();
            double frequency = Math.abs(aFrequency);
            for (i = freqs.length - 1; i >= 0 && !(frequency >= freqs[i].getFactor()); --i) {
            }
            return freqs[Math.max(i, 0)];
        }

        public String format(double aFrequency, int aScale) {
            if (Math.abs(aFrequency) < 1.0E-5) {
                return Unit.format(0.0, aScale, HZ.getDisplayName());
            }
            return Unit.format(aFrequency / this.getFactor(), aScale, this.getDisplayName());
        }

        public String getDisplayName() {
            return this.displayName;
        }

        public double getFactor() {
            return this.factor;
        }
    }
}

