/*
 * Decompiled with CFR 0.152.
 */
package nl.lxtreme.ols.runner;

import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import nl.lxtreme.ols.runner.HostActivator;
import org.apache.felix.framework.Felix;
import org.apache.felix.framework.Logger;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleException;
import org.osgi.framework.FrameworkEvent;
import org.osgi.framework.FrameworkListener;
import org.osgi.framework.ServiceReference;
import org.osgi.service.packageadmin.PackageAdmin;

public final class Runner {
    private final CmdLineOptions options;
    private Felix framework;
    private Logger fwLogger;

    public Runner(CmdLineOptions aOptions) throws IOException {
        this.options = aOptions;
    }

    public static void main(String[] aArgs) throws Exception {
        Runner runner = new Runner(new CmdLineOptions(aArgs));
        runner.run();
        runner.waitForStop();
    }

    public void run() throws Exception {
        try {
            this.framework = new Felix(this.createConfig());
            this.framework.init();
            this.framework.start();
            this.log(3, "Framework started...");
            this.log(3, "  plugin dir: " + this.options.pluginDir);
            this.log(3, "  cache dir : " + this.options.cacheDir);
            this.bootstrap(this.framework.getBundleContext());
            this.log(3, "Bootstrap complete...");
        }
        catch (Exception exception) {
            this.log(1, "Failed to start OSGi framework! Possible reason: " + exception.getMessage(), exception);
            throw exception;
        }
    }

    public void waitForStop() throws InterruptedException {
        FrameworkEvent event = this.framework.waitForStop(0L);
        switch (event.getType()) {
            case 64: {
                System.exit(0);
            }
            case 2: 
            case 16: {
                System.exit(1);
            }
        }
        System.exit(-1);
    }

    private void bootstrap(BundleContext aContext) throws InterruptedException {
        Map<String, Bundle> installed = this.getInstalledBundles(aContext);
        ArrayList<Bundle> toBeStarted = new ArrayList<Bundle>();
        List<String> available = this.getBundles(this.options.pluginDir);
        for (String bundleLocation : available) {
            Bundle bundle = installed.get(bundleLocation);
            if (bundle == null) {
                bundle = this.installBundle(aContext, bundleLocation);
                if (bundle == null) continue;
                installed.put(bundleLocation, bundle);
                toBeStarted.add(bundle);
                continue;
            }
            File file = new File(URI.create(bundleLocation));
            if (file.lastModified() < bundle.getLastModified() || (bundle = this.updateBundle(bundle)) == null) continue;
            toBeStarted.add(bundle);
        }
        ArrayList<String> removed = new ArrayList<String>(installed.keySet());
        removed.remove("System Bundle");
        removed.removeAll(available);
        for (String plugin : removed) {
            Bundle bundle = installed.remove(plugin);
            this.uninstallBundle(bundle);
        }
        this.refreshAll(aContext);
        for (Bundle bundle : toBeStarted) {
            this.startBundle(bundle);
        }
    }

    private Map<String, Object> createConfig() {
        this.fwLogger = new Logger();
        String logLevel = "" + Math.min(4, this.options.logLevel);
        HashMap<String, Object> config = new HashMap<String, Object>();
        config.put("org.osgi.framework.bootdelegation", "com.yourkit.*,com.sun.*,sun.*,apple.*,com.apple.*");
        config.put("org.osgi.framework.system.packages.extra", "com.apple.mrj,com.apple.eawt,javax.swing,javax.media.jai,org.osgi.service.cm");
        config.put("org.osgi.framework.storage", this.options.cacheDir.getPath());
        if (this.options.cleanCache) {
            config.put("org.osgi.framework.storage.clean", "onFirstInit");
        }
        config.put("felix.systembundle.activators", Arrays.asList(new HostActivator()));
        config.put("felix.log.level", logLevel);
        config.put("felix.log.logger", this.fwLogger);
        config.put("nl.lxtreme.ols.config.dir", this.options.pluginDir.getAbsolutePath());
        return config;
    }

    private List<String> getBundles(File pluginDir) {
        final ArrayList<String> plugins = new ArrayList<String>();
        pluginDir.listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File aDir, String aName) {
                if (aName.endsWith(".jar")) {
                    plugins.add(new File(aDir, aName).toURI().toString());
                }
                return false;
            }
        });
        return plugins;
    }

    private Map<String, Bundle> getInstalledBundles(BundleContext context) {
        HashMap<String, Bundle> installed = new HashMap<String, Bundle>();
        for (Bundle bundle : context.getBundles()) {
            installed.put(bundle.getLocation(), bundle);
        }
        return installed;
    }

    private Bundle installBundle(BundleContext context, String plugin) {
        this.log(4, "Installing plugin: '" + plugin + "'...");
        try {
            return context.installBundle(plugin);
        }
        catch (BundleException exception) {
            this.log(2, "Failed to install bundle: " + plugin + "...", exception);
            return null;
        }
    }

    private boolean isFragment(Bundle aBundle) {
        if (aBundle == null) {
            return false;
        }
        return aBundle.getHeaders().get("Fragment-Host") != null;
    }

    private void log(int aLevel, String aMessage) {
        this.fwLogger.log(aLevel, aMessage);
    }

    private void log(int aLevel, String aMessage, Throwable aException) {
        this.fwLogger.log(aLevel, aMessage, aException);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void refreshAll(BundleContext aContext) throws InterruptedException {
        block6: {
            ServiceReference ref = aContext.getServiceReference(PackageAdmin.class.getName());
            if (ref != null) {
                PackageAdmin packageAdm = (PackageAdmin)aContext.getService(ref);
                final CountDownLatch packagesRefreshed = new CountDownLatch(1);
                FrameworkListener fwListener = new FrameworkListener(){

                    public void frameworkEvent(FrameworkEvent aEvent) {
                        switch (aEvent.getType()) {
                            case 2: 
                            case 4: 
                            case 512: {
                                packagesRefreshed.countDown();
                            }
                        }
                    }
                };
                try {
                    aContext.addFrameworkListener(fwListener);
                    packageAdm.refreshPackages(null);
                    if (packagesRefreshed.await(15L, TimeUnit.SECONDS)) {
                        if (!packageAdm.resolveBundles(null)) {
                            this.log(2, "Not all bundles resolve correctly!");
                        }
                        break block6;
                    }
                    throw new RuntimeException("Refresh packages took longer than expected!");
                }
                finally {
                    aContext.removeFrameworkListener(fwListener);
                    aContext.ungetService(ref);
                }
            }
        }
    }

    private void startBundle(Bundle aBundle) {
        if (!this.isFragment(aBundle)) {
            this.log(4, "Starting bundle: " + aBundle.getSymbolicName() + "...");
            try {
                aBundle.start(2);
            }
            catch (BundleException exception) {
                this.log(2, "Failed to start bundle: " + aBundle.getSymbolicName() + "...", exception);
            }
        }
    }

    private void uninstallBundle(Bundle aBundle) {
        this.log(4, "Removing stale plugin: " + aBundle.getSymbolicName() + "...");
        try {
            aBundle.stop();
        }
        catch (BundleException exception) {
            this.log(2, "Failed to stop bundle: " + aBundle.getSymbolicName() + "...", exception);
        }
        try {
            aBundle.uninstall();
        }
        catch (BundleException exception) {
            this.log(2, "Failed to uninstall bundle: " + aBundle.getSymbolicName() + "...", exception);
        }
    }

    private Bundle updateBundle(Bundle aBundle) {
        this.log(4, "Updating plugin: " + aBundle.getSymbolicName() + "...");
        Bundle result = null;
        if (!this.isFragment(aBundle) && (aBundle.getState() & 0x20) != 0) {
            this.log(4, "Stopping plugin: " + aBundle.getSymbolicName() + " for update...");
            try {
                aBundle.stop();
            }
            catch (BundleException exception) {
                this.log(2, "Failed to stop bundle: " + aBundle.getSymbolicName() + "...", exception);
            }
            result = aBundle;
        }
        try {
            aBundle.update();
        }
        catch (BundleException exception) {
            this.log(2, "Failed to update bundle: " + aBundle.getSymbolicName() + "...", exception);
        }
        return result;
    }

    static class CmdLineOptions {
        final File pluginDir;
        final File cacheDir;
        final boolean cleanCache;
        final int logLevel;

        public CmdLineOptions(String ... aCmdLineArgs) throws IOException {
            String _pluginDir = CmdLineOptions.getPluginDir();
            String _cacheDir = null;
            boolean _cleanCache = false;
            int _logLevel = 2;
            for (String cmdLineArg : aCmdLineArgs) {
                if ("-clean".equals(cmdLineArg)) {
                    _cleanCache = true;
                    continue;
                }
                if (cmdLineArg.startsWith("-logLevel=")) {
                    String arg = cmdLineArg.substring(10);
                    _logLevel = Integer.parseInt(arg);
                    continue;
                }
                if (cmdLineArg.startsWith("-pluginDir=")) {
                    _pluginDir = cmdLineArg.substring(11);
                    continue;
                }
                if (!cmdLineArg.startsWith("-cacheDir=")) continue;
                _cacheDir = cmdLineArg.substring(10);
            }
            if (_logLevel < 0 || _logLevel > 6) {
                throw new IllegalArgumentException("Invalid log level, should be between 0 and 6!");
            }
            this.pluginDir = new File(_pluginDir).getCanonicalFile();
            if ("".equals(_pluginDir) || !this.pluginDir.exists()) {
                throw new IllegalArgumentException(String.format("Invalid plugin directory (%s)!", this.pluginDir));
            }
            if (_cacheDir == null) {
                _cacheDir = new File(_pluginDir, "/../.fwcache").getAbsolutePath();
            }
            this.cacheDir = new File(_cacheDir).getCanonicalFile();
            if (!this.cacheDir.exists() && !this.cacheDir.mkdirs()) {
                throw new IllegalArgumentException(String.format("Invalid cache directory (%s): cannot create directory!", this.cacheDir));
            }
            this.cleanCache = _cleanCache;
            this.logLevel = _logLevel;
        }

        private static String getPluginDir() {
            String defaultDir = "./plugins";
            File pluginDir = new File(System.getProperty("nl.lxtreme.ols.bundle.dir", defaultDir));
            if (pluginDir.exists() && pluginDir.isDirectory()) {
                return pluginDir.getAbsolutePath();
            }
            pluginDir = new File(defaultDir);
            if (pluginDir.exists() && pluginDir.isDirectory()) {
                return pluginDir.getAbsolutePath();
            }
            return null;
        }
    }
}

