/*
 * Decompiled with CFR 0.152.
 */
package nl.lxtreme.ols.tool.i2c;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.IOException;
import java.text.DateFormat;
import java.util.Date;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.Action;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.SpringLayout;
import nl.lxtreme.ols.api.UserSettings;
import nl.lxtreme.ols.api.tools.Tool;
import nl.lxtreme.ols.api.tools.ToolContext;
import nl.lxtreme.ols.api.tools.ToolTask;
import nl.lxtreme.ols.api.util.Unit;
import nl.lxtreme.ols.tool.base.BaseToolDialog;
import nl.lxtreme.ols.tool.base.ExportAware;
import nl.lxtreme.ols.tool.base.ToolDialog;
import nl.lxtreme.ols.tool.base.ToolUtils;
import nl.lxtreme.ols.tool.i2c.I2CAnalyser;
import nl.lxtreme.ols.tool.i2c.I2CAnalyserTask;
import nl.lxtreme.ols.tool.i2c.I2CData;
import nl.lxtreme.ols.tool.i2c.I2CDataSet;
import nl.lxtreme.ols.util.ExportUtils;
import nl.lxtreme.ols.util.HostUtils;
import nl.lxtreme.ols.util.StringUtils;
import nl.lxtreme.ols.util.swing.SpringLayoutUtils;
import nl.lxtreme.ols.util.swing.SwingComponentUtils;
import org.osgi.framework.BundleContext;

public final class I2CProtocolAnalysisDialog
extends BaseToolDialog<I2CDataSet>
implements ExportAware<I2CDataSet>,
PropertyChangeListener {
    private static final long serialVersionUID = 1L;
    private static final Logger LOG = Logger.getLogger(I2CProtocolAnalysisDialog.class.getName());
    private JLabel lineALabel;
    private JComboBox lineA;
    private JLabel lineBLabel;
    private JComboBox lineB;
    private JEditorPane outText;
    private JLabel busSetSCL;
    private JLabel busSetSDA;
    private JCheckBox detectSDA_SCL;
    private JCheckBox detectSTART;
    private JCheckBox detectSTOP;
    private JCheckBox detectACK;
    private JCheckBox detectNACK;
    private ToolUtils.RestorableAction runAnalysisAction;
    private Action exportAction;
    private Action closeAction;

    public I2CProtocolAnalysisDialog(Window aOwner, ToolContext aToolContext, BundleContext aContext, I2CAnalyser aTool) {
        super(aOwner, aToolContext, aContext, (Tool)aTool);
        this.initDialog();
        this.setLocationRelativeTo(this.getOwner());
    }

    public void exportToFile(File aOutputFile, ExportAware.ExportFormat aFormat) throws IOException {
        if (ExportAware.ExportFormat.CSV.equals((Object)aFormat)) {
            this.storeToCsvFile(aOutputFile, (I2CDataSet)((Object)this.getLastResult()));
        } else if (ExportAware.ExportFormat.HTML.equals((Object)aFormat)) {
            this.storeToHtmlFile(aOutputFile, (I2CDataSet)((Object)this.getLastResult()));
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent aEvent) {
        String propertyName = aEvent.getPropertyName();
        final Object lineValue = aEvent.getNewValue();
        final JLabel label = "AutoDetectSCL".equals(propertyName) ? this.busSetSCL : this.busSetSDA;
        SwingComponentUtils.invokeOnEDT((Runnable)new Runnable(){

            @Override
            public void run() {
                if ("LineA".equals(lineValue)) {
                    label.setText((String)I2CProtocolAnalysisDialog.this.lineA.getSelectedItem());
                } else if ("LineB".equals(lineValue)) {
                    label.setText((String)I2CProtocolAnalysisDialog.this.lineB.getSelectedItem());
                }
            }
        });
    }

    public void readPreferences(UserSettings aSettings) {
        this.setComboBoxIndex(this.lineA, aSettings, "lineA");
        this.setComboBoxIndex(this.lineB, aSettings, "lineB");
        this.detectSDA_SCL.setSelected(aSettings.getBoolean("detectSDA_SCL", this.detectSDA_SCL.isSelected()));
        this.detectSTART.setSelected(aSettings.getBoolean("detectStart", this.detectSTART.isSelected()));
        this.detectSTOP.setSelected(aSettings.getBoolean("detectStop", this.detectSTOP.isSelected()));
        this.detectNACK.setSelected(aSettings.getBoolean("detectNack", this.detectNACK.isSelected()));
        this.detectACK.setSelected(aSettings.getBoolean("detectAck", this.detectACK.isSelected()));
    }

    public void reset() {
        String emptyHtmlPage = this.getEmptyHtmlPage();
        this.outText.setText(emptyHtmlPage);
        this.outText.setEditable(false);
        this.runAnalysisAction.restore();
        this.setControlsEnabled(true);
        this.exportAction.setEnabled(false);
    }

    public void setControlsEnabled(boolean aEnabled) {
        this.lineA.setEnabled(aEnabled);
        this.lineB.setEnabled(aEnabled);
        this.detectSTART.setEnabled(aEnabled);
        this.detectSTOP.setEnabled(aEnabled);
        this.detectACK.setEnabled(aEnabled);
        this.detectNACK.setEnabled(aEnabled);
        this.closeAction.setEnabled(aEnabled);
        this.exportAction.setEnabled(aEnabled);
    }

    public void writePreferences(UserSettings aSettings) {
        aSettings.putInt("lineA", this.lineA.getSelectedIndex());
        aSettings.putInt("lineB", this.lineB.getSelectedIndex());
        aSettings.putBoolean("detectSDA_SCL", this.detectSDA_SCL.isSelected());
        aSettings.putBoolean("detectStart", this.detectSTART.isSelected());
        aSettings.putBoolean("detectStop", this.detectSTOP.isSelected());
        aSettings.putBoolean("detectNack", this.detectNACK.isSelected());
        aSettings.putBoolean("detectAck", this.detectACK.isSelected());
    }

    final void syncLineLabels(JCheckBox aCheckBox) {
        if (aCheckBox.isSelected()) {
            this.lineALabel.setText("Line A");
            this.lineBLabel.setText("Line B");
        } else {
            this.lineALabel.setText("SCL");
            this.lineBLabel.setText("SDA");
        }
    }

    protected void onToolEnded(I2CDataSet aAnalysisResult) {
        block4: {
            try {
                String htmlPage;
                if (aAnalysisResult != null) {
                    htmlPage = this.toHtmlPage(null, aAnalysisResult);
                    this.exportAction.setEnabled(!aAnalysisResult.isEmpty());
                } else {
                    htmlPage = this.getEmptyHtmlPage();
                    this.exportAction.setEnabled(false);
                }
                this.outText.setText(htmlPage);
                this.outText.setEditable(false);
                this.runAnalysisAction.restore();
            }
            catch (IOException exception) {
                if (HostUtils.handleInterruptedException((Throwable)exception)) break block4;
                throw new RuntimeException(exception);
            }
        }
    }

    protected void onToolStarted() {
    }

    protected void prepareToolTask(ToolTask<I2CDataSet> aToolTask) {
        I2CAnalyserTask toolTask = (I2CAnalyserTask)aToolTask;
        toolTask.setLineAIndex(this.lineA.getSelectedIndex());
        toolTask.setLineBIndex(this.lineB.getSelectedIndex());
        toolTask.setDetectSDA_SCL(this.detectSDA_SCL.isSelected());
        toolTask.setReportACK(this.detectACK.isSelected());
        toolTask.setReportNACK(this.detectNACK.isSelected());
        toolTask.setReportStart(this.detectSTART.isSelected());
        toolTask.setReportStop(this.detectSTOP.isSelected());
        toolTask.addPropertyChangeListener(this);
    }

    private ExportUtils.HtmlExporter createHtmlTemplate(ExportUtils.HtmlExporter aExporter) {
        aExporter.addCssStyle("body { font-family: sans-serif; } ");
        aExporter.addCssStyle("table { border-width: 1px; border-spacing: 0px; border-color: gray; border-collapse: collapse; border-style: solid; margin-bottom: 15px; } ");
        aExporter.addCssStyle("table th { border-width: 1px; padding: 2px; border-style: solid; border-color: gray; background-color: #C0C0FF; text-align: left; font-weight: bold; font-family: sans-serif; } ");
        aExporter.addCssStyle("table td { border-width: 1px; padding: 2px; border-style: solid; border-color: gray; font-family: monospace; } ");
        aExporter.addCssStyle(".date { text-align: right; font-size: x-small; margin-bottom: 15px; } ");
        aExporter.addCssStyle(".w100 { width: 100%; } ");
        aExporter.addCssStyle(".w30 { width: 30%; } ");
        aExporter.addCssStyle(".w20 { width: 20%; } ");
        aExporter.addCssStyle(".w15 { width: 15%; } ");
        aExporter.addCssStyle(".w10 { width: 10%; } ");
        ExportUtils.HtmlExporter.Element body = aExporter.getBody();
        body.addChild(ExportUtils.HtmlExporter.H1).addContent(new String[]{"I<sup>2</sup>C Analysis results"});
        body.addChild(ExportUtils.HtmlExporter.HR);
        body.addChild(ExportUtils.HtmlExporter.DIV).addAttribute("class", "date").addContent(new String[]{"{date-now}"});
        ExportUtils.HtmlExporter.Element table = body.addChild(ExportUtils.HtmlExporter.TABLE).addAttribute("class", "w100");
        ExportUtils.HtmlExporter.Element tbody = table.addChild(ExportUtils.HtmlExporter.TBODY);
        ExportUtils.HtmlExporter.Element tr = tbody.addChild(ExportUtils.HtmlExporter.TR);
        tr.addChild(ExportUtils.HtmlExporter.TH).addAttribute("colspan", "2").addContent(new String[]{"Bus configuration"});
        tr = tbody.addChild(ExportUtils.HtmlExporter.TR);
        tr.addChild(ExportUtils.HtmlExporter.TD).addAttribute("class", "w30").addContent(new String[]{"SDA"});
        tr.addChild(ExportUtils.HtmlExporter.TD).addContent(new String[]{"{sda-bus-config}"});
        tr = tbody.addChild(ExportUtils.HtmlExporter.TR);
        tr.addChild(ExportUtils.HtmlExporter.TD).addAttribute("class", "w30").addContent(new String[]{"SCL"});
        tr.addChild(ExportUtils.HtmlExporter.TD).addContent(new String[]{"{scl-bus-config}"});
        tbody = table.addChild(ExportUtils.HtmlExporter.TBODY);
        tr = tbody.addChild(ExportUtils.HtmlExporter.TR);
        tr.addChild(ExportUtils.HtmlExporter.TH).addAttribute("colspan", "2").addContent(new String[]{"Statistics"});
        tr = tbody.addChild(ExportUtils.HtmlExporter.TR);
        tr.addChild(ExportUtils.HtmlExporter.TD).addAttribute("class", "w30").addContent(new String[]{"Decoded bytes"});
        tr.addChild(ExportUtils.HtmlExporter.TD).addContent(new String[]{"{decoded-bytes}"});
        tr = tbody.addChild(ExportUtils.HtmlExporter.TR);
        tr.addChild(ExportUtils.HtmlExporter.TD).addAttribute("class", "w30").addContent(new String[]{"Detected bus errors"});
        tr.addChild(ExportUtils.HtmlExporter.TD).addContent(new String[]{"{detected-bus-errors}"});
        table = body.addChild(ExportUtils.HtmlExporter.TABLE).addAttribute("class", "w100");
        ExportUtils.HtmlExporter.Element thead = table.addChild(ExportUtils.HtmlExporter.THEAD);
        tr = thead.addChild(ExportUtils.HtmlExporter.TR);
        tr.addChild(ExportUtils.HtmlExporter.TH).addAttribute("class", "w30").addContent(new String[]{"Index"});
        tr.addChild(ExportUtils.HtmlExporter.TH).addAttribute("class", "w15").addContent(new String[]{"Time"});
        tr.addChild(ExportUtils.HtmlExporter.TH).addAttribute("class", "w20").addContent(new String[]{"Hex"});
        tr.addChild(ExportUtils.HtmlExporter.TH).addAttribute("class", "w20").addContent(new String[]{"Bin"});
        tr.addChild(ExportUtils.HtmlExporter.TH).addAttribute("class", "w20").addContent(new String[]{"Dec"});
        tr.addChild(ExportUtils.HtmlExporter.TH).addAttribute("class", "w10").addContent(new String[]{"ASCII"});
        tbody = table.addChild(ExportUtils.HtmlExporter.TBODY);
        tbody.addContent(new String[]{"{decoded-data}"});
        return aExporter;
    }

    private JPanel createPreviewPane() {
        JPanel output = new JPanel(new GridLayout(1, 1, 0, 0));
        this.outText = new JEditorPane("text/html", this.getEmptyHtmlPage());
        this.outText.setEditable(false);
        output.add(new JScrollPane(this.outText));
        return output;
    }

    private JPanel createSettingsPane() {
        int channelCount = this.getData().getChannels();
        this.busSetSCL = new JLabel("<autodetect>");
        this.busSetSDA = new JLabel("<autodetect>");
        JPanel panel = new JPanel(new SpringLayout());
        SpringLayoutUtils.addSeparator((Container)panel, (String)"Settings");
        this.lineALabel = SwingComponentUtils.createRightAlignedLabel((String)"Line A");
        this.lineBLabel = SwingComponentUtils.createRightAlignedLabel((String)"Line B");
        panel.add(this.lineALabel);
        this.lineA = SwingComponentUtils.createChannelSelector((int)channelCount, (int)0);
        panel.add(this.lineA);
        panel.add(this.lineBLabel);
        this.lineB = SwingComponentUtils.createChannelSelector((int)channelCount, (int)1);
        panel.add(this.lineB);
        this.detectSDA_SCL = new JCheckBox();
        this.detectSDA_SCL.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent aEvent) {
                JCheckBox cb = (JCheckBox)aEvent.getSource();
                I2CProtocolAnalysisDialog.this.syncLineLabels(cb);
            }
        });
        this.detectSDA_SCL.setSelected(true);
        panel.add(SwingComponentUtils.createRightAlignedLabel((String)"Detect SDA & SCL?"));
        panel.add(this.detectSDA_SCL);
        this.detectSTART = new JCheckBox();
        this.detectSTART.setSelected(true);
        panel.add(SwingComponentUtils.createRightAlignedLabel((String)"Show START?"));
        panel.add(this.detectSTART);
        this.detectSTOP = new JCheckBox();
        this.detectSTOP.setSelected(true);
        panel.add(SwingComponentUtils.createRightAlignedLabel((String)"Show STOP?"));
        panel.add(this.detectSTOP);
        this.detectACK = new JCheckBox();
        this.detectACK.setSelected(true);
        panel.add(SwingComponentUtils.createRightAlignedLabel((String)"Show ACK?"));
        panel.add(this.detectACK);
        this.detectNACK = new JCheckBox();
        this.detectNACK.setSelected(true);
        panel.add(SwingComponentUtils.createRightAlignedLabel((String)"Show NACK?"));
        panel.add(this.detectNACK);
        SpringLayoutUtils.addSeparator((Container)panel, (String)"Bus configuration");
        panel.add(SwingComponentUtils.createRightAlignedLabel((String)"SCL"));
        panel.add(this.busSetSCL);
        panel.add(SwingComponentUtils.createRightAlignedLabel((String)"SDA"));
        panel.add(this.busSetSDA);
        SpringLayoutUtils.makeEditorGrid((Container)panel, (int)10, (int)4);
        return panel;
    }

    private String getEmptyHtmlPage() {
        ExportUtils.HtmlExporter exporter = this.createHtmlTemplate(ExportUtils.createHtmlExporter());
        return exporter.toString(new ExportUtils.HtmlExporter.MacroResolver(){

            public Object resolve(String aMacro, ExportUtils.HtmlExporter.Element aParent) {
                if ("date-now".equals(aMacro)) {
                    DateFormat df = DateFormat.getDateInstance(1);
                    return df.format(new Date());
                }
                if ("sda-bus-config".equals(aMacro) || "scl-bus-config".equals(aMacro)) {
                    return "&lt;auto detect&gt;";
                }
                if ("decoded-bytes".equals(aMacro) || "detected-bus-errors".equals(aMacro)) {
                    return "-";
                }
                return null;
            }
        });
    }

    private void initDialog() {
        this.setMinimumSize(new Dimension(640, 480));
        JPanel settingsPane = this.createSettingsPane();
        JPanel previewPane = this.createPreviewPane();
        JPanel contentPane = new JPanel(new GridBagLayout());
        contentPane.add((Component)settingsPane, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 11, 0, new Insets(2, 0, 2, 0), 0, 0));
        contentPane.add((Component)previewPane, new GridBagConstraints(1, 0, 1, 1, 1.0, 1.0, 11, 1, new Insets(2, 0, 2, 0), 0, 0));
        JButton runAnalysisButton = ToolUtils.createRunAnalysisButton((ToolDialog)this);
        this.runAnalysisAction = (ToolUtils.RestorableAction)runAnalysisButton.getAction();
        JButton exportButton = ToolUtils.createExportButton((ExportAware)this);
        this.exportAction = exportButton.getAction();
        this.exportAction.setEnabled(false);
        JButton closeButton = ToolUtils.createCloseButton();
        this.closeAction = closeButton.getAction();
        JComponent buttonPane = SwingComponentUtils.createButtonPane((JButton[])new JButton[]{runAnalysisButton, exportButton, closeButton});
        SwingComponentUtils.setupWindowContentPane((Window)((Object)this), (Component)contentPane, (Component)buttonPane, (JButton)runAnalysisButton);
        this.pack();
    }

    private void storeToCsvFile(File aSelectedFile, I2CDataSet aAnalysisResult) {
        block3: {
            try {
                ExportUtils.CsvExporter exporter = ExportUtils.createCsvExporter((File)aSelectedFile);
                exporter.setHeaders(new String[]{"index", "start-time", "end-time", "event?", "event-type", "data"});
                List dataSet = aAnalysisResult.getData();
                for (int i = 0; i < dataSet.size(); ++i) {
                    I2CData ds = (I2CData)((Object)dataSet.get(i));
                    String startTime = Unit.Time.format((double)aAnalysisResult.getTime(ds.getStartSampleIndex()));
                    String endTime = Unit.Time.format((double)aAnalysisResult.getTime(ds.getEndSampleIndex()));
                    String data = ds.isEvent() ? "" : Character.toString((char)ds.getValue());
                    exporter.addRow(new Object[]{i, startTime, endTime, ds.isEvent(), ds.getEventName(), data});
                }
                exporter.close();
            }
            catch (IOException exception) {
                if (HostUtils.handleInterruptedException((Throwable)exception)) break block3;
                LOG.log(Level.WARNING, "CSV export failed!", exception);
            }
        }
    }

    private void storeToHtmlFile(File aSelectedFile, I2CDataSet aAnalysisResult) {
        block2: {
            try {
                this.toHtmlPage(aSelectedFile, aAnalysisResult);
            }
            catch (IOException exception) {
                if (HostUtils.handleInterruptedException((Throwable)exception)) break block2;
                LOG.log(Level.WARNING, "HTML export failed!", exception);
            }
        }
    }

    private String toHtmlPage(File aFile, final I2CDataSet aAnalysisResult) throws IOException {
        ExportUtils.HtmlExporter.MacroResolver macroResolver = new ExportUtils.HtmlExporter.MacroResolver(){

            public Object resolve(String aMacro, ExportUtils.HtmlExporter.Element aParent) {
                if ("date-now".equals(aMacro)) {
                    DateFormat df = DateFormat.getDateInstance(1);
                    return df.format(new Date());
                }
                if ("sda-bus-config".equals(aMacro)) {
                    return I2CProtocolAnalysisDialog.this.busSetSDA.getText();
                }
                if ("scl-bus-config".equals(aMacro)) {
                    return I2CProtocolAnalysisDialog.this.busSetSCL.getText();
                }
                if ("decoded-bytes".equals(aMacro)) {
                    return aAnalysisResult.getDecodedByteCount();
                }
                if ("detected-bus-errors".equals(aMacro)) {
                    return aAnalysisResult.getBusErrorCount();
                }
                if ("decoded-data".equals(aMacro)) {
                    List dataSet = aAnalysisResult.getData();
                    for (int i = 0; i < dataSet.size(); ++i) {
                        ExportUtils.HtmlExporter.Element tr;
                        I2CData data = (I2CData)((Object)dataSet.get(i));
                        if (data.isEvent()) {
                            String event = data.getEventName();
                            String bgColor = "START".equals(event) || "STOP".equals(event) ? "#e0e0e0" : ("ACK".equals(event) ? "#c0ffc0" : ("NACK".equals(event) ? "#ffc0c0" : "#ff8000"));
                            tr = aParent.addChild(ExportUtils.HtmlExporter.TR).addAttribute("style", "background-color: " + bgColor + ";");
                            tr.addChild(ExportUtils.HtmlExporter.TD).addContent(new String[]{String.valueOf(i)});
                            tr.addChild(ExportUtils.HtmlExporter.TD).addContent(new String[]{Unit.Time.format((double)aAnalysisResult.getTime(data.getStartSampleIndex()))});
                            tr.addChild(ExportUtils.HtmlExporter.TD).addContent(new String[]{event});
                            tr.addChild(ExportUtils.HtmlExporter.TD);
                            tr.addChild(ExportUtils.HtmlExporter.TD);
                            tr.addChild(ExportUtils.HtmlExporter.TD);
                            continue;
                        }
                        int value = data.getValue();
                        tr = aParent.addChild(ExportUtils.HtmlExporter.TR);
                        tr.addChild(ExportUtils.HtmlExporter.TD).addContent(new String[]{String.valueOf(i)});
                        tr.addChild(ExportUtils.HtmlExporter.TD).addContent(new String[]{Unit.Time.format((double)aAnalysisResult.getTime(data.getStartSampleIndex()))});
                        tr.addChild(ExportUtils.HtmlExporter.TD).addContent(new String[]{"0x" + StringUtils.integerToHexString((int)value, (int)2)});
                        tr.addChild(ExportUtils.HtmlExporter.TD).addContent(new String[]{"0b" + StringUtils.integerToBinString((int)value, (int)8)});
                        tr.addChild(ExportUtils.HtmlExporter.TD).addContent(new String[]{String.valueOf(value)});
                        tr.addChild(ExportUtils.HtmlExporter.TD).addContent(new String[]{String.valueOf((char)value)});
                    }
                }
                return null;
            }
        };
        if (aFile == null) {
            ExportUtils.HtmlExporter exporter = this.createHtmlTemplate(ExportUtils.createHtmlExporter());
            return exporter.toString(macroResolver);
        }
        ExportUtils.HtmlFileExporter exporter = (ExportUtils.HtmlFileExporter)this.createHtmlTemplate((ExportUtils.HtmlExporter)ExportUtils.createHtmlExporter((File)aFile));
        exporter.write(macroResolver);
        exporter.close();
        return null;
    }
}

