/*
 * Decompiled with CFR 0.152.
 */
package nl.lxtreme.ols.tool.base;

import java.awt.Cursor;
import java.awt.Dialog;
import java.awt.Insets;
import java.awt.Window;
import java.util.concurrent.Future;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import nl.lxtreme.ols.api.Configurable;
import nl.lxtreme.ols.api.UserSettings;
import nl.lxtreme.ols.api.acquisition.AcquisitionResult;
import nl.lxtreme.ols.api.data.annotation.AnnotationListener;
import nl.lxtreme.ols.api.task.Task;
import nl.lxtreme.ols.api.task.TaskStatusListener;
import nl.lxtreme.ols.api.tools.Tool;
import nl.lxtreme.ols.api.tools.ToolContext;
import nl.lxtreme.ols.api.tools.ToolProgressListener;
import nl.lxtreme.ols.api.tools.ToolTask;
import nl.lxtreme.ols.tool.base.AnnotationListenerServiceTracker;
import nl.lxtreme.ols.tool.base.TaskExecutionServiceTracker;
import nl.lxtreme.ols.tool.base.ToolDialog;
import nl.lxtreme.ols.tool.base.ToolProgressListenerServiceTracker;
import nl.lxtreme.ols.tool.base.ToolUtils;
import nl.lxtreme.ols.util.swing.StandardActionFactory;
import nl.lxtreme.ols.util.swing.SwingComponentUtils;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;

public abstract class BaseToolDialog<RESULT_TYPE>
extends JFrame
implements ToolDialog,
TaskStatusListener,
Configurable,
StandardActionFactory.CloseAction.Closeable {
    private static final long serialVersionUID = 1L;
    protected static final Insets LABEL_INSETS = new Insets(4, 4, 4, 2);
    protected static final Insets COMP_INSETS = new Insets(4, 2, 4, 4);
    private final ToolContext context;
    private final Tool<RESULT_TYPE> tool;
    private final BundleContext bundleContext;
    private final TaskExecutionServiceTracker taskExecutionService;
    private final AnnotationListenerServiceTracker annotationListener;
    private final ToolProgressListenerServiceTracker toolProgressListener;
    private ServiceRegistration serviceReg;
    private volatile Future<RESULT_TYPE> toolFutureTask;
    private volatile ToolTask<RESULT_TYPE> toolTask;
    private volatile RESULT_TYPE lastResult;

    protected BaseToolDialog(Window aOwner, ToolContext aContext, BundleContext aBundleContext, Tool<RESULT_TYPE> aTool) {
        super(aTool.getName());
        this.context = aContext;
        this.bundleContext = aBundleContext;
        this.tool = aTool;
        this.setModalExclusionType(Dialog.ModalExclusionType.NO_EXCLUDE);
        this.taskExecutionService = new TaskExecutionServiceTracker(aBundleContext);
        this.annotationListener = new AnnotationListenerServiceTracker(aBundleContext);
        this.toolProgressListener = new ToolProgressListenerServiceTracker(aBundleContext);
    }

    @Override
    public final void cancelTool() throws IllegalStateException {
        if (this.toolFutureTask == null) {
            throw new IllegalStateException("Tool is already cancelled!");
        }
        this.toolFutureTask.cancel(true);
        this.toolFutureTask = null;
    }

    public final void close() {
        this.taskExecutionService.close();
        this.annotationListener.close();
        this.toolProgressListener.close();
        try {
            this.serviceReg.unregister();
            this.serviceReg = null;
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        this.onBeforeCloseDialog();
        this.setVisible(false);
        this.dispose();
    }

    public final ToolContext getContext() {
        return this.context;
    }

    public final RESULT_TYPE getLastResult() {
        return this.lastResult;
    }

    public final Tool<RESULT_TYPE> getTool() {
        return this.tool;
    }

    @Override
    public final boolean invokeTool() throws IllegalStateException {
        if (this.toolFutureTask != null) {
            throw new IllegalStateException("Tool is already running!");
        }
        boolean settingsValid = this.validateToolSettings();
        if (settingsValid) {
            this.toolTask = this.tool.createToolTask(this.context, (ToolProgressListener)this.toolProgressListener, (AnnotationListener)this.annotationListener);
            this.prepareToolTask(this.toolTask);
            this.toolFutureTask = this.taskExecutionService.execute(this.toolTask);
        }
        return settingsValid;
    }

    @Override
    public final void showDialog() {
        this.serviceReg = this.bundleContext.registerService(TaskStatusListener.class.getName(), (Object)this, null);
        this.taskExecutionService.open();
        this.annotationListener.open();
        this.toolProgressListener.open();
        this.onBeforeShowDialog();
        this.setVisible(true);
    }

    public final <RT> void taskEnded(Task<RT> aTask, RT aResult) {
        if (this.toolTask == aTask) {
            this.lastResult = aResult;
            SwingComponentUtils.invokeOnEDT((Runnable)new Runnable(){

                @Override
                public void run() {
                    BaseToolDialog.this.setCursor(Cursor.getPredefinedCursor(0));
                    BaseToolDialog.this.setControlsEnabled(true);
                    BaseToolDialog.this.onToolEnded(BaseToolDialog.this.lastResult);
                }
            });
            this.toolFutureTask = null;
            this.toolTask = null;
        }
    }

    public final <RT> void taskFailed(Task<RT> aTask, final Exception aException) {
        if (this.toolTask == aTask) {
            SwingComponentUtils.invokeOnEDT((Runnable)new Runnable(){

                @Override
                public void run() {
                    BaseToolDialog.this.setCursor(Cursor.getPredefinedCursor(0));
                    BaseToolDialog.this.setControlsEnabled(true);
                    BaseToolDialog.this.onToolFailed(aException);
                }
            });
            this.toolFutureTask = null;
            this.toolTask = null;
        }
    }

    public final <RT> void taskStarted(Task<RT> aTask) {
        if (this.toolTask == aTask) {
            SwingComponentUtils.invokeOnEDT((Runnable)new Runnable(){

                @Override
                public void run() {
                    BaseToolDialog.this.setCursor(Cursor.getPredefinedCursor(3));
                    BaseToolDialog.this.setControlsEnabled(false);
                    BaseToolDialog.this.onToolStarted();
                }
            });
        }
    }

    protected final BundleContext getBundleContext() {
        return this.bundleContext;
    }

    protected final AcquisitionResult getData() {
        return this.context.getData();
    }

    protected void onBeforeCloseDialog() {
    }

    protected void onBeforeShowDialog() {
    }

    protected abstract void onToolEnded(RESULT_TYPE var1);

    protected void onToolFailed(Exception aException) {
        ToolUtils.showErrorMessage(this.getOwner(), "Tool failed!\nDetails: " + aException.getMessage());
    }

    protected abstract void onToolStarted();

    protected void prepareToolTask(ToolTask<RESULT_TYPE> aToolTask) {
    }

    protected final void setComboBoxIndex(JComboBox aComboBox, UserSettings aSettings, String aSettingName) {
        ToolUtils.setComboBoxIndex(aComboBox, aSettings.getInt(aSettingName, -1));
    }

    protected void setControlsEnabled(boolean aEnabled) {
    }

    protected boolean validateToolSettings() {
        return true;
    }
}

