/*
 * Decompiled with CFR 0.152.
 */
package nl.lxtreme.ols.tool.spi;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.logging.Level;
import java.util.logging.Logger;
import nl.lxtreme.ols.api.acquisition.AcquisitionResult;
import nl.lxtreme.ols.api.data.Edge;
import nl.lxtreme.ols.api.data.annotation.Annotation;
import nl.lxtreme.ols.api.data.annotation.AnnotationListener;
import nl.lxtreme.ols.api.tools.ToolContext;
import nl.lxtreme.ols.api.tools.ToolProgressListener;
import nl.lxtreme.ols.api.tools.ToolTask;
import nl.lxtreme.ols.tool.base.annotation.ChannelLabelAnnotation;
import nl.lxtreme.ols.tool.base.annotation.SampleDataAnnotation;
import nl.lxtreme.ols.tool.spi.SPIDataSet;
import nl.lxtreme.ols.tool.spi.SPIFIMode;
import nl.lxtreme.ols.tool.spi.SPIMode;
import nl.lxtreme.ols.util.NumberUtils;
import nl.lxtreme.ols.util.analysis.Frequency;

public class SPIAnalyserTask
implements ToolTask<SPIDataSet> {
    private static final Logger LOG = Logger.getLogger(SPIAnalyserTask.class.getName());
    public static final String PROPERTY_AUTO_DETECT_MODE = "AutoDetectSPIMode";
    private final ToolContext context;
    private final ToolProgressListener progressListener;
    private final AnnotationListener annotationListener;
    private final PropertyChangeSupport pcs;
    private int csIdx;
    private int sckIdx;
    private SPIFIMode protocol;
    private SPIMode spiMode;
    private int bitCount;
    private NumberUtils.BitOrder bitOrder;
    private boolean reportCS;
    private boolean honourCS;
    private boolean invertCS;
    private int mosiIdx;
    private int misoIdx;
    private int io2Idx;
    private int io3Idx;

    public SPIAnalyserTask(ToolContext aContext, ToolProgressListener aProgressListener, AnnotationListener aAnnotationListener) {
        this.context = aContext;
        this.progressListener = aProgressListener;
        this.annotationListener = aAnnotationListener;
        this.pcs = new PropertyChangeSupport(this);
        this.misoIdx = -1;
        this.mosiIdx = -1;
        this.protocol = SPIFIMode.STANDARD;
        this.invertCS = false;
    }

    public void addPropertyChangeListener(PropertyChangeListener aListener) {
        this.pcs.addPropertyChangeListener(aListener);
    }

    public SPIDataSet call() throws Exception {
        if (LOG.isLoggable(Level.FINE)) {
            LOG.fine("csmask   = 0x" + Integer.toHexString(1 << this.csIdx));
            LOG.fine("sckmask  = 0x" + Integer.toHexString(1 << this.sckIdx));
            LOG.fine("misomask = 0x" + Integer.toHexString(1 << this.misoIdx));
            LOG.fine("mosimask = 0x" + Integer.toHexString(1 << this.mosiIdx));
        }
        int startOfDecode = this.context.getStartSampleIndex();
        int endOfDecode = this.context.getEndSampleIndex();
        int slaveSelected = this.slaveSelected(startOfDecode, endOfDecode);
        if (this.honourCS && slaveSelected < 0 || startOfDecode >= endOfDecode) {
            LOG.log(Level.WARNING, "No CS start-condition found! Analysis aborted...");
            throw new IllegalStateException("No CS start-condition found!");
        }
        this.prepareResults();
        if (this.spiMode == null || this.spiMode == SPIMode.AUTODETECT) {
            LOG.log(Level.INFO, "Detecting which SPI mode is most probably used...");
            this.spiMode = this.detectSPIMode(startOfDecode, endOfDecode);
        }
        this.pcs.firePropertyChange(PROPERTY_AUTO_DETECT_MODE, null, (Object)this.spiMode);
        SPIDataSet decodedData = new SPIDataSet(startOfDecode, endOfDecode, this.context.getData());
        if (slaveSelected >= 0) {
            this.reportCsLow(decodedData, slaveSelected);
        }
        this.clockDataOnEdge(decodedData, this.spiMode, slaveSelected);
        return decodedData;
    }

    public void removePropertyChangeListener(PropertyChangeListener aListener) {
        this.pcs.removePropertyChangeListener(aListener);
    }

    public void setBitCount(int aBitCount) {
        this.bitCount = aBitCount;
    }

    public void setCSIndex(int aCsIndex) {
        this.csIdx = aCsIndex;
    }

    public void setHonourCS(boolean aHonourCS) {
        this.honourCS = aHonourCS;
    }

    public void setInvertCS(boolean aInvertCS) {
        this.invertCS = aInvertCS;
    }

    public void setIO0Index(int aIndex) {
        this.mosiIdx = aIndex;
    }

    public void setIO1Index(int aIndex) {
        this.misoIdx = aIndex;
    }

    public void setIO2Index(int aIndex) {
        this.io2Idx = aIndex;
    }

    public void setIO3Index(int aIndex) {
        this.io3Idx = aIndex;
    }

    public void setOrder(NumberUtils.BitOrder aOrder) {
        this.bitOrder = aOrder;
    }

    public void setProtocol(SPIFIMode aProtocol) {
        this.protocol = aProtocol;
    }

    public void setReportCS(boolean aReportCS) {
        this.reportCS = aReportCS;
    }

    public void setSCKIndex(int aSckIndex) {
        this.sckIdx = aSckIndex;
    }

    public void setSPIMode(SPIMode aMode) {
        this.spiMode = aMode;
    }

    private void clockDataOnEdge(SPIDataSet aDataSet, SPIMode aMode, int aSlaveSelectedIdx) {
        AcquisitionResult data = this.context.getData();
        int[] values = data.getValues();
        int startOfDecode = Math.max(aSlaveSelectedIdx, aDataSet.getStartOfDecode());
        int endOfDecode = aDataSet.getEndOfDecode();
        int mosiMask = 1 << this.mosiIdx;
        int misoMask = 1 << this.misoIdx;
        int io2Mask = 1 << this.io2Idx;
        int io3Mask = 1 << this.io3Idx;
        int sckMask = 1 << this.sckIdx;
        int csMask = 1 << this.csIdx;
        int oldSckValue = values[startOfDecode] & sckMask;
        int oldCsValue = values[startOfDecode] & csMask;
        boolean slaveSelected = true;
        int dataStartIdx = startOfDecode;
        int bitIdx = this.bitCount;
        int clockEdgeCount = (this.bitCount + 1) * 2;
        int clockEdgeIdx = 0;
        int misovalue = 0;
        int mosivalue = 0;
        for (int idx = startOfDecode + 1; idx < endOfDecode; ++idx) {
            boolean sampleEdgeSeen;
            int dataSample = values[idx];
            int sckValue = dataSample & sckMask;
            int csValue = dataSample & csMask;
            Edge slaveSelectEdge = Edge.toEdge((int)oldCsValue, (int)csValue);
            oldCsValue = csValue;
            if (slaveSelectEdge.isFalling()) {
                this.reportCsLow(aDataSet, idx);
                slaveSelected = !this.invertCS;
            } else if (slaveSelectEdge.isRising()) {
                this.reportCsHigh(aDataSet, idx);
                slaveSelected = this.invertCS;
                if (bitIdx <= 0) {
                    this.reportData(aDataSet, dataStartIdx, idx, mosivalue, misovalue);
                    bitIdx = this.bitCount;
                    misovalue = 0;
                    mosivalue = 0;
                }
            }
            if (this.honourCS && !slaveSelected) continue;
            Edge clockEdge = Edge.toEdge((int)oldSckValue, (int)sckValue);
            oldSckValue = sckValue;
            if (clockEdge.isRising() || clockEdge.isFalling()) {
                boolean bl = sampleEdgeSeen = ((clockEdgeIdx = (clockEdgeIdx + 1) % clockEdgeCount) + aMode.getCPHA()) % 2 != 0;
                if (sampleEdgeSeen && bitIdx == this.bitCount) {
                    dataStartIdx = idx;
                }
                LOG.log(Level.FINE, "Clock edge: {0}, idx: {1}, sample? {2}", new Object[]{clockEdge, clockEdgeIdx, sampleEdgeSeen});
            } else {
                sampleEdgeSeen = false;
            }
            if (sampleEdgeSeen) {
                if (SPIFIMode.STANDARD.equals((Object)this.protocol)) {
                    if (this.misoIdx >= 0 && (dataSample & misoMask) != 0) {
                        misovalue |= 1 << bitIdx;
                    }
                    if (this.mosiIdx >= 0 && (dataSample & mosiMask) != 0) {
                        mosivalue |= 1 << bitIdx;
                    }
                    if (bitIdx >= 0) {
                        --bitIdx;
                    }
                } else if (SPIFIMode.DUAL.equals((Object)this.protocol)) {
                    if ((dataSample & misoMask) != 0) {
                        mosivalue |= 1 << bitIdx;
                    }
                    --bitIdx;
                    if ((dataSample & mosiMask) != 0) {
                        mosivalue |= 1 << bitIdx;
                    }
                    --bitIdx;
                } else if (SPIFIMode.QUAD.equals((Object)this.protocol)) {
                    if ((dataSample & io3Mask) != 0) {
                        mosivalue |= 1 << bitIdx;
                    }
                    --bitIdx;
                    if ((dataSample & io2Mask) != 0) {
                        mosivalue |= 1 << bitIdx;
                    }
                    --bitIdx;
                    if ((dataSample & misoMask) != 0) {
                        mosivalue |= 1 << bitIdx;
                    }
                    --bitIdx;
                    if ((dataSample & mosiMask) != 0) {
                        mosivalue |= 1 << bitIdx;
                    }
                    --bitIdx;
                }
                if (bitIdx < 0) {
                    this.reportData(aDataSet, dataStartIdx, idx, mosivalue, misovalue);
                    bitIdx = this.bitCount;
                    misovalue = 0;
                    mosivalue = 0;
                }
            }
            this.progressListener.setProgress(NumberUtils.getPercentage((int)idx, (int)startOfDecode, (int)endOfDecode));
        }
    }

    private SPIMode detectSPIMode(int aStartIndex, int aEndIndex) {
        SPIMode result;
        AcquisitionResult data = this.context.getData();
        Frequency valueStats = new Frequency();
        int[] values = data.getValues();
        int sckMask = 1 << this.sckIdx;
        for (int i = aStartIndex; i < aEndIndex; ++i) {
            int newValue = (values[i] & sckMask) >> this.sckIdx;
            valueStats.addValue((Comparable)Integer.valueOf(newValue));
        }
        if ((Integer)valueStats.getHighestRanked() == 1) {
            LOG.log(Level.INFO, "SPI mode is probably mode 2 or 3 (CPOL == 1). Assuming mode 2 ...");
            result = SPIMode.MODE_2;
        } else {
            LOG.log(Level.INFO, "SPI mode is probably mode 0 or 1 (CPOL == 0). Assuming mode 0 ...");
            result = SPIMode.MODE_0;
        }
        return result;
    }

    private void prepareResults() {
        String label;
        if (this.mosiIdx >= 0) {
            label = SPIFIMode.STANDARD.equals((Object)this.protocol) ? "MOSI" : "IO0";
            this.annotationListener.clearAnnotations(this.mosiIdx);
            this.annotationListener.onAnnotation((Annotation)new ChannelLabelAnnotation(this.mosiIdx, label));
        }
        if (this.misoIdx >= 0) {
            label = SPIFIMode.STANDARD.equals((Object)this.protocol) ? "MISO" : "IO1";
            this.annotationListener.clearAnnotations(this.misoIdx);
            this.annotationListener.onAnnotation((Annotation)new ChannelLabelAnnotation(this.misoIdx, label));
        }
        if (this.io2Idx >= 0) {
            this.annotationListener.clearAnnotations(this.io2Idx);
            this.annotationListener.onAnnotation((Annotation)new ChannelLabelAnnotation(this.io2Idx, "IO2"));
        }
        if (this.io3Idx >= 0) {
            this.annotationListener.clearAnnotations(this.io3Idx);
            this.annotationListener.onAnnotation((Annotation)new ChannelLabelAnnotation(this.io3Idx, "IO3"));
        }
        if (this.sckIdx >= 0) {
            this.annotationListener.clearAnnotations(this.sckIdx);
            this.annotationListener.onAnnotation((Annotation)new ChannelLabelAnnotation(this.sckIdx, "SCK"));
        }
        if (this.csIdx >= 0) {
            this.annotationListener.clearAnnotations(this.csIdx);
            this.annotationListener.onAnnotation((Annotation)new ChannelLabelAnnotation(this.csIdx, "/CS"));
        }
    }

    private void reportCsHigh(SPIDataSet aDecodedData, int aIndex) {
        if (this.reportCS) {
            aDecodedData.reportCSHigh(this.csIdx, aIndex);
        }
    }

    private void reportCsLow(SPIDataSet aDecodedData, int aIndex) {
        if (this.reportCS) {
            aDecodedData.reportCSLow(this.csIdx, aIndex);
        }
    }

    private void reportData(SPIDataSet aDecodedData, int aStartIdx, int aEndIdx, int aMosiValue, int aMisoValue) {
        long[] timestamps = this.context.getData().getTimestamps();
        if (SPIFIMode.STANDARD.equals((Object)this.protocol)) {
            String formatSpec;
            if (this.mosiIdx >= 0) {
                int mosivalue = NumberUtils.convertBitOrder((int)aMosiValue, (int)(this.bitCount + 1), (NumberUtils.BitOrder)this.bitOrder);
                formatSpec = "0x%1$X";
                if (Character.isLetterOrDigit(mosivalue)) {
                    formatSpec = formatSpec.concat(" (%1$c)");
                }
                this.annotationListener.onAnnotation((Annotation)new SampleDataAnnotation(this.mosiIdx, timestamps[aStartIdx], timestamps[aEndIdx], String.format(formatSpec, mosivalue)));
                aDecodedData.reportMosiData(this.mosiIdx, aStartIdx, aEndIdx, mosivalue);
            }
            if (this.misoIdx >= 0) {
                int misovalue = NumberUtils.convertBitOrder((int)aMisoValue, (int)(this.bitCount + 1), (NumberUtils.BitOrder)this.bitOrder);
                formatSpec = "0x%1$X";
                if (Character.isLetterOrDigit(misovalue)) {
                    formatSpec = formatSpec.concat(" (%1$c)");
                }
                this.annotationListener.onAnnotation((Annotation)new SampleDataAnnotation(this.misoIdx, timestamps[aStartIdx], timestamps[aEndIdx], String.format(formatSpec, misovalue)));
                aDecodedData.reportMisoData(this.misoIdx, aStartIdx, aEndIdx, misovalue);
            }
        } else {
            int mosivalue = NumberUtils.convertBitOrder((int)aMosiValue, (int)(this.bitCount + 1), (NumberUtils.BitOrder)this.bitOrder);
            String formatSpec = "0x%1$X";
            if (Character.isLetterOrDigit(mosivalue)) {
                formatSpec = formatSpec.concat(" (%1$c)");
            }
            this.annotationListener.onAnnotation((Annotation)new SampleDataAnnotation(this.mosiIdx, timestamps[aStartIdx], timestamps[aEndIdx], String.format(formatSpec, mosivalue)));
            aDecodedData.reportMosiData(this.mosiIdx, aStartIdx, aEndIdx, mosivalue);
        }
    }

    private int searchSlaveSelected(int aStartIndex, int aEndIndex) {
        AcquisitionResult data = this.context.getData();
        int[] values = data.getValues();
        int csMask = 1 << this.csIdx;
        int oldCsValue = values[aStartIndex] & csMask;
        for (int i = aStartIndex + 1; i < aEndIndex; ++i) {
            int csValue = values[i] & csMask;
            Edge edge = Edge.toEdge((int)oldCsValue, (int)csValue);
            if (this.invertCS && edge.isRising() || !this.invertCS && edge.isFalling()) {
                if (LOG.isLoggable(Level.FINE)) {
                    LOG.fine("CS found at " + i);
                }
                return i;
            }
            oldCsValue = csValue;
        }
        return -1;
    }

    private int slaveSelected(int aStartOfDecode, int aEndOfDecode) {
        int slaveSelected = -1;
        if (aStartOfDecode > 0) {
            slaveSelected = this.searchSlaveSelected(0, aStartOfDecode);
        }
        if (slaveSelected < 0) {
            slaveSelected = this.searchSlaveSelected(aStartOfDecode, aEndOfDecode);
        }
        return slaveSelected;
    }
}

