/*
 * Decompiled with CFR 0.152.
 */
package nl.lxtreme.ols.tool.spi;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.IOException;
import java.text.DateFormat;
import java.util.BitSet;
import java.util.Date;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.Action;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.SpringLayout;
import nl.lxtreme.ols.api.UserSettings;
import nl.lxtreme.ols.api.tools.Tool;
import nl.lxtreme.ols.api.tools.ToolContext;
import nl.lxtreme.ols.api.tools.ToolTask;
import nl.lxtreme.ols.api.util.Unit;
import nl.lxtreme.ols.tool.base.BaseToolDialog;
import nl.lxtreme.ols.tool.base.ExportAware;
import nl.lxtreme.ols.tool.base.ToolDialog;
import nl.lxtreme.ols.tool.base.ToolUtils;
import nl.lxtreme.ols.tool.spi.SPIAnalyser;
import nl.lxtreme.ols.tool.spi.SPIAnalyserTask;
import nl.lxtreme.ols.tool.spi.SPIData;
import nl.lxtreme.ols.tool.spi.SPIDataSet;
import nl.lxtreme.ols.tool.spi.SPIFIMode;
import nl.lxtreme.ols.tool.spi.SPIMode;
import nl.lxtreme.ols.util.ExportUtils;
import nl.lxtreme.ols.util.HostUtils;
import nl.lxtreme.ols.util.NumberUtils;
import nl.lxtreme.ols.util.StringUtils;
import nl.lxtreme.ols.util.swing.SpringLayoutUtils;
import nl.lxtreme.ols.util.swing.SwingComponentUtils;
import nl.lxtreme.ols.util.swing.component.EnumItemRenderer;
import nl.lxtreme.ols.util.swing.component.JErrorDialog;
import org.osgi.framework.BundleContext;

public final class SPIProtocolAnalysisDialog
extends BaseToolDialog<SPIDataSet>
implements ExportAware<SPIDataSet>,
PropertyChangeListener {
    private static final long serialVersionUID = 1L;
    private static final Logger LOG = Logger.getLogger(SPIProtocolAnalysisDialog.class.getName());
    private JLabel misoLabel;
    private JLabel mosiLabel;
    private JLabel io2Label;
    private JLabel io3Label;
    private JComboBox sck;
    private JComboBox miso;
    private JComboBox mosi;
    private JComboBox io2;
    private JComboBox io3;
    private JComboBox cs;
    private JComboBox mode;
    private JComboBox bits;
    private JComboBox order;
    private JComboBox spifiMode;
    private JEditorPane outText;
    private JCheckBox reportCS;
    private JCheckBox honourCS;
    private JCheckBox invertCS;
    private ToolUtils.RestorableAction runAnalysisAction;
    private Action exportAction;
    private Action closeAction;
    private SPIMode detectedSPIMode;

    public SPIProtocolAnalysisDialog(Window aOwner, ToolContext aToolContext, BundleContext aContext, SPIAnalyser aTool) {
        super(aOwner, aToolContext, aContext, (Tool)aTool);
        this.initDialog();
        this.setLocationRelativeTo(this.getOwner());
    }

    public void exportToFile(File aOutputFile, ExportAware.ExportFormat aFormat) throws IOException {
        if (ExportAware.ExportFormat.HTML.equals((Object)aFormat)) {
            this.storeToHtmlFile(aOutputFile, (SPIDataSet)((Object)this.getLastResult()));
        } else if (ExportAware.ExportFormat.CSV.equals((Object)aFormat)) {
            this.storeToCsvFile(aOutputFile, (SPIDataSet)((Object)this.getLastResult()));
        }
    }

    @Override
    public void propertyChange(final PropertyChangeEvent aEvent) {
        String name = aEvent.getPropertyName();
        if ("AutoDetectSPIMode".equals(name)) {
            SwingComponentUtils.invokeOnEDT((Runnable)new Runnable(){

                @Override
                public void run() {
                    Object value = aEvent.getNewValue();
                    SPIProtocolAnalysisDialog.this.setAutoDetectSPIMode((SPIMode)((Object)value));
                }
            });
        }
    }

    public void readPreferences(UserSettings aSettings) {
        this.spifiMode.setSelectedIndex(aSettings.getInt("protocol", this.spifiMode.getSelectedIndex()));
        this.reportCS.setSelected(aSettings.getBoolean("reportCS", this.reportCS.isSelected()));
        this.honourCS.setSelected(aSettings.getBoolean("honourCS", this.honourCS.isSelected()));
        this.invertCS.setSelected(aSettings.getBoolean("invertCS", this.invertCS.isSelected()));
        this.setComboBoxIndex(this.sck, aSettings, "sck");
        this.setComboBoxIndex(this.miso, aSettings, "miso");
        this.setComboBoxIndex(this.mosi, aSettings, "mosi");
        this.setComboBoxIndex(this.io2, aSettings, "io2");
        this.setComboBoxIndex(this.io3, aSettings, "io3");
        this.setComboBoxIndex(this.cs, aSettings, "cs");
        this.mode.setSelectedIndex(aSettings.getInt("mode", this.mode.getSelectedIndex()));
        this.bits.setSelectedIndex(aSettings.getInt("bits", this.bits.getSelectedIndex()));
        this.order.setSelectedIndex(aSettings.getInt("order", this.order.getSelectedIndex()));
        this.updateSPIFIModeSettings((SPIFIMode)((Object)this.spifiMode.getSelectedItem()));
    }

    public void reset() {
        this.outText.setText(this.getEmptyHtmlPage());
        this.outText.setEditable(false);
        this.runAnalysisAction.restore();
        this.setControlsEnabled(true);
        this.exportAction.setEnabled(false);
    }

    public void setAutoDetectSPIMode(SPIMode aMode) {
        this.detectedSPIMode = aMode;
    }

    public void writePreferences(UserSettings aSettings) {
        aSettings.putBoolean("reportCS", this.reportCS.isSelected());
        aSettings.putBoolean("honourCS", this.honourCS.isSelected());
        aSettings.putBoolean("invertCS", this.invertCS.isSelected());
        aSettings.putInt("protocol", this.spifiMode.getSelectedIndex());
        aSettings.putInt("sck", this.sck.getSelectedIndex());
        aSettings.putInt("miso", this.miso.getSelectedIndex());
        aSettings.putInt("mosi", this.mosi.getSelectedIndex());
        aSettings.putInt("io2", this.io2.getSelectedIndex());
        aSettings.putInt("io3", this.io3.getSelectedIndex());
        aSettings.putInt("cs", this.cs.getSelectedIndex());
        aSettings.putInt("mode", this.mode.getSelectedIndex());
        aSettings.putInt("bits", this.bits.getSelectedIndex());
        aSettings.putInt("order", this.order.getSelectedIndex());
    }

    final void updateSPIFIModeSettings(SPIFIMode aMode) {
        boolean enabled = false;
        if (aMode == null || SPIFIMode.STANDARD.equals((Object)aMode)) {
            this.misoLabel.setText("MISO");
            this.mosiLabel.setText("MOSI");
        } else {
            this.mosiLabel.setText("IO0");
            this.misoLabel.setText("IO1");
            enabled = SPIFIMode.QUAD.equals((Object)aMode);
        }
        this.io2Label.setEnabled(enabled);
        this.io2.setEnabled(enabled);
        this.io3Label.setEnabled(enabled);
        this.io3.setEnabled(enabled);
    }

    protected void onToolEnded(SPIDataSet aAnalysisResult) {
        block4: {
            try {
                String htmlPage;
                if (aAnalysisResult != null) {
                    htmlPage = this.toHtmlPage(null, aAnalysisResult);
                    this.exportAction.setEnabled(!aAnalysisResult.isEmpty());
                } else {
                    htmlPage = this.getEmptyHtmlPage();
                    this.exportAction.setEnabled(false);
                }
                this.outText.setText(htmlPage);
                this.outText.setEditable(false);
                this.runAnalysisAction.restore();
            }
            catch (IOException exception) {
                if (HostUtils.handleInterruptedException((Throwable)exception)) break block4;
                throw new RuntimeException(exception);
            }
        }
    }

    protected void onToolStarted() {
    }

    protected void prepareToolTask(ToolTask<SPIDataSet> aToolTask) {
        SPIAnalyserTask toolTask = (SPIAnalyserTask)aToolTask;
        toolTask.setBitCount(Integer.parseInt((String)this.bits.getSelectedItem()) - 1);
        toolTask.setCSIndex(this.cs.getSelectedIndex());
        toolTask.setSCKIndex(this.sck.getSelectedIndex());
        toolTask.setIO0Index(this.mosi.getSelectedIndex() - 1);
        toolTask.setIO1Index(this.miso.getSelectedIndex() - 1);
        toolTask.setIO2Index(this.io2.getSelectedIndex() - 1);
        toolTask.setIO3Index(this.io3.getSelectedIndex() - 1);
        toolTask.setProtocol((SPIFIMode)((Object)this.spifiMode.getSelectedItem()));
        toolTask.setReportCS(this.reportCS.isSelected());
        toolTask.setHonourCS(this.honourCS.isSelected());
        toolTask.setInvertCS(this.invertCS.isSelected());
        toolTask.setOrder((NumberUtils.BitOrder)this.order.getSelectedItem());
        toolTask.setSPIMode((SPIMode)((Object)this.mode.getSelectedItem()));
        toolTask.addPropertyChangeListener(this);
    }

    protected void setControlsEnabled(boolean aEnable) {
        this.spifiMode.setEnabled(aEnable);
        this.reportCS.setEnabled(aEnable);
        this.honourCS.setEnabled(aEnable);
        this.sck.setEnabled(aEnable);
        this.miso.setEnabled(aEnable);
        this.mosi.setEnabled(aEnable);
        this.io2.setEnabled(aEnable);
        this.io3.setEnabled(aEnable);
        this.cs.setEnabled(aEnable);
        this.mode.setEnabled(aEnable);
        this.bits.setEnabled(aEnable);
        this.order.setEnabled(aEnable);
        this.closeAction.setEnabled(aEnable);
        this.exportAction.setEnabled(aEnable);
    }

    protected boolean validateToolSettings() {
        BitSet bitset = new BitSet();
        bitset.set(this.cs.getSelectedIndex());
        bitset.set(this.sck.getSelectedIndex());
        int expectedBitCount = 2;
        SPIFIMode protocol = (SPIFIMode)((Object)this.spifiMode.getSelectedItem());
        if (SPIFIMode.DUAL.equals((Object)protocol)) {
            if (this.mosi.getSelectedIndex() < 1 || this.miso.getSelectedIndex() < 1) {
                JErrorDialog.showDialog((Window)this.getOwner(), (String)"Cannot start analysis!", (String)"Invalid settings detected!", (String)"For dual-mode SPI, you need to assign both IO0 and IO1.");
                return false;
            }
            bitset.set(this.mosi.getSelectedIndex() - 1);
            bitset.set(this.miso.getSelectedIndex() - 1);
            expectedBitCount += 2;
        } else if (SPIFIMode.QUAD.equals((Object)protocol)) {
            if (this.mosi.getSelectedIndex() < 1 || this.miso.getSelectedIndex() < 1 || this.io2.getSelectedIndex() < 1 || this.io3.getSelectedIndex() < 1) {
                JErrorDialog.showDialog((Window)this.getOwner(), (String)"Cannot start analysis!", (String)"Invalid settings detected!", (String)"For quad-mode SPI, you need to assign IO0, IO1, IO2 and IO3.");
                return false;
            }
            bitset.set(this.mosi.getSelectedIndex() - 1);
            bitset.set(this.miso.getSelectedIndex() - 1);
            bitset.set(this.io2.getSelectedIndex() - 1);
            bitset.set(this.io3.getSelectedIndex() - 1);
            expectedBitCount += 4;
        } else {
            if (this.miso.getSelectedIndex() > 0) {
                bitset.set(this.miso.getSelectedIndex() - 1);
                ++expectedBitCount;
            }
            if (this.mosi.getSelectedIndex() > 0) {
                bitset.set(this.mosi.getSelectedIndex() - 1);
                ++expectedBitCount;
            }
        }
        if (bitset.cardinality() != expectedBitCount) {
            JErrorDialog.showDialog((Window)this.getOwner(), (String)"Cannot start analysis!", (String)"Invalid settings detected!", (String)"Not all signals are assigned to unique channels.");
            return false;
        }
        return true;
    }

    private ExportUtils.HtmlExporter createHtmlTemplate(ExportUtils.HtmlExporter aExporter) {
        aExporter.addCssStyle("body { font-family: sans-serif; } ");
        aExporter.addCssStyle("table { border-width: 1px; border-spacing: 0px; border-color: gray; border-collapse: collapse; border-style: solid; margin-bottom: 15px; } ");
        aExporter.addCssStyle("table th { border-width: 1px; padding: 2px; border-style: solid; border-color: gray; background-color: #C0C0FF; text-align: left; font-weight: bold; font-family: sans-serif; } ");
        aExporter.addCssStyle("table td { border-width: 1px; padding: 2px; border-style: solid; border-color: gray; font-family: monospace; } ");
        aExporter.addCssStyle(".date { text-align: right; font-size: x-small; margin-bottom: 15px; } ");
        aExporter.addCssStyle(".w100 { width: 100%; } ");
        aExporter.addCssStyle(".w35 { width: 35%; } ");
        aExporter.addCssStyle(".w30 { width: 30%; } ");
        aExporter.addCssStyle(".w15 { width: 15%; } ");
        aExporter.addCssStyle(".w10 { width: 10%; } ");
        aExporter.addCssStyle(".w8 { width: 8%; } ");
        aExporter.addCssStyle(".w7 { width: 7%; } ");
        ExportUtils.HtmlExporter.Element body = aExporter.getBody();
        body.addChild(ExportUtils.HtmlExporter.H1).addContent(new String[]{"SPI Analysis results"});
        body.addChild(ExportUtils.HtmlExporter.HR);
        body.addChild(ExportUtils.HtmlExporter.DIV).addAttribute("class", "date").addContent(new String[]{"Generated: ", "{date-now}"});
        ExportUtils.HtmlExporter.Element table = body.addChild(ExportUtils.HtmlExporter.TABLE).addAttribute("class", "w100");
        ExportUtils.HtmlExporter.Element tbody = table.addChild(ExportUtils.HtmlExporter.TBODY);
        ExportUtils.HtmlExporter.Element tr = tbody.addChild(ExportUtils.HtmlExporter.TR);
        tr.addChild(ExportUtils.HtmlExporter.TH).addAttribute("colspan", "2").addContent(new String[]{"Configuration"});
        tr = tbody.addChild(ExportUtils.HtmlExporter.TR);
        tr.addChild(ExportUtils.HtmlExporter.TD).addAttribute("class", "w30").addContent(new String[]{"SPI mode"});
        tr.addChild(ExportUtils.HtmlExporter.TD).addContent(new String[]{"{detected-spi-mode}"});
        table = body.addChild(ExportUtils.HtmlExporter.TABLE).addAttribute("class", "w100");
        ExportUtils.HtmlExporter.Element thead = table.addChild(ExportUtils.HtmlExporter.THEAD);
        tr = thead.addChild(ExportUtils.HtmlExporter.TR);
        tr.addChild(ExportUtils.HtmlExporter.TH).addAttribute("class", "w30").addAttribute("colspan", "2");
        tr.addChild(ExportUtils.HtmlExporter.TH).addAttribute("class", "w35").addAttribute("colspan", "4").addContent(new String[]{"MOSI"});
        tr.addChild(ExportUtils.HtmlExporter.TH).addAttribute("class", "w35").addAttribute("colspan", "4").addContent(new String[]{"MISO"});
        tr = thead.addChild(ExportUtils.HtmlExporter.TR);
        tr.addChild(ExportUtils.HtmlExporter.TH).addAttribute("class", "w15").addContent(new String[]{"Index"});
        tr.addChild(ExportUtils.HtmlExporter.TH).addAttribute("class", "w15").addContent(new String[]{"Time"});
        tr.addChild(ExportUtils.HtmlExporter.TH).addAttribute("class", "w10").addContent(new String[]{"Hex"});
        tr.addChild(ExportUtils.HtmlExporter.TH).addAttribute("class", "w10").addContent(new String[]{"Bin"});
        tr.addChild(ExportUtils.HtmlExporter.TH).addAttribute("class", "w8").addContent(new String[]{"Dec"});
        tr.addChild(ExportUtils.HtmlExporter.TH).addAttribute("class", "w7").addContent(new String[]{"ASCII"});
        tr.addChild(ExportUtils.HtmlExporter.TH).addAttribute("class", "w10").addContent(new String[]{"Hex"});
        tr.addChild(ExportUtils.HtmlExporter.TH).addAttribute("class", "w10").addContent(new String[]{"Bin"});
        tr.addChild(ExportUtils.HtmlExporter.TH).addAttribute("class", "w8").addContent(new String[]{"Dec"});
        tr.addChild(ExportUtils.HtmlExporter.TH).addAttribute("class", "w7").addContent(new String[]{"ASCII"});
        tbody = table.addChild(ExportUtils.HtmlExporter.TBODY);
        tbody.addContent(new String[]{"{decoded-data}"});
        return aExporter;
    }

    private JPanel createPreviewPane() {
        JPanel panTable = new JPanel(new GridLayout(1, 1, 0, 0));
        this.outText = new JEditorPane("text/html", this.getEmptyHtmlPage());
        this.outText.setEditable(false);
        panTable.add(new JScrollPane(this.outText));
        return panTable;
    }

    private JPanel createSettingsPane() {
        int channelCount = this.getData().getChannels();
        JPanel settings = new JPanel(new SpringLayout());
        SpringLayoutUtils.addSeparator((Container)settings, (String)"Settings");
        settings.add(SwingComponentUtils.createRightAlignedLabel((String)"Protocol"));
        this.spifiMode = new JComboBox<SPIFIMode>(SPIFIMode.values());
        this.spifiMode.setSelectedIndex(0);
        this.spifiMode.setRenderer(new SPIFIModeRenderer());
        this.spifiMode.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent aEvent) {
                JComboBox cb = (JComboBox)aEvent.getSource();
                SPIProtocolAnalysisDialog.this.updateSPIFIModeSettings((SPIFIMode)((Object)cb.getSelectedItem()));
            }
        });
        settings.add(this.spifiMode);
        settings.add(SwingComponentUtils.createRightAlignedLabel((String)"/CS"));
        this.cs = SwingComponentUtils.createChannelSelector((int)channelCount, (int)3);
        settings.add(this.cs);
        settings.add(SwingComponentUtils.createRightAlignedLabel((String)"SCK"));
        this.sck = SwingComponentUtils.createChannelSelector((int)channelCount, (int)0);
        settings.add(this.sck);
        this.mosiLabel = SwingComponentUtils.createRightAlignedLabel((String)"MOSI");
        settings.add(this.mosiLabel);
        this.mosi = SwingComponentUtils.createOptionalChannelSelector((int)channelCount, (int)3);
        settings.add(this.mosi);
        this.misoLabel = SwingComponentUtils.createRightAlignedLabel((String)"MISO");
        settings.add(this.misoLabel);
        this.miso = SwingComponentUtils.createOptionalChannelSelector((int)channelCount, (int)2);
        settings.add(this.miso);
        this.io2Label = SwingComponentUtils.createRightAlignedLabel((String)"IO2");
        settings.add(this.io2Label);
        this.io2 = SwingComponentUtils.createOptionalChannelSelector((int)channelCount, (int)0);
        settings.add(this.io2);
        this.io3Label = SwingComponentUtils.createRightAlignedLabel((String)"IO3");
        settings.add(this.io3Label);
        this.io3 = SwingComponentUtils.createOptionalChannelSelector((int)channelCount, (int)0);
        settings.add(this.io3);
        settings.add(SwingComponentUtils.createRightAlignedLabel((String)"SPI Mode"));
        this.mode = new JComboBox<SPIMode>(SPIMode.values());
        this.mode.setSelectedIndex(2);
        this.mode.setRenderer(new SPIModeRenderer());
        settings.add(this.mode);
        settings.add(SwingComponentUtils.createRightAlignedLabel((String)"Bits"));
        String[] bitarray = new String[]{"4", "5", "6", "7", "8", "9", "10", "11", "12", "13", "14", "15", "16", "24", "32"};
        this.bits = new JComboBox<String>(bitarray);
        this.bits.setSelectedIndex(4);
        settings.add(this.bits);
        settings.add(SwingComponentUtils.createRightAlignedLabel((String)"Order"));
        this.order = new JComboBox<NumberUtils.BitOrder>(NumberUtils.BitOrder.values());
        this.order.setSelectedIndex(0);
        this.order.setRenderer(new BitOrderItemRenderer());
        settings.add(this.order);
        settings.add(SwingComponentUtils.createRightAlignedLabel((String)"Show /CS?"));
        this.reportCS = new JCheckBox();
        this.reportCS.setToolTipText("Whether or not to show /CS transitions in analysis results?");
        this.reportCS.setSelected(true);
        settings.add(this.reportCS);
        settings.add(SwingComponentUtils.createRightAlignedLabel((String)"Honour /CS?"));
        this.honourCS = new JCheckBox();
        this.honourCS.setToolTipText("Whether or not to use /CS in analysis results?");
        this.honourCS.setSelected(false);
        settings.add(this.honourCS);
        settings.add(SwingComponentUtils.createRightAlignedLabel((String)"Invert CS?"));
        this.invertCS = new JCheckBox();
        this.invertCS.setToolTipText("Whether CS is default high (= unchecked) or default low (= checked).");
        this.invertCS.setSelected(false);
        settings.add(this.invertCS);
        SpringLayoutUtils.makeEditorGrid((Container)settings, (int)10, (int)4);
        this.updateSPIFIModeSettings(null);
        return settings;
    }

    private String getEmptyHtmlPage() {
        ExportUtils.HtmlExporter exporter = this.createHtmlTemplate(ExportUtils.createHtmlExporter());
        return exporter.toString(new ExportUtils.HtmlExporter.MacroResolver(){

            public Object resolve(String aMacro, ExportUtils.HtmlExporter.Element aParent) {
                if ("date-now".equals(aMacro)) {
                    DateFormat df = DateFormat.getDateInstance(1);
                    return df.format(new Date());
                }
                return null;
            }
        });
    }

    private void initDialog() {
        this.setMinimumSize(new Dimension(640, 480));
        JPanel settingsPane = this.createSettingsPane();
        JPanel previewPane = this.createPreviewPane();
        JPanel contentPane = new JPanel(new GridBagLayout());
        contentPane.add((Component)settingsPane, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 11, 0, new Insets(2, 0, 2, 0), 0, 0));
        contentPane.add((Component)previewPane, new GridBagConstraints(1, 0, 1, 1, 1.0, 1.0, 11, 1, new Insets(2, 0, 2, 0), 0, 0));
        JButton runAnalysisButton = ToolUtils.createRunAnalysisButton((ToolDialog)this);
        this.runAnalysisAction = (ToolUtils.RestorableAction)runAnalysisButton.getAction();
        JButton exportButton = ToolUtils.createExportButton((ExportAware)this);
        this.exportAction = exportButton.getAction();
        this.exportAction.setEnabled(false);
        JButton closeButton = ToolUtils.createCloseButton();
        this.closeAction = closeButton.getAction();
        JComponent buttons = SwingComponentUtils.createButtonPane((JButton[])new JButton[]{runAnalysisButton, exportButton, closeButton});
        SwingComponentUtils.setupWindowContentPane((Window)((Object)this), (Component)contentPane, (Component)buttons, (JButton)runAnalysisButton);
    }

    private void storeToCsvFile(File aFile, SPIDataSet aDataSet) {
        block3: {
            try {
                ExportUtils.CsvExporter exporter = ExportUtils.createCsvExporter((File)aFile);
                exporter.setHeaders(new String[]{"index", "start-time", "end-time", "event?", "event-type", "MOSI data", "MISO data"});
                List decodedData = aDataSet.getData();
                for (int i = 0; i < decodedData.size(); ++i) {
                    SPIData ds = (SPIData)((Object)decodedData.get(i));
                    String startTime = Unit.Time.format((double)aDataSet.getTime(ds.getStartSampleIndex()));
                    String endTime = Unit.Time.format((double)aDataSet.getTime(ds.getStartSampleIndex()));
                    String mosiDataValue = ds.isMosiData() ? Integer.toString(ds.getDataValue()) : null;
                    String misoDataValue = ds.isMisoData() ? Integer.toString(ds.getDataValue()) : null;
                    exporter.addRow(new Object[]{i, startTime, endTime, ds.isEvent(), ds.getEventName(), mosiDataValue, misoDataValue});
                }
                exporter.close();
            }
            catch (IOException exception) {
                if (HostUtils.handleInterruptedException((Throwable)exception)) break block3;
                LOG.log(Level.WARNING, "CSV export failed!", exception);
            }
        }
    }

    private void storeToHtmlFile(File aFile, SPIDataSet aDataSet) {
        block2: {
            try {
                this.toHtmlPage(aFile, aDataSet);
            }
            catch (IOException exception) {
                if (HostUtils.handleInterruptedException((Throwable)exception)) break block2;
                LOG.log(Level.WARNING, "HTML export failed!", exception);
            }
        }
    }

    private String toHtmlPage(File aFile, final SPIDataSet aDataSet) throws IOException {
        final int bitCount = Integer.parseInt((String)this.bits.getSelectedItem());
        final int bitAdder = bitCount % 4 != 0 ? 1 : 0;
        ExportUtils.HtmlExporter.MacroResolver macroResolver = new ExportUtils.HtmlExporter.MacroResolver(){

            public Object resolve(String aMacro, ExportUtils.HtmlExporter.Element aParent) {
                if ("date-now".equals(aMacro)) {
                    DateFormat df = DateFormat.getDateInstance(1);
                    return df.format(new Date());
                }
                if ("detected-spi-mode".equals(aMacro)) {
                    String result = "<unknown>";
                    switch (SPIProtocolAnalysisDialog.this.detectedSPIMode) {
                        case MODE_0: {
                            result = "Mode 0 (CPOL = 0, CPHA = 0)";
                            break;
                        }
                        case MODE_1: {
                            result = "Mode 1 (CPOL = 0, CPHA = 1)";
                            break;
                        }
                        case MODE_2: {
                            result = "Mode 2 (CPOL = 1, CPHA = 0)";
                            break;
                        }
                        case MODE_3: {
                            result = "Mode 3 (CPOL = 1, CPHA = 1)";
                            break;
                        }
                    }
                    return result;
                }
                if ("decoded-data".equals(aMacro)) {
                    List decodedData = aDataSet.getData();
                    for (int i = 0; i < decodedData.size(); ++i) {
                        SPIData nextDS;
                        int misoValue;
                        ExportUtils.HtmlExporter.Element tr;
                        SPIData ds = (SPIData)((Object)decodedData.get(i));
                        if (ds.isEvent()) {
                            String bgColor;
                            String event;
                            if ("CS_LOW".equals(ds.getEventName())) {
                                event = ds.getEventName();
                                bgColor = "#c0ffc0";
                            } else if ("CS_HIGH".equals(ds.getEventName())) {
                                event = ds.getEventName();
                                bgColor = "#e0e0e0";
                            } else {
                                event = "UNKNOWN";
                                bgColor = "#ff8000";
                            }
                            tr = aParent.addChild(ExportUtils.HtmlExporter.TR).addAttribute("style", "background-color: " + bgColor + ";");
                            tr.addChild(ExportUtils.HtmlExporter.TD).addContent(new String[]{String.valueOf(i)});
                            tr.addChild(ExportUtils.HtmlExporter.TD).addContent(new String[]{Unit.Time.format((double)aDataSet.getTime(ds.getStartSampleIndex()))});
                            tr.addChild(ExportUtils.HtmlExporter.TD).addContent(new String[]{event});
                            tr.addChild(ExportUtils.HtmlExporter.TD);
                            tr.addChild(ExportUtils.HtmlExporter.TD);
                            tr.addChild(ExportUtils.HtmlExporter.TD);
                            tr.addChild(ExportUtils.HtmlExporter.TD).addContent(new String[]{event});
                            tr.addChild(ExportUtils.HtmlExporter.TD);
                            tr.addChild(ExportUtils.HtmlExporter.TD);
                            tr.addChild(ExportUtils.HtmlExporter.TD);
                            continue;
                        }
                        if (!ds.isData()) continue;
                        int sampleIdx = ds.getStartSampleIndex();
                        tr = aParent.addChild(ExportUtils.HtmlExporter.TR);
                        tr.addChild(ExportUtils.HtmlExporter.TD).addContent(new String[]{String.valueOf(i)});
                        tr.addChild(ExportUtils.HtmlExporter.TD).addContent(new String[]{Unit.Time.format((double)aDataSet.getTime(sampleIdx))});
                        int mosiValue = ds.isMosiData() ? ds.getDataValue() : 0;
                        int n = misoValue = ds.isMisoData() ? ds.getDataValue() : 0;
                        if (i + 1 < decodedData.size() && (nextDS = (SPIData)((Object)decodedData.get(i + 1))).getStartSampleIndex() == sampleIdx) {
                            mosiValue = nextDS.isMosiData() ? nextDS.getDataValue() : mosiValue;
                            misoValue = nextDS.isMisoData() ? nextDS.getDataValue() : misoValue;
                            ++i;
                        }
                        this.addDataValues(tr, i, sampleIdx, mosiValue);
                        this.addDataValues(tr, i, sampleIdx, misoValue);
                    }
                }
                return null;
            }

            private void addDataValues(ExportUtils.HtmlExporter.Element aTableRow, int aIdx, int aSampleIdx, int aValue) {
                String mosiDataHex = StringUtils.integerToHexString((int)aValue, (int)(bitCount / 4 + bitAdder));
                String mosiDataBin = StringUtils.integerToBinString((int)aValue, (int)bitCount);
                String mosiDataDec = String.valueOf(aValue);
                String mosiDataASCII = Character.isLetterOrDigit(aValue) ? Character.toString((char)aValue) : "";
                aTableRow.addChild(ExportUtils.HtmlExporter.TD).addContent(new String[]{"0x", mosiDataHex});
                aTableRow.addChild(ExportUtils.HtmlExporter.TD).addContent(new String[]{"0b", mosiDataBin});
                aTableRow.addChild(ExportUtils.HtmlExporter.TD).addContent(new String[]{mosiDataDec});
                aTableRow.addChild(ExportUtils.HtmlExporter.TD).addContent(new String[]{mosiDataASCII});
            }
        };
        if (aFile == null) {
            ExportUtils.HtmlExporter exporter = this.createHtmlTemplate(ExportUtils.createHtmlExporter());
            return exporter.toString(macroResolver);
        }
        ExportUtils.HtmlFileExporter exporter = (ExportUtils.HtmlFileExporter)this.createHtmlTemplate((ExportUtils.HtmlExporter)ExportUtils.createHtmlExporter((File)aFile));
        exporter.write(macroResolver);
        exporter.close();
        return null;
    }

    static class SPIModeRenderer
    extends EnumItemRenderer<SPIMode> {
        private static final long serialVersionUID = 1L;

        SPIModeRenderer() {
        }

        protected String getDisplayValue(SPIMode aValue) {
            switch (aValue) {
                case AUTODETECT: {
                    return "Auto-detect";
                }
                case MODE_0: {
                    return "Mode 0";
                }
                case MODE_1: {
                    return "Mode 1";
                }
                case MODE_2: {
                    return "Mode 2";
                }
                case MODE_3: {
                    return "Mode 3";
                }
            }
            return super.getDisplayValue((Enum)aValue);
        }

        protected String getToolTip(Object aValue) {
            switch ((SPIMode)((Object)aValue)) {
                case AUTODETECT: {
                    return "Tries to determine the SPI mode based on the clock polarity (CPOL).";
                }
                case MODE_0: {
                    return "CPOL = 0, CPHA = 0";
                }
                case MODE_1: {
                    return "CPOL = 0, CPHA = 1";
                }
                case MODE_2: {
                    return "CPOL = 1, CPHA = 0";
                }
                case MODE_3: {
                    return "CPOL = 1, CPHA = 1";
                }
            }
            LOG.warning("We should not be here actually! Value = " + aValue);
            return super.getToolTip(aValue);
        }
    }

    static class SPIFIModeRenderer
    extends EnumItemRenderer<SPIFIMode> {
        private static final long serialVersionUID = 1L;

        SPIFIModeRenderer() {
        }

        protected String getDisplayValue(SPIFIMode aValue) {
            switch (aValue) {
                case STANDARD: {
                    return "Standard";
                }
                case DUAL: {
                    return "Dual mode";
                }
                case QUAD: {
                    return "Quad mode";
                }
            }
            return super.getDisplayValue((Enum)aValue);
        }
    }

    static class BitOrderItemRenderer
    extends EnumItemRenderer<NumberUtils.BitOrder> {
        private static final long serialVersionUID = 1L;

        BitOrderItemRenderer() {
        }

        protected String getDisplayValue(NumberUtils.BitOrder aValue) {
            switch (aValue) {
                case LSB_FIRST: {
                    return "LSB first";
                }
                case MSB_FIRST: {
                    return "MSB first";
                }
            }
            LOG.warning("We should not be here actually! Value = " + aValue);
            return super.getDisplayValue((Enum)aValue);
        }
    }
}

