/*
 * Decompiled with CFR 0.152.
 */
package org.sump.device.logicsniffer;

import java.io.Closeable;
import java.io.EOFException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.microedition.io.StreamConnection;
import nl.lxtreme.ols.api.acquisition.AcquisitionProgressListener;
import nl.lxtreme.ols.api.acquisition.AcquisitionResult;
import nl.lxtreme.ols.api.data.CapturedData;
import nl.lxtreme.ols.api.devices.AcquisitionTask;
import nl.lxtreme.ols.util.HostUtils;
import org.sump.device.logicsniffer.LogicSnifferConfig;
import org.sump.device.logicsniffer.profile.DeviceProfileManager;
import org.sump.device.logicsniffer.protocol.SumpCommandWriter;
import org.sump.device.logicsniffer.protocol.SumpProtocolConstants;
import org.sump.device.logicsniffer.protocol.SumpResultReader;
import org.sump.device.logicsniffer.sampleprocessor.EqualityFilter;
import org.sump.device.logicsniffer.sampleprocessor.RleDecoder;
import org.sump.device.logicsniffer.sampleprocessor.SampleProcessor;
import org.sump.device.logicsniffer.sampleprocessor.SampleProcessorCallback;

public class LogicSnifferAcquisitionTask
implements SumpProtocolConstants,
AcquisitionTask {
    private static final Logger LOG = Logger.getLogger(LogicSnifferAcquisitionTask.class.getName());
    private final DeviceProfileManager deviceProfileManager;
    private final AcquisitionProgressListener acquisitionProgressListener;
    private final LogicSnifferConfig config;
    private StreamConnection connection;
    private SumpResultReader inputStream;
    private SumpCommandWriter outputStream;
    private int trigcount;

    public LogicSnifferAcquisitionTask(LogicSnifferConfig aConfig, StreamConnection aConnection, DeviceProfileManager aDeviceProfileManager, AcquisitionProgressListener aProgressListener) {
        this.config = aConfig;
        this.connection = aConnection;
        this.deviceProfileManager = aDeviceProfileManager;
        this.acquisitionProgressListener = aProgressListener;
    }

    public AcquisitionResult call() throws IOException, InterruptedException {
        LOG.info("Starting capture ...");
        this.open();
        this.detectDevice();
        int channelCount = this.config.getChannelCount();
        if (channelCount <= 0) {
            throw new InternalError("Internal error: did not obtain correct number of channels (" + channelCount + ")?!");
        }
        int sampleCount = this.config.getSampleCount();
        if (sampleCount <= 0) {
            throw new InternalError("Internal error: did not obtain correct number of samples (" + sampleCount + ")?!");
        }
        this.configureAndArmDevice();
        int[] samples = this.readSamples(this.config.getEnabledGroupCount(), sampleCount);
        if (samples.length < sampleCount) {
            LOG.log(Level.INFO, "Only {0} samples read!", samples.length);
        } else {
            LOG.log(Level.FINE, "{0} samples read. Starting post processing...", sampleCount);
        }
        final ArrayList values = new ArrayList();
        final ArrayList timestamps = new ArrayList();
        final long[] absoluteLength = new long[]{0L};
        final long[] triggerPos = new long[]{-1L};
        int rate = this.config.getSampleRate();
        SampleProcessorCallback callback = new SampleProcessorCallback(){

            @Override
            public void addValue(int aSampleValue, long aTimestamp) {
                values.add(aSampleValue);
                timestamps.add(aTimestamp);
            }

            @Override
            public void ready(long aAbsoluteLength, long aTriggerPosition) {
                absoluteLength[0] = aAbsoluteLength;
                if (LogicSnifferAcquisitionTask.this.config.isTriggerEnabled()) {
                    triggerPos[0] = aTriggerPosition;
                }
            }
        };
        this.createSampleProcessor(sampleCount, samples, callback).process();
        this.close();
        return new CapturedData(values, timestamps, triggerPos[0], rate, this.config.getEnabledChannelsCount(), this.config.getEnabledChannelsMask(), absoluteLength[0]);
    }

    void configureAndArmDevice() throws IOException {
        this.trigcount = this.outputStream.writeDeviceConfiguration();
        this.outputStream.writeCmdRun();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void close() {
        StreamConnection conn = this.getStreamConnection();
        if (conn == null) return;
        try {
            if (this.outputStream == null) return;
            this.outputStream.writeCmdReset();
            return;
        }
        catch (IOException exception) {
            if (HostUtils.handleInterruptedException((Throwable)exception)) return;
            LOG.log(Level.WARNING, "Detaching failed!", exception);
            return;
        }
        finally {
            HostUtils.closeResource((Closeable)this.outputStream);
            HostUtils.closeResource((Closeable)this.inputStream);
            try {
                conn.close();
            }
            catch (IOException exception) {
                LOG.log(Level.WARNING, "Closing connection failed!", exception);
            }
            finally {
                this.connection = null;
                this.outputStream = null;
                this.inputStream = null;
            }
        }
    }

    protected final LogicSnifferConfig getConfig() {
        return this.config;
    }

    protected DeviceProfileManager getDeviceProfileManager() {
        return this.deviceProfileManager;
    }

    protected StreamConnection getStreamConnection() {
        return this.connection;
    }

    protected void open() throws IOException {
        block3: {
            StreamConnection conn = this.getStreamConnection();
            try {
                if (conn == null) {
                    throw new IOException("Failed to open a valid connection!");
                }
                this.outputStream = new SumpCommandWriter(this.config, conn.openDataOutputStream());
                this.inputStream = new SumpResultReader(conn.openDataInputStream());
                this.inputStream.flush();
            }
            catch (Exception exception) {
                LOG.log(Level.WARNING, "Failed to open connection! Possible reason: " + exception.getMessage());
                LOG.log(Level.FINE, "Detailed stack trace:", exception);
                if (HostUtils.handleInterruptedException((Throwable)exception)) break block3;
                throw new IOException("Failed to open connection! Possible reason: " + exception.getMessage());
            }
        }
    }

    private SampleProcessor createSampleProcessor(int aSampleCount, int[] aSampleValues, SampleProcessorCallback aCallback) {
        SampleProcessor processor;
        if (this.config.isRleEnabled()) {
            LOG.log(Level.INFO, "Decoding Run Length Encoded data, sample count: {0}", aSampleCount);
            processor = new RleDecoder(this.config, aSampleValues, this.trigcount, aCallback);
        } else {
            LOG.log(Level.INFO, "Decoding unencoded data, sample count: {0}", aSampleCount);
            processor = new EqualityFilter(this.config, aSampleValues, this.trigcount, aCallback);
        }
        return processor;
    }

    private void detectDevice() throws IOException {
        int tries = 3;
        int id = -1;
        do {
            this.inputStream.flush();
            this.outputStream.writeCmdReset();
            this.outputStream.writeCmdGetId();
            try {
                id = this.inputStream.readDeviceId();
            }
            catch (EOFException exception) {
                id = -1;
                tries = -1;
            }
            catch (IOException exception) {
                id = -1;
                if (HostUtils.handleInterruptedException((Throwable)exception)) continue;
                LOG.log(Level.INFO, "I/O exception!", exception);
            }
        } while (!Thread.currentThread().isInterrupted() && tries-- > 0 && id < 0);
        if (id == 809585747) {
            throw new IOException("Device is obsolete. Please upgrade firmware.");
        }
        if (id != 826362963) {
            throw new IOException("Device not found!");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int[] readSamples(int aEnabledGroupCount, int aSampleCount) throws IOException, InterruptedException {
        int length = aEnabledGroupCount * aSampleCount;
        byte[] rawData = new byte[length];
        try {
            int offset = 0;
            int count = length;
            while (!Thread.currentThread().isInterrupted() && offset >= 0 && offset < length) {
                int read = this.inputStream.readRawData(rawData, offset, count);
                if (read < 0) {
                    throw new EOFException();
                }
                count -= read;
                this.acquisitionProgressListener.acquisitionInProgress(100 * (offset += read) / length);
            }
        }
        catch (IOException exception) {
            if (!HostUtils.handleInterruptedException((Throwable)exception)) {
                throw exception;
            }
        }
        finally {
            this.outputStream.writeCmdReset();
            this.acquisitionProgressListener.acquisitionInProgress(100);
        }
        if (Thread.currentThread().isInterrupted()) {
            throw new InterruptedException();
        }
        int groupCount = this.config.getGroupCount();
        int[] samples = new int[aSampleCount];
        int j = 0;
        for (int i = samples.length - 1; i >= 0; --i) {
            for (int g = 0; g < groupCount; ++g) {
                if (!this.config.isGroupEnabled(g)) continue;
                int n = i;
                samples[n] = samples[n] | (rawData[j++] & 0xFF) << 8 * g;
            }
        }
        if (this.config.isSamplesInReverseOrder()) {
            HostUtils.reverse((int[])samples);
        }
        return samples;
    }
}

