/*
 * Decompiled with CFR 0.152.
 */
package org.sump.device.logicsniffer;

import org.sump.device.logicsniffer.profile.DeviceProfile;

public final class LogicSnifferConfig {
    private static final int TRIGGER_DELAYMASK = 65535;
    private static final int TRIGGER_LEVELMASK = 196608;
    private static final int TRIGGER_CHANNELMASK = 0x1F00000;
    private static final int TRIGGER_SERIAL = 0x4000000;
    public static final int TRIGGER_STAGES = 4;
    public static final int TRIGGER_CAPTURE = 0x8000000;
    static final int MIN_CHANNEL_GROUPS = 1;
    static final int MAX_CHANNEL_GROUPS_DDR = 2;
    private DeviceProfile.CaptureClockSource clockSource;
    private boolean filterEnabled;
    private boolean triggerEnabled;
    private boolean rleEnabled;
    private boolean altNumberSchemeEnabled;
    private boolean testModeEnabled;
    private final int[] triggerMask = new int[4];
    private final int[] triggerValue = new int[4];
    private final int[] triggerConfig = new int[4];
    private int enabledChannels;
    private final boolean[] enabledGroups;
    private int size;
    private double ratio;
    private int rleDataWidth;
    private DeviceProfile deviceProfile;
    private int sampleRate;
    private String connectionURI;

    public LogicSnifferConfig() {
        for (int i = 0; i < 4; ++i) {
            this.triggerMask[i] = 0;
            this.triggerValue[i] = 0;
            this.triggerConfig[i] = 0;
        }
        this.triggerEnabled = false;
        this.filterEnabled = false;
        this.setClockSource(DeviceProfile.CaptureClockSource.INTERNAL);
        this.ratio = 0.5;
        this.size = 512;
        this.enabledGroups = new boolean[]{true, true, true, true};
    }

    public int getChannelCount() {
        int channels = 32;
        if (this.isDoubleDataRateEnabled()) {
            channels = 16;
        }
        if (this.deviceProfile != null) {
            channels = Math.min(channels, this.deviceProfile.getChannelCount());
        }
        return channels;
    }

    public DeviceProfile.CaptureClockSource getClockSource() {
        return this.clockSource;
    }

    public int getClockspeed() {
        int result = 100000000;
        if (this.deviceProfile != null) {
            result = this.deviceProfile.getClockspeed();
        }
        return result;
    }

    public String getConnectionURI() {
        return this.connectionURI;
    }

    public DeviceProfile getDeviceProfile() {
        return this.deviceProfile;
    }

    public int getDivider() {
        double clock = this.getDividerClockspeed();
        if (this.isDoubleDataRateEnabled()) {
            clock *= 2.0;
        }
        return (int)Math.max(0.0, clock / (double)this.sampleRate - 1.0);
    }

    public int getDividerClockspeed() {
        int result = 100000000;
        if (this.deviceProfile != null) {
            result = this.deviceProfile.getDividerClockspeed();
        }
        return result;
    }

    public int getEnabledChannelsCount() {
        int result = this.getEnabledGroupCount() * 8;
        if (this.deviceProfile != null) {
            result = Math.min(result, this.deviceProfile.getChannelCount());
        }
        return result;
    }

    public int getEnabledChannelsMask() {
        return this.enabledChannels;
    }

    public int getEnabledGroupCount() {
        int cnt = 0;
        for (int i = this.getGroupCount() - 1; i >= 0; --i) {
            if (!this.enabledGroups[i]) continue;
            ++cnt;
        }
        return cnt;
    }

    public int getGroupCount() {
        int cnt = Math.max(1, this.getChannelCount() / 8);
        if (this.isDoubleDataRateEnabled()) {
            cnt = Math.min(2, cnt);
        }
        return cnt;
    }

    public int getMaxTriggerStages() {
        int result = 4;
        if (this.deviceProfile != null) {
            result = Math.min(result, this.deviceProfile.getTriggerStages());
        }
        return result;
    }

    public int getOpenPortDelay() {
        if (this.deviceProfile == null) {
            return 0;
        }
        return this.deviceProfile.getOpenPortDelay();
    }

    public double getRatio() {
        return this.ratio;
    }

    public int getReadCounter() {
        return this.size;
    }

    public int getRLEDataWidth() {
        return this.rleDataWidth;
    }

    public int getSampleCount() {
        int samples = this.isDoubleDataRateEnabled() ? this.getReadCounter() & 0xFFFF8 : this.getReadCounter() & 0xFFFFC;
        return samples;
    }

    public int getSampleRate() {
        return this.sampleRate;
    }

    public int getStopCounter() {
        return (int)((double)this.getReadCounter() * this.getRatio());
    }

    public int getTriggerConfig(int aStage) {
        if (aStage < 0 || aStage >= 4) {
            throw new IllegalArgumentException("Invalid trigger stage: " + aStage + "!");
        }
        return this.triggerConfig[aStage];
    }

    public int getTriggerMask(int aStage) {
        if (aStage < 0 || aStage >= 4) {
            throw new IllegalArgumentException("Invalid trigger stage: " + aStage + "!");
        }
        return this.triggerMask[aStage];
    }

    public int getTriggerValue(int aStage) {
        if (aStage < 0 || aStage >= 4) {
            throw new IllegalArgumentException("Invalid trigger stage: " + aStage + "!");
        }
        return this.triggerValue[aStage];
    }

    public boolean isAltNumberSchemeEnabled() {
        return this.altNumberSchemeEnabled;
    }

    public boolean isDoubleDataRateEnabled() {
        if (!this.isInternalClock() || !this.isDoubleDataRateSupported()) {
            return false;
        }
        int clock = this.getClockspeed();
        return this.sampleRate > clock;
    }

    public boolean isExternalClock() {
        return this.clockSource == DeviceProfile.CaptureClockSource.EXTERNAL_FALLING || this.clockSource == DeviceProfile.CaptureClockSource.EXTERNAL_RISING;
    }

    public boolean isFilterAvailable() {
        boolean result;
        boolean bl = result = !this.isDoubleDataRateEnabled();
        if (result && this.deviceProfile != null) {
            result = this.deviceProfile.isNoiseFilterSupported();
        }
        return result;
    }

    public boolean isFilterEnabled() {
        return this.filterEnabled;
    }

    public boolean isGroupEnabled(int aGroupNr) {
        if (aGroupNr < 0 || aGroupNr >= 4) {
            throw new IllegalArgumentException("Invalid channel group: " + aGroupNr + "!");
        }
        return this.enabledGroups[aGroupNr];
    }

    public boolean isInternalClock() {
        return this.clockSource == DeviceProfile.CaptureClockSource.INTERNAL;
    }

    public boolean isOpenPortDtr() {
        if (this.deviceProfile == null) {
            return false;
        }
        return this.deviceProfile.isOpenPortDtr();
    }

    public boolean isRleEnabled() {
        return this.rleEnabled;
    }

    public boolean isSamplesInReverseOrder() {
        if (this.deviceProfile != null) {
            return this.deviceProfile.isSamplesInReverseOrder();
        }
        return false;
    }

    public boolean isTestModeEnabled() {
        return this.testModeEnabled;
    }

    public boolean isTriggerEnabled() {
        return this.triggerEnabled;
    }

    public void setAltNumberSchemeEnabled(boolean aEnable) {
        this.altNumberSchemeEnabled = aEnable;
    }

    public void setClockSource(DeviceProfile.CaptureClockSource aSource) {
        this.clockSource = aSource;
    }

    public void setConnectionURI(String aConnectionURI) {
        if (aConnectionURI == null || aConnectionURI.trim().isEmpty()) {
            throw new IllegalArgumentException("ConnectionURI cannot be null!");
        }
        this.connectionURI = aConnectionURI;
    }

    public void setEnabledChannels(int aMask) {
        this.enabledChannels = aMask & 0xFFFFFFFF;
        int newRLEDataBytes = 0;
        int mask = this.enabledChannels;
        for (int i = 0; i < this.enabledGroups.length; ++i) {
            boolean groupEnabled;
            this.enabledGroups[i] = groupEnabled = (mask & 0xFF) != 0;
            if (groupEnabled) {
                ++newRLEDataBytes;
            }
            mask >>= 8;
        }
        if (this.isDoubleDataRateEnabled()) {
            newRLEDataBytes = Math.min(2, newRLEDataBytes);
        }
        this.rleDataWidth = 8 * newRLEDataBytes;
    }

    public void setFilterEnabled(boolean aEnable) {
        this.filterEnabled = aEnable;
    }

    public void setParallelTrigger(int aStage, int aMask, int aValue, int aLevel, int aDelay, boolean aStartCapture) {
        if (aStage < 0 || aStage >= 4) {
            throw new IllegalArgumentException("Invalid trigger stage: " + aStage + "!");
        }
        if (this.isDoubleDataRateEnabled()) {
            this.triggerMask[aStage] = aMask & 0xFFFF | (aMask & 0xFFFF) << 16;
            this.triggerValue[aStage] = aValue & 0xFFFF | (aValue & 0xFFFF) << 16;
        } else {
            this.triggerMask[aStage] = aMask;
            this.triggerValue[aStage] = aValue;
        }
        this.triggerConfig[aStage] = 0;
        int n = aStage;
        this.triggerConfig[n] = this.triggerConfig[n] | aDelay & 0xFFFF;
        int n2 = aStage;
        this.triggerConfig[n2] = this.triggerConfig[n2] | aLevel << 16 & 0x30000;
        if (aStartCapture) {
            int n3 = aStage;
            this.triggerConfig[n3] = this.triggerConfig[n3] | 0x8000000;
        }
    }

    public void setRatio(double aRatio) {
        if (aRatio < 0.0) {
            throw new IllegalArgumentException("Ratio cannot be negative!");
        }
        if (aRatio > 1.0) {
            throw new IllegalArgumentException("Ratio cannot be more than one!");
        }
        this.ratio = aRatio;
    }

    public void setRleEnabled(boolean enable) {
        this.rleEnabled = enable;
    }

    public void setSampleCount(int aCount) throws IllegalArgumentException {
        if (aCount == 0) {
            throw new IllegalArgumentException("Sample count cannot be zero!");
        }
        this.size = aCount & 0xFFFFF;
    }

    public void setSampleRate(int aSampleRate) throws IllegalArgumentException {
        if (aSampleRate == 0) {
            throw new IllegalArgumentException("Sample rate cannot be zero!");
        }
        this.sampleRate = aSampleRate & 0xFFFFFFF;
    }

    public void setSerialTrigger(int aStage, int aChannel, int aMask, int aValue, int aLevel, int aDelay, boolean aStartCapture) {
        if (aStage < 0 || aStage >= 4) {
            throw new IllegalArgumentException("Invalid trigger stage: " + aStage + "!");
        }
        if (this.isDoubleDataRateEnabled()) {
            this.triggerMask[aStage] = aMask & 0xFFFF | (aMask & 0xFFFF) << 16;
            this.triggerValue[aStage] = aValue & 0xFFFF | (aValue & 0xFFFF) << 16;
        } else {
            this.triggerMask[aStage] = aMask;
            this.triggerValue[aStage] = aValue;
        }
        this.triggerConfig[aStage] = 0x4000000;
        int n = aStage;
        this.triggerConfig[n] = this.triggerConfig[n] | aDelay & 0xFFFF;
        int n2 = aStage;
        this.triggerConfig[n2] = this.triggerConfig[n2] | aLevel << 16 & 0x30000;
        int n3 = aStage;
        this.triggerConfig[n3] = this.triggerConfig[n3] | aChannel << 20 & 0x1F00000;
        if (aStartCapture) {
            int n4 = aStage;
            this.triggerConfig[n4] = this.triggerConfig[n4] | 0x8000000;
        }
    }

    public void setTestModeEnabled(boolean enable) {
        this.testModeEnabled = enable;
    }

    public void setTriggerEnabled(boolean enable) {
        this.triggerEnabled = enable;
    }

    final void setDeviceProfile(DeviceProfile aDeviceProfile) {
        this.deviceProfile = aDeviceProfile;
    }

    private boolean isDoubleDataRateSupported() {
        boolean result = true;
        if (this.deviceProfile != null) {
            result = this.deviceProfile.isDoubleDataRateSupported();
        }
        return result;
    }
}

