/*
 * Decompiled with CFR 0.152.
 */
package org.sump.device.logicsniffer;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Enumeration;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.SpringLayout;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.plaf.basic.BasicComboBoxRenderer;
import nl.lxtreme.ols.api.Configurable;
import nl.lxtreme.ols.api.UserSettings;
import nl.lxtreme.ols.api.util.Unit;
import nl.lxtreme.ols.util.NumberUtils;
import nl.lxtreme.ols.util.swing.SpringLayoutUtils;
import nl.lxtreme.ols.util.swing.StandardActionFactory;
import nl.lxtreme.ols.util.swing.SwingComponentUtils;
import nl.lxtreme.ols.util.swing.component.EnumItemRenderer;
import nl.lxtreme.ols.util.swing.component.JLazyComboBox;
import org.sump.device.logicsniffer.ConfigDialogHelper;
import org.sump.device.logicsniffer.LogicSnifferConfig;
import org.sump.device.logicsniffer.LogicSnifferDevice;
import org.sump.device.logicsniffer.LogicSnifferDeviceProfilePanel;
import org.sump.device.logicsniffer.profile.DeviceProfile;
import purejavacomm.CommPortIdentifier;

public final class LogicSnifferConfigDialog
extends JDialog
implements Configurable,
StandardActionFactory.CloseAction.Closeable {
    private static final long serialVersionUID = 1L;
    private static final String rleWarning = "The last channel will always be low when RLE is enabled!";
    private static final String[] BAUDRATES = new String[]{"921600bps", "460800bps", "230400bps", "115200bps", "57600bps", "38400bps", "19200bps", "14400bps", "9600bps", "4800bps"};
    private final LogicSnifferDevice logicSnifferDevice;
    private LogicSnifferDeviceProfilePanel deviceProfilePanel;
    private JComboBox connTypeSelect;
    private JTextField remAddress;
    private JTextField remPort;
    private JComboBox numberSchemeSelect;
    private JComboBox portSelect;
    private JComboBox portRateSelect;
    private JComboBox sourceSelect;
    private JComboBox sizeSelect;
    private JComboBox speedSelect;
    private JComboBox triggerTypeSelect;
    private JCheckBox maxSampleSize;
    private JCheckBox testModeEnable;
    private JCheckBox filterEnable;
    private JCheckBox rleEnable;
    private JCheckBox triggerEnable;
    private JTabbedPane triggerStageTabs;
    private JComboBox[] triggerLevel;
    private JTextField[] triggerDelay;
    private JComboBox[] triggerMode;
    private JComboBox[] triggerChannel;
    private JCheckBox[] triggerStart;
    private JCheckBox[][] triggerMask;
    private JCheckBox[][] triggerValue;
    private JCheckBox[] channelGroup;
    private JButton captureButton;
    private JComponent groupsPanel;
    private boolean dialogResult;
    private JSlider ratioSlider;
    private JLabel ratioLabel;
    private JLabel warningLabel;
    private JTextField[] triggerHexMask;
    private JTextField[] triggerHexValue;
    private JButton[] applyHexMaskButton;
    private JButton[] applyHexValueButton;
    private JCheckBox[] invertHexValue;
    private DeviceProfile deviceProfile;

    public LogicSnifferConfigDialog(Window aParent, LogicSnifferDevice aDevice) {
        super(aParent, "OLS Capture settings", Dialog.ModalityType.DOCUMENT_MODAL);
        this.logicSnifferDevice = aDevice;
        this.initDialog();
        this.buildDialog();
        this.updateFields();
    }

    private static GridBagConstraints createConstraints(int x, int y, int w, int h, double wx, double wy) {
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.fill = 2;
        gbc.anchor = 256;
        gbc.insets = new Insets(2, 2, 2, 2);
        gbc.gridx = x;
        gbc.gridy = y;
        gbc.gridwidth = w;
        gbc.gridheight = h;
        gbc.weightx = wx;
        gbc.weighty = wy;
        return gbc;
    }

    private static String maskToHexString(String aMask) {
        try {
            int value = (int)Long.parseLong(aMask, 2);
            return Integer.toHexString(Integer.reverse(value));
        }
        catch (NumberFormatException exception) {
            return "";
        }
    }

    public final void close() {
        this.setVisible(false);
        this.dispose();
    }

    public LogicSnifferConfig getConfiguration() {
        LogicSnifferConfig config = new LogicSnifferConfig();
        config.setDeviceProfile(this.deviceProfile);
        config.setConnectionURI(this.getConnectionURI());
        config.setClockSource((DeviceProfile.CaptureClockSource)((Object)this.sourceSelect.getSelectedItem()));
        int enabledChannels = 0;
        for (int i = 0; i < this.channelGroup.length; ++i) {
            if (!this.channelGroup[i].isSelected()) continue;
            enabledChannels |= 255 << 8 * i;
        }
        config.setEnabledChannels(enabledChannels);
        config.setSampleRate(this.getSelectedSampleRate());
        config.setSampleCount(this.getSelectedSampleCount());
        double r = 1.0 - (double)this.ratioSlider.getValue() / (double)this.ratioSlider.getMaximum();
        config.setRatio(r);
        config.setFilterEnabled(this.filterEnable.isEnabled() && this.filterEnable.isSelected());
        config.setRleEnabled(this.rleEnable.isEnabled() && this.rleEnable.isSelected());
        DeviceProfile.NumberingScheme scheme = (DeviceProfile.NumberingScheme)((Object)this.numberSchemeSelect.getSelectedItem());
        config.setAltNumberSchemeEnabled(DeviceProfile.NumberingScheme.OUTSIDE.equals((Object)scheme));
        config.setTestModeEnabled(this.testModeEnable.isEnabled() && this.testModeEnable.isSelected());
        boolean triggerEnabled = this.triggerEnable.isEnabled() && this.triggerEnable.isSelected();
        config.setTriggerEnabled(triggerEnabled);
        if (triggerEnabled) {
            boolean complex = DeviceProfile.TriggerType.COMPLEX.equals(this.triggerTypeSelect.getSelectedItem());
            for (int stage = 0; stage < 4; ++stage) {
                int m = 0;
                int v = 0;
                for (int i = 0; i < 32; ++i) {
                    if (this.triggerMask[stage][i].isSelected()) {
                        m |= 1 << i;
                    }
                    if (!this.triggerValue[stage][i].isSelected()) continue;
                    v |= 1 << i;
                }
                int level = this.triggerLevel[stage].getSelectedIndex();
                int delay = NumberUtils.smartParseInt((String)this.triggerDelay[stage].getText());
                boolean parallelTriggerStage = this.triggerMode[stage].getSelectedIndex() == 0;
                int channel = this.triggerChannel[stage].getSelectedIndex();
                boolean startCapture = this.triggerStart[stage].isSelected();
                if (complex) {
                    if (parallelTriggerStage) {
                        config.setParallelTrigger(stage, m, v, level, delay, startCapture);
                        continue;
                    }
                    config.setSerialTrigger(stage, channel, m, v, level, delay, startCapture);
                    continue;
                }
                if (stage == 0) {
                    if (parallelTriggerStage) {
                        config.setParallelTrigger(stage, m, v, 0, delay, true);
                        continue;
                    }
                    config.setSerialTrigger(stage, channel, m, v, 0, delay, true);
                    continue;
                }
                config.setParallelTrigger(stage, 0, 0, 3, 0, false);
            }
        }
        return config;
    }

    public void readPreferences(UserSettings aSettings) {
        String preferredPortRate;
        this.connTypeSelect.setSelectedIndex(aSettings.getInt("connType", this.connTypeSelect.getSelectedIndex()));
        this.remAddress.setText(aSettings.get("remAddress", ""));
        this.remPort.setText(aSettings.get("remPort", ""));
        this.deviceProfilePanel.readPreferences(aSettings);
        String preferredPortName = aSettings.get("port", null);
        if (preferredPortName != null && !"null".equals(preferredPortName)) {
            this.portSelect.setSelectedItem(preferredPortName);
        }
        if ((preferredPortRate = aSettings.get("portRate", null)) != null && !"null".equals(preferredPortRate)) {
            int value = NumberUtils.safeParseInt((String)preferredPortRate, (int)-1);
            if (value >= 0 && value < BAUDRATES.length) {
                this.portRateSelect.setSelectedIndex(value);
            } else {
                this.portRateSelect.setSelectedItem(preferredPortRate);
            }
        }
        this.sourceSelect.setSelectedIndex(aSettings.getInt("source", this.sourceSelect.getSelectedIndex()));
        this.numberSchemeSelect.setSelectedIndex(aSettings.getInt("numberScheme", this.numberSchemeSelect.getSelectedIndex()));
        this.testModeEnable.setSelected(aSettings.getBoolean("testMode", this.testModeEnable.isSelected()));
        this.speedSelect.setSelectedIndex(aSettings.getInt("speed", this.speedSelect.getSelectedIndex()));
        this.sizeSelect.setSelectedIndex(aSettings.getInt("size", this.sizeSelect.getSelectedIndex()));
        this.maxSampleSize.setSelected(aSettings.getBoolean("autosize", this.maxSampleSize.isSelected()));
        this.ratioSlider.setValue(aSettings.getInt("ratio", 50));
        this.filterEnable.setSelected(aSettings.getBoolean("filter", this.filterEnable.isSelected()));
        this.rleEnable.setSelected(aSettings.getBoolean("rle", this.rleEnable.isSelected()));
        this.triggerEnable.setSelected(aSettings.getBoolean("trigger", this.triggerEnable.isSelected()));
        this.triggerTypeSelect.setSelectedIndex(aSettings.getInt("triggerType", this.triggerTypeSelect.getSelectedIndex()));
        for (int stage = 0; stage < 4; ++stage) {
            String prefix = "triggerStage." + stage;
            this.triggerDelay[stage].setText(aSettings.get(prefix + ".delay", ""));
            this.triggerLevel[stage].setSelectedIndex(aSettings.getInt(prefix + ".level", this.triggerLevel[stage].getSelectedIndex()));
            this.triggerMode[stage].setSelectedIndex(aSettings.getInt(prefix + ".mode", this.triggerMode[stage].getSelectedIndex()));
            this.triggerChannel[stage].setSelectedIndex(aSettings.getInt(prefix + ".channel", this.triggerChannel[stage].getSelectedIndex()));
            String mask = aSettings.get(prefix + ".mask", "");
            for (int i = 0; i < 32 && i < mask.length(); ++i) {
                this.triggerMask[stage][i].setSelected(mask.charAt(i) == '1');
            }
            String value = aSettings.get(prefix + ".value", "");
            for (int i = 0; i < 32 && i < value.length(); ++i) {
                this.triggerValue[stage][i].setSelected(value.charAt(i) == '1');
            }
            this.triggerStart[stage].setSelected(aSettings.getBoolean(prefix + ".startCapture", this.triggerStart[stage].isSelected()));
            String hexMask = LogicSnifferConfigDialog.maskToHexString(mask);
            this.triggerHexMask[stage].setText(hexMask);
            String hexValue = LogicSnifferConfigDialog.maskToHexString(value);
            this.triggerHexValue[stage].setText(hexValue);
        }
        String group = aSettings.get("channelGroup", "");
        for (int i = 0; i < 4 && i < group.length(); ++i) {
            this.channelGroup[i].setSelected(group.charAt(i) == '1');
        }
        this.updateFields();
    }

    public boolean showDialog() {
        this.dialogResult = false;
        this.setVisible(true);
        return this.dialogResult;
    }

    public void writePreferences(UserSettings aSettings) {
        aSettings.putInt("connType", this.connTypeSelect.getSelectedIndex());
        aSettings.put("remAddress", this.remAddress.getText());
        aSettings.putInt("remPort", NumberUtils.smartParseInt((String)this.remPort.getText()));
        aSettings.put("port", String.valueOf(this.portSelect.getSelectedItem()));
        aSettings.put("portRate", String.valueOf(this.portRateSelect.getSelectedItem()));
        aSettings.putInt("source", this.sourceSelect.getSelectedIndex());
        aSettings.putInt("numberScheme", this.numberSchemeSelect.getSelectedIndex());
        aSettings.putBoolean("testMode", this.testModeEnable.isSelected());
        aSettings.putInt("speed", this.speedSelect.getSelectedIndex());
        aSettings.putBoolean("autosize", this.maxSampleSize.isSelected());
        aSettings.putInt("size", this.sizeSelect.getSelectedIndex());
        aSettings.putInt("ratio", this.ratioSlider.getValue());
        aSettings.putBoolean("filter", this.filterEnable.isSelected());
        aSettings.putBoolean("rle", this.rleEnable.isSelected());
        aSettings.putBoolean("trigger", this.triggerEnable.isSelected());
        aSettings.putInt("triggerType", this.triggerTypeSelect.getSelectedIndex());
        for (int stage = 0; stage < 4; ++stage) {
            String prefix = "triggerStage." + stage;
            aSettings.put(prefix + ".delay", this.triggerDelay[stage].getText());
            aSettings.putInt(prefix + ".level", this.triggerLevel[stage].getSelectedIndex());
            aSettings.putInt(prefix + ".mode", this.triggerMode[stage].getSelectedIndex());
            aSettings.putInt(prefix + ".channel", this.triggerChannel[stage].getSelectedIndex());
            StringBuffer mask = new StringBuffer();
            for (int i = 0; i < 32; ++i) {
                mask.append(this.triggerMask[stage][i].isSelected() ? "1" : "0");
            }
            aSettings.put(prefix + ".mask", mask.toString());
            StringBuffer value = new StringBuffer();
            for (int i = 0; i < 32; ++i) {
                value.append(this.triggerValue[stage][i].isSelected() ? "1" : "0");
            }
            aSettings.put(prefix + ".value", value.toString());
            aSettings.putBoolean(prefix + ".startCapture", this.triggerStart[stage].isSelected());
        }
        StringBuffer group = new StringBuffer();
        for (int i = 0; i < 4; ++i) {
            group.append(this.channelGroup[i].isSelected() ? "1" : "0");
        }
        aSettings.put("channelGroup", group.toString());
        this.deviceProfilePanel.writePreferences(aSettings);
    }

    final String getConnectionURI() {
        String result;
        if (this.connTypeSelect.getSelectedItem() == DeviceProfile.DeviceInterface.NETWORK) {
            String address = this.remAddress.getText();
            Integer port = ConfigDialogHelper.getNumericValue(this.remPort);
            result = String.format("socket://%s:%d", address, port);
        } else if (this.connTypeSelect.getSelectedItem() == DeviceProfile.DeviceInterface.SERIAL) {
            String portName = ConfigDialogHelper.getComboBoxText(this.portSelect);
            Integer baudrate = ConfigDialogHelper.getNumericValue(this.portRateSelect);
            result = String.format("comm:%s;baudrate=%d;bitsperchar=8;parity=none;stopbits=1;flowcontrol=xon_xoff", portName, baudrate);
            if (this.deviceProfile != null) {
                Integer openDelay = this.deviceProfile.getOpenPortDelay();
                boolean dtrValue = this.deviceProfile.isOpenPortDtr();
                result = String.format("%s;dtr=%s;delay=%d", result, dtrValue ? "on" : "off", openDelay);
                Integer recvTimeout = this.deviceProfile.getReceiveTimeout();
                if (recvTimeout != null) {
                    result = String.format("%s;recv_timeout=%d", result, recvTimeout);
                }
            }
        } else {
            throw new IllegalStateException("Unknown/unsupported device interface: " + this.connTypeSelect.getSelectedItem());
        }
        return result;
    }

    final void updateDeviceProfile(DeviceProfile aProfile) {
        this.deviceProfile = aProfile;
        this.captureButton.setEnabled(aProfile != null);
        if (aProfile == null) {
            return;
        }
        ConfigDialogHelper.updateCheckBoxState(this.filterEnable, aProfile.isNoiseFilterSupported());
        ConfigDialogHelper.updateCheckBoxState(this.rleEnable, aProfile.isRleSupported());
        ConfigDialogHelper.updateCheckBoxState(this.testModeEnable, aProfile.isTestModeSupported());
        ConfigDialogHelper.updateCheckBoxState(this.triggerEnable, aProfile.isTriggerSupported());
        ConfigDialogHelper.updateTriggerTypeComboBoxModel(this.triggerTypeSelect, aProfile);
        ConfigDialogHelper.updateTriggerChannels(this.triggerMask, this.triggerValue, aProfile);
        ConfigDialogHelper.updateChannelGroups(this.channelGroup, aProfile);
        ConfigDialogHelper.updateCaptureSpeedComboBoxModel(this.speedSelect, aProfile);
        ConfigDialogHelper.updateComboBoxModel(this.sizeSelect, aProfile.getCaptureSizes());
        ConfigDialogHelper.updateComboBoxModel(this.sourceSelect, aProfile.getCaptureClock());
        ConfigDialogHelper.updateComboBoxModel(this.numberSchemeSelect, aProfile.getChannelNumberingSchemes());
    }

    final void updateFields() {
        boolean mandatoryFieldsFilled = false;
        if (this.isSerialConnection()) {
            Object port = this.portSelect.getSelectedItem();
            Object speed = this.portRateSelect.getSelectedItem();
            mandatoryFieldsFilled = port != null && !"".equals(port) && speed != null && !"".equals(speed);
        } else if (this.isNetworkConnection()) {
            String host = this.remAddress.getText();
            String port = this.remPort.getText();
            mandatoryFieldsFilled = host != null && !"".equals(host) && port != null && !"".equals(port);
        }
        int availableChannelGroups = this.getChannelGroupCount();
        for (int i = 0; i < this.channelGroup.length; ++i) {
            boolean enabled = i < availableChannelGroups;
            this.channelGroup[i].setEnabled(enabled);
            if (enabled) continue;
            this.channelGroup[i].setSelected(false);
        }
        boolean filterEnabled = this.deviceProfile != null && this.deviceProfile.isNoiseFilterSupported() && !this.isDdrMode();
        ConfigDialogHelper.updateCheckBoxState(this.filterEnable, filterEnabled);
        boolean triggerSupported = this.deviceProfile != null && this.deviceProfile.isTriggerSupported();
        ConfigDialogHelper.updateCheckBoxState(this.triggerEnable, triggerSupported);
        int triggerStages = this.deviceProfile != null ? this.deviceProfile.getTriggerStages() : 0;
        this.setTriggerEnabled(this.triggerEnable.isSelected(), triggerStages);
        this.speedSelect.setEnabled(this.sourceSelect.getSelectedItem() == DeviceProfile.CaptureClockSource.INTERNAL);
        this.sizeSelect.setEnabled(!this.maxSampleSize.isSelected());
        boolean serialPortSelected = this.connTypeSelect.getSelectedItem() == DeviceProfile.DeviceInterface.SERIAL;
        this.portSelect.setEnabled(serialPortSelected);
        this.portRateSelect.setEnabled(serialPortSelected);
        boolean networkSelected = this.connTypeSelect.getSelectedItem() == DeviceProfile.DeviceInterface.NETWORK;
        this.remAddress.setEnabled(networkSelected);
        this.remPort.setEnabled(networkSelected);
        this.warningLabel.setText(" ");
        if (this.rleEnable.isSelected()) {
            this.warningLabel.setText(rleWarning);
        }
        if (this.maxSampleSize.isSelected()) {
            this.forceCaptureSizeTo(this.getSelectedSampleCount());
        }
        this.captureButton.setEnabled(mandatoryFieldsFilled);
        this.deviceProfilePanel.showMetadataButton.setEnabled(mandatoryFieldsFilled);
    }

    private void buildDialog() {
        this.captureButton = new JButton("Capture");
        JButton cancel = StandardActionFactory.createCloseButton();
        JTabbedPane tabs = new JTabbedPane(1, 1);
        tabs.addTab("Connection", this.createConnectionSettingsPane());
        tabs.addTab("Acquisition", this.createAcquisitionSettingsPane());
        tabs.addTab("Triggers", this.createTriggerPane());
        this.captureButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent aEvent) {
                boolean configCorrect = LogicSnifferConfigDialog.this.verifyConfiguration(true);
                LogicSnifferConfigDialog.this.dialogResult = configCorrect;
                if (configCorrect) {
                    LogicSnifferConfigDialog.this.close();
                }
            }
        });
        JComponent buttonPane = SwingComponentUtils.createButtonPane((JButton[])new JButton[]{this.captureButton, cancel});
        SwingComponentUtils.setupWindowContentPane((Window)this, (Component)tabs, (Component)buttonPane, (JButton)this.captureButton);
        this.pack();
        this.updateFields();
    }

    private JPanel createAcquisitionSettingsPane() {
        JPanel connectionPane = new JPanel(new SpringLayout());
        SpringLayoutUtils.addSeparator((Container)connectionPane, (String)"Acquisition settings");
        connectionPane.add(SwingComponentUtils.createRightAlignedLabel((String)"Number scheme"));
        connectionPane.add(this.numberSchemeSelect);
        connectionPane.add(SwingComponentUtils.createRightAlignedLabel((String)"Sampling Clock"));
        connectionPane.add(this.sourceSelect);
        connectionPane.add(SwingComponentUtils.createRightAlignedLabel((String)"Sampling Rate"));
        connectionPane.add(this.speedSelect);
        SpringLayoutUtils.addSeparator((Container)connectionPane, (String)"");
        connectionPane.add(SwingComponentUtils.createRightAlignedLabel((String)"Channel Groups"));
        connectionPane.add(this.groupsPanel);
        connectionPane.add(SwingComponentUtils.createRightAlignedLabel((String)"Recording Size"));
        connectionPane.add(this.maxSampleSize);
        connectionPane.add(new JLabel());
        connectionPane.add(this.sizeSelect);
        SpringLayoutUtils.addSeparator((Container)connectionPane, (String)"Options");
        connectionPane.add(SwingComponentUtils.createRightAlignedLabel((String)"Test mode"));
        connectionPane.add(this.testModeEnable);
        connectionPane.add(SwingComponentUtils.createRightAlignedLabel((String)"Noise Filter"));
        connectionPane.add(this.filterEnable);
        connectionPane.add(SwingComponentUtils.createRightAlignedLabel((String)"Run Length Encoding"));
        connectionPane.add(this.rleEnable);
        SpringLayoutUtils.makeEditorGrid((Container)connectionPane, (int)10, (int)10);
        JPanel result = new JPanel(new GridBagLayout());
        result.add((Component)connectionPane, new GridBagConstraints(0, 0, 1, 1, 0.0, 1.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
        result.add((Component)this.warningLabel, new GridBagConstraints(0, 1, 1, 0, 1.0, 0.1, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
        result.add((Component)new JLabel(), new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        return result;
    }

    private JPanel createConnectionSettingsPane() {
        JPanel connectionPane = new JPanel(new SpringLayout());
        SpringLayoutUtils.addSeparator((Container)connectionPane, (String)"General");
        connectionPane.add(SwingComponentUtils.createRightAlignedLabel((String)"Connection type"));
        connectionPane.add(this.connTypeSelect);
        SpringLayoutUtils.addSeparator((Container)connectionPane, (String)"");
        connectionPane.add(SwingComponentUtils.createRightAlignedLabel((String)"Remote host address"));
        connectionPane.add(this.remAddress);
        connectionPane.add(SwingComponentUtils.createRightAlignedLabel((String)"Remote port"));
        connectionPane.add(this.remPort);
        SpringLayoutUtils.addSeparator((Container)connectionPane, (String)"");
        connectionPane.add(SwingComponentUtils.createRightAlignedLabel((String)"Analyzer port"));
        connectionPane.add(this.portSelect);
        connectionPane.add(SwingComponentUtils.createRightAlignedLabel((String)"Port Speed"));
        connectionPane.add(this.portRateSelect);
        SpringLayoutUtils.addSeparator((Container)connectionPane, (String)"");
        this.deviceProfilePanel = new LogicSnifferDeviceProfilePanel(this.logicSnifferDevice){

            @Override
            protected String getConnectionURI() {
                return LogicSnifferConfigDialog.this.getConnectionURI();
            }

            @Override
            protected void updateDeviceProfile(DeviceProfile aProfile) {
                LogicSnifferConfigDialog.this.updateDeviceProfile(aProfile);
            }
        };
        this.deviceProfilePanel.buildPanel(connectionPane);
        SpringLayoutUtils.makeEditorGrid((Container)connectionPane, (int)10, (int)10);
        JPanel result = new JPanel(new GridBagLayout());
        result.add((Component)connectionPane, new GridBagConstraints(0, 0, 1, 1, 0.4, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
        result.add((Component)new JLabel(), new GridBagConstraints(0, 1, 1, 1, 0.6, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        return result;
    }

    private JPanel createMaskValueEditor(int aStage) {
        int j;
        JPanel maskValuePanel = new JPanel(new SpringLayout());
        JLabel[] channelLabels = new JLabel[32];
        maskValuePanel.add(new JLabel(" "));
        for (j = 32; j > 0; --j) {
            String channel = j % 8 == 0 || j % 8 == 1 ? String.format("%2d", j - 1) : "";
            channelLabels[j - 1] = new JLabel(channel);
            maskValuePanel.add(channelLabels[j - 1]);
        }
        maskValuePanel.add(SwingComponentUtils.createRightAlignedLabel((String)"Mask"));
        this.triggerMask[aStage] = new JCheckBox[32];
        for (j = 32; j > 0; --j) {
            JCheckBox triggerEnabled = new JCheckBox();
            triggerEnabled.setBorder(BorderFactory.createEmptyBorder());
            triggerEnabled.setEnabled(false);
            this.triggerMask[aStage][j - 1] = triggerEnabled;
            maskValuePanel.add(triggerEnabled);
        }
        maskValuePanel.add(SwingComponentUtils.createRightAlignedLabel((String)"Value"));
        this.triggerValue[aStage] = new JCheckBox[32];
        for (j = 32; j > 0; --j) {
            JCheckBox valueEnabled = new JCheckBox();
            valueEnabled.setBorder(BorderFactory.createEmptyBorder());
            valueEnabled.setEnabled(false);
            this.triggerValue[aStage][j - 1] = valueEnabled;
            maskValuePanel.add(valueEnabled);
        }
        SpringLayoutUtils.makeCompactGrid((Container)maskValuePanel, (int)3, (int)33, (int)1, (int)1, (int)1, (int)1);
        return maskValuePanel;
    }

    private JPanel createTriggerPane() {
        JPanel generalPane = new JPanel(new SpringLayout());
        generalPane.add(SwingComponentUtils.createRightAlignedLabel((String)"Trigger"));
        generalPane.add(this.triggerEnable);
        generalPane.add(new JLabel());
        generalPane.add(SwingComponentUtils.createRightAlignedLabel((String)"Before/After ratio"));
        generalPane.add(this.ratioSlider);
        generalPane.add(this.ratioLabel);
        generalPane.add(SwingComponentUtils.createRightAlignedLabel((String)"Type"));
        generalPane.add(this.triggerTypeSelect);
        generalPane.add(new JLabel());
        SpringLayoutUtils.makeCompactGrid((Container)generalPane, (int)3, (int)3, (int)6, (int)6, (int)6, (int)6);
        JPanel triggerPane = new JPanel(new GridBagLayout());
        triggerPane.add((Component)generalPane, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
        triggerPane.add((Component)this.triggerStageTabs, new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        return triggerPane;
    }

    private int determineMaxSampleCount(int aEnabledChannelGroups) {
        if (this.deviceProfile != null) {
            return this.deviceProfile.getMaximumCaptureSizeFor(aEnabledChannelGroups);
        }
        return -1;
    }

    private void forceCaptureSizeTo(int aSampleCount) {
        this.sizeSelect.setSelectedItem(aSampleCount);
    }

    private int getChannelCount() {
        int channels = 32;
        if (this.isDdrMode()) {
            channels = 16;
        }
        if (this.deviceProfile != null) {
            channels = Math.min(channels, this.deviceProfile.getChannelCount());
        }
        return channels;
    }

    private int getChannelGroupCount() {
        int count = 4;
        if (this.isDdrMode()) {
            count >>= 1;
        }
        if (this.deviceProfile != null) {
            count = Math.min(count, this.deviceProfile.getChannelGroupCount());
        }
        return count;
    }

    private int getEnabledChannelGroups() {
        int enabledChannelGroups = 0;
        for (JCheckBox element : this.channelGroup) {
            if (!element.isSelected()) continue;
            ++enabledChannelGroups;
        }
        return enabledChannelGroups;
    }

    private int getSelectedSampleCount() {
        int result = this.determineMaxSampleCount(this.getEnabledChannelGroups());
        Integer sampleCount = ConfigDialogHelper.getNumericValue(this.sizeSelect);
        if (sampleCount != null && !this.maxSampleSize.isSelected()) {
            result = sampleCount;
        }
        return result;
    }

    private int getSelectedSampleRate() {
        String value = ConfigDialogHelper.getComboBoxText(this.speedSelect);
        return NumberUtils.smartParseInt((String)value, (NumberUtils.UnitDefinition)NumberUtils.UnitDefinition.SI, (int)100000000);
    }

    private void initDialog() {
        ActionListener fieldUpdater = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent aEvent) {
                LogicSnifferConfigDialog.this.updateFields();
            }
        };
        DeviceProfile.DeviceInterface[] devInterfaces = new DeviceProfile.DeviceInterface[]{DeviceProfile.DeviceInterface.NETWORK, DeviceProfile.DeviceInterface.SERIAL};
        this.connTypeSelect = new JComboBox<DeviceProfile.DeviceInterface>(devInterfaces);
        this.connTypeSelect.setRenderer(new DeviceInterfaceComboBoxRenderer());
        this.connTypeSelect.setSelectedItem((Object)DeviceProfile.DeviceInterface.SERIAL);
        this.connTypeSelect.addActionListener(fieldUpdater);
        this.remAddress = new JTextField("localhost");
        this.remAddress.addActionListener(fieldUpdater);
        this.remPort = new JTextField("5678");
        this.remPort.addActionListener(fieldUpdater);
        this.portSelect = new JLazyComboBox(new JLazyComboBox.ItemProvider(){

            public Object[] getItems() {
                Enumeration portIdentifiers = CommPortIdentifier.getPortIdentifiers();
                ArrayList<String> portList = new ArrayList<String>();
                while (portIdentifiers.hasMoreElements()) {
                    CommPortIdentifier portId = (CommPortIdentifier)portIdentifiers.nextElement();
                    if (portId.getPortType() != 1) continue;
                    portList.add(portId.getName());
                }
                return portList.toArray(new String[portList.size()]);
            }
        });
        this.portSelect.setEditable(true);
        this.portSelect.addActionListener(fieldUpdater);
        this.portRateSelect = new JComboBox<String>(BAUDRATES);
        this.portRateSelect.setEditable(true);
        this.portRateSelect.setSelectedIndex(3);
        this.portRateSelect.addActionListener(fieldUpdater);
        this.numberSchemeSelect = new JComboBox();
        this.numberSchemeSelect.setRenderer(new NumberSchemeComboBoxRenderer());
        this.numberSchemeSelect.addActionListener(fieldUpdater);
        this.sourceSelect = new JComboBox();
        this.sourceSelect.setRenderer(new ClockSourceComboBoxRenderer());
        this.sourceSelect.addActionListener(fieldUpdater);
        this.speedSelect = new JComboBox();
        this.speedSelect.setRenderer(new CaptureSpeedComboBoxRenderer());
        this.speedSelect.addActionListener(fieldUpdater);
        this.groupsPanel = new JPanel();
        this.groupsPanel.setLayout(new GridLayout(1, 4));
        this.channelGroup = new JCheckBox[4];
        for (int i = 0; i < this.channelGroup.length; ++i) {
            this.channelGroup[i] = new JCheckBox(Integer.toString(i));
            this.channelGroup[i].setSelected(i == 0);
            this.channelGroup[i].addActionListener(fieldUpdater);
            this.groupsPanel.add(this.channelGroup[i]);
        }
        this.sizeSelect = new JComboBox();
        this.sizeSelect.setRenderer(new BinarySizeComboBoxRenderer());
        this.sizeSelect.addActionListener(fieldUpdater);
        this.maxSampleSize = new JCheckBox("Automatic (maximum)");
        this.maxSampleSize.setSelected(false);
        this.maxSampleSize.addActionListener(fieldUpdater);
        this.testModeEnable = new JCheckBox("Enabled");
        this.testModeEnable.setSelected(true);
        this.testModeEnable.setEnabled(false);
        this.testModeEnable.addActionListener(fieldUpdater);
        this.filterEnable = new JCheckBox("Enabled");
        this.filterEnable.setSelected(true);
        this.filterEnable.setEnabled(false);
        this.filterEnable.addActionListener(fieldUpdater);
        this.rleEnable = new JCheckBox("Enabled");
        this.rleEnable.setSelected(false);
        this.rleEnable.setEnabled(true);
        this.rleEnable.addActionListener(fieldUpdater);
        this.triggerEnable = new JCheckBox("Enabled");
        this.triggerEnable.addActionListener(fieldUpdater);
        this.ratioLabel = new JLabel("");
        SwingComponentUtils.fixLabelWidth((JLabel)this.ratioLabel, (String)"100 / 100");
        this.ratioSlider = new JSlider(0, 0, 100, 50);
        this.ratioSlider.setMajorTickSpacing(10);
        this.ratioSlider.setMinorTickSpacing(5);
        this.ratioSlider.setPaintLabels(true);
        this.ratioSlider.setPaintTicks(true);
        this.ratioSlider.addChangeListener(new TriggerRatioChangeListener(this.ratioLabel));
        Dimension size = new Dimension(350, 50);
        this.ratioSlider.setMinimumSize(size);
        this.ratioSlider.setPreferredSize(size);
        this.triggerTypeSelect = new JComboBox();
        this.triggerTypeSelect.addActionListener(fieldUpdater);
        this.triggerStageTabs = new JTabbedPane();
        this.triggerMask = new JCheckBox[4][];
        this.triggerValue = new JCheckBox[4][];
        this.triggerLevel = new JComboBox[4];
        this.triggerDelay = new JTextField[4];
        this.triggerMode = new JComboBox[4];
        this.triggerChannel = new JComboBox[4];
        this.triggerStart = new JCheckBox[4];
        this.triggerHexMask = new JTextField[4];
        this.triggerHexValue = new JTextField[4];
        this.applyHexMaskButton = new JButton[4];
        this.applyHexValueButton = new JButton[4];
        this.invertHexValue = new JCheckBox[4];
        for (int i = 0; i < 4; ++i) {
            JPanel stagePane = new JPanel(new GridBagLayout());
            stagePane.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
            String[] levels = new String[]{"Immediately", "On Level 1", "On Level 2", "On Level 3"};
            this.triggerLevel[i] = new JComboBox<String>(levels);
            this.triggerLevel[i].setSelectedIndex(i);
            stagePane.add((Component)SwingComponentUtils.createRightAlignedLabel((String)"Arm"), LogicSnifferConfigDialog.createConstraints(0, 0, 1, 1, 1.0, 1.0));
            stagePane.add((Component)this.triggerLevel[i], LogicSnifferConfigDialog.createConstraints(1, 0, 1, 1, 0.5, 1.0));
            String[] modes = new String[]{"Parallel", "Serial"};
            this.triggerMode[i] = new JComboBox<String>(modes);
            this.triggerMode[i].setSelectedIndex(0);
            stagePane.add((Component)SwingComponentUtils.createRightAlignedLabel((String)"Mode"), LogicSnifferConfigDialog.createConstraints(2, 0, 1, 1, 0.5, 1.0));
            stagePane.add((Component)this.triggerMode[i], LogicSnifferConfigDialog.createConstraints(3, 0, 1, 1, 0.5, 1.0));
            this.triggerMode[i].addActionListener(fieldUpdater);
            String[] channels = new String[]{"0", "1", "2", "3", "4", "5", "6", "7", "8", "9", "10", "11", "12", "13", "14", "15", "16", "17", "18", "19", "20", "21", "22", "23", "24", "25", "26", "27", "28", "29", "30", "31"};
            this.triggerChannel[i] = new JComboBox<String>(channels);
            this.triggerChannel[i].setSelectedIndex(0);
            stagePane.add((Component)SwingComponentUtils.createRightAlignedLabel((String)"Channel"), LogicSnifferConfigDialog.createConstraints(4, 0, 1, 1, 0.5, 1.0));
            stagePane.add((Component)this.triggerChannel[i], LogicSnifferConfigDialog.createConstraints(5, 0, 1, 1, 0.5, 1.0));
            JPanel maskValueEditor = this.createMaskValueEditor(i);
            stagePane.add((Component)maskValueEditor, LogicSnifferConfigDialog.createConstraints(0, 1, 6, 1, 1.0, 1.0));
            stagePane.add((Component)SwingComponentUtils.createRightAlignedLabel((String)"Hex Mask"), LogicSnifferConfigDialog.createConstraints(0, 4, 1, 1, 0.5, 1.0));
            this.triggerHexMask[i] = new JTextField("0");
            this.triggerHexMask[i].setToolTipText("hexadecimal trigger mask.");
            stagePane.add((Component)this.triggerHexMask[i], LogicSnifferConfigDialog.createConstraints(1, 4, 1, 1, 0.5, 1.0));
            stagePane.add((Component)SwingComponentUtils.createRightAlignedLabel((String)"Hex Value"), LogicSnifferConfigDialog.createConstraints(2, 4, 1, 1, 0.5, 1.0));
            this.triggerHexValue[i] = new JTextField("0");
            this.triggerHexValue[i].setToolTipText("hexadecimal trigger value.");
            stagePane.add((Component)this.triggerHexValue[i], LogicSnifferConfigDialog.createConstraints(3, 4, 1, 1, 0.5, 1.0));
            this.invertHexValue[i] = new JCheckBox("Invert");
            stagePane.add((Component)this.invertHexValue[i], LogicSnifferConfigDialog.createConstraints(4, 4, 1, 1, 1.0, 1.0));
            this.applyHexMaskButton[i] = new JButton("Apply Hex Mask");
            this.applyHexMaskButton[i].putClientProperty("EDITOR", this.triggerHexMask[i]);
            this.applyHexMaskButton[i].putClientProperty("MASKS", this.triggerMask[i]);
            stagePane.add((Component)this.applyHexMaskButton[i], LogicSnifferConfigDialog.createConstraints(1, 5, 1, 1, 1.0, 1.0));
            this.applyHexMaskButton[i].addActionListener(new ActionListener(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void actionPerformed(ActionEvent aEvent) {
                    JComponent source = (JComponent)aEvent.getSource();
                    JTextField textField = (JTextField)source.getClientProperty("EDITOR");
                    JCheckBox[] triggerMask = (JCheckBox[])source.getClientProperty("MASKS");
                    try {
                        long hexMask = Long.parseLong(textField.getText(), 16);
                        for (int i = 0; i < 32; ++i) {
                            boolean value = (hexMask >>> i & 1L) != 0L;
                            triggerMask[i].setSelected(value);
                        }
                    }
                    catch (NumberFormatException e) {
                        JOptionPane.showMessageDialog(LogicSnifferConfigDialog.this, "Illegal number format!\nPlease enter a hexadecimal value.");
                    }
                    finally {
                        LogicSnifferConfigDialog.this.updateFields();
                    }
                }
            });
            this.applyHexValueButton[i] = new JButton("Apply Hex Value");
            this.applyHexValueButton[i].putClientProperty("EDITOR", this.triggerHexValue[i]);
            this.applyHexValueButton[i].putClientProperty("VALUES", this.triggerValue[i]);
            this.applyHexValueButton[i].putClientProperty("INVERT", this.invertHexValue[i]);
            stagePane.add((Component)this.applyHexValueButton[i], LogicSnifferConfigDialog.createConstraints(3, 5, 1, 1, 1.0, 1.0));
            this.applyHexValueButton[i].addActionListener(new ActionListener(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void actionPerformed(ActionEvent aEvent) {
                    JComponent source = (JComponent)aEvent.getSource();
                    JTextField textField = (JTextField)source.getClientProperty("EDITOR");
                    JCheckBox[] triggerValue = (JCheckBox[])source.getClientProperty("VALUES");
                    JCheckBox invertHexValue = (JCheckBox)source.getClientProperty("INVERT");
                    try {
                        long hexValue = Long.parseLong(textField.getText(), 16);
                        if (invertHexValue.isSelected()) {
                            hexValue ^= 0xFFFFFFFFFFFFFFFFL;
                        }
                        for (int i = 0; i < 32; ++i) {
                            boolean value = (hexValue >>> i & 1L) != 0L;
                            triggerValue[i].setSelected(value);
                        }
                    }
                    catch (NumberFormatException e) {
                        JOptionPane.showMessageDialog(LogicSnifferConfigDialog.this, "Illegal number format!\nPlease enter a hexadecimal value.");
                    }
                    finally {
                        LogicSnifferConfigDialog.this.updateFields();
                    }
                }
            });
            stagePane.add((Component)SwingComponentUtils.createRightAlignedLabel((String)"Action"), LogicSnifferConfigDialog.createConstraints(0, 6, 1, 1, 1.0, 1.0));
            this.triggerStart[i] = new JCheckBox("Start Capture    (otherwise trigger level will rise by one)");
            stagePane.add((Component)this.triggerStart[i], LogicSnifferConfigDialog.createConstraints(1, 6, 3, 1, 1.0, 1.0));
            stagePane.add((Component)SwingComponentUtils.createRightAlignedLabel((String)"Delay"), LogicSnifferConfigDialog.createConstraints(4, 6, 1, 1, 0.5, 1.0));
            this.triggerDelay[i] = new JTextField("0");
            this.triggerDelay[i].setToolTipText("Delays trigger # samples after its condition is met.");
            stagePane.add((Component)this.triggerDelay[i], LogicSnifferConfigDialog.createConstraints(5, 6, 1, 1, 0.5, 1.0));
            this.triggerStageTabs.add(String.format("Stage %d", i + 1), stagePane);
        }
        this.warningLabel = new JLabel(" ");
        this.warningLabel.setFont(this.warningLabel.getFont().deriveFont(1));
    }

    private boolean isDdrMode() {
        return this.getSelectedSampleRate() > 100000000;
    }

    private boolean isSerialConnection() {
        return DeviceProfile.DeviceInterface.SERIAL.equals(this.connTypeSelect.getSelectedItem());
    }

    private boolean isNetworkConnection() {
        return DeviceProfile.DeviceInterface.NETWORK.equals(this.connTypeSelect.getSelectedItem());
    }

    private void setTriggerEnabled(boolean aEnable, int aAvailableTriggerStages) {
        int channelCount = this.getChannelCount();
        boolean complex = DeviceProfile.TriggerType.COMPLEX.equals(this.triggerTypeSelect.getSelectedItem());
        if (!complex) {
            this.triggerStageTabs.setSelectedIndex(0);
        }
        this.triggerTypeSelect.setEnabled(aEnable);
        this.ratioSlider.setEnabled(aEnable);
        for (int stage = 0; stage < 4; ++stage) {
            boolean stageEnabled = aEnable && stage < aAvailableTriggerStages;
            for (int i = 0; i < 32; ++i) {
                boolean enabled = stageEnabled && i < channelCount;
                ConfigDialogHelper.updateCheckBoxState(this.triggerMask[stage][i], enabled);
                ConfigDialogHelper.updateCheckBoxState(this.triggerValue[stage][i], enabled);
            }
            this.triggerStageTabs.setEnabledAt(stage, stageEnabled && (stage == 0 || complex));
            this.triggerLevel[stage].setEnabled(stageEnabled && complex);
            this.triggerDelay[stage].setEnabled(stageEnabled);
            this.triggerMode[stage].setEnabled(stageEnabled);
            if (aEnable && this.triggerMode[stage].getSelectedIndex() == 1) {
                this.triggerChannel[stage].setEnabled(true);
            } else {
                this.triggerChannel[stage].setEnabled(false);
            }
            this.triggerStart[stage].setEnabled(stageEnabled && complex);
            this.triggerHexMask[stage].setEnabled(stageEnabled);
            this.triggerHexValue[stage].setEnabled(stageEnabled);
            this.applyHexMaskButton[stage].setEnabled(stageEnabled);
            this.applyHexValueButton[stage].setEnabled(stageEnabled);
            this.invertHexValue[stage].setEnabled(stageEnabled);
        }
    }

    private boolean verifyConfiguration(boolean aWarnUserIfConfigIncorrect) {
        boolean result = true;
        if (this.deviceProfile == null) {
            if (aWarnUserIfConfigIncorrect) {
                JOptionPane.showMessageDialog(this, "No device profile is selected!\nIs the device(port) properly configurated?", "Invalid settings detected!", 2);
            }
            return false;
        }
        boolean triggerEnabled = this.triggerEnable.isSelected();
        if (triggerEnabled) {
            for (int stage = 0; result && stage < 4; ++stage) {
                Integer delay = ConfigDialogHelper.getNumericValue(this.triggerDelay[stage]);
                if ((result &= delay != null && delay <= 65535) || !aWarnUserIfConfigIncorrect) continue;
                result = SwingComponentUtils.askConfirmation((Window)this, (String)("Trigger delay for stage " + stage + " is larger than 65535 cycles! Continue capture?"));
            }
        }
        int enabledChannelGroups = this.getEnabledChannelGroups();
        int maxSampleCount = this.determineMaxSampleCount(enabledChannelGroups);
        int sampleCount = this.getSelectedSampleCount();
        if (maxSampleCount >= 0 && result) {
            boolean bl = result = sampleCount <= maxSampleCount;
            if (!result && aWarnUserIfConfigIncorrect) {
                result = SwingComponentUtils.askConfirmation((Window)this, (String)"Sample count too large for chosen channel groups! Continue capture?");
            }
        }
        if (result) {
            boolean bl = result = enabledChannelGroups > 0;
            if (!result && aWarnUserIfConfigIncorrect) {
                result = SwingComponentUtils.askConfirmation((Window)this, (String)"No channel groups are enabled! Continue capture?");
            }
        }
        return result;
    }

    static final class TriggerRatioChangeListener
    implements ChangeListener {
        static final int DEFAULT_RATIO = 50;
        private final JLabel label;

        public TriggerRatioChangeListener(JLabel aListeningLabel) {
            this.label = aListeningLabel;
            this.updateLabel(50, 50);
        }

        @Override
        public void stateChanged(ChangeEvent aEvent) {
            JSlider slider = (JSlider)aEvent.getSource();
            int before = slider.getValue();
            int after = slider.getMaximum() - before;
            slider.setToolTipText(this.updateLabel(before, after));
        }

        private String updateLabel(int aBeforeRatio, int aAfterRatio) {
            String ratioText = String.format("%d / %d", aBeforeRatio, aAfterRatio);
            this.label.setText(ratioText);
            return ratioText;
        }
    }

    static final class NumberSchemeComboBoxRenderer
    extends EnumItemRenderer<DeviceProfile.NumberingScheme> {
        private static final long serialVersionUID = 1L;

        NumberSchemeComboBoxRenderer() {
        }

        protected String getDisplayValue(DeviceProfile.NumberingScheme aValue) {
            switch (aValue) {
                case DEFAULT: {
                    return "Default";
                }
                case INSIDE: {
                    return "Inside";
                }
                case OUTSIDE: {
                    return "Outside";
                }
            }
            return super.getDisplayValue((Enum)aValue);
        }
    }

    static final class DeviceInterfaceComboBoxRenderer
    extends EnumItemRenderer<DeviceProfile.DeviceInterface> {
        private static final long serialVersionUID = 1L;

        DeviceInterfaceComboBoxRenderer() {
        }

        protected String getDisplayValue(DeviceProfile.DeviceInterface aValue) {
            switch (aValue) {
                case NETWORK: {
                    return "Network";
                }
                case SERIAL: {
                    return "Serial port";
                }
                case USB: {
                    return "USB";
                }
            }
            return super.getDisplayValue((Enum)aValue);
        }
    }

    static final class ClockSourceComboBoxRenderer
    extends EnumItemRenderer<DeviceProfile.CaptureClockSource> {
        private static final long serialVersionUID = 1L;

        ClockSourceComboBoxRenderer() {
        }

        protected String getDisplayValue(DeviceProfile.CaptureClockSource aValue) {
            switch (aValue) {
                case INTERNAL: {
                    return "Internal";
                }
                case EXTERNAL_FALLING: {
                    return "External / Rising";
                }
                case EXTERNAL_RISING: {
                    return "External / Falling";
                }
            }
            return super.getDisplayValue((Enum)aValue);
        }
    }

    static final class CaptureSpeedComboBoxRenderer
    extends BasicComboBoxRenderer {
        private static final long serialVersionUID = 1L;

        CaptureSpeedComboBoxRenderer() {
        }

        @Override
        public Component getListCellRendererComponent(JList aList, Object aValue, int aIndex, boolean aIsSelected, boolean aCellHasFocus) {
            Object value = aValue;
            if (value instanceof Integer) {
                value = Unit.Frequency.format((double)((Integer)value).doubleValue());
            }
            return super.getListCellRendererComponent((JList<?>)aList, value, aIndex, aIsSelected, aCellHasFocus);
        }
    }

    final class BinarySizeComboBoxRenderer
    extends BasicComboBoxRenderer {
        private static final long serialVersionUID = 1L;

        BinarySizeComboBoxRenderer() {
        }

        @Override
        public Component getListCellRendererComponent(JList aList, Object aValue, int aIndex, boolean aIsSelected, boolean aCellHasFocus) {
            Object value = aValue;
            if (value instanceof Integer) {
                double size = ((Integer)value).doubleValue();
                int enabledGroups = LogicSnifferConfigDialog.this.getEnabledChannelGroups();
                if (enabledGroups > 0) {
                    int sampleRate = LogicSnifferConfigDialog.this.getSelectedSampleRate();
                    double time = enabledGroups != 0 ? size / (double)(sampleRate * enabledGroups) : 0.0;
                    value = String.format("<html>%s&nbsp;&nbsp;<span style='color:gray;font-size:0.85em;'>(%s)</span></html>", Unit.SizeSI.format((double)size), Unit.Time.format((double)time));
                } else {
                    value = String.format("%s", Unit.SizeSI.format((double)size));
                }
            }
            return super.getListCellRendererComponent((JList<?>)aList, value, aIndex, aIsSelected, aCellHasFocus);
        }
    }
}

