/*
 * Decompiled with CFR 0.152.
 */
package org.sump.device.logicsniffer.protocol;

import java.io.Closeable;
import java.io.DataInputStream;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import nl.lxtreme.ols.util.HostUtils;
import org.sump.device.logicsniffer.LogicSnifferMetadata;
import org.sump.device.logicsniffer.protocol.SumpProtocolConstants;

public class SumpResultReader
implements Closeable,
SumpProtocolConstants {
    private static final Logger LOG = Logger.getLogger(SumpResultReader.class.getName());
    private final DataInputStream inputStream;

    public SumpResultReader(DataInputStream aInputStream) {
        this.inputStream = aInputStream;
    }

    @Override
    public void close() throws IOException {
        this.inputStream.close();
    }

    public void flush() throws IOException {
        if (this.inputStream != null) {
            while (this.inputStream.available() > 0 && this.inputStream.read() >= 0) {
            }
        }
    }

    public int readDeviceId() throws IOException {
        int id = this.inputStream.readInt();
        if (id == 809585747) {
            LOG.log(Level.INFO, "Found (unsupported!) Sump Logic Analyzer ...", Integer.toHexString(id));
        } else if (id == 826362963) {
            LOG.log(Level.INFO, "Found Sump Logic Analyzer/LogicSniffer compatible device ...", Integer.toHexString(id));
        } else {
            LOG.log(Level.INFO, "Found unknown device: 0x{0} ...", Integer.toHexString(id));
            id = -1;
        }
        return id;
    }

    public boolean readMetadata(LogicSnifferMetadata aMetadata) throws IOException, IllegalStateException {
        boolean gotResponse = false;
        int result = -1;
        do {
            try {
                result = this.inputStream.read();
                if (result <= 0) continue;
                gotResponse = true;
                int type = (result & 0xE0) >> 5;
                if (type == 0) {
                    String value = this.readString();
                    aMetadata.put(result, value);
                    continue;
                }
                if (type == 1) {
                    int value = this.inputStream.readInt();
                    aMetadata.put(result, value);
                    continue;
                }
                if (type == 2) {
                    int value = this.inputStream.read();
                    aMetadata.put(result, value);
                    continue;
                }
                LOG.log(Level.INFO, "Ignoring unknown metadata type: {0}", type);
            }
            catch (IOException exception) {
                result = -1;
                if (HostUtils.handleInterruptedException((Throwable)exception)) continue;
                LOG.log(Level.INFO, "I/O exception", exception);
            }
        } while (result > 0 && !Thread.currentThread().isInterrupted());
        return gotResponse;
    }

    public int readRawData(byte[] aBuffer, int aOffset, int aCount) throws IOException {
        return this.inputStream.read(aBuffer, aOffset, aCount);
    }

    final String readString() throws IOException {
        StringBuilder sb = new StringBuilder();
        int read = -1;
        do {
            if ((read = this.inputStream.read()) <= 0) continue;
            sb.append((char)read);
        } while (read > 0 && !Thread.currentThread().isInterrupted());
        return sb.toString();
    }
}

