/*
 * Decompiled with CFR 0.152.
 */
package nl.lxtreme.ols.tool.onewire;

import java.util.logging.Level;
import java.util.logging.Logger;
import nl.lxtreme.ols.api.acquisition.AcquisitionResult;
import nl.lxtreme.ols.api.data.Edge;
import nl.lxtreme.ols.api.data.annotation.Annotation;
import nl.lxtreme.ols.api.data.annotation.AnnotationListener;
import nl.lxtreme.ols.api.tools.ToolContext;
import nl.lxtreme.ols.api.tools.ToolProgressListener;
import nl.lxtreme.ols.api.tools.ToolTask;
import nl.lxtreme.ols.api.util.Unit;
import nl.lxtreme.ols.tool.base.annotation.ChannelLabelAnnotation;
import nl.lxtreme.ols.tool.base.annotation.SampleDataAnnotation;
import nl.lxtreme.ols.tool.onewire.OneWireBusMode;
import nl.lxtreme.ols.tool.onewire.OneWireDataSet;
import nl.lxtreme.ols.tool.onewire.OneWireTiming;
import nl.lxtreme.ols.util.NumberUtils;

public class OneWireAnalyserTask
implements ToolTask<OneWireDataSet> {
    private static final String OW_1_WIRE = "1-Wire";
    private static final Logger LOG = Logger.getLogger(OneWireAnalyserTask.class.getName());
    private final ToolContext context;
    private final ToolProgressListener progressListener;
    private final AnnotationListener annotationListener;
    private int owLineIndex;
    private int owLineMask;
    private OneWireTiming owTiming;

    public OneWireAnalyserTask(ToolContext aContext, ToolProgressListener aProgressListener, AnnotationListener aAnnotationListener) {
        this.context = aContext;
        this.progressListener = aProgressListener;
        this.annotationListener = aAnnotationListener;
        this.owTiming = new OneWireTiming(OneWireBusMode.STANDARD);
    }

    public OneWireDataSet call() throws Exception {
        int dataValue;
        int sampleIdx;
        AcquisitionResult data = this.context.getData();
        int[] values = data.getValues();
        int dataMask = this.owLineMask;
        int sampleCount = values.length;
        if (LOG.isLoggable(Level.FINE)) {
            LOG.log(Level.FINE, "1-Wire Line mask = 0x{0}", Integer.toHexString(this.owLineMask));
        }
        for (sampleIdx = 0; sampleIdx < sampleCount && ((dataValue = values[sampleIdx]) & dataMask) != dataMask; ++sampleIdx) {
        }
        if (sampleIdx == sampleCount) {
            LOG.log(Level.WARNING, "No IDLE state found in data; aborting analysis...");
            throw new IllegalStateException("No IDLE state found!");
        }
        OneWireDataSet decodedData = new OneWireDataSet(sampleIdx, sampleCount, data);
        this.prepareResult(OW_1_WIRE);
        this.decodeData(data, decodedData);
        return decodedData;
    }

    public void setOneWireBusMode(OneWireBusMode aBusMode) {
        this.owTiming = new OneWireTiming(aBusMode);
    }

    public void setOneWireLineIndex(int aIndex) {
        this.owLineIndex = aIndex;
        this.owLineMask = 1 << aIndex;
    }

    private void decodeData(AcquisitionResult aData, OneWireDataSet aDataSet) {
        long[] timestamps = aData.getTimestamps();
        this.progressListener.setProgress(0);
        long startOfDecode = timestamps[aDataSet.getStartOfDecode()];
        long endOfDecode = timestamps[aDataSet.getEndOfDecode() - 1];
        double timingCorrection = 1000000.0 / (double)aData.getSampleRate();
        long time = Math.max(0L, startOfDecode);
        int bitCount = 8;
        int byteValue = 0;
        long byteStartTime = time;
        while (endOfDecode - time > 0L) {
            double diff;
            long fallingEdge = this.findEdge(aData, time, endOfDecode, Edge.FALLING);
            if (fallingEdge < 0L) {
                LOG.log(Level.INFO, "Decoding ended at {0}; no falling edge found...", Unit.Time.format((double)((double)time / (double)aData.getSampleRate())));
                break;
            }
            long risingEdge = this.findEdge(aData, fallingEdge, endOfDecode, Edge.RISING);
            if (risingEdge < 0L) {
                risingEdge = endOfDecode;
            }
            if (this.owTiming.isReset(diff = (double)(risingEdge - fallingEdge) * timingCorrection)) {
                long nextFallingEdge = this.findEdge(aData, risingEdge, endOfDecode, Edge.FALLING);
                boolean slavePresent = false;
                if (nextFallingEdge > 0L) {
                    slavePresent = this.owTiming.isSlavePresencePulse((double)(nextFallingEdge - risingEdge) * timingCorrection);
                }
                time = (long)((double)fallingEdge + this.owTiming.getResetFrameLength() / timingCorrection);
                LOG.log(Level.FINE, "Master bus reset; slave is {0}present...", slavePresent ? "" : "NOT ");
                this.reportReset(aDataSet, fallingEdge, time, slavePresent);
            } else {
                if (bitCount == 8) {
                    byteStartTime = fallingEdge;
                }
                if (this.owTiming.isZero(diff)) {
                    time = (long)((double)fallingEdge + this.owTiming.getBitFrameLength() / timingCorrection);
                } else if (this.owTiming.isOne(diff)) {
                    byteValue |= 0x80;
                    time = (long)((double)fallingEdge + this.owTiming.getBitFrameLength() / timingCorrection);
                } else {
                    this.reportBusError(aDataSet, byteStartTime);
                    byteValue = 0;
                    bitCount = 8;
                    time = fallingEdge;
                    continue;
                }
                if (--bitCount == 0) {
                    this.reportData(aDataSet, byteStartTime, time, byteValue);
                    byteValue = 0;
                    bitCount = 8;
                } else {
                    byteValue >>= 1;
                }
            }
            this.progressListener.setProgress(NumberUtils.getPercentage((long)time, (long)startOfDecode, (long)endOfDecode));
        }
        this.progressListener.setProgress(100);
    }

    private long findEdge(AcquisitionResult aData, long aStartOfDecode, long aEndOfDecode, Edge aEdge) {
        long result = -1L;
        int oldBitValue = this.getDataValue(aData, aStartOfDecode) & this.owLineMask;
        for (long timeCursor = aStartOfDecode + 1L; result < 0L && timeCursor < aEndOfDecode; ++timeCursor) {
            int bitValue = this.getDataValue(aData, timeCursor) & this.owLineMask;
            Edge edge = Edge.toEdge((int)oldBitValue, (int)bitValue);
            if (aEdge == edge) {
                result = timeCursor;
            }
            oldBitValue = bitValue;
        }
        return result;
    }

    private int getDataValue(AcquisitionResult aData, long aTimeValue) {
        int i;
        int[] values = aData.getValues();
        long[] timestamps = aData.getTimestamps();
        for (i = 1; i < timestamps.length && aTimeValue >= timestamps[i]; ++i) {
        }
        return values[i - 1];
    }

    private void prepareResult(String aLabel) {
        this.annotationListener.clearAnnotations(this.owLineIndex);
        this.annotationListener.onAnnotation((Annotation)new ChannelLabelAnnotation(this.owLineIndex, aLabel));
    }

    private void reportBusError(OneWireDataSet aDataSet, long aStartTimestamp) {
        AcquisitionResult data = this.context.getData();
        int startSampleIdx = Math.max(data.getSampleIndex(aStartTimestamp), 0);
        aDataSet.reportBusError(this.owLineIndex, startSampleIdx);
        this.annotationListener.onAnnotation((Annotation)new SampleDataAnnotation(this.owLineIndex, aStartTimestamp, aStartTimestamp, "BUS-ERROR"));
    }

    private void reportData(OneWireDataSet aDataSet, long aStartTimestamp, long aEndTimestamp, int aByteValue) {
        AcquisitionResult data = this.context.getData();
        int startSampleIdx = Math.max(data.getSampleIndex(aStartTimestamp), 0);
        int endSampleIdx = Math.min(data.getSampleIndex(aEndTimestamp) - 1, data.getTimestamps().length - 1);
        aDataSet.reportData(this.owLineIndex, startSampleIdx, endSampleIdx, aByteValue);
        String annotation = String.format("0x%X (%c)", aByteValue, aByteValue);
        this.annotationListener.onAnnotation((Annotation)new SampleDataAnnotation(this.owLineIndex, aStartTimestamp, aEndTimestamp, annotation));
    }

    private void reportReset(OneWireDataSet aDataSet, long aStartTimestamp, long aEndTimestamp, boolean aSlaveIsPresent) {
        AcquisitionResult data = this.context.getData();
        int startSampleIdx = Math.max(data.getSampleIndex(aStartTimestamp), 0);
        int endSampleIdx = Math.min(data.getSampleIndex(aEndTimestamp) - 1, data.getTimestamps().length - 1);
        aDataSet.reportReset(this.owLineIndex, startSampleIdx, endSampleIdx, aSlaveIsPresent);
        String annotation = String.format("Master reset, slave %s present", aSlaveIsPresent ? "is" : "is NOT");
        this.annotationListener.onAnnotation((Annotation)new SampleDataAnnotation(this.owLineIndex, aStartTimestamp, aEndTimestamp, annotation));
    }
}

