/*
 * Decompiled with CFR 0.152.
 */
package nl.lxtreme.ols.tool.uart;

import java.util.Arrays;
import nl.lxtreme.ols.api.acquisition.AcquisitionResult;
import nl.lxtreme.ols.api.data.Edge;
import nl.lxtreme.ols.api.tools.ToolContext;
import nl.lxtreme.ols.api.tools.ToolProgressListener;
import nl.lxtreme.ols.util.NumberUtils;

public class AsyncSerialDataDecoder {
    public static final int[] COMMON_BAUDRATES = new int[]{150, 300, 600, 1200, 2400, 4800, 9600, 14400, 19200, 28800, 38400, 57600, 76800, 115200, 230400, 460800, 921600};
    protected final SerialConfiguration configuration;
    protected final AcquisitionResult dataSet;
    protected final ToolContext context;
    private SerialDecoderCallback callback;
    private ToolProgressListener progressListener;

    public AsyncSerialDataDecoder(SerialConfiguration aConfiguration, ToolContext aContext) {
        this.configuration = aConfiguration;
        this.context = aContext;
        this.dataSet = aContext.getData();
    }

    protected static final int findSampleIndex(long[] aTimestamps, long aTimeValue) {
        int k = Arrays.binarySearch(aTimestamps, aTimeValue);
        if (k < 0) {
            k = -(k + 1);
        }
        return k;
    }

    public double decodeDataLine(int aChannelIndex) {
        int frameSize = this.configuration.getFrameSize(this.dataSet.getSampleRate());
        double bitLength = this.configuration.getBitLength(this.dataSet.getSampleRate());
        int bitCount = this.configuration.getDataBits();
        StopBits stopBits = this.configuration.getStopBits();
        Parity parity = this.configuration.getParity();
        long[] timestamps = this.dataSet.getTimestamps();
        long startOfDecode = timestamps[this.context.getStartSampleIndex()];
        long endOfDecode = timestamps[this.context.getEndSampleIndex()];
        BitLevel idleLevel = this.configuration.getIdleLevel();
        DataBitExtractor extractor = new DataBitExtractor(aChannelIndex);
        this.setProgress(0);
        long start = this.findStartBit(aChannelIndex, idleLevel.nextEdge(), startOfDecode, endOfDecode);
        while (start >= 0L && endOfDecode - start > (long)frameSize) {
            extractor.jumpTo(start);
            if (extractor.level() != idleLevel.invert() && this.callback != null) {
                this.callback.onError(aChannelIndex, ErrorType.START, extractor.time());
            }
            extractor.next();
            long startTime = extractor.time();
            int symbol = 0;
            int marks = 0;
            for (int bitIdx = 0; bitIdx < bitCount; ++bitIdx) {
                if (extractor.value() == BitValue.MARK) {
                    symbol |= 1 << bitIdx;
                    ++marks;
                }
                extractor.next();
            }
            long endTime = extractor.time() - 1L;
            if (this.configuration.getBitOrder() == BitOrder.MSB_FIRST) {
                symbol = NumberUtils.reverseBits((int)symbol, (int)bitCount);
            }
            if (this.callback != null) {
                this.callback.onSymbol(aChannelIndex, symbol, startTime, endTime);
            }
            if (parity.isOdd() || parity.isEven()) {
                if (extractor.value() == BitValue.MARK) {
                    ++marks;
                }
                if (parity.isOdd() && marks % 2 == 0 || parity.isEven() && marks % 2 == 1) {
                    this.callback.onError(aChannelIndex, ErrorType.PARITY, extractor.time());
                }
                extractor.next();
            }
            if (extractor.level() != idleLevel && this.callback != null) {
                this.callback.onError(aChannelIndex, ErrorType.FRAME, extractor.time());
            }
            start = this.findStartBit(aChannelIndex, idleLevel.nextEdge(), (long)((double)extractor.time() + bitLength / 2.0), endOfDecode);
            long endOfStopbit = extractor.time() + (long)(stopBits.getValue() * bitLength);
            if (start >= 0L && endOfStopbit > start && this.callback != null) {
                this.callback.onError(aChannelIndex, ErrorType.FRAME, extractor.time());
            }
            if (start < 0L) continue;
            this.setProgress(NumberUtils.getPercentage((long)start, (long)startOfDecode, (long)endOfDecode));
        }
        this.setProgress(100);
        return extractor.averageBitLength();
    }

    public void setCallback(SerialDecoderCallback aCallback) {
        this.callback = aCallback;
    }

    public final void setProgressListener(ToolProgressListener aProgressListener) {
        this.progressListener = aProgressListener;
    }

    protected final long findEdge(int aChannelIndex, Edge aSampleEdge, long aStartOfDecode, long aEndOfDecode) {
        int mask = 1 << aChannelIndex;
        long result = -1L;
        int oldBitValue = this.getDataValue(aStartOfDecode, mask);
        for (long timeCursor = aStartOfDecode + 1L; result < 0L && timeCursor < aEndOfDecode; ++timeCursor) {
            int bitValue = this.getDataValue(timeCursor, mask);
            Edge edge = Edge.toEdge((int)oldBitValue, (int)bitValue);
            if (aSampleEdge.isNone() && !edge.isNone()) {
                result = timeCursor;
            } else if (!aSampleEdge.isNone() && aSampleEdge == edge) {
                result = timeCursor;
            }
            oldBitValue = bitValue;
        }
        return result;
    }

    protected long findStartBit(int aChannelIndex, Edge aEdge, long aStartOfDecode, long aEndOfDecode) {
        return this.findEdge(aChannelIndex, aEdge, aStartOfDecode, aEndOfDecode);
    }

    protected final SerialDecoderCallback getCallback() {
        return this.callback;
    }

    protected final int getDataValue(long aTimeValue, int aMask) {
        int[] values = this.dataSet.getValues();
        long[] timestamps = this.dataSet.getTimestamps();
        int k = AsyncSerialDataDecoder.findSampleIndex(timestamps, aTimeValue);
        int value = k == 0 ? values[0] : values[k - 1];
        return value & aMask;
    }

    protected final void setProgress(int aProgress) {
        if (this.progressListener != null) {
            this.progressListener.setProgress(aProgress);
        }
    }

    public static enum StopBits {
        ONE,
        ONE_HALF,
        TWO;


        public double getValue() {
            if (this == ONE_HALF) {
                return 1.5;
            }
            if (this == TWO) {
                return 2.0;
            }
            return 1.0;
        }
    }

    private class DataBitExtractor {
        private double time = 0.0;
        private int mask;
        private int channelIndex;
        private double bitLength;
        private double confirmedSamples;
        private long confirmedBits;
        private double lastEdge;
        private int bitsSinceEdge;

        public DataBitExtractor(int aChannelIndex) {
            this.channelIndex = aChannelIndex;
            this.mask = 1 << aChannelIndex;
            this.bitLength = AsyncSerialDataDecoder.this.configuration.getBitLength(AsyncSerialDataDecoder.this.dataSet.getSampleRate());
        }

        public BitLevel level() {
            long halfTime = (long)(this.time + this.bitLength / 2.0);
            int level = AsyncSerialDataDecoder.this.getDataValue(halfTime, this.mask);
            return level == 0 ? BitLevel.LOW : BitLevel.HIGH;
        }

        public BitValue value() {
            if (AsyncSerialDataDecoder.this.configuration.getBitEncoding() == BitEncoding.HIGH_IS_SPACE) {
                return this.level() == BitLevel.HIGH ? BitValue.SPACE : BitValue.MARK;
            }
            return this.level() == BitLevel.HIGH ? BitValue.MARK : BitValue.SPACE;
        }

        public void next() {
            this.time += this.bitLength;
            ++this.bitsSinceEdge;
            long start = (long)(this.time - this.bitLength * 0.25 - 1.0);
            long end = (long)(this.time + this.bitLength * 0.25 + 1.0);
            long edge = AsyncSerialDataDecoder.this.findEdge(this.channelIndex, Edge.NONE, start, end);
            if (edge >= 0L) {
                this.time = edge;
                this.confirmedSamples += this.time - this.lastEdge;
                this.confirmedBits += (long)this.bitsSinceEdge;
                this.lastEdge = this.time;
                this.bitsSinceEdge = 0;
            }
        }

        public void jumpTo(long time) {
            this.time = time;
            this.lastEdge = time;
            this.bitsSinceEdge = 0;
        }

        public long time() {
            return (long)this.time;
        }

        public double averageBitLength() {
            return this.confirmedSamples / (double)this.confirmedBits;
        }
    }

    public static enum BitValue {
        SPACE,
        MARK;

    }

    public static enum BitLevel {
        HIGH,
        LOW;


        public BitLevel invert() {
            return this == HIGH ? LOW : HIGH;
        }

        public Edge nextEdge() {
            return this == HIGH ? Edge.FALLING : Edge.RISING;
        }
    }

    public static interface SerialDecoderCallback {
        public void onError(int var1, ErrorType var2, long var3);

        public void onEvent(int var1, String var2, long var3, long var5);

        public void onSymbol(int var1, int var2, long var3, long var5);
    }

    public static class SerialConfiguration {
        private final int dataBits;
        private final int baudRate;
        private final StopBits stopBits;
        private final Parity parity;
        private final BitEncoding bitEncoding;
        private final BitOrder bitOrder;
        private final BitLevel idleLevel;

        public SerialConfiguration() {
            this(9600, 8, StopBits.ONE, Parity.NONE, BitEncoding.HIGH_IS_MARK, BitOrder.LSB_FIRST, BitLevel.HIGH);
        }

        public SerialConfiguration(int aBaudRate, int aDataBits, StopBits aStopBits, Parity aParity, BitEncoding aBitEncoding, BitOrder aBitOrder, BitLevel aIdleLevel) {
            this.baudRate = aBaudRate;
            this.dataBits = aDataBits;
            this.stopBits = aStopBits;
            this.parity = aParity;
            this.bitEncoding = aBitEncoding;
            this.bitOrder = aBitOrder;
            this.idleLevel = aIdleLevel;
        }

        public int getBaudRate() {
            return this.baudRate;
        }

        public double getBitLength(int aSampleRate) {
            return (double)aSampleRate / (double)this.baudRate;
        }

        public int getDataBits() {
            return this.dataBits;
        }

        public int getFrameSize(int aSampleRate) {
            double bitLength = this.getBitLength(aSampleRate);
            int stopCount = (int)Math.ceil(this.stopBits.getValue());
            int parityCount = this.parity.isNone() ? 0 : 1;
            return (int)((double)(this.dataBits + stopCount + parityCount) * bitLength);
        }

        public Parity getParity() {
            return this.parity;
        }

        public StopBits getStopBits() {
            return this.stopBits;
        }

        public BitEncoding getBitEncoding() {
            return this.bitEncoding;
        }

        public BitOrder getBitOrder() {
            return this.bitOrder;
        }

        public BitLevel getIdleLevel() {
            return this.idleLevel;
        }
    }

    public static enum BitEncoding {
        HIGH_IS_MARK,
        HIGH_IS_SPACE;

    }

    public static enum BitOrder {
        LSB_FIRST,
        MSB_FIRST;

    }

    public static enum Parity {
        NONE,
        ODD,
        EVEN;


        public boolean isEven() {
            return this == EVEN;
        }

        public boolean isNone() {
            return this == NONE;
        }

        public boolean isOdd() {
            return this == ODD;
        }
    }

    public static enum ErrorType {
        START,
        PARITY,
        FRAME;

    }
}

