/*
 * Decompiled with CFR 0.152.
 */
package nl.lxtreme.ols.tool.uart;

import nl.lxtreme.ols.tool.uart.AsyncSerialDataDecoder;
import nl.lxtreme.ols.util.analysis.Frequency;

public final class BaudRateAnalyzer {
    private final double sampleRate;
    private final Frequency<Integer> statData;

    public BaudRateAnalyzer(int aSampleRate, int aFixedBaudRate) {
        this.sampleRate = aSampleRate;
        this.statData = new Frequency();
        int bitLength = (int)Math.round((double)aSampleRate / (double)aFixedBaudRate);
        this.statData.addValue((Comparable)Integer.valueOf(bitLength));
    }

    public BaudRateAnalyzer(int aSampleRate, int[] aValues, long[] aTimestamps, int aMask) {
        this.sampleRate = aSampleRate;
        this.statData = new Frequency();
        long lastTransition = 0L;
        int lastBitValue = aValues[0] & aMask;
        for (int i = 0; i < aValues.length; ++i) {
            int bitValue = aValues[i] & aMask;
            if (lastBitValue != bitValue) {
                int bitLength = (int)(aTimestamps[i] - lastTransition);
                this.statData.addValue((Comparable)Integer.valueOf(bitLength));
                lastTransition = aTimestamps[i];
            }
            lastBitValue = aValues[i] & aMask;
        }
    }

    public int getBaudRate() {
        int br = this.getBaudRateExact();
        int[] commonBaudrates = AsyncSerialDataDecoder.COMMON_BAUDRATES;
        int baudRateRounded = -1;
        for (int idx = 1; baudRateRounded < 0 && idx < commonBaudrates.length; ++idx) {
            int delta = (commonBaudrates[idx] - commonBaudrates[idx - 1]) / 2;
            if (br < commonBaudrates[idx] - delta || br > commonBaudrates[idx] + delta) continue;
            baudRateRounded = commonBaudrates[idx];
        }
        if (baudRateRounded < 0) {
            return br;
        }
        return baudRateRounded;
    }

    public int getBaudRateExact() {
        double bestBitLength = this.getBestBitLength();
        if (bestBitLength < 0.0) {
            return -1;
        }
        return (int)(this.sampleRate / bestBitLength);
    }

    public double getBestBitLength() {
        Integer highestRanked = (Integer)this.statData.getHighestRanked();
        long sum = 0L;
        long count = 0L;
        if (highestRanked != null) {
            double min = highestRanked.doubleValue() * 0.75;
            double max = highestRanked.doubleValue() * 1.25;
            for (Integer length : this.statData.values()) {
                double bitlength = length.doubleValue();
                if (!(min < bitlength) || !(bitlength < max)) continue;
                long rank = this.statData.getCount((Comparable)length);
                sum = (long)((double)sum + bitlength * (double)rank);
                count += rank;
            }
        }
        return highestRanked == null ? -1.0 : (double)sum / (double)count;
    }
}

