/*
 * Decompiled with CFR 0.152.
 */
package nl.lxtreme.ols.tool.uart.impl;

import java.util.logging.Level;
import java.util.logging.Logger;
import nl.lxtreme.ols.api.acquisition.AcquisitionResult;
import nl.lxtreme.ols.api.data.BaseDataSet;
import nl.lxtreme.ols.tool.uart.AsyncSerialDataDecoder;
import nl.lxtreme.ols.tool.uart.impl.UARTData;

public final class UARTDataSet
extends BaseDataSet<UARTData> {
    public static final String UART_RXD = "RxD";
    public static final String UART_TXD = "TxD";
    public static final String UART_CTS = "CTS";
    public static final String UART_RTS = "RTS";
    public static final String UART_DCD = "DCD";
    public static final String UART_RI = "RI";
    public static final String UART_DSR = "DSR";
    public static final String UART_DTR = "DTR";
    private static final Logger LOG = Logger.getLogger(UARTDataSet.class.getName());
    private int decodedSymbols = 0;
    private double bitLength = -1.0;
    private int detectedErrors = 0;
    private int baudRate;

    public UARTDataSet(int aStartSampleIdx, int aEndSampleIdx, AcquisitionResult aData) {
        super(aStartSampleIdx, aEndSampleIdx, aData);
    }

    public int getBaudRate() {
        return this.baudRate;
    }

    public int getBaudRateExact() {
        return (int)((double)this.getSampleRate() / this.bitLength);
    }

    public double getBitLength() {
        return this.bitLength;
    }

    public int getDecodedSymbols() {
        return this.decodedSymbols;
    }

    public int getDetectedErrors() {
        return this.detectedErrors;
    }

    public boolean isBitLengthUsable() {
        return this.getBitLength() > 15.0;
    }

    public void reportControlHigh(int aChannelIdx, int aSampleIdx, String aName) {
        int idx = this.size();
        this.addData(new UARTData(idx, aChannelIdx, aSampleIdx, aName.toUpperCase() + "_HIGH"));
    }

    public void reportControlLow(int aChannelIdx, int aSampleIdx, String aName) {
        int idx = this.size();
        this.addData(new UARTData(idx, aChannelIdx, aSampleIdx, aName.toUpperCase() + "_LOW"));
    }

    public void reportData(int aChannelIdx, int aStartSampleIdx, int aEndSampleIdx, int aValue, int aEventType) {
        int idx = this.size();
        ++this.decodedSymbols;
        this.addData(new UARTData(idx, aChannelIdx, aStartSampleIdx, aEndSampleIdx, aValue, aEventType));
    }

    public void reportError(AsyncSerialDataDecoder.ErrorType aType, int aChannelIdx, int aSampleIdx, int aEventType) {
        int idx = this.size();
        ++this.detectedErrors;
        this.addData(new UARTData(idx, aChannelIdx, aSampleIdx, aType.name(), aEventType));
    }

    public void setBaudRate(int aBaudRate) {
        this.baudRate = aBaudRate;
    }

    public void setSampledBitLength(double aBitLength) {
        if (this.bitLength <= 0.0 || 10.0 * aBitLength < this.bitLength) {
            this.bitLength = aBitLength;
        } else {
            double diff = Math.abs(aBitLength - this.bitLength);
            if (diff < 50.0) {
                this.bitLength = (aBitLength + this.bitLength) / 2.0;
            } else {
                LOG.log(Level.INFO, "Ignoring sampled bit length ({0}) as it deviates too much from current bit length ({1}).", new Object[]{aBitLength, this.bitLength});
            }
        }
    }

    public void sort() {
        super.sort();
    }
}

