/*
 * Decompiled with CFR 0.152.
 */
package nl.lxtreme.ols.tool.uart.impl;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.File;
import java.io.IOException;
import java.text.DateFormat;
import java.util.Date;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.Action;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.SpringLayout;
import nl.lxtreme.ols.api.UserSettings;
import nl.lxtreme.ols.api.tools.Tool;
import nl.lxtreme.ols.api.tools.ToolContext;
import nl.lxtreme.ols.api.tools.ToolTask;
import nl.lxtreme.ols.api.util.Unit;
import nl.lxtreme.ols.tool.base.BaseToolDialog;
import nl.lxtreme.ols.tool.base.ExportAware;
import nl.lxtreme.ols.tool.base.ToolDialog;
import nl.lxtreme.ols.tool.base.ToolUtils;
import nl.lxtreme.ols.tool.uart.AsyncSerialDataDecoder;
import nl.lxtreme.ols.tool.uart.impl.UARTAnalyser;
import nl.lxtreme.ols.tool.uart.impl.UARTAnalyserTask;
import nl.lxtreme.ols.tool.uart.impl.UARTData;
import nl.lxtreme.ols.tool.uart.impl.UARTDataSet;
import nl.lxtreme.ols.util.ExportUtils;
import nl.lxtreme.ols.util.HostUtils;
import nl.lxtreme.ols.util.NumberUtils;
import nl.lxtreme.ols.util.StringUtils;
import nl.lxtreme.ols.util.swing.SpringLayoutUtils;
import nl.lxtreme.ols.util.swing.SwingComponentUtils;
import nl.lxtreme.ols.util.swing.component.EnumItemRenderer;
import org.osgi.framework.BundleContext;

public final class UARTProtocolAnalysisDialog
extends BaseToolDialog<UARTDataSet>
implements ExportAware<UARTDataSet> {
    private static final long serialVersionUID = 1L;
    private static final Logger LOG = Logger.getLogger(UARTProtocolAnalysisDialog.class.getName());
    private JComboBox rxd;
    private JComboBox txd;
    private JComboBox cts;
    private JComboBox rts;
    private JComboBox dtr;
    private JComboBox dsr;
    private JComboBox dcd;
    private JComboBox ri;
    private JComboBox parity;
    private JComboBox bits;
    private JComboBox stop;
    private JComboBox bitEncoding;
    private JComboBox bitOrder;
    private JComboBox idleLevel;
    private JCheckBox autoDetectBaudRate;
    private JComboBox baudrate;
    private JEditorPane outText;
    private ToolUtils.RestorableAction runAnalysisAction;
    private Action closeAction;
    private Action exportAction;

    public UARTProtocolAnalysisDialog(Window aOwner, ToolContext aToolContext, BundleContext aContext, UARTAnalyser aTool) {
        super(aOwner, aToolContext, aContext, (Tool)aTool);
        this.initDialog();
        this.setLocationRelativeTo(this.getOwner());
    }

    public void exportToFile(File aOutputFile, ExportAware.ExportFormat aFormat) throws IOException {
        if (ExportAware.ExportFormat.HTML.equals((Object)aFormat)) {
            this.storeToHtmlFile(aOutputFile, (UARTDataSet)((Object)this.getLastResult()));
        } else if (ExportAware.ExportFormat.CSV.equals((Object)aFormat)) {
            this.storeToCsvFile(aOutputFile, (UARTDataSet)((Object)this.getLastResult()));
        }
    }

    public void readPreferences(UserSettings aSettings) {
        this.setComboBoxIndex(this.rxd, aSettings, "rxd");
        this.setComboBoxIndex(this.txd, aSettings, "txd");
        this.setComboBoxIndex(this.cts, aSettings, "cts");
        this.setComboBoxIndex(this.rts, aSettings, "rts");
        this.setComboBoxIndex(this.dtr, aSettings, "dtr");
        this.setComboBoxIndex(this.dsr, aSettings, "dsr");
        this.setComboBoxIndex(this.dcd, aSettings, "dcd");
        this.setComboBoxIndex(this.ri, aSettings, "ri");
        this.parity.setSelectedIndex(aSettings.getInt("parity", this.parity.getSelectedIndex()));
        this.bits.setSelectedIndex(aSettings.getInt("bits", this.bits.getSelectedIndex()));
        this.stop.setSelectedIndex(aSettings.getInt("stop", this.stop.getSelectedIndex()));
        this.idleLevel.setSelectedIndex(aSettings.getInt("idle-state", this.idleLevel.getSelectedIndex()));
        this.bitEncoding.setSelectedIndex(aSettings.getInt("bit-encoding", this.bitEncoding.getSelectedIndex()));
        this.bitOrder.setSelectedIndex(aSettings.getInt("bit-order", this.bitOrder.getSelectedIndex()));
        this.baudrate.setSelectedItem(aSettings.getInt("baudrate", 9600));
        this.autoDetectBaudRate.setSelected(aSettings.getBoolean("auto-baudrate", this.autoDetectBaudRate.isSelected()));
    }

    public void reset() {
        this.outText.setText(this.getEmptyHtmlPage());
        this.outText.setEditable(false);
        this.runAnalysisAction.restore();
        this.setControlsEnabled(true);
        this.exportAction.setEnabled(false);
    }

    public void writePreferences(UserSettings aSettings) {
        aSettings.putInt("rxd", this.rxd.getSelectedIndex());
        aSettings.putInt("txd", this.txd.getSelectedIndex());
        aSettings.putInt("cts", this.cts.getSelectedIndex());
        aSettings.putInt("rts", this.rts.getSelectedIndex());
        aSettings.putInt("dtr", this.dtr.getSelectedIndex());
        aSettings.putInt("dsr", this.dsr.getSelectedIndex());
        aSettings.putInt("dcd", this.dcd.getSelectedIndex());
        aSettings.putInt("ri", this.ri.getSelectedIndex());
        aSettings.putInt("parity", this.parity.getSelectedIndex());
        aSettings.putInt("bits", this.bits.getSelectedIndex());
        aSettings.putInt("stop", this.stop.getSelectedIndex());
        aSettings.putInt("idle-state", this.idleLevel.getSelectedIndex());
        aSettings.putInt("bit-encoding", this.bitEncoding.getSelectedIndex());
        aSettings.putInt("bit-order", this.bitOrder.getSelectedIndex());
        aSettings.putInt("baudrate", ((Integer)this.baudrate.getSelectedItem()).intValue());
        aSettings.putBoolean("auto-baudrate", this.autoDetectBaudRate.isSelected());
    }

    protected void onToolEnded(UARTDataSet aAnalysisResult) {
        block2: {
            try {
                String htmlPage = aAnalysisResult != null ? this.toHtmlPage(null, aAnalysisResult) : this.getEmptyHtmlPage();
                this.outText.setText(htmlPage);
                this.outText.setEditable(false);
                this.runAnalysisAction.restore();
            }
            catch (IOException exception) {
                if (HostUtils.handleInterruptedException((Throwable)exception)) break block2;
                throw new RuntimeException(exception);
            }
        }
    }

    protected void onToolStarted() {
    }

    protected void prepareToolTask(ToolTask<UARTDataSet> aToolTask) {
        UARTAnalyserTask toolTask = (UARTAnalyserTask)aToolTask;
        toolTask.setRxdIndex(this.rxd.getSelectedIndex() - 1);
        toolTask.setTxdIndex(this.txd.getSelectedIndex() - 1);
        toolTask.setCtsIndex(this.cts.getSelectedIndex() - 1);
        toolTask.setRtsIndex(this.rts.getSelectedIndex() - 1);
        toolTask.setDcdIndex(this.dcd.getSelectedIndex() - 1);
        toolTask.setRiIndex(this.ri.getSelectedIndex() - 1);
        toolTask.setDsrIndex(this.dsr.getSelectedIndex() - 1);
        toolTask.setDtrIndex(this.dtr.getSelectedIndex() - 1);
        if (this.autoDetectBaudRate.isSelected()) {
            toolTask.setBaudRate(-1);
        } else {
            toolTask.setBaudRate((Integer)this.baudrate.getSelectedItem());
        }
        toolTask.setIdleLevel((AsyncSerialDataDecoder.BitLevel)((Object)this.idleLevel.getSelectedItem()));
        toolTask.setBitEncoding((AsyncSerialDataDecoder.BitEncoding)((Object)this.bitEncoding.getSelectedItem()));
        toolTask.setBitOrder((AsyncSerialDataDecoder.BitOrder)((Object)this.bitOrder.getSelectedItem()));
        toolTask.setParity((AsyncSerialDataDecoder.Parity)((Object)this.parity.getSelectedItem()));
        toolTask.setStopBits((AsyncSerialDataDecoder.StopBits)((Object)this.stop.getSelectedItem()));
        toolTask.setBitCount(NumberUtils.smartParseInt((String)((String)this.bits.getSelectedItem()), (int)8));
    }

    protected void setControlsEnabled(boolean aEnable) {
        this.rxd.setEnabled(aEnable);
        this.txd.setEnabled(aEnable);
        this.cts.setEnabled(aEnable);
        this.rts.setEnabled(aEnable);
        this.dtr.setEnabled(aEnable);
        this.dsr.setEnabled(aEnable);
        this.dcd.setEnabled(aEnable);
        this.ri.setEnabled(aEnable);
        this.parity.setEnabled(aEnable);
        this.bits.setEnabled(aEnable);
        this.stop.setEnabled(aEnable);
        this.idleLevel.setEnabled(aEnable);
        this.bitEncoding.setEnabled(aEnable);
        this.bitOrder.setEnabled(aEnable);
        this.closeAction.setEnabled(aEnable);
        this.exportAction.setEnabled(aEnable);
    }

    private ExportUtils.HtmlExporter createHtmlTemplate(ExportUtils.HtmlExporter aExporter) {
        aExporter.addCssStyle("body { font-family: sans-serif; } ");
        aExporter.addCssStyle("table { border-width: 1px; border-spacing: 0px; border-color: gray; border-collapse: collapse; border-style: solid; margin-bottom: 15px; } ");
        aExporter.addCssStyle("table th { border-width: 1px; padding: 2px; border-style: solid; border-color: gray; background-color: #C0C0FF; text-align: left; font-weight: bold; font-family: sans-serif; } ");
        aExporter.addCssStyle("table td { border-width: 1px; padding: 2px; border-style: solid; border-color: gray; font-family: monospace; } ");
        aExporter.addCssStyle(".error { color: red; } ");
        aExporter.addCssStyle(".warning { color: orange; } ");
        aExporter.addCssStyle(".date { text-align: right; font-size: x-small; margin-bottom: 15px; } ");
        aExporter.addCssStyle(".w100 { width: 100%; } ");
        aExporter.addCssStyle(".w35 { width: 35%; } ");
        aExporter.addCssStyle(".w30 { width: 30%; } ");
        aExporter.addCssStyle(".w15 { width: 15%; } ");
        aExporter.addCssStyle(".w10 { width: 10%; } ");
        aExporter.addCssStyle(".w8 { width: 8%; } ");
        aExporter.addCssStyle(".w7 { width: 7%; } ");
        ExportUtils.HtmlExporter.Element body = aExporter.getBody();
        body.addChild(ExportUtils.HtmlExporter.H1).addContent(new String[]{"UART Analysis results"});
        body.addChild(ExportUtils.HtmlExporter.HR);
        body.addChild(ExportUtils.HtmlExporter.DIV).addAttribute("class", "date").addContent(new String[]{"Generated: ", "{date-now}"});
        ExportUtils.HtmlExporter.Element table = body.addChild(ExportUtils.HtmlExporter.TABLE).addAttribute("class", "w100");
        ExportUtils.HtmlExporter.Element tbody = table.addChild(ExportUtils.HtmlExporter.TBODY);
        ExportUtils.HtmlExporter.Element tr = tbody.addChild(ExportUtils.HtmlExporter.TR);
        tr.addChild(ExportUtils.HtmlExporter.TH).addAttribute("colspan", "2").addContent(new String[]{"Statistics"});
        tr = tbody.addChild(ExportUtils.HtmlExporter.TR);
        tr.addChild(ExportUtils.HtmlExporter.TD).addAttribute("class", "w30").addContent(new String[]{"Decoded bytes"});
        tr.addChild(ExportUtils.HtmlExporter.TD).addContent(new String[]{"{decoded-bytes}"});
        tr = tbody.addChild(ExportUtils.HtmlExporter.TR);
        tr.addChild(ExportUtils.HtmlExporter.TD).addAttribute("class", "w30").addContent(new String[]{"Detected bus errors"});
        tr.addChild(ExportUtils.HtmlExporter.TD).addContent(new String[]{"{detected-bus-errors}"});
        tr = tbody.addChild(ExportUtils.HtmlExporter.TR);
        tr.addChild(ExportUtils.HtmlExporter.TD).addAttribute("class", "w30").addContent(new String[]{"Baudrate"});
        tr.addChild(ExportUtils.HtmlExporter.TD).addContent(new String[]{"{baudrate}"});
        table = body.addChild(ExportUtils.HtmlExporter.TABLE).addAttribute("class", "w100");
        ExportUtils.HtmlExporter.Element thead = table.addChild(ExportUtils.HtmlExporter.THEAD);
        tr = thead.addChild(ExportUtils.HtmlExporter.TR);
        tr.addChild(ExportUtils.HtmlExporter.TH).addAttribute("class", "w30").addAttribute("colspan", "2");
        tr.addChild(ExportUtils.HtmlExporter.TH).addAttribute("class", "w35").addAttribute("colspan", "4").addContent(new String[]{"RxD"});
        tr.addChild(ExportUtils.HtmlExporter.TH).addAttribute("class", "w35").addAttribute("colspan", "4").addContent(new String[]{"TxD"});
        tr = thead.addChild(ExportUtils.HtmlExporter.TR);
        tr.addChild(ExportUtils.HtmlExporter.TH).addAttribute("class", "w15").addContent(new String[]{"Index"});
        tr.addChild(ExportUtils.HtmlExporter.TH).addAttribute("class", "w15").addContent(new String[]{"Time"});
        tr.addChild(ExportUtils.HtmlExporter.TH).addAttribute("class", "w10").addContent(new String[]{"Hex"});
        tr.addChild(ExportUtils.HtmlExporter.TH).addAttribute("class", "w10").addContent(new String[]{"Bin"});
        tr.addChild(ExportUtils.HtmlExporter.TH).addAttribute("class", "w8").addContent(new String[]{"Dec"});
        tr.addChild(ExportUtils.HtmlExporter.TH).addAttribute("class", "w7").addContent(new String[]{"ASCII"});
        tr.addChild(ExportUtils.HtmlExporter.TH).addAttribute("class", "w10").addContent(new String[]{"Hex"});
        tr.addChild(ExportUtils.HtmlExporter.TH).addAttribute("class", "w10").addContent(new String[]{"Bin"});
        tr.addChild(ExportUtils.HtmlExporter.TH).addAttribute("class", "w8").addContent(new String[]{"Dec"});
        tr.addChild(ExportUtils.HtmlExporter.TH).addAttribute("class", "w7").addContent(new String[]{"ASCII"});
        tbody = table.addChild(ExportUtils.HtmlExporter.TBODY);
        tbody.addContent(new String[]{"{decoded-data}"});
        return aExporter;
    }

    private JPanel createPreviewPane() {
        JPanel panTable = new JPanel(new GridLayout(1, 1, 0, 0));
        this.outText = new JEditorPane("text/html", this.getEmptyHtmlPage());
        this.outText.setEditable(false);
        panTable.add(new JScrollPane(this.outText));
        return panTable;
    }

    private JPanel createSettingsPane() {
        int channelCount = this.getData().getChannels();
        Integer[] baudrates = new Integer[AsyncSerialDataDecoder.COMMON_BAUDRATES.length];
        for (int i = 0; i < baudrates.length; ++i) {
            baudrates[i] = AsyncSerialDataDecoder.COMMON_BAUDRATES[i];
        }
        String[] bitarray = new String[10];
        for (int i = 0; i < bitarray.length; ++i) {
            bitarray[i] = String.format("%d", i + 5);
        }
        JPanel settings = new JPanel(new SpringLayout());
        SpringLayoutUtils.addSeparator((Container)settings, (String)"Settings");
        settings.add(SwingComponentUtils.createRightAlignedLabel((String)"RxD"));
        this.rxd = SwingComponentUtils.createOptionalChannelSelector((int)channelCount);
        settings.add(this.rxd);
        settings.add(SwingComponentUtils.createRightAlignedLabel((String)"TxD"));
        this.txd = SwingComponentUtils.createOptionalChannelSelector((int)channelCount);
        settings.add(this.txd);
        settings.add(SwingComponentUtils.createRightAlignedLabel((String)"CTS"));
        this.cts = SwingComponentUtils.createOptionalChannelSelector((int)channelCount);
        settings.add(this.cts);
        settings.add(SwingComponentUtils.createRightAlignedLabel((String)"RTS"));
        this.rts = SwingComponentUtils.createOptionalChannelSelector((int)channelCount);
        settings.add(this.rts);
        settings.add(SwingComponentUtils.createRightAlignedLabel((String)"DTR"));
        this.dtr = SwingComponentUtils.createOptionalChannelSelector((int)channelCount);
        settings.add(this.dtr);
        settings.add(SwingComponentUtils.createRightAlignedLabel((String)"DSR"));
        this.dsr = SwingComponentUtils.createOptionalChannelSelector((int)channelCount);
        settings.add(this.dsr);
        settings.add(SwingComponentUtils.createRightAlignedLabel((String)"DCD"));
        this.dcd = SwingComponentUtils.createOptionalChannelSelector((int)channelCount);
        settings.add(this.dcd);
        settings.add(SwingComponentUtils.createRightAlignedLabel((String)"RI"));
        this.ri = SwingComponentUtils.createOptionalChannelSelector((int)channelCount);
        settings.add(this.ri);
        settings.add(SwingComponentUtils.createRightAlignedLabel((String)"Baudrate"));
        this.autoDetectBaudRate = new JCheckBox("Auto detect");
        settings.add(this.autoDetectBaudRate);
        settings.add(new JLabel(""));
        this.baudrate = new JComboBox<Integer>(baudrates);
        this.baudrate.setEditable(true);
        this.baudrate.setSelectedIndex(0);
        settings.add(this.baudrate);
        this.autoDetectBaudRate.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent aEvent) {
                JCheckBox cb = (JCheckBox)aEvent.getSource();
                UARTProtocolAnalysisDialog.this.baudrate.setEnabled(!cb.isSelected());
            }
        });
        settings.add(SwingComponentUtils.createRightAlignedLabel((String)"Parity"));
        this.parity = new JComboBox<AsyncSerialDataDecoder.Parity>(AsyncSerialDataDecoder.Parity.values());
        this.parity.setSelectedIndex(0);
        this.parity.setRenderer(new UARTParityItemRenderer());
        settings.add(this.parity);
        settings.add(SwingComponentUtils.createRightAlignedLabel((String)"Bits"));
        this.bits = new JComboBox<String>(bitarray);
        this.bits.setSelectedIndex(3);
        settings.add(this.bits);
        settings.add(SwingComponentUtils.createRightAlignedLabel((String)"Stopbits"));
        this.stop = new JComboBox<AsyncSerialDataDecoder.StopBits>(AsyncSerialDataDecoder.StopBits.values());
        this.stop.setSelectedIndex(0);
        this.stop.setRenderer(new UARTStopBitsItemRenderer());
        settings.add(this.stop);
        settings.add(SwingComponentUtils.createRightAlignedLabel((String)"Idle level"));
        this.idleLevel = new JComboBox<AsyncSerialDataDecoder.BitLevel>(AsyncSerialDataDecoder.BitLevel.values());
        this.idleLevel.setSelectedIndex(0);
        this.idleLevel.setRenderer(new UARTIdleLevelItemRenderer());
        settings.add(this.idleLevel);
        settings.add(SwingComponentUtils.createRightAlignedLabel((String)"Bit encoding"));
        this.bitEncoding = new JComboBox<AsyncSerialDataDecoder.BitEncoding>(AsyncSerialDataDecoder.BitEncoding.values());
        this.bitEncoding.setSelectedIndex(0);
        this.bitEncoding.setRenderer(new UARTBitEncodingItemRenderer());
        settings.add(this.bitEncoding);
        settings.add(SwingComponentUtils.createRightAlignedLabel((String)"Bit order"));
        this.bitOrder = new JComboBox<AsyncSerialDataDecoder.BitOrder>(AsyncSerialDataDecoder.BitOrder.values());
        this.bitOrder.setSelectedIndex(0);
        this.bitOrder.setRenderer(new UARTBitOrderItemRenderer());
        settings.add(this.bitOrder);
        SpringLayoutUtils.makeEditorGrid((Container)settings, (int)10, (int)4);
        return settings;
    }

    private String getEmptyHtmlPage() {
        ExportUtils.HtmlExporter exporter = this.createHtmlTemplate(ExportUtils.createHtmlExporter());
        return exporter.toString(new ExportUtils.HtmlExporter.MacroResolver(){

            public Object resolve(String aMacro, ExportUtils.HtmlExporter.Element aParent) {
                if ("date-now".equals(aMacro)) {
                    DateFormat df = DateFormat.getDateInstance(1);
                    return df.format(new Date());
                }
                if ("decoded-bytes".equals(aMacro) || "detected-bus-errors".equals(aMacro) || "baudrate".equals(aMacro)) {
                    return "-";
                }
                if ("decoded-data".equals(aMacro)) {
                    return null;
                }
                return null;
            }
        });
    }

    private void initDialog() {
        this.setMinimumSize(new Dimension(640, 480));
        JPanel settingsPane = this.createSettingsPane();
        JPanel previewPane = this.createPreviewPane();
        JPanel contentPane = new JPanel(new GridBagLayout());
        contentPane.add((Component)settingsPane, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 11, 0, new Insets(2, 0, 2, 0), 0, 0));
        contentPane.add((Component)previewPane, new GridBagConstraints(1, 0, 1, 1, 1.0, 1.0, 11, 1, new Insets(2, 0, 2, 0), 0, 0));
        JButton runAnalysisButton = ToolUtils.createRunAnalysisButton((ToolDialog)this);
        this.runAnalysisAction = (ToolUtils.RestorableAction)runAnalysisButton.getAction();
        JButton exportButton = ToolUtils.createExportButton((ExportAware)this);
        this.exportAction = exportButton.getAction();
        this.exportAction.setEnabled(false);
        JButton closeButton = ToolUtils.createCloseButton();
        this.closeAction = closeButton.getAction();
        JComponent buttons = SwingComponentUtils.createButtonPane((JButton[])new JButton[]{runAnalysisButton, exportButton, closeButton});
        SwingComponentUtils.setupWindowContentPane((Window)((Object)this), (Component)contentPane, (Component)buttons, (JButton)runAnalysisButton);
    }

    private void storeToCsvFile(File aFile, UARTDataSet aDataSet) {
        block10: {
            try {
                ExportUtils.CsvExporter exporter = ExportUtils.createCsvExporter((File)aFile);
                exporter.setHeaders(new String[]{"index", "start-time", "end-time", "event?", "event-type", "RxD event", "TxD event", "RxD data", "TxD data"});
                List decodedData = aDataSet.getData();
                for (int i = 0; i < decodedData.size(); ++i) {
                    UARTData ds = (UARTData)((Object)decodedData.get(i));
                    String startTime = Unit.Time.format((double)aDataSet.getTime(ds.getStartSampleIndex()));
                    String endTime = Unit.Time.format((double)aDataSet.getTime(ds.getEndSampleIndex()));
                    String eventType = null;
                    String rxdEvent = null;
                    String txdEvent = null;
                    String rxdData = null;
                    String txdData = null;
                    switch (ds.getType()) {
                        case 0: {
                            eventType = ds.getEventName();
                            break;
                        }
                        case 1: {
                            rxdEvent = ds.getEventName();
                            break;
                        }
                        case 2: {
                            txdEvent = ds.getEventName();
                            break;
                        }
                        case 3: {
                            rxdData = Integer.toString(ds.getData());
                            break;
                        }
                        case 4: {
                            txdData = Integer.toString(ds.getData());
                            break;
                        }
                    }
                    exporter.addRow(new Object[]{i, startTime, endTime, ds.isEvent(), eventType, rxdEvent, txdEvent, rxdData, txdData});
                }
                exporter.close();
            }
            catch (IOException exception) {
                if (HostUtils.handleInterruptedException((Throwable)exception)) break block10;
                LOG.log(Level.WARNING, "CSV export failed!", exception);
            }
        }
    }

    private void storeToHtmlFile(File aFile, UARTDataSet aDataSet) {
        block2: {
            try {
                this.toHtmlPage(aFile, aDataSet);
            }
            catch (IOException exception) {
                if (HostUtils.handleInterruptedException((Throwable)exception)) break block2;
                LOG.log(Level.WARNING, "HTML export failed!", exception);
            }
        }
    }

    private String toHtmlPage(File aFile, final UARTDataSet aDataSet) throws IOException {
        final int bitCount = Integer.parseInt((String)this.bits.getSelectedItem());
        final int bitAdder = bitCount % 4 != 0 ? 1 : 0;
        ExportUtils.HtmlExporter.MacroResolver macroResolver = new ExportUtils.HtmlExporter.MacroResolver(){

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public Object resolve(String aMacro, ExportUtils.HtmlExporter.Element aParent) {
                if ("date-now".equals(aMacro)) {
                    DateFormat df = DateFormat.getDateInstance(1);
                    return df.format(new Date());
                }
                if ("decoded-bytes".equals(aMacro)) {
                    return aDataSet.getDecodedSymbols();
                }
                if ("detected-bus-errors".equals(aMacro)) {
                    return aDataSet.getDetectedErrors();
                }
                if ("baudrate".equals(aMacro)) {
                    if (aDataSet.getBaudRate() <= 0) {
                        return null;
                    }
                    String baudrate = String.format("%d (exact: %d)", aDataSet.getBaudRate(), aDataSet.getBaudRateExact());
                    if (aDataSet.isBitLengthUsable()) return baudrate;
                    return baudrate.concat(" <span class='warning'>The baudrate may be wrong, use a higher samplerate to avoid this!</span>");
                }
                if (!"decoded-data".equals(aMacro)) return null;
                List decodedData = aDataSet.getData();
                for (int i = 0; i < decodedData.size(); ++i) {
                    ExportUtils.HtmlExporter.Element tr;
                    UARTData ds = (UARTData)((Object)decodedData.get(i));
                    if (ds.isEvent()) {
                        String bgColor;
                        String rxEventData = "";
                        String txEventData = "";
                        if (0 == ds.getType()) {
                            rxEventData = txEventData = ds.getEventName();
                            bgColor = "#e0e0e0";
                        } else if (1 == ds.getType()) {
                            rxEventData = ds.getEventName();
                            bgColor = "#c0ffc0";
                        } else if (2 == ds.getType()) {
                            txEventData = ds.getEventName();
                            bgColor = "#c0ffc0";
                        } else {
                            bgColor = "#ff8000";
                        }
                        if (txEventData.endsWith("_ERR") || rxEventData.endsWith("_ERR")) {
                            bgColor = "#ff8000";
                        }
                        tr = aParent.addChild(ExportUtils.HtmlExporter.TR).addAttribute("style", "background-color: " + bgColor + ";");
                        tr.addChild(ExportUtils.HtmlExporter.TD).addContent(new String[]{String.valueOf(i)});
                        tr.addChild(ExportUtils.HtmlExporter.TD).addContent(new String[]{Unit.Time.format((double)aDataSet.getTime(ds.getStartSampleIndex()))});
                        tr.addChild(ExportUtils.HtmlExporter.TD).addContent(new String[]{rxEventData});
                        tr.addChild(ExportUtils.HtmlExporter.TD);
                        tr.addChild(ExportUtils.HtmlExporter.TD);
                        tr.addChild(ExportUtils.HtmlExporter.TD);
                        tr.addChild(ExportUtils.HtmlExporter.TD).addContent(new String[]{txEventData});
                        tr.addChild(ExportUtils.HtmlExporter.TD);
                        tr.addChild(ExportUtils.HtmlExporter.TD);
                        tr.addChild(ExportUtils.HtmlExporter.TD);
                        continue;
                    }
                    String rxDataHex = "";
                    String rxDataBin = "";
                    String rxDataDec = "";
                    String rxDataASCII = "";
                    String txDataHex = "";
                    String txDataBin = "";
                    String txDataDec = "";
                    String txDataASCII = "";
                    if (3 == ds.getType()) {
                        int rxData = ds.getData();
                        rxDataHex = "0x" + StringUtils.integerToHexString((int)rxData, (int)(bitCount / 4 + bitAdder));
                        rxDataBin = "0b" + StringUtils.integerToBinString((int)rxData, (int)bitCount);
                        rxDataDec = String.valueOf(rxData);
                        if (this.isPrintableCharacter(rxData)) {
                            rxDataASCII = String.valueOf((char)rxData);
                        }
                    } else {
                        int txData = ds.getData();
                        txDataHex = "0x" + StringUtils.integerToHexString((int)txData, (int)(bitCount / 4 + bitAdder));
                        txDataBin = "0b" + StringUtils.integerToBinString((int)txData, (int)bitCount);
                        txDataDec = String.valueOf(txData);
                        if (this.isPrintableCharacter(txData)) {
                            txDataASCII = String.valueOf((char)txData);
                        }
                    }
                    tr = aParent.addChild(ExportUtils.HtmlExporter.TR);
                    tr.addChild(ExportUtils.HtmlExporter.TD).addContent(new String[]{String.valueOf(i)});
                    tr.addChild(ExportUtils.HtmlExporter.TD).addContent(new String[]{Unit.Time.format((double)aDataSet.getTime(ds.getStartSampleIndex()))});
                    tr.addChild(ExportUtils.HtmlExporter.TD).addContent(new String[]{rxDataHex});
                    tr.addChild(ExportUtils.HtmlExporter.TD).addContent(new String[]{rxDataBin});
                    tr.addChild(ExportUtils.HtmlExporter.TD).addContent(new String[]{rxDataDec});
                    tr.addChild(ExportUtils.HtmlExporter.TD).addContent(new String[]{rxDataASCII});
                    tr.addChild(ExportUtils.HtmlExporter.TD).addContent(new String[]{txDataHex});
                    tr.addChild(ExportUtils.HtmlExporter.TD).addContent(new String[]{txDataBin});
                    tr.addChild(ExportUtils.HtmlExporter.TD).addContent(new String[]{txDataDec});
                    tr.addChild(ExportUtils.HtmlExporter.TD).addContent(new String[]{txDataASCII});
                }
                return null;
            }

            private boolean isPrintableCharacter(int aValue) {
                boolean withinRange = aValue >= 32 && aValue < 255;
                return withinRange;
            }
        };
        if (aFile == null) {
            ExportUtils.HtmlExporter exporter = this.createHtmlTemplate(ExportUtils.createHtmlExporter());
            return exporter.toString(macroResolver);
        }
        ExportUtils.HtmlFileExporter exporter = (ExportUtils.HtmlFileExporter)this.createHtmlTemplate((ExportUtils.HtmlExporter)ExportUtils.createHtmlExporter((File)aFile));
        exporter.write(macroResolver);
        exporter.close();
        return null;
    }

    static final class UARTIdleLevelItemRenderer
    extends EnumItemRenderer<AsyncSerialDataDecoder.BitLevel> {
        private static final long serialVersionUID = 1L;

        UARTIdleLevelItemRenderer() {
        }

        protected String getDisplayValue(AsyncSerialDataDecoder.BitLevel aValue) {
            String text = super.getDisplayValue((Enum)aValue);
            if (AsyncSerialDataDecoder.BitLevel.HIGH.equals((Object)aValue)) {
                text = "High (start = L, stop = H)";
            } else if (AsyncSerialDataDecoder.BitLevel.LOW.equals((Object)aValue)) {
                text = "Low (start = H, stop = L)";
            }
            return text;
        }
    }

    static final class UARTBitEncodingItemRenderer
    extends EnumItemRenderer<AsyncSerialDataDecoder.BitEncoding> {
        private static final long serialVersionUID = 1L;

        UARTBitEncodingItemRenderer() {
        }

        protected String getDisplayValue(AsyncSerialDataDecoder.BitEncoding aValue) {
            String text = super.getDisplayValue((Enum)aValue);
            if (AsyncSerialDataDecoder.BitEncoding.HIGH_IS_MARK.equals((Object)aValue)) {
                text = "High is mark (1)";
            } else if (AsyncSerialDataDecoder.BitEncoding.HIGH_IS_SPACE.equals((Object)aValue)) {
                text = "High is space (0)";
            }
            return text;
        }
    }

    static final class UARTBitOrderItemRenderer
    extends EnumItemRenderer<AsyncSerialDataDecoder.BitOrder> {
        private static final long serialVersionUID = 1L;

        UARTBitOrderItemRenderer() {
        }

        protected String getDisplayValue(AsyncSerialDataDecoder.BitOrder aValue) {
            String text = super.getDisplayValue((Enum)aValue);
            if (AsyncSerialDataDecoder.BitOrder.LSB_FIRST.equals((Object)aValue)) {
                text = "LSB first";
            } else if (AsyncSerialDataDecoder.BitOrder.MSB_FIRST.equals((Object)aValue)) {
                text = "MSB first";
            }
            return text;
        }
    }

    static final class UARTStopBitsItemRenderer
    extends EnumItemRenderer<AsyncSerialDataDecoder.StopBits> {
        private static final long serialVersionUID = 1L;

        UARTStopBitsItemRenderer() {
        }

        protected String getDisplayValue(AsyncSerialDataDecoder.StopBits aValue) {
            String text = super.getDisplayValue((Enum)aValue);
            if (AsyncSerialDataDecoder.StopBits.ONE.equals((Object)aValue)) {
                text = "1";
            } else if (AsyncSerialDataDecoder.StopBits.ONE_HALF.equals((Object)aValue)) {
                text = "1.5";
            } else if (AsyncSerialDataDecoder.StopBits.TWO.equals((Object)aValue)) {
                text = "2";
            }
            return text;
        }
    }

    static final class UARTParityItemRenderer
    extends EnumItemRenderer<AsyncSerialDataDecoder.Parity> {
        private static final long serialVersionUID = 1L;

        UARTParityItemRenderer() {
        }

        protected String getDisplayValue(AsyncSerialDataDecoder.Parity aValue) {
            String text = super.getDisplayValue((Enum)aValue);
            if (AsyncSerialDataDecoder.Parity.EVEN.equals((Object)aValue)) {
                text = "Even parity";
            } else if (AsyncSerialDataDecoder.Parity.NONE.equals((Object)aValue)) {
                text = "No parity";
            } else if (AsyncSerialDataDecoder.Parity.ODD.equals((Object)aValue)) {
                text = "Odd parity";
            }
            return text;
        }
    }
}

