/*
 * Decompiled with CFR 0.152.
 */
package nl.lxtreme.ols.config.provision.impl;

import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import nl.lxtreme.ols.config.provision.impl.ConfigFileResource;
import nl.lxtreme.ols.config.provision.impl.ConfiguratorImpl;
import org.osgi.service.cm.Configuration;

public class ConfigFileRepository {
    private final Map<String, ResourceInfo> mapping = new HashMap<String, ResourceInfo>();

    public boolean add(Configuration configuration, ConfigFileResource resource) {
        String id = this.createIdentity(resource);
        String pid = configuration.getPid();
        if (this.isNewOrChanged(resource)) {
            this.mapping.put(pid, new ResourceInfo(id, resource.getLastModified()));
            return true;
        }
        return false;
    }

    public String getConfigurationPid(ConfigFileResource resource) {
        String id = this.createIdentity(resource);
        for (Map.Entry<String, ResourceInfo> entry : this.mapping.entrySet()) {
            if (!id.equals(entry.getValue().id)) continue;
            return entry.getKey();
        }
        return null;
    }

    public boolean isEmpty() {
        return this.mapping.isEmpty();
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void load(File repoFile) throws IOException {
        FileInputStream fis = null;
        ObjectInputStream ois = null;
        try {
            fis = new FileInputStream(repoFile);
            ois = new ObjectInputStream(fis);
            this.mapping.putAll((Map)ois.readObject());
        }
        catch (EOFException exception) {
            ConfiguratorImpl.closeQuietly(ois);
            ConfiguratorImpl.closeQuietly(fis);
            return;
            catch (FileNotFoundException exception2) {
                ConfiguratorImpl.closeQuietly(ois);
                ConfiguratorImpl.closeQuietly(fis);
                return;
                catch (Exception exception3) {
                    try {
                        throw new IOException("Invalid repository data?!", exception3);
                    }
                    catch (Throwable throwable) {
                        ConfiguratorImpl.closeQuietly(ois);
                        ConfiguratorImpl.closeQuietly(fis);
                        throw throwable;
                    }
                }
            }
        }
        ConfiguratorImpl.closeQuietly(ois);
        ConfiguratorImpl.closeQuietly(fis);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void store(File repoFile) throws IOException {
        FileOutputStream fos = null;
        ObjectOutputStream oos = null;
        try {
            fos = new FileOutputStream(repoFile);
            oos = new ObjectOutputStream(fos);
            oos.writeObject(this.mapping);
        }
        catch (Throwable throwable) {
            ConfiguratorImpl.closeQuietly(oos);
            ConfiguratorImpl.closeQuietly(fos);
            throw throwable;
        }
        ConfiguratorImpl.closeQuietly(oos);
        ConfiguratorImpl.closeQuietly(fos);
    }

    private String createIdentity(ConfigFileResource resource) {
        String factoryPid = resource.getFactoryPid();
        if (factoryPid != null) {
            return String.format("%s-%s", factoryPid, resource.getPid());
        }
        return resource.getPid();
    }

    private boolean isNewOrChanged(ConfigFileResource resource) {
        String pid = resource.getPid();
        ResourceInfo info = this.mapping.get(pid);
        return info == null || info.lastModified != resource.getLastModified();
    }

    static class ResourceInfo
    implements Serializable {
        private static final long serialVersionUID = 1L;
        final String id;
        final long lastModified;

        public ResourceInfo(String id, long lastModified) {
            this.id = id;
            this.lastModified = lastModified;
        }
    }
}

