/*
 * Decompiled with CFR 0.152.
 */
package nl.lxtreme.ols.config.provision.impl;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Dictionary;
import java.util.Hashtable;
import java.util.Properties;
import nl.lxtreme.ols.config.provision.impl.ConfiguratorImpl;

public class ConfigFileResource {
    private final File resource;
    private final String factoryPid;
    private final String pid;
    private final Dictionary<String, Object> config;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ConfigFileResource(File aResource) throws IOException {
        this.resource = aResource;
        FileInputStream fis = null;
        try {
            fis = new FileInputStream(aResource);
            Properties props = new Properties();
            props.load(fis);
            String name = ConfigFileResource.stripFileExtension(aResource.getName());
            int idx = name.indexOf(45);
            if (idx >= 0) {
                this.factoryPid = name.substring(0, idx);
                this.pid = name.substring(idx + 1);
            } else {
                this.factoryPid = null;
                this.pid = name;
            }
            Hashtable<String, Object> dict = new Hashtable<String, Object>(props.size());
            for (Object key : props.keySet()) {
                ((Dictionary)dict).put((String)key, ConfigFileResource.getValue(props, (String)key));
            }
            this.config = dict;
        }
        catch (Throwable throwable) {
            ConfiguratorImpl.closeQuietly(fis);
            throw throwable;
        }
        ConfiguratorImpl.closeQuietly(fis);
    }

    static Object getValue(Properties properties, String key) {
        String ref;
        Object val = properties.get(key);
        if (val instanceof String && (ref = (String)val).startsWith("${") && ref.endsWith("}")) {
            return ConfigFileResource.getValue(properties, ref.substring(2, ref.length() - 1));
        }
        return val;
    }

    static boolean isEmtpy(String str) {
        return str == null || "".equals(str.trim());
    }

    static String stripFileExtension(String str) {
        String part;
        if (ConfigFileResource.isEmtpy(str)) {
            return "";
        }
        int idx = str.lastIndexOf(46);
        if (idx >= 0 && "cfg".equals(part = str.substring(idx + 1))) {
            return str.substring(0, idx);
        }
        return str;
    }

    public Dictionary<String, ?> getConfiguration() {
        return this.config;
    }

    public String getFactoryPid() {
        return this.factoryPid;
    }

    public String getId() {
        String id = this.getFactoryPid();
        if (ConfigFileResource.isEmtpy(id)) {
            id = this.getPid();
        }
        return id;
    }

    public long getLastModified() {
        return this.resource.lastModified();
    }

    public String getPid() {
        return this.pid;
    }

    public boolean isFactoryConfig() {
        return !ConfigFileResource.isEmtpy(this.factoryPid);
    }
}

