/*
 * Decompiled with CFR 0.152.
 */
package nl.lxtreme.ols.config.provision.impl;

import java.io.Closeable;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.util.Dictionary;
import nl.lxtreme.ols.config.provision.Configurator;
import nl.lxtreme.ols.config.provision.impl.ConfigFileRepository;
import nl.lxtreme.ols.config.provision.impl.ConfigFileResource;
import org.apache.felix.dm.Component;
import org.osgi.framework.BundleContext;
import org.osgi.service.cm.Configuration;
import org.osgi.service.cm.ConfigurationAdmin;
import org.osgi.service.log.LogService;

public class ConfiguratorImpl
implements Configurator {
    public static final String KEY_CONFIG_DIR = "nl.lxtreme.ols.config.dir";
    private volatile ConfigurationAdmin configAdmin;
    private volatile LogService log;
    private final ConfigFileRepository repository = new ConfigFileRepository();

    static void closeQuietly(Closeable aResource) {
        try {
            if (aResource != null) {
                aResource.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Override
    public boolean provision(File file) throws IOException {
        this.log.log(3, "Installing configuration from \"" + file.getName() + "\"...");
        ConfigFileResource resource = new ConfigFileResource(file);
        this.log.log(3, "Provisioning configuration \"" + resource.getId() + "\"...");
        return this.provision(resource);
    }

    @Override
    public void provisionAll(File dir) throws IOException {
        File[] files;
        Exception firstException = null;
        for (File file : files = this.listConfigurations(dir)) {
            try {
                this.provision(file);
            }
            catch (Exception exception) {
                if (firstException == null) {
                    firstException = exception;
                }
                this.log.log(2, "Failed to provision \"" + file.getName() + "\" as configuration...", (Throwable)exception);
            }
        }
        if (firstException instanceof RuntimeException) {
            throw (RuntimeException)firstException;
        }
        if (firstException instanceof IOException) {
            throw (IOException)firstException;
        }
        if (firstException != null) {
            throw new RuntimeException("Failed to provision configuration!", firstException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void start(Component component) throws IOException {
        BundleContext context = component.getDependencyManager().getBundleContext();
        File configDir = this.getConfigDirectory(context);
        File repositoryFile = this.getRepositoryFile(context);
        this.repository.load(repositoryFile);
        try {
            this.provisionAll(configDir);
        }
        finally {
            this.repository.store(repositoryFile);
        }
    }

    protected void stop(Component component) throws IOException {
        BundleContext context = component.getDependencyManager().getBundleContext();
        File repositoryFile = this.getRepositoryFile(context);
        this.repository.store(repositoryFile);
    }

    protected void setConfigurationAdmin(ConfigurationAdmin configAdmin) {
        this.configAdmin = configAdmin;
    }

    protected void setLogService(LogService log) {
        this.log = log;
    }

    private File getConfigDirectory(BundleContext context) throws IOException {
        String dir = context.getProperty(KEY_CONFIG_DIR);
        if (dir == null) {
            throw new IOException("No configuration directory set! Use property nl.lxtreme.ols.config.dir for that!");
        }
        return new File(dir);
    }

    private File getRepositoryFile(BundleContext context) throws IOException {
        File dataArea = context.getDataFile("");
        if (dataArea == null) {
            throw new IOException("No peristent storage supported...");
        }
        return new File(dataArea, "configs.repo");
    }

    private File[] listConfigurations(File dir) throws IOException {
        if (!dir.exists()) {
            this.log.log(2, "Configuration directory \"" + dir + "\" does not exist!");
            return new File[0];
        }
        return dir.listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return name.endsWith(".cfg");
            }
        });
    }

    private boolean provision(ConfigFileResource resource) throws IOException {
        Configuration configuration;
        Dictionary<String, ?> props = resource.getConfiguration();
        String pid = resource.getPid();
        String factoryPID = resource.getFactoryPid();
        if (resource.isFactoryConfig()) {
            String generatedPid = this.repository.getConfigurationPid(resource);
            if (generatedPid == null) {
                this.log.log(4, "Creating new configuration for \"" + factoryPID + "\" (not found in repository)...");
                configuration = this.configAdmin.createFactoryConfiguration(factoryPID, null);
            } else {
                this.log.log(4, "Obtaining configuration for \"" + generatedPid + "\" (found in repository)...");
                configuration = this.configAdmin.getConfiguration(generatedPid, null);
            }
        } else {
            this.log.log(4, "Obtaining configuration for \"" + pid + "\" (maybe found in repository)...");
            configuration = this.configAdmin.getConfiguration(pid, null);
        }
        if (configuration != null && this.repository.add(configuration, resource)) {
            this.log.log(3, "Provisioned new configuration: " + resource.getId());
            configuration.update(props);
            return true;
        }
        return false;
    }
}

