/*
 * Decompiled with CFR 0.152.
 */
package nl.lxtreme.ols.tool.dmx512;

import nl.lxtreme.ols.api.acquisition.AcquisitionResult;
import nl.lxtreme.ols.api.data.annotation.Annotation;
import nl.lxtreme.ols.api.data.annotation.AnnotationListener;
import nl.lxtreme.ols.api.tools.ToolContext;
import nl.lxtreme.ols.api.tools.ToolProgressListener;
import nl.lxtreme.ols.api.tools.ToolTask;
import nl.lxtreme.ols.tool.base.annotation.ChannelLabelAnnotation;
import nl.lxtreme.ols.tool.base.annotation.SampleDataAnnotation;
import nl.lxtreme.ols.tool.dmx512.DMX512DataSet;
import nl.lxtreme.ols.tool.dmx512.DMX512SerialDataDecoder;
import nl.lxtreme.ols.tool.uart.AsyncSerialDataDecoder;

public class DMX512AnalyzerTask
implements ToolTask<DMX512DataSet> {
    private static final String DMX512_DATA_LABEL = "DMX512 data";
    private static final int BAUDRATE = 250000;
    private static final int DATABITS = 8;
    private static final AsyncSerialDataDecoder.Parity PARITY = AsyncSerialDataDecoder.Parity.NONE;
    private static final AsyncSerialDataDecoder.StopBits STOPBITS = AsyncSerialDataDecoder.StopBits.TWO;
    private final ToolContext context;
    private final ToolProgressListener progressListener;
    private final AnnotationListener annotationListener;
    private int dataLine;

    public DMX512AnalyzerTask(ToolContext aContext, ToolProgressListener aProgressListener, AnnotationListener aAnnotationListener) {
        this.context = aContext;
        this.progressListener = aProgressListener;
        this.annotationListener = aAnnotationListener;
        this.dataLine = -1;
    }

    public DMX512DataSet call() throws Exception {
        final AcquisitionResult data = this.context.getData();
        int[] values = data.getValues();
        int startOfDecode = this.context.getStartSampleIndex();
        int endOfDecode = this.context.getEndSampleIndex();
        int mask = 1 << this.dataLine;
        int value = values[startOfDecode] & mask;
        for (int i = startOfDecode + 1; i < endOfDecode; ++i) {
            if (value == (values[i] & mask)) continue;
            startOfDecode = i;
            break;
        }
        if ((startOfDecode = Math.max(0, startOfDecode - 10)) >= endOfDecode) {
            throw new IllegalStateException("No valid data range found for DMX512 analysis!");
        }
        final DMX512DataSet dataSet = new DMX512DataSet(startOfDecode, endOfDecode, data);
        this.annotationListener.clearAnnotations(this.dataLine);
        this.annotationListener.onAnnotation((Annotation)new ChannelLabelAnnotation(this.dataLine, DMX512_DATA_LABEL));
        AsyncSerialDataDecoder.SerialConfiguration config = new AsyncSerialDataDecoder.SerialConfiguration(250000, 8, STOPBITS, PARITY, AsyncSerialDataDecoder.BitEncoding.HIGH_IS_MARK, AsyncSerialDataDecoder.BitOrder.MSB_FIRST, AsyncSerialDataDecoder.BitLevel.HIGH);
        DMX512SerialDataDecoder decoder = new DMX512SerialDataDecoder(config, this.context);
        decoder.setProgressListener(this.progressListener);
        decoder.setCallback(new AsyncSerialDataDecoder.SerialDecoderCallback(){

            public void onError(int aChannelIdx, AsyncSerialDataDecoder.ErrorType aType, long aTime) {
                dataSet.reportError(aChannelIdx, aType, data.getSampleIndex(aTime));
            }

            public void onEvent(int aChannelIdx, String aEvent, long aStartTime, long aEndTime) {
                dataSet.reportEvent(aChannelIdx, aEvent, data.getSampleIndex(aStartTime), data.getSampleIndex(aEndTime));
                this.addEventAnnotation(aChannelIdx, aEvent, aStartTime, aEndTime);
            }

            public void onSymbol(int aChannelIdx, int aSymbol, long aStartTime, long aEndTime) {
                dataSet.reportData(aChannelIdx, data.getSampleIndex(aStartTime), data.getSampleIndex(aEndTime), aSymbol);
                this.addSymbolAnnotation(aChannelIdx, aSymbol, aStartTime, aEndTime);
            }

            private void addEventAnnotation(int aChannelIdx, String aEvent, long aStartTimestamp, long aEndTimestamp) {
                DMX512AnalyzerTask.this.annotationListener.onAnnotation((Annotation)new SampleDataAnnotation(aChannelIdx, aStartTimestamp, aEndTimestamp, aEvent));
            }

            private void addSymbolAnnotation(int aChannelIdx, int aSymbol, long aStartTimestamp, long aEndTimestamp) {
                DMX512AnalyzerTask.this.annotationListener.onAnnotation((Annotation)new SampleDataAnnotation(aChannelIdx, aStartTimestamp, aEndTimestamp, String.format("0x%1$X (%1$c)", aSymbol)));
            }
        });
        decoder.decodeDataLine(this.dataLine);
        return dataSet;
    }

    public int getDataLine() {
        return this.dataLine;
    }

    public void setDataLine(int aDataLine) {
        this.dataLine = aDataLine;
    }
}

