/*
 * Decompiled with CFR 0.152.
 */
package nl.lxtreme.ols.tool.dmx512;

import nl.lxtreme.ols.api.data.Edge;
import nl.lxtreme.ols.api.tools.ToolContext;
import nl.lxtreme.ols.tool.uart.AsyncSerialDataDecoder;

public class DMX512SerialDataDecoder
extends AsyncSerialDataDecoder {
    public DMX512SerialDataDecoder(AsyncSerialDataDecoder.SerialConfiguration aConfiguration, ToolContext aContext) {
        super(aConfiguration, aContext);
    }

    protected long findStartBit(int aChannelIdx, Edge aEdge, long aStartOfDecode, long aEndOfDecode) {
        int sampleRate = this.dataSet.getSampleRate();
        long time = super.findEdge(aChannelIdx, aEdge, aStartOfDecode, aEndOfDecode);
        if (time < 0L) {
            return time;
        }
        long time2 = super.findEdge(aChannelIdx, aEdge.invert(), time, aEndOfDecode);
        if (time2 - time > (long)this.configuration.getFrameSize(sampleRate)) {
            long time3 = super.findEdge(aChannelIdx, aEdge, time2, aEndOfDecode);
            AsyncSerialDataDecoder.SerialDecoderCallback callback = this.getCallback();
            if (callback != null) {
                callback.onEvent(aChannelIdx, "Start before break", time, time2);
                callback.onEvent(aChannelIdx, "Mark after break", time2, time3);
            }
            time = time3;
        }
        return time;
    }
}

