/*
 * Decompiled with CFR 0.152.
 */
package nl.lxtreme.ols.client.project.impl;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import nl.lxtreme.ols.api.data.Channel;
import nl.lxtreme.ols.api.data.annotation.Annotation;
import nl.lxtreme.ols.api.data.annotation.DataAnnotation;

public final class ChannelImpl
implements Channel {
    private static final int MAX_CHANNELS = 32;
    private final int index;
    private final int mask;
    private String label;
    private boolean enabled;
    private final List<Annotation<?>> annotations;
    private final PropertyChangeSupport propertyChangeSupport;

    public ChannelImpl(Channel aChannel, boolean aRetainAnnotation) {
        if (aChannel == null) {
            throw new IllegalArgumentException("Channel cannot be null!");
        }
        this.propertyChangeSupport = new PropertyChangeSupport(this);
        this.index = aChannel.getIndex();
        this.mask = aChannel.getMask();
        this.label = aChannel.hasName() ? aChannel.getLabel() : null;
        this.enabled = aChannel.isEnabled();
        this.annotations = new CopyOnWriteArrayList();
        if (aRetainAnnotation) {
            this.annotations.addAll(aChannel.getAnnotations());
        }
    }

    public ChannelImpl(int aChannelIdx) {
        if (aChannelIdx < 0 || aChannelIdx >= 32) {
            throw new IllegalArgumentException("Invalid channel index!");
        }
        this.propertyChangeSupport = new PropertyChangeSupport(this);
        this.index = aChannelIdx;
        this.mask = (int)(1L << aChannelIdx);
        this.label = null;
        this.enabled = true;
        this.annotations = new CopyOnWriteArrayList();
    }

    public void addAnnotation(Annotation<?> aAnnotation) {
        if (aAnnotation instanceof DataAnnotation) {
            this.annotations.add(aAnnotation);
        } else if (!this.hasName()) {
            this.setLabel(aAnnotation.toString());
        }
    }

    public void addPropertyChangeListener(PropertyChangeListener aListener) {
        this.propertyChangeSupport.addPropertyChangeListener(aListener);
    }

    public void clearAnnotations() {
        this.annotations.clear();
    }

    public int compareTo(Channel aChannel) {
        return this.index - aChannel.getIndex();
    }

    public boolean equals(Object aObject) {
        if (this == aObject) {
            return true;
        }
        if (aObject == null || !(aObject instanceof ChannelImpl)) {
            return false;
        }
        ChannelImpl other = (ChannelImpl)aObject;
        return this.index == other.index;
    }

    public Collection<Annotation<?>> getAnnotations() {
        return Collections.unmodifiableCollection(this.annotations);
    }

    public int getIndex() {
        return this.index;
    }

    public String getLabel() {
        if (this.label == null || "".equals(this.label.trim())) {
            return this.getDefaultName();
        }
        return this.label;
    }

    public int getMask() {
        return this.mask;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.index;
        return result;
    }

    public boolean hasName() {
        return this.label != null && !this.label.trim().isEmpty();
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void removePropertyChangeListener(PropertyChangeListener aListener) {
        this.propertyChangeSupport.removePropertyChangeListener(aListener);
    }

    public void setEnabled(boolean aEnabled) {
        boolean oldEnabled = this.enabled;
        this.enabled = aEnabled;
        this.propertyChangeSupport.fireIndexedPropertyChange("channelEnabled", this.index, oldEnabled, aEnabled);
    }

    public void setLabel(String aLabel) {
        String oldLabel = this.label;
        this.label = aLabel;
        this.propertyChangeSupport.fireIndexedPropertyChange("channelLabel", this.index, oldLabel, aLabel);
    }

    public String toString() {
        return this.index + ": " + this.getLabel();
    }

    private String getDefaultName() {
        return String.format("%s-%d", "Channel", this.getIndex());
    }
}

