/*
 * Decompiled with CFR 0.152.
 */
package nl.lxtreme.ols.client.project.impl;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import nl.lxtreme.ols.api.acquisition.AcquisitionResult;
import nl.lxtreme.ols.api.data.CapturedData;
import nl.lxtreme.ols.api.data.Cursor;
import nl.lxtreme.ols.api.data.DataSet;
import nl.lxtreme.ols.client.project.impl.DataSetImpl;
import nl.lxtreme.ols.util.NumberUtils;

public final class OlsDataHelper {
    private static final Logger LOG = Logger.getLogger(OlsDataHelper.class.getName());
    private static final Pattern OLS_INSTRUCTION_PATTERN = Pattern.compile("^;([^:]+):\\s+([^\r\n]+)$");
    private static final Pattern OLS_DATA_PATTERN = Pattern.compile("^([0-9a-fA-F]+)@(\\d+)$");

    public static DataSetImpl read(Reader aReader) throws IOException {
        String line;
        int size = -1;
        Integer rate = null;
        Integer channels = null;
        Integer enabledChannels = null;
        long triggerPos = -1L;
        long absLen = -1L;
        boolean compressed = true;
        CapturedData capturedData = null;
        DataSetImpl tempDataSet = new DataSetImpl();
        BufferedReader br = new BufferedReader(aReader);
        if (LOG.isLoggable(Level.INFO)) {
            LOG.info("Parsing OLS captured data from stream...");
        }
        ArrayList<String[]> dataValues = new ArrayList<String[]>();
        while ((line = br.readLine()) != null) {
            Matcher instructionMatcher = OLS_INSTRUCTION_PATTERN.matcher(line);
            Matcher dataMatcher = OLS_DATA_PATTERN.matcher(line);
            if (dataMatcher.matches()) {
                String[] dataPair = new String[]{dataMatcher.group(1), dataMatcher.group(2)};
                dataValues.add(dataPair);
                continue;
            }
            if (!instructionMatcher.matches()) continue;
            String instrKey = instructionMatcher.group(1);
            String instrValue = instructionMatcher.group(2);
            if ("Size".equals(instrKey)) {
                size = NumberUtils.safeParseInt((String)instrValue);
                continue;
            }
            if ("Rate".equals(instrKey)) {
                rate = NumberUtils.safeParseInt((String)instrValue);
                continue;
            }
            if ("Channels".equals(instrKey)) {
                channels = NumberUtils.safeParseInt((String)instrValue);
                continue;
            }
            if ("TriggerPosition".equals(instrKey)) {
                triggerPos = Long.parseLong(instrValue);
                continue;
            }
            if ("EnabledChannels".equals(instrKey)) {
                enabledChannels = NumberUtils.safeParseInt((String)instrValue);
                continue;
            }
            if ("CursorEnabled".equals(instrKey)) {
                tempDataSet.setCursorsEnabled(Boolean.parseBoolean(instrValue));
                continue;
            }
            if ("Compressed".equals(instrKey)) {
                compressed = Boolean.parseBoolean(instrValue);
                continue;
            }
            if ("AbsoluteLength".equals(instrKey)) {
                absLen = Long.parseLong(instrValue);
                continue;
            }
            if ("CursorA".equals(instrKey)) {
                long value = NumberUtils.safeParseLong((String)instrValue);
                if (value <= Long.MIN_VALUE) continue;
                tempDataSet.getCursor(0).setTimestamp(value);
                continue;
            }
            if ("CursorB".equals(instrKey)) {
                long value = NumberUtils.safeParseLong((String)instrValue);
                if (value <= Long.MIN_VALUE) continue;
                tempDataSet.getCursor(1).setTimestamp(value);
                continue;
            }
            if (!instrKey.startsWith("Cursor")) continue;
            int idx = NumberUtils.safeParseInt((String)instrKey.substring(6));
            long pos = Long.parseLong(instrValue);
            if (pos <= Long.MIN_VALUE) continue;
            tempDataSet.getCursor(idx).setTimestamp(pos);
        }
        if (dataValues.isEmpty()) {
            throw new IOException("Data file does not contain any sample data!");
        }
        if (!compressed) {
            throw new IOException("Uncompressed data file found! Please send this file to the OLS developers!");
        }
        if (size < 0) {
            size = dataValues.size();
        }
        if (size != dataValues.size()) {
            throw new IOException("Data file is corrupt?! Data size does not match sample count!");
        }
        if (rate == null) {
            throw new IOException("Data file is corrupt?! Sample rate is not provided!");
        }
        if (channels == null || channels <= 0 || channels > 32) {
            throw new IOException("Data file is corrupt?! Channel count is not provided!");
        }
        if (enabledChannels == null) {
            enabledChannels = -1;
        }
        int[] values = new int[size];
        long[] timestamps = new long[size];
        try {
            for (int i = 0; i < size; ++i) {
                String[] dataPair = (String[])dataValues.get(i);
                values[i] = (int)Long.parseLong(dataPair[0], 16);
                timestamps[i] = Long.parseLong(dataPair[1], 10) & Long.MAX_VALUE;
            }
        }
        catch (NumberFormatException exception) {
            throw new IOException("Invalid data encountered.", exception);
        }
        capturedData = new CapturedData(values, timestamps, triggerPos, rate.intValue(), channels.intValue(), enabledChannels.intValue(), absLen);
        return new DataSetImpl((AcquisitionResult)capturedData, tempDataSet, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void write(DataSet aDataSet, Writer aWriter) throws IOException {
        BufferedWriter bw = new BufferedWriter(aWriter);
        AcquisitionResult capturedData = aDataSet.getCapturedData();
        Cursor[] cursors = aDataSet.getCursors();
        boolean cursorsEnabled = aDataSet.isCursorsEnabled();
        try {
            int i;
            int[] values = capturedData.getValues();
            long[] timestamps = capturedData.getTimestamps();
            bw.write(";Size: ");
            bw.write(Integer.toString(values.length));
            bw.newLine();
            bw.write(";Rate: ");
            bw.write(Integer.toString(capturedData.getSampleRate()));
            bw.newLine();
            bw.write(";Channels: ");
            bw.write(Integer.toString(capturedData.getChannels()));
            bw.newLine();
            bw.write(";EnabledChannels: ");
            bw.write(Integer.toString(capturedData.getEnabledChannels()));
            bw.newLine();
            if (capturedData.hasTriggerData()) {
                bw.write(";TriggerPosition: ");
                bw.write(Long.toString(capturedData.getTriggerPosition()));
                bw.newLine();
            }
            bw.write(";Compressed: ");
            bw.write(Boolean.toString(true));
            bw.newLine();
            bw.write(";AbsoluteLength: ");
            bw.write(Long.toString(capturedData.getAbsoluteLength()));
            bw.newLine();
            bw.write(";CursorEnabled: ");
            bw.write(Boolean.toString(cursorsEnabled));
            bw.newLine();
            for (i = 0; cursorsEnabled && i < cursors.length; ++i) {
                if (!cursors[i].isDefined()) continue;
                bw.write(String.format(";Cursor%d: ", i));
                bw.write(Long.toString(cursors[i].getTimestamp()));
                bw.newLine();
            }
            for (i = 0; i < values.length; ++i) {
                bw.write(OlsDataHelper.formatSample(values[i], timestamps[i]));
                bw.newLine();
            }
        }
        finally {
            bw.flush();
        }
    }

    static String formatSample(int aValue, long aTimestamp) {
        return String.format("%08x@%d", aValue, aTimestamp & Long.MAX_VALUE);
    }
}

