/*
 * Decompiled with CFR 0.152.
 */
package nl.lxtreme.ols.tool.jtag;

import java.math.BigInteger;
import java.util.logging.Level;
import java.util.logging.Logger;
import nl.lxtreme.ols.api.acquisition.AcquisitionResult;
import nl.lxtreme.ols.api.data.annotation.Annotation;
import nl.lxtreme.ols.api.data.annotation.AnnotationListener;
import nl.lxtreme.ols.api.tools.ToolContext;
import nl.lxtreme.ols.api.tools.ToolProgressListener;
import nl.lxtreme.ols.api.tools.ToolTask;
import nl.lxtreme.ols.tool.base.annotation.ChannelLabelAnnotation;
import nl.lxtreme.ols.tool.base.annotation.SampleDataAnnotation;
import nl.lxtreme.ols.tool.jtag.JTAGDataSet;
import nl.lxtreme.ols.tool.jtag.JTAGState;

public class JTAGAnalyserTask
implements ToolTask<JTAGDataSet> {
    private static final Logger LOG = Logger.getLogger(JTAGAnalyserTask.class.getName());
    public static final String PROPERTY_AUTO_DETECT_MODE = "AutoDetectJTAGMode";
    private final ToolContext context;
    private final AnnotationListener annotationListener;
    private final ToolProgressListener progressListener;
    private int tmsIdx;
    private int tckIdx;
    private int tdiIdx;
    private int tdoIdx;
    private JTAGState currentState;
    private JTAGState oldState;
    private int startIdx;

    public JTAGAnalyserTask(ToolContext aContext, ToolProgressListener aProgressListener, AnnotationListener aAnnotationListener) {
        this.context = aContext;
        this.progressListener = aProgressListener;
        this.annotationListener = aAnnotationListener;
        this.tdoIdx = -1;
        this.tdiIdx = -1;
    }

    public JTAGDataSet call() throws Exception {
        if (LOG.isLoggable(Level.FINE)) {
            LOG.fine("tmsmask = 0x" + Integer.toHexString(1 << this.tmsIdx));
            LOG.fine("tckmask = 0x" + Integer.toHexString(1 << this.tckIdx));
            LOG.fine("tdomask = 0x" + Integer.toHexString(1 << this.tdoIdx));
            LOG.fine("tdimask = 0x" + Integer.toHexString(1 << this.tdiIdx));
        }
        int startOfDecode = this.context.getStartSampleIndex();
        int endOfDecode = this.context.getEndSampleIndex();
        this.prepareResults();
        JTAGDataSet decodedData = new JTAGDataSet(startOfDecode, endOfDecode, this.context.getData());
        this.clockDataOnEdge(decodedData, startOfDecode);
        decodedData.sort();
        return decodedData;
    }

    public void setTckIndex(int aTckIndex) {
        this.tckIdx = aTckIndex;
    }

    public void setTdiIndex(int aTdiIndex) {
        this.tdiIdx = aTdiIndex;
    }

    public void setTdoIndex(int aTdoIndex) {
        this.tdoIdx = aTdoIndex;
    }

    public void setTmsIndex(int aTmsIndex) {
        this.tmsIdx = aTmsIndex;
    }

    private void clockDataOnEdge(JTAGDataSet aDataSet, int aSlaveSelectedIdx) {
        AcquisitionResult data = this.context.getData();
        int[] values = data.getValues();
        long[] timestamps = data.getTimestamps();
        int startOfDecode = Math.max(aSlaveSelectedIdx, aDataSet.getStartOfDecode());
        int endOfDecode = aDataSet.getEndOfDecode();
        int tdoMask = 1 << this.tdoIdx;
        int tdiMask = 1 << this.tdiIdx;
        int tckMask = 1 << this.tckIdx;
        int tmsMask = 1 << this.tmsIdx;
        int oldTckValue = values[startOfDecode] & tckMask;
        int startTdiDataIdx = 0;
        int endTdiDataIdx = 0;
        String tdiData = null;
        String tdoData = null;
        this.currentState = JTAGState.TEST_LOGIC_RESET;
        this.oldState = JTAGState.TEST_LOGIC_RESET;
        this.startIdx = startOfDecode;
        LOG.log(Level.INFO, "clockDataOnEdge: " + startOfDecode + " to " + endOfDecode);
        double length = endOfDecode - startOfDecode;
        for (int idx = startOfDecode + 1; idx < endOfDecode; ++idx) {
            String state;
            int dataSample = values[idx];
            int tckValue = dataSample & tckMask;
            int tmsValue = dataSample & tmsMask;
            int tdiValue = dataSample & tdiMask;
            int tdoValue = dataSample & tdoMask;
            if (oldTckValue == tckValue) continue;
            oldTckValue = tckValue;
            if (tckValue == 0) continue;
            if (this.currentState == JTAGState.TEST_LOGIC_RESET) {
                state = this.currentState.getDisplayText();
                if (tmsValue == 0) {
                    this.currentState = JTAGState.RUN_TEST_IDLE;
                }
            } else if (this.currentState == JTAGState.RUN_TEST_IDLE) {
                state = this.currentState.getDisplayText();
                this.currentState = tmsValue == 0 ? JTAGState.RUN_TEST_IDLE : JTAGState.SELECT_DR;
            } else if (this.currentState == JTAGState.SELECT_DR) {
                state = this.currentState.getDisplayText();
                this.currentState = tmsValue == 0 ? JTAGState.CAPTURE_DR : JTAGState.SELECT_IR;
            } else if (this.currentState == JTAGState.CAPTURE_DR) {
                state = this.currentState.getDisplayText();
                tdiData = null;
                tdoData = null;
                this.currentState = tmsValue == 0 ? JTAGState.SHIFT_DR : JTAGState.EXIT1_DR;
            } else if (this.currentState == JTAGState.SHIFT_DR) {
                state = this.currentState.getDisplayText();
                if (tdiData == null) {
                    startTdiDataIdx = idx;
                    tdiData = "";
                    tdoData = "";
                }
                endTdiDataIdx = idx;
                tdiData = tdiValue == 0 ? "0" + tdiData : "1" + tdiData;
                tdoData = tdoValue == 0 ? "0" + tdoData : "1" + tdoData;
                if (tmsValue != 0) {
                    this.currentState = JTAGState.EXIT1_DR;
                }
            } else if (this.currentState == JTAGState.EXIT1_DR) {
                state = this.currentState.getDisplayText();
                this.currentState = tmsValue == 0 ? JTAGState.PAUSE_DR : JTAGState.UPDATE_DR;
            } else if (this.currentState == JTAGState.PAUSE_DR) {
                state = this.currentState.getDisplayText();
                this.currentState = tmsValue == 0 ? JTAGState.PAUSE_DR : JTAGState.EXIT2_DR;
            } else if (this.currentState == JTAGState.EXIT2_DR) {
                state = this.currentState.getDisplayText();
                this.currentState = tmsValue == 0 ? JTAGState.SHIFT_DR : JTAGState.UPDATE_DR;
            } else if (this.currentState == JTAGState.UPDATE_DR) {
                state = this.currentState.getDisplayText();
                this.annotationListener.onAnnotation((Annotation)new SampleDataAnnotation(this.tdiIdx, timestamps[startTdiDataIdx], timestamps[endTdiDataIdx], String.format("0x%x", new BigInteger(tdiData, 2))));
                this.annotationListener.onAnnotation((Annotation)new SampleDataAnnotation(this.tdoIdx, timestamps[startTdiDataIdx], timestamps[endTdiDataIdx], String.format("0x%x", new BigInteger(tdoData, 2))));
                aDataSet.reportJTAGTdiData(this.tdiIdx, startTdiDataIdx, endTdiDataIdx, this.currentState, tdiData);
                aDataSet.reportJTAGTdoData(this.tdoIdx, startTdiDataIdx, endTdiDataIdx, this.currentState, tdoData);
                this.currentState = tmsValue == 0 ? JTAGState.RUN_TEST_IDLE : JTAGState.SELECT_DR;
            } else if (this.currentState == JTAGState.SELECT_IR) {
                state = this.currentState.getDisplayText();
                this.currentState = tmsValue == 0 ? JTAGState.CAPTURE_IR : JTAGState.TEST_LOGIC_RESET;
            } else if (this.currentState == JTAGState.CAPTURE_IR) {
                state = this.currentState.getDisplayText();
                tdiData = null;
                tdoData = null;
                this.currentState = tmsValue == 0 ? JTAGState.SHIFT_IR : JTAGState.EXIT1_IR;
            } else if (this.currentState == JTAGState.SHIFT_IR) {
                state = this.currentState.getDisplayText();
                if (tdiData == null) {
                    startTdiDataIdx = idx;
                    tdiData = "";
                    tdoData = "";
                }
                endTdiDataIdx = idx;
                tdiData = tdiValue == 0 ? "0" + tdiData : "1" + tdiData;
                tdoData = tdoValue == 0 ? "0" + tdoData : "1" + tdoData;
                if (tmsValue != 0) {
                    this.currentState = JTAGState.EXIT1_IR;
                }
            } else if (this.currentState == JTAGState.EXIT1_IR) {
                state = this.currentState.getDisplayText();
                this.currentState = tmsValue == 0 ? JTAGState.PAUSE_IR : JTAGState.UPDATE_IR;
            } else if (this.currentState == JTAGState.PAUSE_IR) {
                state = this.currentState.getDisplayText();
                this.currentState = tmsValue == 0 ? JTAGState.PAUSE_IR : JTAGState.EXIT2_IR;
            } else if (this.currentState == JTAGState.EXIT2_IR) {
                state = this.currentState.getDisplayText();
                this.currentState = tmsValue == 0 ? JTAGState.SHIFT_IR : JTAGState.UPDATE_IR;
            } else if (this.currentState == JTAGState.UPDATE_IR) {
                state = this.currentState.getDisplayText();
                this.annotationListener.onAnnotation((Annotation)new SampleDataAnnotation(this.tdiIdx, timestamps[startTdiDataIdx], timestamps[endTdiDataIdx], String.format("0x%x", new BigInteger(tdiData, 2))));
                this.annotationListener.onAnnotation((Annotation)new SampleDataAnnotation(this.tdoIdx, timestamps[startTdiDataIdx], timestamps[endTdiDataIdx], String.format("0x%x", new BigInteger(tdoData, 2))));
                aDataSet.reportJTAGTdiData(this.tdiIdx, startTdiDataIdx, endTdiDataIdx, this.currentState, tdiData);
                aDataSet.reportJTAGTdoData(this.tdoIdx, startTdiDataIdx, endTdiDataIdx, this.currentState, tdoData);
                this.currentState = tmsValue == 0 ? JTAGState.RUN_TEST_IDLE : JTAGState.SELECT_DR;
            } else {
                state = "ERROR";
            }
            if (this.oldState != this.currentState) {
                this.annotationListener.onAnnotation((Annotation)new SampleDataAnnotation(this.tmsIdx, timestamps[this.startIdx], timestamps[idx], state));
                aDataSet.reportJTAGState(this.tmsIdx, this.startIdx, idx, this.oldState);
                this.startIdx = idx + 1;
                this.oldState = this.currentState;
            }
            this.progressListener.setProgress((int)((double)(idx - startOfDecode) * 100.0 / length));
        }
    }

    private void prepareResults() {
        if (this.tckIdx >= 0) {
            this.annotationListener.clearAnnotations(this.tckIdx);
            this.annotationListener.onAnnotation((Annotation)new ChannelLabelAnnotation(this.tckIdx, "TCK"));
        }
        if (this.tmsIdx >= 0) {
            this.annotationListener.clearAnnotations(this.tmsIdx);
            this.annotationListener.onAnnotation((Annotation)new ChannelLabelAnnotation(this.tmsIdx, "TMS"));
        }
        if (this.tdiIdx >= 0) {
            this.annotationListener.clearAnnotations(this.tdiIdx);
            this.annotationListener.onAnnotation((Annotation)new ChannelLabelAnnotation(this.tdiIdx, "TDI"));
        }
        if (this.tdoIdx >= 0) {
            this.annotationListener.clearAnnotations(this.tdoIdx);
            this.annotationListener.onAnnotation((Annotation)new ChannelLabelAnnotation(this.tdoIdx, "TDO"));
        }
    }
}

