/*
 * Decompiled with CFR 0.152.
 */
package nl.lxtreme.ols.tool.jtag;

import java.math.BigInteger;
import nl.lxtreme.ols.api.acquisition.AcquisitionResult;
import nl.lxtreme.ols.api.data.BaseDataSet;
import nl.lxtreme.ols.tool.jtag.JTAGData;
import nl.lxtreme.ols.tool.jtag.JTAGState;

public final class JTAGDataSet
extends BaseDataSet<JTAGData> {
    public static final String JTAG_TDI = "TDI";
    public static final String JTAG_TDO = "TDO";
    public static final String JTAG_TCK = "TCK";
    public static final String JTAG_TMS = "TMS";

    public JTAGDataSet(int aStartOfDecode, int aEndOfDecode, AcquisitionResult aData) {
        super(aStartOfDecode, aEndOfDecode, aData);
    }

    public void reportJTAGState(int aChannelIdx, int aStartIdx, int aEndIdx, JTAGState aState) {
        int idx = this.size();
        this.addData(new JTAGData(idx, aChannelIdx, aState, aStartIdx, aEndIdx));
    }

    public void reportJTAGTdiData(int aChannelIdx, int aStartIdx, int aEndIdx, JTAGState aState, String aTdiData) {
        int idx = this.size();
        this.addData(new JTAGData(idx, aChannelIdx, JTAG_TDI, new BigInteger(aTdiData, 2), aStartIdx, aEndIdx));
    }

    public void reportJTAGTdoData(int aChannelIdx, int aStartIdx, int aEndIdx, JTAGState aState, String aTdoData) {
        int idx = this.size();
        this.addData(new JTAGData(idx, aChannelIdx, JTAG_TDO, new BigInteger(aTdoData, 2), aStartIdx, aEndIdx));
    }

    public void sort() {
        super.sort();
    }
}

