/*
 * Decompiled with CFR 0.152.
 */
package nl.lxtreme.ols.tool.jtag;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Window;
import java.io.File;
import java.io.IOException;
import java.math.BigInteger;
import java.text.DateFormat;
import java.util.Date;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.Action;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.SpringLayout;
import nl.lxtreme.ols.api.UserSettings;
import nl.lxtreme.ols.api.tools.Tool;
import nl.lxtreme.ols.api.tools.ToolContext;
import nl.lxtreme.ols.api.tools.ToolTask;
import nl.lxtreme.ols.api.util.Unit;
import nl.lxtreme.ols.tool.base.BaseToolDialog;
import nl.lxtreme.ols.tool.base.ExportAware;
import nl.lxtreme.ols.tool.base.ToolDialog;
import nl.lxtreme.ols.tool.base.ToolUtils;
import nl.lxtreme.ols.tool.jtag.JTAGAnalyser;
import nl.lxtreme.ols.tool.jtag.JTAGAnalyserTask;
import nl.lxtreme.ols.tool.jtag.JTAGData;
import nl.lxtreme.ols.tool.jtag.JTAGDataSet;
import nl.lxtreme.ols.util.ExportUtils;
import nl.lxtreme.ols.util.HostUtils;
import nl.lxtreme.ols.util.swing.SpringLayoutUtils;
import nl.lxtreme.ols.util.swing.SwingComponentUtils;
import org.osgi.framework.BundleContext;

public final class JTAGProtocolAnalysisDialog
extends BaseToolDialog<JTAGDataSet>
implements ExportAware<JTAGDataSet> {
    private static final long serialVersionUID = 1L;
    private static final Logger LOG = Logger.getLogger(JTAGProtocolAnalysisDialog.class.getName());
    private JComboBox tck;
    private JComboBox tdo;
    private JComboBox tdi;
    private JComboBox tms;
    private JEditorPane outText;
    private ToolUtils.RestorableAction runAnalysisAction;
    private Action exportAction;
    private Action closeAction;

    public JTAGProtocolAnalysisDialog(Window aOwner, ToolContext aToolContext, BundleContext aContext, JTAGAnalyser aTool) {
        super(aOwner, aToolContext, aContext, (Tool)aTool);
        this.initDialog();
        this.setLocationRelativeTo(this.getOwner());
    }

    public void exportToFile(File aOutputFile, ExportAware.ExportFormat aFormat) throws IOException {
        if (ExportAware.ExportFormat.HTML.equals((Object)aFormat)) {
            this.storeToHtmlFile(aOutputFile, (JTAGDataSet)((Object)this.getLastResult()));
        } else if (ExportAware.ExportFormat.CSV.equals((Object)aFormat)) {
            this.storeToCsvFile(aOutputFile, (JTAGDataSet)((Object)this.getLastResult()));
        }
    }

    public void readPreferences(UserSettings aSettings) {
        this.setComboBoxIndex(this.tck, aSettings, "tck");
        this.setComboBoxIndex(this.tms, aSettings, "tms");
        this.setComboBoxIndex(this.tdi, aSettings, "tdi");
        this.setComboBoxIndex(this.tdo, aSettings, "tdo");
    }

    public void reset() {
        this.outText.setText(this.getEmptyHtmlPage());
        this.outText.setEditable(false);
        this.runAnalysisAction.restore();
        this.setControlsEnabled(true);
        this.exportAction.setEnabled(false);
    }

    public void writePreferences(UserSettings aSettings) {
        aSettings.putInt("tck", this.tck.getSelectedIndex());
        aSettings.putInt("tms", this.tms.getSelectedIndex());
        aSettings.putInt("tdi", this.tdi.getSelectedIndex());
        aSettings.putInt("tdo", this.tdo.getSelectedIndex());
    }

    protected void onToolEnded(JTAGDataSet aAnalysisResult) {
        block4: {
            try {
                String htmlPage;
                if (aAnalysisResult != null) {
                    htmlPage = this.toHtmlPage(null, aAnalysisResult);
                    this.exportAction.setEnabled(!aAnalysisResult.isEmpty());
                } else {
                    htmlPage = this.getEmptyHtmlPage();
                    this.exportAction.setEnabled(false);
                }
                this.outText.setText(htmlPage);
                this.outText.setEditable(false);
                this.runAnalysisAction.restore();
            }
            catch (IOException exception) {
                if (HostUtils.handleInterruptedException((Throwable)exception)) break block4;
                throw new RuntimeException(exception);
            }
        }
    }

    protected void onToolStarted() {
    }

    protected void prepareToolTask(ToolTask<JTAGDataSet> aToolTask) {
        JTAGAnalyserTask toolTask = (JTAGAnalyserTask)aToolTask;
        toolTask.setTmsIndex(this.tms.getSelectedIndex());
        toolTask.setTckIndex(this.tck.getSelectedIndex());
        toolTask.setTdoIndex(this.tdo.getSelectedIndex() - 1);
        toolTask.setTdiIndex(this.tdi.getSelectedIndex() - 1);
    }

    protected void setControlsEnabled(boolean aEnable) {
        this.tck.setEnabled(aEnable);
        this.tms.setEnabled(aEnable);
        this.tdi.setEnabled(aEnable);
        this.tdo.setEnabled(aEnable);
        this.closeAction.setEnabled(aEnable);
        this.exportAction.setEnabled(aEnable);
    }

    private ExportUtils.HtmlExporter createHtmlTemplate(ExportUtils.HtmlExporter aExporter) {
        aExporter.addCssStyle("body { font-family: sans-serif; } ");
        aExporter.addCssStyle("table { border-width: 1px; border-spacing: 0px; border-color: gray; border-collapse: collapse; border-style: solid; margin-bottom: 15px; } ");
        aExporter.addCssStyle("table th { border-width: 1px; padding: 2px; border-style: solid; border-color: gray; background-color: #C0C0FF; text-align: left; font-weight: bold; font-family: sans-serif; } ");
        aExporter.addCssStyle("table td { border-width: 1px; padding: 2px; border-style: solid; border-color: gray; font-family: monospace; } ");
        aExporter.addCssStyle(".date { text-align: right; font-size: x-small; margin-bottom: 15px; } ");
        aExporter.addCssStyle(".w100 { width: 100%; } ");
        aExporter.addCssStyle(".w50 { width: 50%; } ");
        aExporter.addCssStyle(".w45 { width: 45%; } ");
        aExporter.addCssStyle(".w44 { width: 44%; } ");
        aExporter.addCssStyle(".w40 { width: 40%; } ");
        aExporter.addCssStyle(".w35 { width: 35%; } ");
        aExporter.addCssStyle(".w30 { width: 30%; } ");
        aExporter.addCssStyle(".w28 { width: 28%; } ");
        aExporter.addCssStyle(".w20 { width: 20%; } ");
        aExporter.addCssStyle(".w15 { width: 15%; } ");
        aExporter.addCssStyle(".w12 { width: 12%; } ");
        aExporter.addCssStyle(".w10 { width: 10%; } ");
        aExporter.addCssStyle(".w8 { width: 8%; } ");
        aExporter.addCssStyle(".w7 { width: 7%; } ");
        aExporter.addCssStyle(".w5 { width: 5%; } ");
        ExportUtils.HtmlExporter.Element body = aExporter.getBody();
        body.addChild(ExportUtils.HtmlExporter.H1).addContent(new String[]{"JTAG Analysis results"});
        body.addChild(ExportUtils.HtmlExporter.HR);
        body.addChild(ExportUtils.HtmlExporter.DIV).addAttribute("class", "date").addContent(new String[]{"Generated: ", "{date-now}"});
        ExportUtils.HtmlExporter.Element table = body.addChild(ExportUtils.HtmlExporter.TABLE).addAttribute("class", "w100");
        ExportUtils.HtmlExporter.Element thead = table.addChild(ExportUtils.HtmlExporter.THEAD);
        ExportUtils.HtmlExporter.Element tr = thead.addChild(ExportUtils.HtmlExporter.TR);
        tr.addChild(ExportUtils.HtmlExporter.TH).addAttribute("class", "w44").addAttribute("colspan", "3");
        tr.addChild(ExportUtils.HtmlExporter.TH).addAttribute("class", "w28").addAttribute("colspan", "2").addContent(new String[]{"TDI"});
        tr.addChild(ExportUtils.HtmlExporter.TH).addAttribute("class", "w28").addAttribute("colspan", "2").addContent(new String[]{"TDO"});
        tr = thead.addChild(ExportUtils.HtmlExporter.TR);
        tr.addChild(ExportUtils.HtmlExporter.TH).addAttribute("class", "w5").addContent(new String[]{"Index"});
        tr.addChild(ExportUtils.HtmlExporter.TH).addAttribute("class", "w10").addContent(new String[]{"Time"});
        tr.addChild(ExportUtils.HtmlExporter.TH).addAttribute("class", "w28").addContent(new String[]{"State"});
        tr.addChild(ExportUtils.HtmlExporter.TH).addAttribute("class", "w8").addContent(new String[]{"Hex"});
        tr.addChild(ExportUtils.HtmlExporter.TH).addAttribute("class", "w20").addContent(new String[]{"Bin"});
        tr.addChild(ExportUtils.HtmlExporter.TH).addAttribute("class", "w8").addContent(new String[]{"Hex"});
        tr.addChild(ExportUtils.HtmlExporter.TH).addAttribute("class", "w20").addContent(new String[]{"Bin"});
        ExportUtils.HtmlExporter.Element tbody = table.addChild(ExportUtils.HtmlExporter.TBODY);
        tbody.addContent(new String[]{"{decoded-data}"});
        return aExporter;
    }

    private JPanel createPreviewPane() {
        JPanel panTable = new JPanel(new GridLayout(1, 1, 0, 0));
        this.outText = new JEditorPane("text/html", this.getEmptyHtmlPage());
        this.outText.setEditable(false);
        panTable.add(new JScrollPane(this.outText));
        return panTable;
    }

    private JPanel createSettingsPane() {
        int channelCount = this.getData().getChannels();
        JPanel settings = new JPanel(new SpringLayout());
        SpringLayoutUtils.addSeparator((Container)settings, (String)"Settings");
        settings.add(SwingComponentUtils.createRightAlignedLabel((String)"TCK"));
        this.tck = SwingComponentUtils.createChannelSelector((int)channelCount, (int)0);
        settings.add(this.tck);
        settings.add(SwingComponentUtils.createRightAlignedLabel((String)"TMS"));
        this.tms = SwingComponentUtils.createChannelSelector((int)channelCount, (int)1);
        settings.add(this.tms);
        settings.add(SwingComponentUtils.createRightAlignedLabel((String)"TDI"));
        this.tdi = SwingComponentUtils.createOptionalChannelSelector((int)channelCount, (int)3);
        settings.add(this.tdi);
        settings.add(SwingComponentUtils.createRightAlignedLabel((String)"TDO"));
        this.tdo = SwingComponentUtils.createOptionalChannelSelector((int)channelCount, (int)4);
        settings.add(this.tdo);
        SpringLayoutUtils.makeEditorGrid((Container)settings, (int)10, (int)4);
        return settings;
    }

    private String getEmptyHtmlPage() {
        ExportUtils.HtmlExporter exporter = this.createHtmlTemplate(ExportUtils.createHtmlExporter());
        return exporter.toString(new ExportUtils.HtmlExporter.MacroResolver(){

            public Object resolve(String aMacro, ExportUtils.HtmlExporter.Element aParent) {
                if ("date-now".equals(aMacro)) {
                    DateFormat df = DateFormat.getDateInstance(1);
                    return df.format(new Date());
                }
                return null;
            }
        });
    }

    private void initDialog() {
        this.setMinimumSize(new Dimension(640, 480));
        JPanel settingsPane = this.createSettingsPane();
        JPanel previewPane = this.createPreviewPane();
        JPanel contentPane = new JPanel(new GridBagLayout());
        contentPane.add((Component)settingsPane, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 11, 0, new Insets(2, 0, 2, 0), 0, 0));
        contentPane.add((Component)previewPane, new GridBagConstraints(1, 0, 1, 1, 1.0, 1.0, 11, 1, new Insets(2, 0, 2, 0), 0, 0));
        JButton runAnalysisButton = ToolUtils.createRunAnalysisButton((ToolDialog)this);
        this.runAnalysisAction = (ToolUtils.RestorableAction)runAnalysisButton.getAction();
        JButton exportButton = ToolUtils.createExportButton((ExportAware)this);
        this.exportAction = exportButton.getAction();
        this.exportAction.setEnabled(false);
        JButton closeButton = ToolUtils.createCloseButton();
        this.closeAction = closeButton.getAction();
        JComponent buttons = SwingComponentUtils.createButtonPane((JButton[])new JButton[]{runAnalysisButton, exportButton, closeButton});
        SwingComponentUtils.setupWindowContentPane((Window)((Object)this), (Component)contentPane, (Component)buttons, (JButton)runAnalysisButton);
    }

    private void storeToCsvFile(File aFile, JTAGDataSet aDataSet) {
        block7: {
            try {
                ExportUtils.CsvExporter exporter = ExportUtils.createCsvExporter((File)aFile);
                exporter.setHeaders(new String[]{"index", "time", "state", "TDI data", "TDO data"});
                List dataSet = aDataSet.getData();
                for (int i = 0; i < dataSet.size(); ++i) {
                    JTAGData next;
                    JTAGData data = (JTAGData)((Object)dataSet.get(i));
                    String time = Unit.Time.format((double)aDataSet.getTime(data.getStartSampleIndex()));
                    String event = data.isEvent() ? data.getEventName() : null;
                    BigInteger tdiData = null;
                    BigInteger tdoData = null;
                    if (i + 1 < dataSet.size() && (next = (JTAGData)((Object)dataSet.get(i + 1))).getStartSampleIndex() == data.getStartSampleIndex()) {
                        tdiData = (BigInteger)(next.isTdiData() ? next.getDataValue() : data.getDataValue());
                        tdoData = (BigInteger)(next.isTdoData() ? next.getDataValue() : data.getDataValue());
                        ++i;
                    }
                    if (tdiData == null && data.isTdiData()) {
                        tdiData = (BigInteger)data.getDataValue();
                        tdoData = null;
                    } else if (tdoData == null && data.isTdoData()) {
                        tdiData = null;
                        tdoData = (BigInteger)data.getDataValue();
                    }
                    String tdiDataValue = tdiData != null ? "0x" + tdiData.toString(16) : null;
                    String tdoDataValue = tdoData != null ? "0x" + tdoData.toString(16) : null;
                    exporter.addRow(new Object[]{i, time, event, tdiDataValue, tdoDataValue});
                }
                exporter.close();
            }
            catch (IOException exception) {
                if (HostUtils.handleInterruptedException((Throwable)exception)) break block7;
                LOG.log(Level.WARNING, "CSV export failed!", exception);
            }
        }
    }

    private void storeToHtmlFile(File aFile, JTAGDataSet aDataSet) {
        block2: {
            try {
                this.toHtmlPage(aFile, aDataSet);
            }
            catch (IOException exception) {
                if (HostUtils.handleInterruptedException((Throwable)exception)) break block2;
                LOG.log(Level.WARNING, "HTML export failed!", exception);
            }
        }
    }

    private String toHtmlPage(File aFile, final JTAGDataSet aAnalysisResult) throws IOException {
        LOG.log(Level.INFO, "toHtmlPage");
        ExportUtils.HtmlExporter.MacroResolver macroResolver = new ExportUtils.HtmlExporter.MacroResolver(){

            public Object resolve(String aMacro, ExportUtils.HtmlExporter.Element aParent) {
                if ("date-now".equals(aMacro)) {
                    LOG.log(Level.INFO, "toHtmlPage date-now");
                    DateFormat df = DateFormat.getDateInstance(1);
                    return df.format(new Date());
                }
                if ("decoded-data".equals(aMacro)) {
                    LOG.log(Level.INFO, "toHtmlPage decoded-data");
                    List dataSet = aAnalysisResult.getData();
                    for (int i = 0; i < dataSet.size(); ++i) {
                        JTAGData next;
                        ExportUtils.HtmlExporter.Element tr;
                        JTAGData data = (JTAGData)((Object)dataSet.get(i));
                        if (data.isEvent()) {
                            tr = aParent.addChild(ExportUtils.HtmlExporter.TR).addAttribute("style", "background-color: #fefeff;");
                            tr.addChild(ExportUtils.HtmlExporter.TD).addContent(new String[]{String.valueOf(i)});
                            tr.addChild(ExportUtils.HtmlExporter.TD).addContent(new String[]{Unit.Time.format((double)aAnalysisResult.getTime(data.getStartSampleIndex()))});
                            tr.addChild(ExportUtils.HtmlExporter.TD).addContent(new String[]{String.valueOf(data.getDataValue())});
                            tr.addChild(ExportUtils.HtmlExporter.TD).addAttribute("colspan", "4");
                            continue;
                        }
                        tr = aParent.addChild(ExportUtils.HtmlExporter.TR);
                        tr.addChild(ExportUtils.HtmlExporter.TD).addContent(new String[]{String.valueOf(i)});
                        tr.addChild(ExportUtils.HtmlExporter.TD).addContent(new String[]{Unit.Time.format((double)aAnalysisResult.getTime(data.getStartSampleIndex()))});
                        tr.addChild(ExportUtils.HtmlExporter.TD).addContent(new String[]{data.getEventName()});
                        BigInteger tdiData = null;
                        BigInteger tdoData = null;
                        if (i + 1 < dataSet.size() && (next = (JTAGData)((Object)dataSet.get(i + 1))).getStartSampleIndex() == data.getStartSampleIndex()) {
                            tdiData = (BigInteger)(next.isTdiData() ? next.getDataValue() : data.getDataValue());
                            tdoData = (BigInteger)(next.isTdoData() ? next.getDataValue() : data.getDataValue());
                            ++i;
                        }
                        if (tdiData == null && data.isTdiData()) {
                            tdiData = (BigInteger)data.getDataValue();
                            tdoData = null;
                        } else if (tdoData == null && data.isTdoData()) {
                            tdiData = null;
                            tdoData = (BigInteger)data.getDataValue();
                        }
                        if (tdiData != null) {
                            tr.addChild(ExportUtils.HtmlExporter.TD).addContent(new String[]{"0x" + tdiData.toString(16)});
                            tr.addChild(ExportUtils.HtmlExporter.TD).addContent(new String[]{"0b" + tdiData.toString(2)});
                        } else {
                            tr.addChild(ExportUtils.HtmlExporter.TD).addAttribute("colspan", "2");
                        }
                        if (tdoData != null) {
                            tr.addChild(ExportUtils.HtmlExporter.TD).addContent(new String[]{"0x" + tdoData.toString(16)});
                            tr.addChild(ExportUtils.HtmlExporter.TD).addContent(new String[]{"0b" + tdoData.toString(2)});
                            continue;
                        }
                        tr.addChild(ExportUtils.HtmlExporter.TD).addAttribute("colspan", "2");
                    }
                }
                return null;
            }
        };
        if (aFile == null) {
            ExportUtils.HtmlExporter exporter = this.createHtmlTemplate(ExportUtils.createHtmlExporter());
            return exporter.toString(macroResolver);
        }
        ExportUtils.HtmlFileExporter exporter = (ExportUtils.HtmlFileExporter)this.createHtmlTemplate((ExportUtils.HtmlExporter)ExportUtils.createHtmlExporter((File)aFile));
        exporter.write(macroResolver);
        exporter.close();
        return null;
    }
}

