/*
 * Decompiled with CFR 0.152.
 */
package nl.lxtreme.ols.util;

import java.io.Closeable;
import java.io.File;
import java.io.Flushable;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.util.logging.Level;
import java.util.logging.LogManager;
import java.util.logging.Logger;
import nl.lxtreme.ols.util.HostInfo;

public final class HostUtils
implements HostInfo {
    private static final HostInfo HOSTINFO = new HostUtils();

    private HostUtils() {
    }

    public static final boolean closeResource(Closeable aResource) {
        boolean result = false;
        if (aResource != null) {
            try {
                if (aResource instanceof Flushable) {
                    ((Flushable)((Object)aResource)).flush();
                }
            }
            catch (IOException exception) {
            }
            finally {
                try {
                    aResource.close();
                    result = true;
                }
                catch (IOException exception) {}
            }
        }
        return result;
    }

    public static final File createLocalDataFile(String aName, String aExtension) {
        String fileName;
        String dirName;
        String extension = (aExtension.startsWith(".") ? "" : ".") + aExtension;
        if (HOSTINFO.isMacOS()) {
            dirName = System.getProperty("user.home") + "/Library/Preferences";
            fileName = aName + ".Application";
        } else if (HOSTINFO.isUnix()) {
            dirName = System.getProperty("user.home");
            fileName = "." + aName + extension;
        } else {
            dirName = System.getenv("LOCALAPPDATA");
            if (dirName == null || dirName.trim().isEmpty()) {
                System.getenv("APPDATA");
            }
            if (dirName == null || dirName.trim().isEmpty()) {
                dirName = System.getProperty("user.home");
            }
            fileName = aName + extension;
        }
        File propFile = new File(dirName, fileName);
        return propFile;
    }

    public static final File createLocalPropertiesFile(String aName) {
        return HostUtils.createLocalDataFile(aName, "properties");
    }

    public static final void flushInputStream(InputStream aResource) throws IOException {
        if (aResource != null) {
            while (aResource.read() >= 0) {
            }
        }
    }

    public static final String getFileExtension(File aFile) {
        String ext = "";
        String filename = aFile.getName();
        int idx = filename.lastIndexOf(46);
        if (idx >= 0 && idx < filename.length() - 1) {
            ext = filename.substring(idx + 1).toLowerCase();
        }
        if (aFile.exists() && aFile.isDirectory() && !"".equals(ext)) {
            ext = "";
        }
        return ext;
    }

    public static HostInfo getHostInfo() {
        return HOSTINFO;
    }

    public static boolean handleInterruptedException(Throwable aThrowable) {
        if (aThrowable == null) {
            return true;
        }
        Throwable current = aThrowable;
        do {
            if (!(current instanceof InterruptedIOException) && !(current instanceof InterruptedException)) continue;
            Thread.currentThread().interrupt();
            return true;
        } while ((current = current.getCause()) != null);
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final void initLogging(InputStream aInputStream) {
        LogManager logManager = LogManager.getLogManager();
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(HostUtils.class.getClassLoader());
            logManager.readConfiguration(aInputStream);
        }
        catch (IOException exception) {
            Logger.getAnonymousLogger().log(Level.FINE, "Problems to load the logging configuration file!", exception);
        }
        finally {
            Thread.currentThread().setContextClassLoader(cl);
        }
    }

    public static final void reverse(int[] aArray) {
        if (aArray == null) {
            throw new IllegalArgumentException("Array cannot be null!");
        }
        int left = 0;
        for (int right = aArray.length - 1; left < right; ++left, --right) {
            int temp = aArray[left];
            aArray[left] = aArray[right];
            aArray[right] = temp;
        }
    }

    public static final <T> void reverse(T[] aArray) {
        if (aArray == null) {
            throw new IllegalArgumentException("Array cannot be null!");
        }
        int left = 0;
        for (int right = aArray.length - 1; left < right; ++left, --right) {
            T temp = aArray[left];
            aArray[left] = aArray[right];
            aArray[right] = temp;
        }
    }

    public static final File setFileExtension(File aFile, String aFileExtension) {
        String extension = aFileExtension.trim();
        if (extension.startsWith(".")) {
            extension = extension.substring(1);
        }
        if (extension.isEmpty()) {
            return aFile;
        }
        File directory = aFile;
        String filename = "";
        boolean endsWithExtension = aFile.getName().toLowerCase().endsWith(extension.toLowerCase());
        if (!aFile.isDirectory() || endsWithExtension) {
            filename = aFile.getName();
            directory = aFile.getParentFile();
        }
        if (!endsWithExtension) {
            filename = filename.concat(".").concat(aFileExtension);
        }
        return new File(directory, filename);
    }

    public static final String stripFileExtension(File aFile, String ... aExtensions) {
        return HostUtils.stripFileExtension(aFile.getName(), aExtensions);
    }

    public static final String stripFileExtension(String aFilename, String ... aExtensions) {
        String result = "";
        int idx = aFilename.lastIndexOf(46);
        if (idx >= 0 && idx < aFilename.length() - 1) {
            result = aFilename.substring(0, idx);
            boolean found = aExtensions == null || aExtensions.length == 0;
            String ext = aFilename.substring(idx + 1).toLowerCase();
            if (aExtensions != null && aExtensions.length > 0) {
                for (String extension : aExtensions) {
                    if (!ext.equalsIgnoreCase(extension)) continue;
                    found = true;
                    break;
                }
            }
            if (!found) {
                result = aFilename;
            }
        }
        return result;
    }

    @Override
    public boolean isLinux() {
        String osName = System.getProperty("os.name").toLowerCase();
        return osName.indexOf("linux") >= 0;
    }

    @Override
    public boolean isMacOS() {
        String osName = System.getProperty("os.name");
        return "Mac OS X".equalsIgnoreCase(osName) || "Darwin".equalsIgnoreCase(osName);
    }

    @Override
    public boolean isSolaris() {
        String osName = System.getProperty("os.name").toLowerCase();
        return osName.indexOf("solaris") >= 0 || osName.indexOf("sunos") >= 0;
    }

    @Override
    public boolean isUnix() {
        String osName = System.getProperty("os.name").toLowerCase();
        return osName.indexOf("nix") >= 0 || this.isLinux() || this.isSolaris();
    }

    @Override
    public boolean isWindows() {
        String osName = System.getProperty("os.name").toLowerCase();
        return osName.indexOf("win") >= 0;
    }

    @Override
    public boolean needsAboutMenuItem() {
        return !this.isMacOS();
    }

    @Override
    public final boolean needsExitMenuItem() {
        return !this.isMacOS();
    }

    @Override
    public boolean needsPreferencesMenuItem() {
        return !this.isMacOS();
    }
}

