/*
 * Decompiled with CFR 0.152.
 */
package nl.lxtreme.ols.util.swing;

import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.IOException;
import java.util.ArrayList;
import javax.swing.JComponent;
import javax.swing.JTree;
import javax.swing.TransferHandler;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreePath;

public class JLxTreeTransferHandler
extends TransferHandler {
    private static final long serialVersionUID = 1L;
    private final DataFlavor nodesFlavor;
    private final DataFlavor[] flavors;
    private DefaultMutableTreeNode[] nodesToRemove;

    public JLxTreeTransferHandler() {
        try {
            String mimeType = String.format("%s;class=\"%s\"", "application/x-java-jvm-local-objectref", DefaultMutableTreeNode[].class.getName());
            this.nodesFlavor = new DataFlavor(mimeType);
            this.flavors = new DataFlavor[]{this.nodesFlavor};
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException("ClassNotFound: " + e.getMessage());
        }
    }

    @Override
    public boolean canImport(TransferHandler.TransferSupport aSupport) {
        if (!aSupport.isDrop()) {
            return false;
        }
        aSupport.setShowDropLocation(true);
        if (!aSupport.isDataFlavorSupported(this.nodesFlavor)) {
            return false;
        }
        JTree.DropLocation dropLocation = (JTree.DropLocation)aSupport.getDropLocation();
        JTree tree = (JTree)aSupport.getComponent();
        int dropRow = tree.getRowForPath(dropLocation.getPath());
        int[] selRows = tree.getSelectionRows();
        for (int i = 0; i < selRows.length; ++i) {
            if (selRows[i] != dropRow) continue;
            return false;
        }
        int action = aSupport.getDropAction();
        if (action == 2) {
            return this.haveCompleteNode(tree);
        }
        TreePath dest = dropLocation.getPath();
        DefaultMutableTreeNode target = (DefaultMutableTreeNode)dest.getLastPathComponent();
        TreePath path = tree.getPathForRow(selRows[0]);
        DefaultMutableTreeNode firstNode = (DefaultMutableTreeNode)path.getLastPathComponent();
        return firstNode.getChildCount() <= 0 || target.getLevel() >= firstNode.getLevel();
    }

    @Override
    public int getSourceActions(JComponent aComponent) {
        if (aComponent instanceof JTree) {
            return 3;
        }
        return 0;
    }

    @Override
    public boolean importData(TransferHandler.TransferSupport aSupport) {
        if (!this.canImport(aSupport)) {
            return false;
        }
        DefaultMutableTreeNode[] nodes = null;
        try {
            Transferable t = aSupport.getTransferable();
            nodes = (DefaultMutableTreeNode[])t.getTransferData(this.nodesFlavor);
        }
        catch (UnsupportedFlavorException ufe) {
            System.out.println("UnsupportedFlavor: " + ufe.getMessage());
        }
        catch (IOException ioe) {
            System.out.println("I/O error: " + ioe.getMessage());
        }
        JTree.DropLocation dl = (JTree.DropLocation)aSupport.getDropLocation();
        int childIndex = dl.getChildIndex();
        TreePath dest = dl.getPath();
        DefaultMutableTreeNode parent = (DefaultMutableTreeNode)dest.getLastPathComponent();
        JTree tree = (JTree)aSupport.getComponent();
        DefaultTreeModel model = (DefaultTreeModel)tree.getModel();
        int index = childIndex;
        if (childIndex == -1) {
            index = parent.getChildCount();
        }
        for (int i = 0; i < nodes.length; ++i) {
            model.insertNodeInto(nodes[i], parent, index++);
        }
        return true;
    }

    @Override
    protected Transferable createTransferable(JComponent aComponent) {
        if (!(aComponent instanceof JTree)) {
            return null;
        }
        TreePath[] paths = ((JTree)aComponent).getSelectionPaths();
        if (paths != null) {
            DefaultMutableTreeNode next;
            ArrayList<DefaultMutableTreeNode> copies = new ArrayList<DefaultMutableTreeNode>();
            ArrayList<DefaultMutableTreeNode> toRemove = new ArrayList<DefaultMutableTreeNode>();
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)paths[0].getLastPathComponent();
            DefaultMutableTreeNode copy = this.copy(node);
            copies.add(copy);
            toRemove.add(node);
            for (int i = 1; i < paths.length && (next = (DefaultMutableTreeNode)paths[i].getLastPathComponent()).getLevel() >= node.getLevel(); ++i) {
                if (next.getLevel() > node.getLevel()) {
                    copy.add(this.copy(next));
                    continue;
                }
                copies.add(this.copy(next));
                toRemove.add(next);
            }
            DefaultMutableTreeNode[] nodes = copies.toArray(new DefaultMutableTreeNode[copies.size()]);
            this.nodesToRemove = toRemove.toArray(new DefaultMutableTreeNode[toRemove.size()]);
            return new NodesTransferable(nodes);
        }
        return null;
    }

    @Override
    protected void exportDone(JComponent aComponent, Transferable aTransferable, int aAction) {
        if ((aAction & 2) == 2) {
            JTree tree = (JTree)aComponent;
            DefaultTreeModel model = (DefaultTreeModel)tree.getModel();
            for (int i = 0; i < this.nodesToRemove.length; ++i) {
                model.removeNodeFromParent(this.nodesToRemove[i]);
            }
        }
    }

    private DefaultMutableTreeNode copy(DefaultMutableTreeNode aNode) {
        DefaultMutableTreeNode clone = (DefaultMutableTreeNode)aNode.clone();
        clone.setUserObject(aNode.getUserObject());
        return clone;
    }

    private boolean haveCompleteNode(JTree tree) {
        int[] selRows = tree.getSelectionRows();
        TreePath path = tree.getPathForRow(selRows[0]);
        DefaultMutableTreeNode first = (DefaultMutableTreeNode)path.getLastPathComponent();
        int childCount = first.getChildCount();
        if (childCount > 0 && selRows.length == 1) {
            return false;
        }
        for (int i = 1; i < selRows.length; ++i) {
            path = tree.getPathForRow(selRows[i]);
            DefaultMutableTreeNode next = (DefaultMutableTreeNode)path.getLastPathComponent();
            if (!first.isNodeChild(next) || childCount <= selRows.length - 1) continue;
            return false;
        }
        return true;
    }

    public class NodesTransferable
    implements Transferable {
        private final DefaultMutableTreeNode[] nodes;

        public NodesTransferable(DefaultMutableTreeNode[] nodes) {
            this.nodes = nodes;
        }

        @Override
        public Object getTransferData(DataFlavor flavor) throws UnsupportedFlavorException {
            if (!this.isDataFlavorSupported(flavor)) {
                throw new UnsupportedFlavorException(flavor);
            }
            return this.nodes;
        }

        @Override
        public DataFlavor[] getTransferDataFlavors() {
            return JLxTreeTransferHandler.this.flavors;
        }

        @Override
        public boolean isDataFlavorSupported(DataFlavor flavor) {
            return JLxTreeTransferHandler.this.nodesFlavor.equals(flavor);
        }
    }
}

