/*
 * Decompiled with CFR 0.152.
 */
package nl.lxtreme.ols.util.swing;

import java.awt.AWTEvent;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FileDialog;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.KeyboardFocusManager;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import java.io.File;
import java.util.ArrayList;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.filechooser.FileFilter;
import nl.lxtreme.ols.util.swing.FilenameFilterAdapter;
import nl.lxtreme.ols.util.swing.StandardActionFactory;
import org.osgi.service.prefs.Preferences;

public final class SwingComponentUtils {
    private static final int DIALOG_PADDING = 6;
    private static final int BUTTONS_PADDING_TOP = 3;
    private static final int BUTTONS_PADDING_BOTTOM = 3;
    private static final int BUTTONS_PADDING_LEFT = 0;
    private static final int BUTTONS_PADDING_RIGHT = 0;
    private static final int BUTTONS_SPACING_DEFAULT = 8;
    public static final int LEFT_FACING = 1;
    public static final int RIGHT_FACING = -1;

    private SwingComponentUtils() {
    }

    public static boolean askConfirmation(Window aWindow, String aMessage) {
        return SwingComponentUtils.askConfirmation(aWindow, aMessage, "Continue?");
    }

    public static boolean askConfirmation(Window aWindow, String aMessage, String aTitle) {
        return JOptionPane.showConfirmDialog(aWindow, aMessage, aTitle, 0, 2) == 0;
    }

    public static JComponent createButtonPane(JButton ... aButtons) {
        if (aButtons == null || aButtons.length < 1) {
            throw new IllegalArgumentException("Need at least one button!");
        }
        int width = 1;
        int height = 1;
        ArrayList<JButton> buttons = new ArrayList<JButton>();
        ArrayList<JButton> stdButtons = new ArrayList<JButton>();
        for (JButton button : aButtons) {
            width = Math.max(width, button.getPreferredSize().width);
            height = Math.max(height, button.getPreferredSize().height);
            Action action = button.getAction();
            if (action != null && (action instanceof StandardActionFactory.CloseAction || action instanceof StandardActionFactory.OkAction || action instanceof StandardActionFactory.CancelAction)) {
                stdButtons.add(button);
                continue;
            }
            buttons.add(button);
        }
        Dimension newDims = new Dimension(width, height);
        JPanel buttonPane = new JPanel();
        buttonPane.setLayout(new BoxLayout(buttonPane, 2));
        buttonPane.setBorder(BorderFactory.createEmptyBorder(3, 0, 3, 0));
        buttonPane.add(Box.createHorizontalGlue());
        for (JButton button : buttons) {
            button.setPreferredSize(newDims);
            buttonPane.add(Box.createHorizontalStrut(8));
            buttonPane.add(button);
        }
        for (JButton button : stdButtons) {
            button.setPreferredSize(newDims);
            buttonPane.add(Box.createHorizontalStrut(8));
            buttonPane.add(button);
        }
        buttonPane.add(Box.createHorizontalStrut(8));
        return buttonPane;
    }

    public static JComboBox createChannelSelector(int aChannelCount) {
        return SwingComponentUtils.internalCreateChannelSelector(aChannelCount, -1, false);
    }

    public static JComboBox createChannelSelector(int aChannelCount, int aDefaultSelectedIndex) {
        return SwingComponentUtils.internalCreateChannelSelector(aChannelCount, aDefaultSelectedIndex, false);
    }

    public static final KeyStroke createKeyMask(int aKeyStroke, int ... aMasks) {
        int modifiers = 0;
        for (int aMask : aMasks) {
            modifiers |= aMask;
        }
        return KeyStroke.getKeyStroke(aKeyStroke, modifiers);
    }

    public static final KeyStroke createMenuKeyMask(int aKeyStroke, int ... aMasks) {
        int modifiers = SwingComponentUtils.getMenuShortcutKeyMask();
        for (int aMask : aMasks) {
            modifiers |= aMask;
        }
        return KeyStroke.getKeyStroke(aKeyStroke, modifiers);
    }

    public static JComboBox createOptionalChannelSelector(int aChannelCount) {
        return SwingComponentUtils.internalCreateChannelSelector(aChannelCount, -1, true);
    }

    public static JComboBox createOptionalChannelSelector(int aChannelCount, int aDefaultSelectedIndex) {
        return SwingComponentUtils.internalCreateChannelSelector(aChannelCount, aDefaultSelectedIndex, true);
    }

    public static final JLabel createRightAlignedLabel(String aText) {
        JLabel label = new JLabel(aText);
        label.setHorizontalAlignment(4);
        return label;
    }

    public static void dispose(Window aWindow) {
        if (aWindow == null) {
            return;
        }
        if (aWindow.isVisible()) {
            aWindow.setVisible(false);
        }
        aWindow.dispose();
    }

    public static final void drawArrowHead(Graphics2D aG, int aXpos, int aYpos, int aFactor, int aArrowWidth, int aArrowHeight) {
        double halfHeight = (double)aArrowHeight / 2.0;
        int x1 = aXpos + aFactor * aArrowWidth;
        int y1 = (int)Math.ceil((double)aYpos - halfHeight);
        int y2 = (int)Math.floor((double)aYpos + halfHeight);
        Polygon arrowHead = new Polygon();
        arrowHead.addPoint(aXpos, aYpos);
        arrowHead.addPoint(x1, y1);
        arrowHead.addPoint(x1, y2);
        aG.fill(arrowHead);
    }

    public static final void drawDoubleHeadedArrow(Graphics aG, int aX1, int aY, int aX2) {
        SwingComponentUtils.drawDoubleHeadedArrow(aG, aX1, aY, aX2, aY);
    }

    public static final void drawDoubleHeadedArrow(Graphics aG, int aX1, int aY1, int aX2, int aY2) {
        SwingComponentUtils.drawDoubleHeadedArrow(aG, aX1, aY1, aX2, aY2, 8, 8);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final void drawDoubleHeadedArrow(Graphics aG, int aX1, int aY1, int aX2, int aY2, int aArrowWidth, int aArrowHeight) {
        Graphics2D g2d = (Graphics2D)aG.create();
        int lineWidth = Math.abs(aX2 - aX1);
        int threshold = 2 * aArrowWidth + 2;
        try {
            int x1 = aX1;
            int x2 = aX2;
            if (lineWidth > threshold) {
                SwingComponentUtils.drawArrowHead(g2d, aX1, aY1, 1, aArrowWidth, aArrowHeight);
                SwingComponentUtils.drawArrowHead(g2d, aX2 + 1, aY2, -1, aArrowWidth, aArrowHeight);
                x1 += aArrowWidth - 1;
                x2 -= aArrowWidth + 1;
            }
            g2d.drawLine(x1, aY1, x2, aY2);
        }
        finally {
            g2d.dispose();
        }
    }

    public static final void fixLabelWidth(JLabel aLabel, String aMinimalText) {
        FontMetrics fm = aLabel.getFontMetrics(aLabel.getFont());
        int height = fm.getHeight();
        aLabel.setPreferredSize(new Dimension(fm.stringWidth(aMinimalText), height));
    }

    public static <T> T getAncestorOfClass(Class<T> aType, Component aComponent) {
        Container parent;
        if (aComponent == null || aType == null) {
            return null;
        }
        for (parent = aComponent.getParent(); parent != null && !aType.isInstance(parent); parent = parent.getParent()) {
        }
        return (T)parent;
    }

    public static final Window getCurrentWindow() {
        KeyboardFocusManager kbdFocusManager = KeyboardFocusManager.getCurrentKeyboardFocusManager();
        Window owner = kbdFocusManager.getFocusedWindow();
        if (owner == null) {
            owner = kbdFocusManager.getActiveWindow();
        }
        return owner;
    }

    public static JComponent getDeepestComponentAt(Component aParent, int aXpos, int aYpos) {
        return (JComponent)SwingUtilities.getDeepestComponentAt(aParent, aXpos, aYpos);
    }

    public static JComponent getDeepestComponentAt(MouseEvent aEvent) {
        return SwingComponentUtils.getDeepestComponentAt(aEvent.getComponent(), aEvent.getX(), aEvent.getY());
    }

    public static final int getMenuShortcutKeyMask() {
        return Toolkit.getDefaultToolkit().getMenuShortcutKeyMask();
    }

    public static final Window getOwningWindow(AWTEvent aEvent) {
        Object source;
        Window owner = null;
        if (aEvent != null && (source = aEvent.getSource()) instanceof Component) {
            owner = SwingComponentUtils.getOwningWindow((Component)source);
        }
        return owner;
    }

    public static final Window getOwningWindow(Component aComponent) {
        if (aComponent == null) {
            return null;
        }
        Window owner = SwingUtilities.getWindowAncestor(aComponent);
        if (owner == null) {
            owner = SwingComponentUtils.getCurrentWindow();
        }
        return owner;
    }

    public static int getStringWidth(Font aFont, String aString) {
        FontMetrics frc = SwingComponentUtils.createFontMetrics(aFont);
        return SwingUtilities.computeStringWidth(frc, aString);
    }

    public static int getStringWidth(String aString) {
        return SwingComponentUtils.getStringWidth(UIManager.getFont("Label.font"), aString);
    }

    public static void invokeOnEDT(Runnable aRunnable) {
        if (SwingUtilities.isEventDispatchThread()) {
            aRunnable.run();
        } else {
            SwingUtilities.invokeLater(aRunnable);
        }
    }

    public static final boolean isActivelyShown(Component aComponent) {
        KeyboardFocusManager kbdFocusManager = KeyboardFocusManager.getCurrentKeyboardFocusManager();
        Window owner = kbdFocusManager.getFocusedWindow();
        return aComponent != null && owner != null && (owner == aComponent || owner.isAncestorOf(aComponent));
    }

    public static void loadWindowState(Preferences aProperties, Window aWindow) {
        SwingComponentUtils.loadFileDialogState(aProperties, aWindow);
        try {
            int xPos = aProperties.getInt("winXpos", -1);
            int yPos = aProperties.getInt("winYpos", -1);
            int width = aProperties.getInt("winWidth", -1);
            int height = aProperties.getInt("winHeight", -1);
            if (xPos >= 0 && yPos >= 0 && width >= 0 && height >= 0) {
                aWindow.setBounds(xPos, yPos, width, height);
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
    }

    public static void registerKeyBinding(JComponent aComponent, char aKey, Action aAction) {
        SwingComponentUtils.registerKeyBinding(aComponent, KeyStroke.getKeyStroke(aKey), aAction);
    }

    public static void registerKeyBinding(JComponent aComponent, KeyStroke aKeyStroke, Action aAction) {
        String name = "KeyBinding.".concat(aKeyStroke.toString());
        aComponent.getInputMap(2).put(aKeyStroke, name);
        aComponent.getActionMap().put(name, aAction);
    }

    public static void registerKeyBinding(JComponent aComponent, String aKeyStroke, Action aAction) {
        SwingComponentUtils.registerKeyBinding(aComponent, KeyStroke.getKeyStroke(aKeyStroke), aAction);
    }

    public static void registerKeystroke(JComponent aComponent, Action aAction, String aCommandName) {
        KeyStroke keyStroke = (KeyStroke)aAction.getValue("AcceleratorKey");
        if (keyStroke == null) {
            return;
        }
        InputMap inputMap = aComponent.getInputMap(2);
        ActionMap actionMap = aComponent.getActionMap();
        inputMap.put(keyStroke, aCommandName);
        actionMap.put(aCommandName, aAction);
        inputMap = aComponent.getInputMap(0);
        Object value = inputMap.get(keyStroke);
        if (value != null) {
            inputMap.put(keyStroke, aCommandName);
        }
        if ((value = (inputMap = aComponent.getInputMap(1)).get(keyStroke)) != null) {
            inputMap.put(keyStroke, aCommandName);
        }
    }

    public static void saveWindowState(Preferences aProperties, Window aWindow) {
        SwingComponentUtils.saveFileDialogState(aProperties, aWindow);
        Rectangle bounds = aWindow.getBounds();
        aProperties.put("winXpos", Integer.toString(bounds.x));
        aProperties.put("winYpos", Integer.toString(bounds.y));
        aProperties.put("winWidth", Integer.toString(bounds.width));
        aProperties.put("winHeight", Integer.toString(bounds.height));
    }

    public static void setupWindowContentPane(Window aDialog, Component aCenterComponent, Component aButtonPane) {
        SwingComponentUtils.setupWindowContentPane(aDialog, aCenterComponent, aButtonPane, null);
    }

    public static void setupWindowContentPane(Window aWindow, Component aCenterComponent, Component aButtonPane, JButton defaultButton) {
        JPanel contentPane = new JPanel(new BorderLayout());
        contentPane.setBorder(BorderFactory.createEmptyBorder(6, 6, 6, 6));
        contentPane.add(aCenterComponent, "Center");
        contentPane.add(aButtonPane, "Last");
        if (aWindow instanceof JDialog) {
            ((JDialog)aWindow).setContentPane(contentPane);
            ((JDialog)aWindow).getRootPane().setDefaultButton(defaultButton);
        } else if (aWindow instanceof JFrame) {
            ((JFrame)aWindow).setContentPane(contentPane);
            ((JFrame)aWindow).getRootPane().setDefaultButton(defaultButton);
        }
        aWindow.pack();
    }

    public static final File showFileOpenDialog(Window aOwner, FileFilter ... aFileFilters) {
        String currentWorkingDir = null;
        return SwingComponentUtils.showFileOpenDialog(aOwner, currentWorkingDir, aFileFilters);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final File showFileOpenDialog(Window aOwner, String aCurrentDirectory, FileFilter ... aFileFilters) {
        if (SwingComponentUtils.isMacOS()) {
            FileDialog dialog;
            if (aOwner instanceof Dialog) {
                dialog = new FileDialog((Dialog)aOwner, "Open file", 0);
            } else if (aOwner instanceof Frame) {
                dialog = new FileDialog((Frame)aOwner, "Open file", 0);
            } else {
                throw new InternalError("Unknown owner window type!");
            }
            dialog.setDirectory(aCurrentDirectory);
            if (aFileFilters != null && aFileFilters.length > 0) {
                dialog.setFilenameFilter(new FilenameFilterAdapter(aFileFilters));
            }
            try {
                dialog.setVisible(true);
                String selectedFile = dialog.getFile();
                File file = selectedFile == null ? null : new File(dialog.getDirectory(), selectedFile);
                return file;
            }
            finally {
                dialog.dispose();
            }
        }
        JFileChooser dialog = new JFileChooser();
        dialog.setCurrentDirectory(aCurrentDirectory == null ? null : new File(aCurrentDirectory));
        for (FileFilter filter : aFileFilters) {
            dialog.addChoosableFileFilter(filter);
        }
        File result = null;
        if (dialog.showOpenDialog(aOwner) == 0) {
            result = dialog.getSelectedFile();
        }
        return result;
    }

    public static final File showFileSaveDialog(Window aOwner, FileFilter ... aFileFilters) {
        String currentWorkingDir = System.getProperty("user.dir");
        return SwingComponentUtils.showFileSaveDialog(aOwner, currentWorkingDir, aFileFilters);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final File showFileSaveDialog(Window aOwner, String aCurrentDirectory, FileFilter ... aFileFilters) {
        if (SwingComponentUtils.isMacOS()) {
            FileDialog dialog;
            if (aOwner instanceof Dialog) {
                dialog = new FileDialog((Dialog)aOwner, "Save file", 1);
            } else if (aOwner instanceof Frame) {
                dialog = new FileDialog((Frame)aOwner, "Save file", 1);
            } else {
                throw new InternalError("Unknown owner window type!");
            }
            dialog.setDirectory(aCurrentDirectory);
            if (aFileFilters != null && aFileFilters.length > 0) {
                dialog.setFilenameFilter(new FilenameFilterAdapter(aFileFilters));
            }
            try {
                dialog.setVisible(true);
                String selectedFile = dialog.getFile();
                File file = selectedFile == null ? null : new File(dialog.getDirectory(), selectedFile);
                return file;
            }
            finally {
                dialog.dispose();
            }
        }
        JFileChooser dialog = new JFileChooser();
        dialog.setCurrentDirectory(aCurrentDirectory == null ? null : new File(aCurrentDirectory));
        for (FileFilter filter : aFileFilters) {
            dialog.addChoosableFileFilter(filter);
        }
        if (dialog.showSaveDialog(aOwner) == 0) {
            return dialog.getSelectedFile();
        }
        return null;
    }

    public static final File showFileSelectionDialog(Window aOwner, FileFilter ... aFileFilters) {
        String currentWorkingDir = System.getProperty("user.dir");
        return SwingComponentUtils.showFileSelectionDialog(aOwner, currentWorkingDir, aFileFilters);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final File showFileSelectionDialog(Window aOwner, String aCurrentDirectory, FileFilter ... aFileFilters) {
        if (SwingComponentUtils.isMacOS()) {
            FileDialog dialog;
            if (aOwner instanceof Dialog) {
                dialog = new FileDialog((Dialog)aOwner);
            } else if (aOwner instanceof Frame) {
                dialog = new FileDialog((Frame)aOwner);
            } else {
                throw new InternalError("Unknown owner window type!");
            }
            dialog.setDirectory(aCurrentDirectory);
            if (aFileFilters != null && aFileFilters.length > 0) {
                dialog.setFilenameFilter(new FilenameFilterAdapter(aFileFilters));
            }
            try {
                dialog.setVisible(true);
                String selectedFile = dialog.getFile();
                File file = selectedFile == null ? null : new File(dialog.getDirectory(), selectedFile);
                return file;
            }
            finally {
                dialog.dispose();
            }
        }
        JFileChooser dialog = new JFileChooser();
        dialog.setCurrentDirectory(aCurrentDirectory == null ? null : new File(aCurrentDirectory));
        for (FileFilter filter : aFileFilters) {
            dialog.addChoosableFileFilter(filter);
        }
        dialog.setVisible(true);
        return dialog.getSelectedFile();
    }

    public static String toCssString(Font aFont) {
        if (aFont == null) {
            throw new IllegalArgumentException("Parameter Font cannot be null!");
        }
        StringBuilder sb = new StringBuilder("font: ");
        if (aFont.isItalic()) {
            sb.append("italic ");
        }
        if (aFont.isBold()) {
            sb.append("bold ");
        }
        sb.append(aFont.getSize()).append("pt ");
        sb.append('\"').append(aFont.getFontName()).append("\", ");
        sb.append('\"').append(aFont.getPSName()).append("\";");
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static FontMetrics createFontMetrics(Font aFont) {
        BufferedImage img = new BufferedImage(1, 1, 2);
        Graphics canvas = img.getGraphics();
        try {
            FontMetrics fontMetrics = canvas.getFontMetrics(aFont);
            return fontMetrics;
        }
        finally {
            canvas.dispose();
            canvas = null;
            img = null;
        }
    }

    private static Component findComponent(Container aContainer, Class<? extends Component> aComponentClass) {
        Component result = null;
        int cnt = aContainer.getComponentCount();
        for (int i = 0; result == null && i < cnt; ++i) {
            Component comp = aContainer.getComponent(i);
            if (aComponentClass.equals(comp.getClass())) {
                result = comp;
                continue;
            }
            if (!(comp instanceof Container)) continue;
            result = SwingComponentUtils.findComponent((Container)comp, aComponentClass);
        }
        return result;
    }

    private static JComboBox internalCreateChannelSelector(int aChannelCount, int aDefaultSelectedindex, boolean aAddUnusedOption) {
        int modelSize = Math.max(0, Math.min(32, aChannelCount));
        if (aAddUnusedOption) {
            ++modelSize;
        }
        String[] dataChannels = new String[modelSize];
        int i = 0;
        if (aAddUnusedOption) {
            dataChannels[i++] = "Unused";
        }
        while (i < modelSize) {
            int index = aAddUnusedOption ? i - 1 : i;
            dataChannels[i] = String.format("Channel %d", index);
            ++i;
        }
        int selectedIndex = aDefaultSelectedindex < 0 ? 0 : aDefaultSelectedindex % modelSize;
        JComboBox<String> result = new JComboBox<String>(dataChannels);
        result.setSelectedIndex(selectedIndex);
        return result;
    }

    private static boolean isMacOS() {
        String osName = System.getProperty("os.name", "").toLowerCase();
        return osName.startsWith("mac os");
    }

    private static void loadFileDialogState(Preferences aProperties, Window aWindow) {
        String dir;
        Container contentPane;
        JFileChooser fileChooser;
        String propKey = "lastDirectory";
        if (aWindow instanceof FileDialog) {
            String dir2 = aProperties.get("lastDirectory", null);
            if (dir2 != null) {
                ((FileDialog)aWindow).setDirectory(dir2);
            }
        } else if (aWindow instanceof JDialog && (fileChooser = (JFileChooser)SwingComponentUtils.findComponent(contentPane = ((JDialog)aWindow).getContentPane(), JFileChooser.class)) != null && (dir = aProperties.get("lastDirectory", null)) != null) {
            fileChooser.setCurrentDirectory(new File(dir));
        }
    }

    private static void saveFileDialogState(Preferences aProperties, Window aWindow) {
        File dir;
        Container contentPane;
        JFileChooser fileChooser;
        String propKey = "lastDirectory";
        if (aWindow instanceof FileDialog) {
            String dir2 = ((FileDialog)aWindow).getDirectory();
            if (dir2 != null) {
                aProperties.put("lastDirectory", dir2);
            }
        } else if (aWindow instanceof JDialog && (fileChooser = (JFileChooser)SwingComponentUtils.findComponent(contentPane = ((JDialog)aWindow).getContentPane(), JFileChooser.class)) != null && (dir = fileChooser.getCurrentDirectory()) != null) {
            aProperties.put("lastDirectory", dir.getAbsolutePath());
        }
    }
}

