/*
 * Decompiled with CFR 0.152.
 */
package nl.lxtreme.ols.util.swing.component;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Desktop;
import java.awt.Dialog;
import java.awt.Font;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Serializable;
import java.io.StringWriter;
import java.net.URI;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import nl.lxtreme.ols.util.HostUtils;
import nl.lxtreme.ols.util.swing.StandardActionFactory;
import nl.lxtreme.ols.util.swing.SwingComponentUtils;

public class JErrorDialog
extends JDialog
implements StandardActionFactory.CloseAction.Closeable {
    private static final long serialVersionUID = 1L;
    public static final String PROPERTY_REPORT_INCIDENT_EMAIL_ADDRESS = "nl.lxtreme.ols.report_incident_email_addr";
    private static final String MORE_DETAILS = "More details";
    private static final String LESS_DETAILS = "Less details";
    private static final String REPORT = "Report";
    private static final String QUIT = "Quit";
    private static final Icon ICON = UIManager.getIcon("OptionPane.warningIcon");
    private JLabel errorMessage;
    private JTextArea details;
    private JButton detailButton;
    private JScrollPane detailsScrollPane;
    private JButton reportButton;
    private IncidentInfo incidentInfo;

    protected JErrorDialog(Window aOwner, IncidentInfo aInfo) {
        super(aOwner, "", Dialog.ModalityType.APPLICATION_MODAL);
        this.initDialog();
        this.setIncident(aInfo);
        this.setLocationRelativeTo(aOwner);
    }

    public static void installSwingExceptionHandler() {
        Thread.setDefaultUncaughtExceptionHandler(new SwingUncaughtExceptionHandler());
    }

    public static synchronized void showDialog(Window aOwner, IncidentInfo aInfo) {
        JErrorDialog errorDialog = null;
        for (Window window : Window.getWindows()) {
            if (!(window instanceof JErrorDialog)) continue;
            errorDialog = (JErrorDialog)window;
            break;
        }
        if (errorDialog == null) {
            errorDialog = new JErrorDialog(aOwner, aInfo);
            errorDialog.setVisible(true);
        } else {
            super.setIncident(aInfo);
            if (!errorDialog.isVisible()) {
                errorDialog.setVisible(true);
            }
            errorDialog.requestFocus();
        }
    }

    public static void showDialog(Window aOwner, String aTitle, String aErrorMessage, String aDetails) {
        JErrorDialog.showDialog(aOwner, new IncidentInfo(aTitle, aErrorMessage, aDetails));
    }

    public static void showDialog(Window aOwner, String aTitle, Throwable aError) {
        JErrorDialog.showDialog(aOwner, new IncidentInfo(aTitle, null, null, aError));
    }

    public static void uninstallSwingExceptionHandler() {
        Thread.setDefaultUncaughtExceptionHandler(null);
    }

    @Override
    public void close() {
        this.setVisible(false);
        this.dispose();
    }

    final void reportIncident() {
        IncidentMailReporter reporter = new IncidentMailReporter(this.getReportIncidentAddress());
        reporter.reportIncident(this.getIncidentInfo());
    }

    final void setDetailsVisible(boolean aVisible) {
        if (aVisible) {
            this.details.setCaretPosition(0);
            this.detailsScrollPane.setVisible(true);
            this.detailButton.setText(LESS_DETAILS);
        } else {
            this.detailsScrollPane.setVisible(false);
            this.detailButton.setText(MORE_DETAILS);
        }
        this.pack();
    }

    protected IncidentInfo getIncidentInfo() {
        return this.incidentInfo;
    }

    private JPanel createDetailsPane() {
        this.errorMessage = new JLabel();
        this.details = new JTextArea(8, 50);
        this.details.setFont(Font.decode("Monospaced"));
        this.details.setEditable(false);
        this.detailsScrollPane = new JScrollPane(this.details);
        this.detailsScrollPane.setVerticalScrollBarPolicy(22);
        JLabel icon = new JLabel(ICON);
        icon.setBorder(BorderFactory.createEmptyBorder(16, 0, 12, 24));
        JPanel topPanel = new JPanel(new BorderLayout());
        topPanel.setBorder(BorderFactory.createEmptyBorder(0, 12, 12, 12));
        topPanel.add((Component)icon, "West");
        topPanel.add((Component)this.errorMessage, "Center");
        JPanel detailPanel = new JPanel(new BorderLayout());
        detailPanel.setBorder(BorderFactory.createEmptyBorder(12, 6, 12, 6));
        detailPanel.add((Component)topPanel, "North");
        detailPanel.add((Component)this.detailsScrollPane, "Center");
        return detailPanel;
    }

    private String getReportIncidentAddress() {
        String property = System.getProperty(PROPERTY_REPORT_INCIDENT_EMAIL_ADDRESS, "");
        String result = String.valueOf(property).trim();
        return result.isEmpty() ? null : result;
    }

    private void initDialog() {
        JPanel contentPane = this.createDetailsPane();
        boolean reportingEnabled = this.getReportIncidentAddress() != null;
        this.reportButton = new JButton(REPORT);
        this.reportButton.setVisible(reportingEnabled);
        this.reportButton.setEnabled(Desktop.isDesktopSupported());
        this.reportButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent aEvent) {
                try {
                    JErrorDialog.this.reportIncident();
                }
                catch (RuntimeException exception) {
                    Window parent1 = SwingComponentUtils.getOwningWindow(aEvent);
                    JOptionPane.showMessageDialog(parent1, exception.getMessage(), "Reporting failed!", 0);
                }
            }
        });
        JButton cancel = StandardActionFactory.createCloseButton();
        this.detailButton = new JButton(MORE_DETAILS);
        this.detailButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent aEvent) {
                JErrorDialog.this.setDetailsVisible(!JErrorDialog.this.detailsScrollPane.isVisible());
            }
        });
        JButton quit = new JButton(QUIT);
        quit.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent aEvent) {
                System.exit(1);
            }
        });
        JComponent buttonPane = SwingComponentUtils.createButtonPane(quit, this.reportButton, this.detailButton, cancel);
        SwingComponentUtils.setupWindowContentPane(this, contentPane, buttonPane, cancel);
        this.pack();
    }

    private void setDetails(String aDetails) {
        this.setDetailsVisible(false);
        if (aDetails == null || aDetails.trim().isEmpty()) {
            this.detailButton.setVisible(false);
        } else {
            this.details.setText(aDetails);
            this.detailButton.setVisible(true);
        }
    }

    private void setErrorMessage(String aErrorMessage) {
        this.errorMessage.setText(aErrorMessage);
    }

    private void setIncident(IncidentInfo aIncident) {
        this.incidentInfo = aIncident;
        String details = aIncident.getDetailedErrorMessage();
        if (details == null || details.trim().isEmpty()) {
            Throwable error = aIncident.getErrorException();
            if (error != null) {
                StringWriter sw = new StringWriter();
                PrintWriter pw = new PrintWriter(sw);
                error.printStackTrace(pw);
                details = sw.toString();
            } else {
                details = "";
            }
        }
        this.setTitle(aIncident.getHeader());
        this.setErrorMessage(aIncident.getBasicErrorMessage());
        this.setDetails(details);
    }

    static final class SwingUncaughtExceptionHandler
    implements Thread.UncaughtExceptionHandler {
        SwingUncaughtExceptionHandler() {
        }

        public void handle(Throwable aException) {
            this.uncaughtException(Thread.currentThread(), aException);
        }

        @Override
        public void uncaughtException(Thread aThread, Throwable aException) {
            aException.printStackTrace(System.err);
            final Window owner = SwingComponentUtils.getCurrentWindow();
            final IncidentInfo incident = new IncidentInfo("Uncaught exception...", "<html><b>Something unexpected happened!</b><br><br>Click on \"more details\" for more information about the possible cause.<br><br>If the problem persists, please report it as bug.</html>", "", aException);
            Runnable task = new Runnable(){

                @Override
                public void run() {
                    JErrorDialog.showDialog(owner, incident);
                }
            };
            if (SwingUtilities.isEventDispatchThread()) {
                task.run();
            } else {
                SwingUtilities.invokeLater(task);
            }
        }
    }

    static final class IncidentMailReporter {
        private static final int MAGIC_WINDOWS_URI_LIMIT = 1700;
        private final String mailAddress;

        public IncidentMailReporter(String aMailAddress) {
            this.mailAddress = aMailAddress;
        }

        public void reportIncident(IncidentInfo aIncident) {
            String uriStr = String.format("%s?subject=%s&body=%s", this.mailAddress, "Crash Reporter", this.formatIncident(aIncident));
            try {
                URI mailURI;
                if (HostUtils.getHostInfo().isWindows() && uriStr.length() > 1700) {
                    mailURI = new URI("mailto", uriStr.substring(0, 1700), null);
                    uriStr = null;
                } else {
                    mailURI = new URI("mailto", uriStr, null);
                    uriStr = null;
                }
                if (Desktop.isDesktopSupported()) {
                    Desktop.getDesktop().mail(mailURI);
                }
            }
            catch (Exception exception) {
                File report = this.writeIncidentReport(aIncident);
                throw new RuntimeException("Cannot open mail client!\nInstead, the report is written to disk. Please mail the contents of:\n" + report.getPath() + "\nto:\n" + this.mailAddress + ", or post it on <https://github.com/jawi/ols/issues>.");
            }
        }

        private String formatIncident(IncidentInfo aIncident) {
            Throwable error;
            String osName = System.getProperty("os.name", "unknown");
            String osVersion = System.getProperty("os.version", "unknown");
            String processor = System.getProperty("os.arch", "unknown");
            String hostDetails = String.format("%s, %s (%s)", osName, osVersion, processor);
            String javaVendor = System.getProperty("java.vendor", "unknown");
            String javaVersion = System.getProperty("java.version", "unknown");
            String javaDetails = String.format("%s v%s", javaVendor, javaVersion);
            boolean debug = Boolean.parseBoolean(System.getProperty("nl.lxtreme.ols.client.debug", "false"));
            String version = System.getProperty("nl.lxtreme.ols.client.version", "<unknown>");
            StringBuilder body = new StringBuilder();
            body.append("Client version  : ").append(version).append('\n');
            body.append("Java information: ").append(javaDetails).append('\n');
            body.append("Host information: ").append(hostDetails).append('\n');
            if (debug) {
                body.append("Debugging mode is ENABLED!\n");
            }
            if ((error = aIncident.getErrorException()) != null) {
                StringWriter sw = new StringWriter();
                PrintWriter pw = new PrintWriter(sw);
                error.printStackTrace(pw);
                body.append("\nStack trace: ").append("\n-----\n").append(sw.toString()).append("\n-----\n");
            }
            body.append('\n');
            return body.toString();
        }

        private File writeIncidentReport(IncidentInfo aIncident) {
            String reportName = String.format("ols-report-%x.txt", System.nanoTime());
            String homeDir = System.getProperty("user.home");
            File report = new File(homeDir, reportName);
            FileOutputStream fos = null;
            try {
                fos = new FileOutputStream(report);
                fos.write(this.formatIncident(aIncident).getBytes());
                fos.flush();
            }
            catch (IOException exception) {
                throw new RuntimeException("Tried to write an incident report to disk, but even that failed!", exception);
            }
            finally {
                if (fos != null) {
                    try {
                        fos.close();
                    }
                    catch (IOException ignored) {}
                }
            }
            return report;
        }
    }

    public static class IncidentInfo
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private final String header;
        private final String basicErrorMessage;
        private final String detailedErrorMessage;
        private final Throwable errorException;

        public IncidentInfo(String aHeader, String aBasicErrorMessage, String aDetailedErrorMessage) {
            this(aHeader, aBasicErrorMessage, aDetailedErrorMessage, null);
        }

        public IncidentInfo(String aHeader, String aBasicErrorMessage, String aDetailedErrorMessage, Throwable aErrorException) {
            this.header = aHeader;
            this.basicErrorMessage = aBasicErrorMessage != null ? aBasicErrorMessage : (aErrorException != null ? aErrorException.getLocalizedMessage() : "");
            this.detailedErrorMessage = aDetailedErrorMessage;
            this.errorException = aErrorException;
        }

        public IncidentInfo(String aHeader, Throwable aErrorException) {
            this(aHeader, null, null, aErrorException);
        }

        public String getBasicErrorMessage() {
            return this.basicErrorMessage;
        }

        public String getDetailedErrorMessage() {
            return this.detailedErrorMessage;
        }

        public Throwable getErrorException() {
            return this.errorException;
        }

        public String getHeader() {
            return this.header;
        }
    }
}

