/*
 * Decompiled with CFR 0.152.
 */
package nl.lxtreme.ols.device.test;

import java.util.ArrayList;
import java.util.List;

final class OneWireGenerator {
    private static final int OW_LINE = 1;
    private final int sampleRate;
    private final int busSpeed;
    private final int tickSize;
    private final List<Integer> data = new ArrayList<Integer>();
    private final int a;
    private final int b;
    private final int c;
    private final int d;
    private final int e;
    private final int f;
    private final int g;
    private final int h;
    private final int i;
    private final int j;
    private int trigger;

    public OneWireGenerator(boolean aStandard) {
        this.busSpeed = 1000000;
        this.sampleRate = this.busSpeed * 8;
        this.tickSize = (int)Math.rint((double)this.sampleRate / (double)this.busSpeed);
        if (aStandard) {
            this.a = (int)(6.0 * (double)this.tickSize);
            this.b = (int)(64.0 * (double)this.tickSize);
            this.c = (int)(60.0 * (double)this.tickSize);
            this.d = (int)(10.0 * (double)this.tickSize);
            this.e = (int)(9.0 * (double)this.tickSize);
            this.f = (int)(55.0 * (double)this.tickSize);
            this.g = (int)(0.0 * (double)this.tickSize);
            this.h = (int)(480.0 * (double)this.tickSize);
            this.i = (int)(70.0 * (double)this.tickSize);
            this.j = (int)(410.0 * (double)this.tickSize);
        } else {
            this.a = (int)(1.5 * (double)this.tickSize);
            this.b = (int)(7.5 * (double)this.tickSize);
            this.c = (int)(7.5 * (double)this.tickSize);
            this.d = (int)(2.5 * (double)this.tickSize);
            this.e = (int)(0.75 * (double)this.tickSize);
            this.f = (int)(7.0 * (double)this.tickSize);
            this.g = (int)(2.5 * (double)this.tickSize);
            this.h = (int)(70.0 * (double)this.tickSize);
            this.i = (int)(8.5 * (double)this.tickSize);
            this.j = (int)(40.0 * (double)this.tickSize);
        }
    }

    public int[] getData() {
        int size = this.data.size();
        int[] result = new int[size];
        for (int i = 0; i < size; ++i) {
            result[i] = this.data.get(i);
        }
        return result;
    }

    public int getRate() {
        return this.sampleRate;
    }

    public int getTrigger() {
        return this.trigger;
    }

    public void writeBitStream(String aString) {
        this.writeStuffData(5, 1);
        this.writeReset();
        this.writeStuffData(5, 1);
        for (byte b : aString.getBytes()) {
            this.writeByte(b);
        }
        this.writeStuffData(5, 1);
    }

    private int readBit() {
        this.data.add(0);
        this.tickDelay(this.a);
        this.data.add(1);
        this.tickDelay(this.e);
        int result = Math.random() > 0.5 ? 1 : 0;
        this.tickDelay(this.f);
        return result;
    }

    private void tickDelay(int aValue) {
        Integer curValue = this.data.isEmpty() ? Integer.valueOf(1) : this.data.get(this.data.size() - 1);
        for (int i = 1; i < aValue; ++i) {
            this.data.add(curValue);
        }
    }

    private void writeBit(boolean aWriteOne) {
        if (aWriteOne) {
            this.data.add(0);
            this.tickDelay(this.a);
            this.data.add(1);
            this.tickDelay(this.b);
        } else {
            this.data.add(0);
            this.tickDelay(this.c);
            this.data.add(1);
            this.tickDelay(this.d);
        }
    }

    private void writeByte(byte aValue) {
        int value = aValue;
        for (int loop = 0; loop < 8; ++loop) {
            this.writeBit((value & 1) == 1);
            value >>= 1;
        }
    }

    private void writeReset() {
        this.tickDelay(this.g);
        this.data.add(0);
        this.tickDelay(this.h);
        this.data.add(1);
        this.trigger = this.data.size();
        this.tickDelay(this.i - 1);
        this.data.add(Math.random() > 0.3 ? 0 : 1);
        this.tickDelay(this.j - 1);
        this.data.add(1);
        this.data.add(1);
    }

    private void writeStuffData(int aDelay, int aValue) {
        this.data.add(aValue);
        this.tickDelay(aDelay);
    }
}

