/*
 * Decompiled with CFR 0.152.
 */
package nl.lxtreme.ols.device.test;

import java.util.Random;
import nl.lxtreme.ols.api.acquisition.AcquisitionProgressListener;
import nl.lxtreme.ols.api.acquisition.AcquisitionResult;
import nl.lxtreme.ols.api.data.CapturedData;
import nl.lxtreme.ols.api.devices.AcquisitionTask;
import nl.lxtreme.ols.device.test.I2CGenerator;
import nl.lxtreme.ols.device.test.ManchesterEncoder;
import nl.lxtreme.ols.device.test.OneWireGenerator;
import nl.lxtreme.ols.device.test.TestDeviceDialog;

public class TestAcquisitionTask
implements AcquisitionTask {
    private final TestDeviceDialog configDialog;
    private final AcquisitionProgressListener progressListener;

    public TestAcquisitionTask(TestDeviceDialog aConfigDialog, AcquisitionProgressListener aProgressListener) {
        this.configDialog = aConfigDialog;
        this.progressListener = aProgressListener;
    }

    public AcquisitionResult call() throws Exception {
        int[] data;
        String dataFunction = this.configDialog.getDataFunction();
        int dataLength = this.configDialog.getDataLength();
        int channels = this.configDialog.getChannels();
        int rate = 1000000000;
        int trigger = -1;
        int enabledChannels = (int)((1L << channels) - 1L);
        double max = (1L << Math.min(16, channels)) - 1L & 0xFFFFFFFFL;
        double half = max / 2.0;
        double factor = Math.PI * 2 / max;
        if (TestDeviceDialog.DATA_FUNCTIONS[6].equals(dataFunction)) {
            I2CGenerator generator = new I2CGenerator();
            generator.writeBitStream("Hello World, this is a sample I2C bit stream!");
            data = generator.getData();
            rate = generator.getRate();
            trigger = generator.getTrigger();
        } else if (TestDeviceDialog.DATA_FUNCTIONS[7].equals(dataFunction)) {
            OneWireGenerator generator = new OneWireGenerator(true);
            generator.writeBitStream("Hello World, this is a sample 1-wire bit stream!");
            data = generator.getData();
            rate = generator.getRate();
            trigger = generator.getTrigger();
        } else if (TestDeviceDialog.DATA_FUNCTIONS[8].equals(dataFunction)) {
            ManchesterEncoder encoder = new ManchesterEncoder();
            encoder.writeData("Hello World!");
            data = encoder.getData();
            rate = encoder.getRate();
            trigger = encoder.getTrigger();
        } else {
            Random rnd = new Random();
            boolean state = false;
            data = new int[dataLength];
            for (int i = 0; i < data.length; ++i) {
                if (TestDeviceDialog.DATA_FUNCTIONS[0].equals(dataFunction)) {
                    int v = i / 8 & 0xFF;
                    data[i] = 255 - v | v << 8 | 255 - v << 16 | v << 24;
                } else if (TestDeviceDialog.DATA_FUNCTIONS[1].equals(dataFunction)) {
                    data[i] = 0;
                } else if (TestDeviceDialog.DATA_FUNCTIONS[2].equals(dataFunction)) {
                    data[i] = (int)(half + half * Math.sin((double)i * factor));
                    rate = -1;
                } else if (TestDeviceDialog.DATA_FUNCTIONS[3].equals(dataFunction)) {
                    data[i] = i % 2 == 0 ? 85 : 170;
                } else if (TestDeviceDialog.DATA_FUNCTIONS[4].equals(dataFunction)) {
                    data[i] = i % 4 == 0 ? 85 : 170;
                } else if (TestDeviceDialog.DATA_FUNCTIONS[5].equals(dataFunction)) {
                    data[i] = rnd.nextInt();
                } else if (TestDeviceDialog.DATA_FUNCTIONS[9].equals(dataFunction)) {
                    if (i % 4 == 0) {
                        state = !state;
                    }
                    data[i] = state ? 0 : 32768;
                    enabledChannels = 65280;
                }
                this.progressListener.acquisitionInProgress((int)((double)i * 100.0 / (double)data.length));
            }
            trigger = (int)((double)data.length * 0.25);
        }
        return new CapturedData(data, (long)trigger, rate, channels, enabledChannels);
    }
}

