/*
 * Decompiled with CFR 0.152.
 */
package nl.lxtreme.ols.task.execution;

import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import nl.lxtreme.ols.api.task.Task;
import nl.lxtreme.ols.api.task.TaskExecutionService;
import nl.lxtreme.ols.api.task.TaskStatusListener;

public class BackgroundTaskExecutionService
implements TaskExecutionService {
    private static final Logger LOG = Logger.getLogger(BackgroundTaskExecutionService.class.getName());
    private static final int POOL_SIZE = 5;
    private final TaskStatusListener taskStatusListener;
    final ExecutorService executorService;

    public BackgroundTaskExecutionService(TaskStatusListener aTaskStatusListener) {
        this.taskStatusListener = aTaskStatusListener;
        this.executorService = Executors.newFixedThreadPool(5);
    }

    public void close() {
        if (this.executorService.isShutdown()) {
            throw new IllegalStateException("Service already shut down!");
        }
        this.executorService.shutdownNow();
        int tries = 3;
        while (!this.executorService.isTerminated() && tries-- >= 0) {
            try {
                if (!this.executorService.awaitTermination(500L, TimeUnit.MILLISECONDS)) continue;
                LOG.fine("All running threads are terminated ...");
            }
            catch (InterruptedException exception) {
                Thread.currentThread().interrupt();
            }
        }
        LOG.fine("Background task execution service closed ...");
    }

    public <RESULT_TYPE> Future<RESULT_TYPE> execute(final Task<RESULT_TYPE> aTask) {
        if (aTask == null) {
            throw new IllegalArgumentException("Parameter Task cannot be null!");
        }
        Callable task = new Callable<RESULT_TYPE>(){
            private final TaskStatusListener tsl;
            {
                this.tsl = BackgroundTaskExecutionService.this.taskStatusListener;
            }

            @Override
            public RESULT_TYPE call() throws Exception {
                this.tsl.taskStarted(aTask);
                try {
                    Object result = aTask.call();
                    this.tsl.taskEnded(aTask, result);
                    return result;
                }
                catch (Exception exception) {
                    LOG.log(Level.FINE, "Task execution failed!", exception);
                    this.tsl.taskFailed(aTask, exception);
                    throw exception;
                }
            }
        };
        return this.executorService.submit(task);
    }
}

