/*
 * Decompiled with CFR 0.152.
 */
package nl.lxtreme.ols.client;

import java.awt.GraphicsEnvironment;
import java.util.Dictionary;
import java.util.Properties;
import nl.lxtreme.ols.api.DataAcquisitionService;
import nl.lxtreme.ols.api.acquisition.AcquisitionDataListener;
import nl.lxtreme.ols.api.acquisition.AcquisitionProgressListener;
import nl.lxtreme.ols.api.acquisition.AcquisitionStatusListener;
import nl.lxtreme.ols.api.data.annotation.AnnotationListener;
import nl.lxtreme.ols.api.data.export.Exporter;
import nl.lxtreme.ols.api.data.project.ProjectManager;
import nl.lxtreme.ols.api.data.project.UserSettingsManager;
import nl.lxtreme.ols.api.devices.Device;
import nl.lxtreme.ols.api.tools.Tool;
import nl.lxtreme.ols.api.ui.ComponentProvider;
import nl.lxtreme.ols.client.ClientController;
import nl.lxtreme.ols.client.osgi.GenericBundleAdapter;
import nl.lxtreme.ols.client.osgi.UIColorSchemeManager;
import nl.lxtreme.ols.client.osgi.UIManagerConfigurator;
import nl.lxtreme.ols.client.osgi.UserSessionManager;
import nl.lxtreme.ols.util.ApplicationCallback;
import nl.lxtreme.ols.util.HostProperties;
import org.apache.felix.dm.Dependency;
import org.apache.felix.dm.DependencyActivatorBase;
import org.apache.felix.dm.DependencyManager;
import org.osgi.framework.BundleContext;
import org.osgi.service.cm.ManagedService;
import org.osgi.service.cm.ManagedServiceFactory;
import org.osgi.service.log.LogService;
import org.osgi.service.prefs.PreferencesService;

public class Activator
extends DependencyActivatorBase {
    private static final String OLS_TOOL_MAGIC_KEY = "OLS-Tool";
    private static final String OLS_TOOL_MAGIC_VALUE = "1.0";
    private static final String OLS_TOOL_CLASS_KEY = "OLS-ToolClass";
    private static final String TOOL_BUNDLE_FILTER = String.format("(&(%s=%s)(%s=*))", "OLS-Tool", "1.0", "OLS-ToolClass");
    private static final String OLS_DEVICE_MAGIC_KEY = "OLS-Device";
    private static final String OLS_DEVICE_MAGIC_VALUE = "1.0";
    private static final String OLS_DEVICE_CLASS_KEY = "OLS-DeviceClass";
    private static final String DEVICE_BUNDLE_FILTER = String.format("(&(%s=%s)(%s=*))", "OLS-Device", "1.0", "OLS-DeviceClass");
    private static final String OLS_EXPORTER_MAGIC_KEY = "OLS-Exporter";
    private static final String OLS_EXPORTER_MAGIC_VALUE = "1.0";
    private static final String OLS_EXPORTER_CLASS_KEY = "OLS-ExporterClass";
    private static final String EXPORTER_BUNDLE_FILTER = String.format("(&(%s=%s)(%s=*))", "OLS-Exporter", "1.0", "OLS-ExporterClass");
    private static final String OLS_COMPONENT_PROVIDER_MAGIC_KEY = "OLS-ComponentProvider";
    private static final String OLS_COMPONENT_PROVIDER_MAGIC_VALUE = "Menu";
    private static final String OLS_COMPONENT_PROVIDER_CLASS_KEY = "OLS-ComponentProviderClass";
    private static final String CP_BUNDLE_FILTER = String.format("(&(%s=%s)(%s=*))", "OLS-ComponentProvider", "Menu", "OLS-ComponentProviderClass");

    public static boolean isDebugMode() {
        return Boolean.parseBoolean(System.getProperty("nl.lxtreme.ols.client.debug", "false"));
    }

    public void destroy(BundleContext aContext, DependencyManager aManager) throws Exception {
    }

    public void init(BundleContext aContext, DependencyManager aManager) throws Exception {
        if (GraphicsEnvironment.isHeadless()) {
            throw new RuntimeException("Cannot start client: running headless.");
        }
        ClientController clientController = new ClientController(aContext);
        aManager.add(this.createBundleAdapterService(32, CP_BUNDLE_FILTER, true).setImplementation(ComponentProviderBundleAdapter.class));
        aManager.add(this.createBundleAdapterService(32, TOOL_BUNDLE_FILTER, true).setImplementation(ToolBundleAdapter.class));
        aManager.add(this.createBundleAdapterService(32, DEVICE_BUNDLE_FILTER, true).setImplementation(DeviceBundleAdapter.class));
        aManager.add(this.createBundleAdapterService(32, EXPORTER_BUNDLE_FILTER, true).setImplementation(ExporterBundleAdapter.class));
        Properties props = new Properties();
        props.put("service.pid", "ols.ui.defaults");
        String[] serviceNames = new String[]{UIManagerConfigurator.class.getName(), ManagedService.class.getName()};
        aManager.add(this.createComponent().setInterface(serviceNames, (Dictionary)props).setImplementation(UIManagerConfigurator.class));
        props.put("service.pid", "ols.ui.colorscheme");
        serviceNames = new String[]{UIColorSchemeManager.class.getName(), ManagedServiceFactory.class.getName()};
        aManager.add(this.createComponent().setInterface(serviceNames, (Dictionary)props).setImplementation(UIColorSchemeManager.class));
        aManager.add(this.createComponent().setImplementation((Object)new UserSessionManager()).add((Dependency)this.createServiceDependency().setService(ProjectManager.class).setRequired(true)).add((Dependency)this.createServiceDependency().setService(UserSettingsManager.class).setRequired(true)).add((Dependency)this.createServiceDependency().setService(PreferencesService.class).setRequired(true)).add((Dependency)this.createServiceDependency().setService(LogService.class).setRequired(false)));
        serviceNames = new String[]{AcquisitionDataListener.class.getName(), AcquisitionProgressListener.class.getName(), AcquisitionStatusListener.class.getName(), AnnotationListener.class.getName(), ApplicationCallback.class.getName()};
        aManager.add(this.createComponent().setInterface(serviceNames, null).setImplementation((Object)clientController).add((Dependency)this.createServiceDependency().setService(HostProperties.class).setRequired(true)).add((Dependency)this.createServiceDependency().setService(ProjectManager.class).setRequired(true).setCallbacks("setProjectManager", "removeProjectManager")).add((Dependency)this.createServiceDependency().setService(DataAcquisitionService.class).setRequired(true)).add((Dependency)this.createServiceDependency().setService(UIColorSchemeManager.class).setRequired(true)).add((Dependency)this.createServiceDependency().setService(ComponentProvider.class, "(OLS-ComponentProvider=Menu)").setCallbacks("addMenu", "removeMenu").setRequired(false)).add((Dependency)this.createServiceDependency().setService(Device.class).setCallbacks("addDevice", "removeDevice").setRequired(false)).add((Dependency)this.createServiceDependency().setService(Tool.class).setCallbacks("addTool", "removeTool").setRequired(false)).add((Dependency)this.createServiceDependency().setService(Exporter.class).setCallbacks("addExporter", "removeExporter").setRequired(false)).add((Dependency)this.createConfigurationDependency().setPid("ols.ui.defaults")));
    }

    static class ToolBundleAdapter
    extends GenericBundleAdapter<Tool> {
        public ToolBundleAdapter() {
            super(Tool.class, Activator.OLS_TOOL_CLASS_KEY);
        }
    }

    static class ExporterBundleAdapter
    extends GenericBundleAdapter<Exporter> {
        public ExporterBundleAdapter() {
            super(Exporter.class, Activator.OLS_EXPORTER_CLASS_KEY);
        }
    }

    static class DeviceBundleAdapter
    extends GenericBundleAdapter<Device> {
        public DeviceBundleAdapter() {
            super(Device.class, Activator.OLS_DEVICE_CLASS_KEY);
        }
    }

    static class ComponentProviderBundleAdapter
    extends GenericBundleAdapter<ComponentProvider> {
        public ComponentProviderBundleAdapter() {
            super(ComponentProvider.class, Activator.OLS_COMPONENT_PROVIDER_CLASS_KEY);
        }
    }
}

