/*
 * Decompiled with CFR 0.152.
 */
package nl.lxtreme.ols.client;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Image;
import java.awt.Point;
import java.awt.Window;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JToolBar;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.MenuEvent;
import javax.swing.event.MenuListener;
import javax.swing.plaf.ScrollPaneUI;
import nl.lxtreme.ols.api.Configurable;
import nl.lxtreme.ols.api.UserSettings;
import nl.lxtreme.ols.api.data.Cursor;
import nl.lxtreme.ols.api.data.project.Project;
import nl.lxtreme.ols.client.ClientController;
import nl.lxtreme.ols.client.DockController;
import nl.lxtreme.ols.client.about.AboutBox;
import nl.lxtreme.ols.client.action.ExportAction;
import nl.lxtreme.ols.client.action.FocusWindowAction;
import nl.lxtreme.ols.client.action.GotoNthCursorAction;
import nl.lxtreme.ols.client.action.MinimizeWindowAction;
import nl.lxtreme.ols.client.action.RunToolAction;
import nl.lxtreme.ols.client.action.SelectDeviceAction;
import nl.lxtreme.ols.client.icons.IconFactory;
import nl.lxtreme.ols.client.signaldisplay.SignalDiagramComponent;
import nl.lxtreme.ols.client.signaldisplay.SignalDiagramController;
import nl.lxtreme.ols.client.signaldisplay.ZoomController;
import nl.lxtreme.ols.util.HostInfo;
import nl.lxtreme.ols.util.HostProperties;
import nl.lxtreme.ols.util.HostUtils;
import nl.lxtreme.ols.util.NumberUtils;
import nl.lxtreme.ols.util.StringUtils;
import nl.lxtreme.ols.util.swing.StandardActionFactory;
import nl.lxtreme.ols.util.swing.component.JTextStatusBar;

public final class MainFrame
extends JFrame
implements StandardActionFactory.CloseAction.Closeable,
PropertyChangeListener,
Configurable {
    private static final long serialVersionUID = 1L;
    private static final String PERSISTENT_MENU_ITEM_KEY = "persistentMenuItem";
    private final SignalDiagramComponent signalDiagram;
    private final JTextStatusBar status;
    private final ClientController controller;
    private final DockController dockController;
    private JMenu deviceMenu;
    private JMenu toolsMenu;
    private JMenu windowMenu;
    private JMenu exportMenu;
    private JMenu cursorsMenu;
    private volatile String lastSelectedDeviceName;

    public MainFrame(DockController aDockController, ClientController aClientController) {
        this.controller = aClientController;
        this.dockController = aDockController;
        this.setLocationByPlatform(true);
        this.setDefaultCloseOperation(0);
        this.setSize(1024, 600);
        this.setIconImages(this.internalGetIconImages());
        SignalDiagramController signalDiagramController = this.controller.getSignalDiagramController();
        this.signalDiagram = signalDiagramController.getSignalDiagram();
        this.status = new JTextStatusBar();
        JToolBar tools = this.createMenuBars();
        this.dockController.setMainContent(new ZoomCapableScrollPane(signalDiagramController));
        JPanel contentPane = new JPanel(new BorderLayout());
        contentPane.add((Component)tools, "First");
        contentPane.add(this.dockController.get(), "Center");
        contentPane.add((Component)this.status, "Last");
        this.setContentPane(contentPane);
        this.addWindowListener(new MainFrameListener());
        this.dockController.start();
    }

    public void close() {
        this.setVisible(false);
        this.dispose();
        this.dockController.stop();
        this.controller.exit();
    }

    public final String getSelectedDeviceName() {
        return this.lastSelectedDeviceName;
    }

    public void gotoPosition(int aChannelIdx, long aSamplePos) {
        this.signalDiagram.scrollToTimestamp(aSamplePos);
    }

    @Override
    public void propertyChange(PropertyChangeEvent aEvent) {
        String propertyName = aEvent.getPropertyName();
        if ("project".equals(propertyName)) {
            Project project = (Project)aEvent.getNewValue();
            this.updateWindowDecorations(project);
        } else if ("capturedData".equals(propertyName)) {
            this.updateWindowDecorations(this.controller.getCurrentProject());
        }
        this.controller.updateActionsOnEDT();
    }

    public void readPreferences(UserSettings aSettings) {
        this.controller.selectDevice(aSettings.get("selectedDevice", "OpenBench LogicSniffer"));
    }

    public void setProgress(int aPercentage) {
        this.status.setProgress(aPercentage);
    }

    public void setStatus(String aMessage, Object ... aMessageArgs) {
        String message = aMessage;
        if (aMessageArgs != null && aMessageArgs.length > 0) {
            message = MessageFormat.format(message, aMessageArgs);
        }
        this.status.setText(message);
        this.status.setProgress(0);
    }

    public void showAboutBox() {
        HostProperties hostProperties = this.controller.getHostProperties();
        AboutBox aboutDialog = new AboutBox(hostProperties.getShortName(), hostProperties.getVersion());
        aboutDialog.showDialog();
    }

    public void writePreferences(UserSettings aSettings) {
        String selectedDevice = this.lastSelectedDeviceName != null ? this.lastSelectedDeviceName : "";
        aSettings.put("selectedDevice", selectedDevice);
    }

    final void diagramSettingsUpdated() {
        this.signalDiagram.revalidate();
    }

    final JComponent getDiagramScrollPane() {
        Container viewport = this.signalDiagram.getParent();
        return (JComponent)viewport.getParent();
    }

    final void setSelectedDeviceName(String aSelectedDeviceName) {
        this.lastSelectedDeviceName = aSelectedDeviceName;
    }

    private JToolBar createMenuBars() {
        JMenuBar bar = new JMenuBar();
        this.setJMenuBar(bar);
        this.exportMenu = new JMenu("Export ...");
        this.exportMenu.setMnemonic('e');
        this.exportMenu.addMenuListener(new ExportMenuBuilder(this.controller));
        JMenu fileMenu = new JMenu("File");
        fileMenu.setMnemonic('F');
        bar.add(fileMenu);
        fileMenu.add(this.controller.getAction("NewProject"));
        fileMenu.add(this.controller.getAction("OpenProject"));
        fileMenu.add(this.controller.getAction("SaveProject"));
        fileMenu.add(this.controller.getAction("SaveProjectAs"));
        fileMenu.addSeparator();
        fileMenu.add(this.controller.getAction("OpenDataFile"));
        fileMenu.add(this.controller.getAction("SaveDataFile"));
        fileMenu.addSeparator();
        fileMenu.add(this.exportMenu);
        HostInfo hostInfo = HostUtils.getHostInfo();
        if (hostInfo.needsExitMenuItem()) {
            fileMenu.add(new JSeparator());
            fileMenu.add(this.controller.getAction("Exit"));
        }
        if (hostInfo.needsPreferencesMenuItem()) {
            JMenu editMenu = bar.add(new JMenu("Edit"));
            editMenu.setMnemonic('E');
            editMenu.add(this.controller.getAction("ShowPreferencesDialogAction"));
        }
        JMenu captureMenu = bar.add(new JMenu("Capture"));
        captureMenu.setMnemonic('C');
        this.deviceMenu = new JMenu("Device");
        this.deviceMenu.setMnemonic('D');
        this.deviceMenu.addMenuListener(new DeviceMenuBuilder(this.controller, this));
        captureMenu.add(this.controller.getAction("Capture"));
        captureMenu.add(this.controller.getAction("RepeatCapture"));
        captureMenu.add(this.controller.getAction("CancelCapture"));
        captureMenu.addSeparator();
        captureMenu.add(this.deviceMenu);
        JMenu diagramMenu = bar.add(new JMenu("Diagram"));
        diagramMenu.setMnemonic('D');
        diagramMenu.add(this.controller.getAction("ZoomIn"));
        diagramMenu.add(this.controller.getAction("ZoomOut"));
        diagramMenu.add(this.controller.getAction("ZoomDefault"));
        diagramMenu.add(this.controller.getAction("ZoomFit"));
        diagramMenu.addSeparator();
        diagramMenu.add(this.controller.getAction("GotoTrigger"));
        diagramMenu.addSeparator();
        diagramMenu.add(new JCheckBoxMenuItem(this.controller.getAction("SetCursorMode")));
        diagramMenu.add(new JCheckBoxMenuItem(this.controller.getAction("SnapCursors")));
        diagramMenu.add(this.controller.getAction("DeleteAllCursors"));
        diagramMenu.add(this.controller.getAction("GotoFirstCursor"));
        diagramMenu.add(this.controller.getAction("GotoLastCursor"));
        this.cursorsMenu = new JMenu("Cursors");
        this.cursorsMenu.setMnemonic('C');
        this.cursorsMenu.addMenuListener(new CursorMenuBuilder(this.controller));
        diagramMenu.add(this.cursorsMenu);
        diagramMenu.addSeparator();
        diagramMenu.add(this.controller.getAction("RemoveAnnotations"));
        diagramMenu.add(this.controller.getAction("ShowManagerViewAction"));
        this.toolsMenu = bar.add(new JMenu("Tools"));
        this.toolsMenu.setMnemonic('T');
        this.toolsMenu.add(new JCheckBoxMenuItem(this.controller.getAction("SetMeasurementMode"))).putClientProperty(PERSISTENT_MENU_ITEM_KEY, Boolean.TRUE);
        this.toolsMenu.addSeparator();
        this.toolsMenu.addMenuListener(new ToolMenuBuilder(this.controller));
        if (hostInfo.isMacOS()) {
            this.windowMenu = bar.add(new JMenu("Window"));
            this.windowMenu.setMnemonic('W');
            this.windowMenu.add(new JMenuItem(StandardActionFactory.createCloseAction())).putClientProperty(PERSISTENT_MENU_ITEM_KEY, Boolean.TRUE);
            this.windowMenu.add(new JMenuItem(new MinimizeWindowAction())).putClientProperty(PERSISTENT_MENU_ITEM_KEY, Boolean.TRUE);
            this.windowMenu.addSeparator();
            this.windowMenu.addMenuListener(new WindowMenuBuilder(this.controller));
        }
        JMenu helpMenu = bar.add(new JMenu("Help"));
        helpMenu.setMnemonic('H');
        helpMenu.add(this.controller.getAction("ShowBundles"));
        if (hostInfo.needsAboutMenuItem()) {
            helpMenu.addSeparator();
            helpMenu.add(this.controller.getAction("HelpAbout"));
        }
        JToolBar toolbar = new JToolBar();
        toolbar.setRollover(true);
        toolbar.setFloatable(false);
        toolbar.add(this.controller.getAction("OpenProject"));
        toolbar.add(this.controller.getAction("SaveProject"));
        toolbar.addSeparator();
        toolbar.add(this.controller.getAction("Capture"));
        toolbar.add(this.controller.getAction("CancelCapture"));
        toolbar.add(this.controller.getAction("RepeatCapture"));
        toolbar.addSeparator();
        toolbar.add(this.controller.getAction("ZoomIn"));
        toolbar.add(this.controller.getAction("ZoomOut"));
        toolbar.add(this.controller.getAction("ZoomDefault"));
        toolbar.add(this.controller.getAction("ZoomFit"));
        toolbar.addSeparator();
        toolbar.add(this.controller.getAction("GotoTrigger"));
        for (int c = 0; c < 10; ++c) {
            toolbar.add(this.controller.getAction(GotoNthCursorAction.getID(c)));
        }
        return toolbar;
    }

    private List<? extends Image> internalGetIconImages() {
        Image windowIcon16x16 = IconFactory.createImage("LogicSniffer_16x16x32.png");
        Image windowIcon32x32 = IconFactory.createImage("LogicSniffer_32x32x32.png");
        Image windowIcon48x48 = IconFactory.createImage("LogicSniffer_48x48x32.png");
        Image windowIcon64x64 = IconFactory.createImage("LogicSniffer_64x64x32.png");
        Image windowIcon256x256 = IconFactory.createImage("LogicSniffer_256x256x32.png");
        return Arrays.asList(windowIcon16x16, windowIcon32x32, windowIcon48x48, windowIcon64x64, windowIcon256x256);
    }

    private void updateWindowDecorations(Project aProject) {
        String title = this.controller.getHostProperties().getFullName();
        if (aProject != null && !StringUtils.isEmpty((String)aProject.getName())) {
            title = title.concat(" :: ").concat(aProject.getName());
        }
        this.setTitle(title);
        this.getRootPane().putClientProperty("Window.documentModified", aProject.isChanged());
    }

    static class ZoomCapableScrollPane
    extends JScrollPane
    implements MouseWheelListener {
        private static final long serialVersionUID = 1L;
        private final MouseWheelZoomAdapter zoomAdapter;
        private volatile List<MouseWheelListener> originalListeners;

        public ZoomCapableScrollPane(SignalDiagramController aController) {
            super(aController.getSignalDiagram());
            this.zoomAdapter = new MouseWheelZoomAdapter(aController.getZoomController(), aController);
            this.setHorizontalScrollBarPolicy(30);
            this.setVerticalScrollBarPolicy(20);
            this.updateUI();
        }

        @Override
        public synchronized void addMouseWheelListener(MouseWheelListener aListener) {
            this.lazyInitListeners();
            this.originalListeners.add(aListener);
            super.addMouseWheelListener(aListener);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public void mouseWheelMoved(MouseWheelEvent aEvent) {
            if (this.isZoomEvent(aEvent)) {
                this.zoomAdapter.mouseWheelMoved(aEvent);
                return;
            }
            MouseWheelListener[] mouseWheelListenerArray = this.originalListeners;
            synchronized (this.originalListeners) {
                MouseWheelListener[] listeners = this.originalListeners.toArray(new MouseWheelListener[this.originalListeners.size()]);
                // ** MonitorExit[var3_2] (shouldn't be in output)
                for (MouseWheelListener listener : listeners) {
                    listener.mouseWheelMoved(aEvent);
                }
                return;
            }
        }

        @Override
        public synchronized void removeMouseWheelListener(MouseWheelListener aListener) {
            this.lazyInitListeners();
            this.originalListeners.remove(aListener);
            super.removeMouseWheelListener(aListener);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void setUI(ScrollPaneUI aNewUI) {
            super.setUI(aNewUI);
            boolean installAdapter = true;
            List<MouseWheelListener> list = this.originalListeners;
            synchronized (list) {
                MouseWheelListener[] listeners;
                this.lazyInitListeners();
                this.originalListeners.clear();
                for (MouseWheelListener listener : listeners = (MouseWheelListener[])this.getListeners(MouseWheelListener.class)) {
                    if (listener == this) {
                        installAdapter = false;
                        continue;
                    }
                    this.removeMouseWheelListener(listener);
                    this.originalListeners.add(listener);
                }
            }
            if (installAdapter) {
                super.addMouseWheelListener(this);
            }
        }

        private int getMouseWheelZoomModifier() {
            HostInfo hostInfo = HostUtils.getHostInfo();
            if (hostInfo.isMacOS()) {
                return 256;
            }
            return 128;
        }

        private boolean isMouseWheelZoomDefault() {
            return UIManager.getBoolean("ols.mousewheel.zoom.default.boolean");
        }

        private boolean isZoomEvent(MouseWheelEvent aEvent) {
            if (aEvent == null) {
                return false;
            }
            boolean invert = this.isMouseWheelZoomDefault();
            int modifier = this.getMouseWheelZoomModifier();
            int result = aEvent.getModifiersEx() & modifier;
            return invert ? result == 0 : result != 0;
        }

        private void lazyInitListeners() {
            if (this.originalListeners == null) {
                this.originalListeners = new ArrayList<MouseWheelListener>();
            }
        }
    }

    static class WindowMenuBuilder
    extends AbstractMenuBuilder {
        public WindowMenuBuilder(ClientController aController) {
            super(aController);
        }

        @Override
        protected JMenuItem createMenuItem(String aWindowName) {
            return new JCheckBoxMenuItem(new FocusWindowAction(aWindowName));
        }

        @Override
        protected String[] getMenuItemNames() {
            Window[] windows = Window.getWindows();
            ArrayList<String> titles = new ArrayList<String>();
            for (Window window : windows) {
                if (!window.isDisplayable()) continue;
                titles.add(FocusWindowAction.getTitle(window));
            }
            return titles.toArray(new String[titles.size()]);
        }

        @Override
        protected String getNoItemsName() {
            return "No windows.";
        }
    }

    static class ToolMenuBuilder
    extends AbstractMenuBuilder {
        public ToolMenuBuilder(ClientController aController) {
            super(aController);
        }

        @Override
        protected JMenuItem createMenuItem(String aToolName) {
            return new JMenuItem(this.controller.getAction(RunToolAction.getID(aToolName)));
        }

        @Override
        protected String[] getMenuItemNames() {
            return this.controller.getToolNames();
        }

        @Override
        protected String getNoItemsName() {
            return "No tools.";
        }
    }

    static class MouseWheelZoomAdapter
    implements MouseWheelListener {
        private final SignalDiagramController controller;
        private final ZoomController zoomController;

        public MouseWheelZoomAdapter(ZoomController aZoomController, SignalDiagramController aController) {
            this.zoomController = aZoomController;
            this.controller = aController;
        }

        @Override
        public void mouseWheelMoved(MouseWheelEvent aEvent) {
            SignalDiagramComponent view = this.controller.getSignalDiagram();
            Point newPoint = SwingUtilities.convertPoint(aEvent.getComponent(), aEvent.getPoint(), view);
            this.zoomController.zoom(aEvent.getWheelRotation(), newPoint);
            aEvent.consume();
        }
    }

    static class MainFrameListener
    extends WindowAdapter {
        MainFrameListener() {
        }

        @Override
        public void windowClosing(WindowEvent aEvent) {
            MainFrame mainFrame = (MainFrame)aEvent.getSource();
            mainFrame.close();
        }
    }

    static class ExportMenuBuilder
    extends AbstractMenuBuilder {
        public ExportMenuBuilder(ClientController aController) {
            super(aController);
        }

        @Override
        protected JMenuItem createMenuItem(String aExporterName) {
            return new JMenuItem(new ExportAction(this.controller, aExporterName));
        }

        @Override
        protected String[] getMenuItemNames() {
            return this.controller.getExporterNames();
        }

        @Override
        protected String getNoItemsName() {
            return "No exporters.";
        }
    }

    static class DeviceMenuBuilder
    extends AbstractMenuBuilder {
        private final MainFrame mainFrame;

        public DeviceMenuBuilder(ClientController aController, MainFrame aMainFrame) {
            super(aController);
            this.mainFrame = aMainFrame;
        }

        @Override
        protected JMenuItem createMenuItem(String aDeviceName) {
            Action action = this.controller.getAction(SelectDeviceAction.getID(aDeviceName));
            action.putValue("SwingSelectedKey", this.isDeviceToBeSelected(aDeviceName));
            return new JRadioButtonMenuItem(action);
        }

        @Override
        protected String[] getMenuItemNames() {
            return this.controller.getDeviceNames();
        }

        @Override
        protected String getNoItemsName() {
            return "No devices.";
        }

        private Boolean isDeviceToBeSelected(String aDeviceName) {
            return aDeviceName.equals(this.mainFrame.lastSelectedDeviceName);
        }
    }

    static class CursorMenuBuilder
    extends AbstractMenuBuilder {
        public CursorMenuBuilder(ClientController aController) {
            super(aController);
        }

        @Override
        protected JMenuItem createMenuItem(String aName) {
            int idx = NumberUtils.safeParseInt((String)aName);
            if (idx >= 0) {
                Action action = this.controller.getAction(GotoNthCursorAction.getID(idx));
                return new JMenuItem(action);
            }
            return null;
        }

        @Override
        protected String[] getMenuItemNames() {
            Cursor[] cursors = this.controller.getCurrentDataSet().getCursors();
            ArrayList<String> result = new ArrayList<String>();
            for (Cursor cursor : cursors) {
                if (!cursor.isDefined()) continue;
                result.add(Integer.toString(cursor.getIndex()));
            }
            return result.toArray(new String[result.size()]);
        }

        @Override
        protected String getNoItemsName() {
            return "No cursors set.";
        }
    }

    static abstract class AbstractMenuBuilder
    implements MenuListener {
        private static final Logger LOG = Logger.getLogger(AbstractMenuBuilder.class.getName());
        protected final ClientController controller;
        private final ButtonGroup group = new ButtonGroup();

        public AbstractMenuBuilder(ClientController aController) {
            this.controller = aController;
        }

        @Override
        public void menuCanceled(MenuEvent aEvent) {
        }

        @Override
        public void menuDeselected(MenuEvent aEvent) {
        }

        @Override
        public void menuSelected(MenuEvent aEvent) {
            JMenu menu = (JMenu)aEvent.getSource();
            String[] names = this.getMenuItemNames();
            if (names.length == 0) {
                int size = menu.getItemCount();
                for (int i = 0; i < size; ++i) {
                    JMenuItem item = menu.getItem(i);
                    if (item instanceof AbstractButton) {
                        this.group.remove(item);
                    }
                    menu.remove(item);
                }
                JMenuItem noDevicesItem = new JMenuItem(this.getNoItemsName());
                noDevicesItem.setEnabled(false);
                menu.add(noDevicesItem);
            } else {
                for (String name : names = this.removeObsoleteMenuItems(menu, names)) {
                    try {
                        JMenuItem menuItem = this.createMenuItem(name);
                        if (menuItem == null) continue;
                        this.group.add(menuItem);
                        menu.add(menuItem);
                    }
                    catch (Exception exception) {
                        LOG.log(Level.FINE, "Exception thrown while creating menu item!", exception);
                    }
                }
            }
            this.controller.updateActionsOnEDT();
        }

        protected abstract JMenuItem createMenuItem(String var1);

        protected abstract String[] getMenuItemNames();

        protected abstract String getNoItemsName();

        private boolean isPersistentMenuItem(JMenuItem aMenuItem) {
            Object isPersistent = aMenuItem.getClientProperty(MainFrame.PERSISTENT_MENU_ITEM_KEY);
            return Boolean.TRUE.equals(isPersistent);
        }

        private String[] removeObsoleteMenuItems(JMenu aMenu, String[] aMenuItems) {
            ArrayList<String> result = new ArrayList<String>(Arrays.asList(aMenuItems));
            for (int i = aMenu.getItemCount() - 1; i >= 0; --i) {
                JMenuItem menuItem = aMenu.getItem(i);
                if (menuItem == null) continue;
                String itemText = menuItem.getText();
                if (!result.contains(itemText) && !this.isPersistentMenuItem(menuItem)) {
                    aMenu.remove(i);
                    continue;
                }
                result.remove(itemText);
            }
            return result.toArray(new String[result.size()]);
        }
    }
}

