/*
 * Decompiled with CFR 0.152.
 */
package nl.lxtreme.ols.client;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Window;
import java.io.IOException;
import java.util.Dictionary;
import java.util.List;
import java.util.Properties;
import javax.swing.AbstractListModel;
import javax.swing.ComboBoxModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.SpringLayout;
import nl.lxtreme.ols.client.osgi.UIColorSchemeManager;
import nl.lxtreme.ols.client.signaldisplay.model.SignalDiagramModel;
import nl.lxtreme.ols.util.ColorUtils;
import nl.lxtreme.ols.util.swing.SpringLayoutUtils;
import nl.lxtreme.ols.util.swing.StandardActionFactory;
import nl.lxtreme.ols.util.swing.SwingComponentUtils;
import nl.lxtreme.ols.util.swing.component.EnumItemRenderer;
import nl.lxtreme.ols.util.swing.component.JErrorDialog;
import org.osgi.service.cm.Configuration;
import org.osgi.service.cm.ConfigurationAdmin;

public class PreferencesDialog
extends JDialog
implements StandardActionFactory.StatusAwareCloseableDialog {
    private static final long serialVersionUID = 1L;
    private final UIColorSchemeManager colorSchemeManager;
    private final JCheckBox mouseWheelZooms;
    private final JCheckBox cursorSnapToEdge;
    private final JCheckBox showGroupSummary;
    private final JCheckBox showAnalogScope;
    private final JCheckBox showToolWindows;
    private final JCheckBox showChannelIndexes;
    private final JCheckBox retainAnnotations;
    private final JCheckBox autoCenterCapture;
    private final JComboBox annotationAlignment;
    private final JComboBox signalAlignment;
    private final JComboBox colorScheme;
    private volatile boolean dialogResult;
    private volatile ConfigurationAdmin configAdmin;
    private volatile Configuration config;

    public PreferencesDialog(Window aParent, UIColorSchemeManager aColorSchemeManager) {
        super(aParent, "", Dialog.ModalityType.APPLICATION_MODAL);
        this.colorSchemeManager = aColorSchemeManager;
        this.mouseWheelZooms = new JCheckBox();
        this.mouseWheelZooms.setToolTipText("Whether the mouse wheel by default zooms in or out, or scrolls the view. Will be applied immediately.");
        this.cursorSnapToEdge = new JCheckBox();
        this.cursorSnapToEdge.setToolTipText("Whether or not cursors by default snap to signal edges. Will be applied immediately.");
        this.showGroupSummary = new JCheckBox();
        this.showGroupSummary.setToolTipText("Whether or not the group (byte) summary is shown by default for each acquisition. Will be applied after an acquisition.");
        this.showAnalogScope = new JCheckBox();
        this.showAnalogScope.setToolTipText("Whether or not the analog scope is shown by default for each acquisition. Will be applied after an acquisition.");
        this.showChannelIndexes = new JCheckBox();
        this.showChannelIndexes.setToolTipText("Whether or not channel indexes are shown beside the labels. Will be applied immediately.");
        this.retainAnnotations = new JCheckBox();
        this.retainAnnotations.setToolTipText("Whether or not annotations should be retained after a recapture. Will be applied immediately.");
        this.showToolWindows = new JCheckBox();
        this.showToolWindows.setToolTipText("Whether or not the tool windows are shown by default. Will be applied after a restart.");
        this.autoCenterCapture = new JCheckBox();
        this.autoCenterCapture.setToolTipText("Whether or not to auto-center the diagram to the trigger after a capture. Will be applied immediately.");
        this.signalAlignment = new JComboBox<SignalDiagramModel.SignalAlignment>(SignalDiagramModel.SignalAlignment.values());
        this.signalAlignment.setToolTipText("The vertical alignment of the signals itself. Will be applied after an acquisition.");
        this.signalAlignment.setRenderer(new SignalAlignmentRenderer());
        this.annotationAlignment = new JComboBox<SignalDiagramModel.SignalAlignment>(SignalDiagramModel.SignalAlignment.values());
        this.annotationAlignment.setToolTipText("The vertical aligment of the annotations. Will be applied immediately.");
        this.annotationAlignment.setRenderer(new SignalAlignmentRenderer());
        this.colorScheme = new JComboBox(new ColorSchemeModel());
        this.colorScheme.setToolTipText("What color scheme is to be used. Will be applied immediately.");
        this.buildDialog();
    }

    public void close() {
        this.setVisible(false);
        this.dispose();
        if (this.dialogResult) {
            try {
                this.applyNewPreferences();
            }
            catch (IOException exception) {
                JErrorDialog.showDialog((Window)this.getOwner(), (String)"Failed to apply preferences!", (Throwable)exception);
            }
        }
    }

    public boolean setDialogStatus(StandardActionFactory.DialogStatus aStatus) {
        this.dialogResult = aStatus == StandardActionFactory.DialogStatus.OK;
        return true;
    }

    public boolean showDialog() {
        this.dialogResult = false;
        this.setVisible(true);
        return this.dialogResult;
    }

    protected void start() throws IOException {
        this.config = this.configAdmin.getConfiguration("ols.ui.defaults");
        Dictionary properties = this.config.getProperties();
        this.mouseWheelZooms.setSelected(this.getBoolean(properties.get("ols.mousewheel.zoom.default.boolean")));
        this.cursorSnapToEdge.setSelected(this.getBoolean(properties.get("ols.snap.cursors.default.boolean")));
        this.showGroupSummary.setSelected(this.getBoolean(properties.get("ols.groupsummary.default.visible.boolean")));
        this.showAnalogScope.setSelected(this.getBoolean(properties.get("ols.analogscope.default.visible.boolean")));
        this.showChannelIndexes.setSelected(this.getBoolean(properties.get("ols.channellabels.show.channel.index.boolean")));
        this.retainAnnotations.setSelected(this.getBoolean(properties.get("ols.retain.annotations.boolean")));
        this.showToolWindows.setSelected(this.getBoolean(properties.get("ols.show.tool.windows.default.boolean")));
        this.autoCenterCapture.setSelected(this.getBoolean(properties.get("ols.trigger.auto.center.boolean")));
        this.signalAlignment.setSelectedItem((Object)this.getSignalAlignment(properties.get("ols.signal.alignment.enum")));
        this.annotationAlignment.setSelectedItem((Object)this.getSignalAlignment(properties.get("ols.signal.annotation.alignment.enum")));
        this.colorScheme.setSelectedItem(String.valueOf(properties.get("ols.current.color.scheme.enum")));
    }

    protected void stop() {
    }

    private void applyNewColorScheme(String colorScheme, Dictionary<String, Object> dictionary) {
        dictionary.put("ols.current.color.scheme.enum", colorScheme);
        Properties props = this.colorSchemeManager.getColorScheme(colorScheme);
        if (props == null) {
            return;
        }
        for (Object key : props.keySet()) {
            Object value = props.get(key);
            if (!(value instanceof Color)) continue;
            dictionary.put((String)key, ColorUtils.toHexString((Color)((Color)value)));
        }
    }

    private void applyNewPreferences() throws IOException {
        Dictionary properties = this.config.getProperties();
        properties.put("ols.mousewheel.zoom.default.boolean", Boolean.toString(this.mouseWheelZooms.isSelected()));
        properties.put("ols.snap.cursors.default.boolean", Boolean.toString(this.cursorSnapToEdge.isSelected()));
        properties.put("ols.groupsummary.default.visible.boolean", Boolean.toString(this.showGroupSummary.isSelected()));
        properties.put("ols.analogscope.default.visible.boolean", Boolean.toString(this.showAnalogScope.isSelected()));
        properties.put("ols.show.tool.windows.default.boolean", Boolean.toString(this.showToolWindows.isSelected()));
        properties.put("ols.channellabels.show.channel.index.boolean", Boolean.toString(this.showChannelIndexes.isSelected()));
        properties.put("ols.retain.annotations.boolean", Boolean.toString(this.retainAnnotations.isSelected()));
        properties.put("ols.trigger.auto.center.boolean", Boolean.toString(this.autoCenterCapture.isSelected()));
        properties.put("ols.signal.alignment.enum", String.valueOf(this.signalAlignment.getSelectedItem()));
        properties.put("ols.signal.annotation.alignment.enum", String.valueOf(this.annotationAlignment.getSelectedItem()));
        String colorScheme = (String)this.colorScheme.getSelectedItem();
        if (colorScheme != null) {
            this.purgeOldColorScheme(properties);
            this.applyNewColorScheme(colorScheme, properties);
        }
        this.config.update(properties);
    }

    private void buildDialog() {
        this.setTitle("Preferences");
        JButton okButton = StandardActionFactory.createOkButton();
        JButton cancelButton = StandardActionFactory.createCancelButton();
        JComponent buttonPane = SwingComponentUtils.createButtonPane((JButton[])new JButton[]{okButton, cancelButton});
        JPanel contentPane = new JPanel(new BorderLayout(4, 4));
        contentPane.add((Component)this.createGeneralSettingsTab(), "Center");
        contentPane.add((Component)buttonPane, "Last");
        this.setContentPane(contentPane);
        this.pack();
    }

    private JComponent createGeneralSettingsTab() {
        JPanel pane = new JPanel(new SpringLayout());
        SpringLayoutUtils.addSeparator((Container)pane, (String)"Look and feel defaults");
        pane.add(SwingComponentUtils.createRightAlignedLabel((String)"Mouse wheel zooms?"));
        pane.add(this.mouseWheelZooms);
        pane.add(SwingComponentUtils.createRightAlignedLabel((String)"Snap cursor to edge?"));
        pane.add(this.cursorSnapToEdge);
        pane.add(SwingComponentUtils.createRightAlignedLabel((String)"Show group summary?"));
        pane.add(this.showGroupSummary);
        pane.add(SwingComponentUtils.createRightAlignedLabel((String)"Show analog scope?"));
        pane.add(this.showAnalogScope);
        pane.add(SwingComponentUtils.createRightAlignedLabel((String)"Show channel indexes?"));
        pane.add(this.showChannelIndexes);
        pane.add(SwingComponentUtils.createRightAlignedLabel((String)"Retain annotations?"));
        pane.add(this.retainAnnotations);
        pane.add(SwingComponentUtils.createRightAlignedLabel((String)"Show tool windows?"));
        pane.add(this.showToolWindows);
        pane.add(SwingComponentUtils.createRightAlignedLabel((String)"Auto-center on trigger?"));
        pane.add(this.autoCenterCapture);
        pane.add(SwingComponentUtils.createRightAlignedLabel((String)"Signal alignment"));
        pane.add(this.signalAlignment);
        pane.add(SwingComponentUtils.createRightAlignedLabel((String)"Annotation alignment"));
        pane.add(this.annotationAlignment);
        SpringLayoutUtils.addSeparator((Container)pane, (String)"Color scheme");
        pane.add(SwingComponentUtils.createRightAlignedLabel((String)"Default scheme"));
        pane.add(this.colorScheme);
        SpringLayoutUtils.makeEditorGrid((Container)pane, (int)10, (int)10);
        return pane;
    }

    private boolean getBoolean(Object aValue) {
        if (aValue instanceof Boolean) {
            return (Boolean)aValue;
        }
        return Boolean.parseBoolean(String.valueOf(aValue));
    }

    private SignalDiagramModel.SignalAlignment getSignalAlignment(Object aValue) {
        if (aValue == null) {
            return SignalDiagramModel.SignalAlignment.CENTER;
        }
        return SignalDiagramModel.SignalAlignment.valueOf(aValue.toString().toUpperCase());
    }

    private void purgeOldColorScheme(Dictionary<String, Object> dictionary) {
        String oldColorScheme = (String)dictionary.get("ols.current.color.scheme.enum");
        Properties props = this.colorSchemeManager.getColorScheme(oldColorScheme);
        if (props == null) {
            return;
        }
        for (Object key : props.keySet()) {
            Object value = props.get(key);
            if (!(value instanceof Color)) continue;
            dictionary.put((String)key, "");
        }
    }

    static final class SignalAlignmentRenderer
    extends EnumItemRenderer<SignalDiagramModel.SignalAlignment> {
        private static final long serialVersionUID = 1L;

        SignalAlignmentRenderer() {
        }

        protected String getDisplayValue(SignalDiagramModel.SignalAlignment aValue) {
            switch (aValue) {
                case BOTTOM: {
                    return "Bottom";
                }
                case CENTER: {
                    return "Center";
                }
                case TOP: {
                    return "Top";
                }
            }
            return super.getDisplayValue((Enum)aValue);
        }
    }

    final class ColorSchemeModel
    extends AbstractListModel
    implements ComboBoxModel {
        private static final long serialVersionUID = 1L;
        private volatile int selected = -1;

        ColorSchemeModel() {
        }

        @Override
        public Object getElementAt(int aIndex) {
            List<String> schemes = PreferencesDialog.this.colorSchemeManager.getColorSchemes();
            if (aIndex < 0 || aIndex >= schemes.size()) {
                return null;
            }
            return schemes.get(aIndex);
        }

        @Override
        public Object getSelectedItem() {
            return this.getElementAt(this.selected);
        }

        @Override
        public int getSize() {
            return PreferencesDialog.this.colorSchemeManager.getColorSchemeCount();
        }

        @Override
        public void setSelectedItem(Object aItem) {
            List<String> schemes = PreferencesDialog.this.colorSchemeManager.getColorSchemes();
            this.selected = schemes.indexOf(aItem);
        }
    }
}

