/*
 * Decompiled with CFR 0.152.
 */
package nl.lxtreme.ols.client.about;

import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.net.URL;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import nl.lxtreme.ols.client.icons.IconLocator;

final class AboutPane
extends JPanel {
    private static final long serialVersionUID = 1L;
    private static final String ABOUT_MESSAGE = "<html><body><h3>%s</h3><p>\u00a9 Copyright 2006-2010 Michael Poppitz<br>\u00a9 Copyright 2010-2013 J.W. Janssen<br><br></p><p>This software is released under the GNU GPLv2 license.<br><br></p><p>Version: %s<br><br></p><p>For more information see:</p><ul><li><a href='http://ols.lxtreme.nl/'>http://ols.lxtreme.nl</a>;</li><li><a href='https://github.com/jawi/ols/wiki/FAQ'>https://github.com/jawi/ols/wiki/FAQ</a>;</li><li><a href='http://dangerousprototypes.com/open-logic-sniffer'>http://dangerousprototypes.com/open-logic-sniffer</a>;</li><li><a href='http://www.gadgetfactory.net/gf/project/butterflylogic'>http://www.gadgetfactory.net/gf/project/butterflylogic</a>;</li><li><a href='http://www.sump.org/projects/analyzer'>http://www.sump.org/projects/analyzer</a>.</li></ul></body></html>";

    private AboutPane() {
        super(new GridBagLayout());
    }

    public static AboutPane create(String aName, String aVersion) {
        AboutPane result = new AboutPane();
        result.buildPanel(aName, aVersion);
        return result;
    }

    void buildPanel(String aName, String aVersion) {
        this.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        URL url = IconLocator.class.getResource("logo.png");
        JLabel iconLabel = new JLabel(new ImageIcon(url));
        iconLabel.setBackground(Color.WHITE);
        JLabel aboutMsg = new JLabel(String.format(ABOUT_MESSAGE, aName, aVersion));
        this.add((Component)iconLabel, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 11, 2, new Insets(0, 0, 5, 0), 0, 0));
        this.add((Component)aboutMsg, new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 11, 1, new Insets(5, 10, 5, 10), 0, 0));
    }
}

