/*
 * Decompiled with CFR 0.152.
 */
package nl.lxtreme.ols.client.action;

import java.awt.event.ActionEvent;
import javax.swing.JMenuItem;
import nl.lxtreme.ols.client.ClientController;
import nl.lxtreme.ols.client.action.BaseAction;

public class SelectDeviceAction
extends BaseAction {
    private static final long serialVersionUID = 1L;
    private static final String ID = "SelectDevice.";
    private final String deviceName;

    public SelectDeviceAction(ClientController aController, String aDeviceName) {
        super(SelectDeviceAction.getID(aDeviceName), aController, aDeviceName, "Selects ".concat(aDeviceName).concat(" as current capturing device"));
        this.deviceName = aDeviceName;
        char mnemonic = Character.toUpperCase(aDeviceName.charAt(0));
        if (Character.isLetterOrDigit(mnemonic)) {
            this.putValue("MnemonicKey", mnemonic);
        }
    }

    public static final String getID(String aDeviceName) {
        return ID.concat(aDeviceName);
    }

    @Override
    public void actionPerformed(ActionEvent aEvent) {
        JMenuItem menuItem = (JMenuItem)aEvent.getSource();
        this.getController().selectDevice(menuItem.isSelected() ? this.deviceName : null);
    }
}

