/*
 * Decompiled with CFR 0.152.
 */
package nl.lxtreme.ols.client.icons;

import java.awt.Image;
import java.awt.Toolkit;
import java.net.URL;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import nl.lxtreme.ols.client.icons.IconLocator;
import nl.lxtreme.ols.util.swing.component.icon.TextOverlayIcon;
import org.osgi.framework.Bundle;
import org.osgi.framework.FrameworkUtil;

public final class IconFactory {
    private static final Logger LOG = Logger.getLogger(IconFactory.class.getName());

    private IconFactory() {
    }

    public static Icon createIcon(String aIconName) {
        try {
            URL url = IconFactory.getResource(aIconName);
            if (url != null) {
                return new ImageIcon(url);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return new ImageIcon();
    }

    public static Image createImage(String aImageName) {
        URL url = IconFactory.getResource(aImageName);
        return Toolkit.getDefaultToolkit().createImage(url);
    }

    public static Icon createOverlayIcon(String aIconName, String aText) {
        return new CompoundTextIcon(aIconName, aText, 3);
    }

    private static URL getResource(String aIconName) {
        URL resource;
        Bundle bundle = FrameworkUtil.getBundle(IconLocator.class);
        if (bundle == null) {
            resource = IconLocator.class.getResource(aIconName);
            LOG.log(Level.FINE, "Get icon resource without bundle: {0} => {1}...", new Object[]{aIconName, resource});
        } else {
            String path = IconLocator.class.getPackage().getName().replaceAll("\\.", "/");
            resource = bundle.getResource(path + "/" + aIconName);
            LOG.log(Level.FINE, "Get icon resource from bundle: {0} => {1}...", new Object[]{aIconName, resource});
        }
        return resource;
    }

    public static class CompoundTextIcon
    extends TextOverlayIcon {
        private static final long serialVersionUID = 1L;

        public CompoundTextIcon(String aIconName, String aTextOverlay) {
            super(IconFactory.createIcon(aIconName), aTextOverlay);
        }

        public CompoundTextIcon(String aIconName, String aTextOverlay, int aPosition) {
            super(IconFactory.createIcon(aIconName), aTextOverlay, aPosition);
        }
    }
}

