/*
 * Decompiled with CFR 0.152.
 */
package nl.lxtreme.ols.client.signaldisplay;

import java.awt.Component;
import java.awt.Point;
import java.awt.Rectangle;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JScrollPane;
import javax.swing.JViewport;
import javax.swing.UIManager;
import nl.lxtreme.ols.api.acquisition.AcquisitionResult;
import nl.lxtreme.ols.api.data.Cursor;
import nl.lxtreme.ols.api.data.DataSet;
import nl.lxtreme.ols.api.data.project.Project;
import nl.lxtreme.ols.client.Activator;
import nl.lxtreme.ols.client.action.SmartJumpAction;
import nl.lxtreme.ols.client.actionmanager.IActionManager;
import nl.lxtreme.ols.client.actionmanager.IManagedAction;
import nl.lxtreme.ols.client.signaldisplay.ICursorChangeListener;
import nl.lxtreme.ols.client.signaldisplay.IDataModelChangeListener;
import nl.lxtreme.ols.client.signaldisplay.IMeasurementListener;
import nl.lxtreme.ols.client.signaldisplay.SignalDiagramComponent;
import nl.lxtreme.ols.client.signaldisplay.ZoomController;
import nl.lxtreme.ols.client.signaldisplay.dnd.DragAndDropTargetController;
import nl.lxtreme.ols.client.signaldisplay.model.SignalDiagramModel;
import nl.lxtreme.ols.client.signaldisplay.signalelement.ElementGroup;
import nl.lxtreme.ols.client.signaldisplay.signalelement.ISignalElementChangeListener;
import nl.lxtreme.ols.client.signaldisplay.signalelement.IUIElement;
import nl.lxtreme.ols.client.signaldisplay.signalelement.SignalElement;
import nl.lxtreme.ols.client.signaldisplay.util.SmartJumpHelper;
import nl.lxtreme.ols.client.signaldisplay.view.ChannelLabelsView;
import nl.lxtreme.ols.util.swing.SwingComponentUtils;

public final class SignalDiagramController
implements ZoomController.ZoomListener,
PropertyChangeListener {
    private final DragAndDropTargetController dndTargetController;
    private final IActionManager actionManager;
    private SignalDiagramModel signalDiagramModel;
    private SignalDiagramComponent signalDiagram;

    public SignalDiagramController(IActionManager aActionManager) {
        this.actionManager = aActionManager;
        this.dndTargetController = new DragAndDropTargetController(this);
    }

    public void addChannelChangeListener(ISignalElementChangeListener aListener) {
        this.getSignalDiagramModel().getSignalElementManager().addChannelChangeListener(aListener);
    }

    public void addCursorChangeListener(ICursorChangeListener aListener) {
        this.getSignalDiagramModel().addCursorChangeListener(aListener);
    }

    public void addDataModelChangeListener(IDataModelChangeListener aListener) {
        this.getSignalDiagramModel().addDataModelChangeListener(aListener);
    }

    public void addMeasurementListener(IMeasurementListener aListener) {
        this.getSignalDiagramModel().addMeasurementListener(aListener);
    }

    public void addPropertyChangeListener(PropertyChangeListener aListener) {
        this.getSignalDiagramModel().addPropertyChangeListener(aListener);
    }

    public final IActionManager getActionManager() {
        return this.actionManager;
    }

    public Cursor[] getDefinedCursors() {
        return this.getSignalDiagramModel().getDefinedCursors();
    }

    public final DragAndDropTargetController getDndTargetController() {
        return this.dndTargetController;
    }

    public final SignalDiagramComponent getSignalDiagram() {
        return this.signalDiagram;
    }

    public final SignalDiagramModel getSignalDiagramModel() {
        return this.signalDiagramModel;
    }

    public SignalElement.SignalElementType getSignalHoverType(Point aPoint) {
        IUIElement element = this.getSignalDiagramModel().findUIElement(aPoint);
        if (element instanceof SignalElement) {
            return ((SignalElement)element).getType();
        }
        return null;
    }

    public ZoomController getZoomController() {
        return this.signalDiagramModel.getZoomController();
    }

    public void initialize() {
        SignalDiagramModel model = new SignalDiagramModel(this);
        this.setSignalDiagramModel(model);
        model.getZoomController().addZoomListener(this);
        SignalDiagramComponent diagram = new SignalDiagramComponent(this);
        this.setSignalDiagram(diagram);
    }

    public boolean isCursorDefined(int aCursorIdx) {
        return this.getSignalDiagramModel().isCursorDefined(aCursorIdx);
    }

    public boolean isCursorMode() {
        return this.getSignalDiagramModel().isCursorMode();
    }

    public void moveCursor(int aCursorIdx, Point aPoint) {
        long newCursorTimestamp = this.locationToTimestamp(aPoint);
        this.getSignalDiagramModel().setCursor(aCursorIdx, newCursorTimestamp);
    }

    @Override
    public void notifyZoomChange(final ZoomController.ZoomEvent aEvent) {
        final boolean dataAvailable = this.getSignalDiagramModel().hasData();
        SwingComponentUtils.invokeOnEDT((Runnable)new Runnable(){

            @Override
            public void run() {
                ZoomController zoomCtrl = aEvent.getZoomController();
                IManagedAction zoomInAction = SignalDiagramController.this.getActionManager().getAction("ZoomIn");
                zoomInAction.setEnabled(dataAvailable && zoomCtrl.canZoomIn());
                IManagedAction zoomOutAction = SignalDiagramController.this.getActionManager().getAction("ZoomOut");
                zoomOutAction.setEnabled(dataAvailable && zoomCtrl.canZoomOut());
                IManagedAction zoomAllAction = SignalDiagramController.this.getActionManager().getAction("ZoomFit");
                zoomAllAction.setEnabled(dataAvailable && !zoomCtrl.isZoomAll());
                IManagedAction zoomOriginalAction = SignalDiagramController.this.getActionManager().getAction("ZoomDefault");
                zoomOriginalAction.setEnabled(dataAvailable && !zoomCtrl.isZoomDefault());
                JScrollPane scrollPane = (JScrollPane)SwingComponentUtils.getAncestorOfClass(JScrollPane.class, (Component)SignalDiagramController.this.getSignalDiagram());
                if (scrollPane == null) {
                    return;
                }
                JViewport viewport = scrollPane.getViewport();
                JViewport timelineViewport = scrollPane.getColumnHeader();
                Component view = viewport.getView();
                if (Activator.isDebugMode()) {
                    System.out.printf("Handling %s.%n", aEvent);
                }
                view.setPreferredSize(aEvent.getDimension());
                viewport.doLayout();
                view.setLocation(aEvent.getLocation());
                timelineViewport.doLayout();
                timelineViewport.repaint();
            }
        });
    }

    @Override
    public void propertyChange(PropertyChangeEvent aEvent) {
        String name = aEvent.getPropertyName();
        if ("project".equals(name)) {
            Project project = (Project)aEvent.getNewValue();
            this.setDataModel(project.getDataSet());
        } else if ("capturedData".equals(name)) {
            DataSet dataSet = (DataSet)aEvent.getNewValue();
            this.setDataModel(dataSet);
            this.getZoomController().restoreZoomLevel();
        }
    }

    public void revalidateAll() {
        this.signalDiagram.revalidateAll();
        this.signalDiagram.repaintAll();
    }

    public void removeChannelChangeListener(ISignalElementChangeListener aListener) {
        this.getSignalDiagramModel().getSignalElementManager().removeChannelChangeListener(aListener);
    }

    public void removeCursor(int aCursorIdx) {
        this.getSignalDiagramModel().removeCursor(aCursorIdx);
    }

    public void removeCursorChangeListener(ICursorChangeListener aListener) {
        this.getSignalDiagramModel().removeCursorChangeListener(aListener);
    }

    public void removeDataModelChangeListener(IDataModelChangeListener aListener) {
        this.getSignalDiagramModel().removeDataModelChangeListener(aListener);
    }

    public void removeMeasurementListener(IMeasurementListener aListener) {
        this.getSignalDiagramModel().removeMeasurementListener(aListener);
    }

    public void removePropertyChangeListener(PropertyChangeListener aListener) {
        this.getSignalDiagramModel().removePropertyChangeListener(aListener);
    }

    public void scrollToTimestamp(long aTimestamp) {
        this.getSignalDiagram().scrollToTimestamp(aTimestamp);
    }

    public void setCursorMode(boolean aVisible) {
        this.getSignalDiagramModel().setCursorMode(aVisible);
    }

    public void setDataModel(DataSet aDataSet) {
        this.getSignalDiagramModel().setDataModel(aDataSet);
        this.revalidateAll();
        boolean autoCenterOnTrigger = UIManager.getBoolean("ols.trigger.auto.center.boolean");
        final AcquisitionResult capturedData = aDataSet.getCapturedData();
        if (autoCenterOnTrigger && capturedData != null && capturedData.hasTriggerData()) {
            SwingComponentUtils.invokeOnEDT((Runnable)new Runnable(){

                @Override
                public void run() {
                    SignalDiagramController.this.scrollToTimestamp(capturedData.getTriggerPosition());
                }
            });
        }
    }

    public void setDefaultSettings() {
        boolean snapCursorsDefault = UIManager.getBoolean("ols.snap.cursors.default.boolean");
        boolean snapCursorsValue = this.getSignalDiagramModel().isSnapCursorMode();
        if (snapCursorsValue ^ snapCursorsDefault) {
            this.setSnapModeEnabled(snapCursorsDefault);
        }
    }

    public void setMeasurementMode(boolean aEnabled) {
        this.getSignalDiagramModel().setMeasurementMode(aEnabled);
    }

    public void setSelectedChannel(Point aPosition) {
        ChannelLabelsView channelLabelsView;
        SignalDiagramModel model = this.getSignalDiagramModel();
        IUIElement element = model.findUIElement(aPosition);
        if (!(element instanceof SignalElement)) {
            return;
        }
        SignalElement signalElement = (SignalElement)element;
        int oldIndex = model.getSelectedChannelIndex();
        int newIndex = -1;
        if (signalElement.isDigitalSignal()) {
            newIndex = signalElement.getChannel().getIndex();
        }
        if (oldIndex != newIndex) {
            model.setSelectedChannelIndex(newIndex);
        }
        if ((channelLabelsView = this.getChannelLabelsView()) != null) {
            SignalElement currentElement;
            Rectangle rect;
            int width = channelLabelsView.getWidth();
            if (signalElement != null) {
                rect = new Rectangle(0, signalElement.getYposition(), width, signalElement.getHeight());
                channelLabelsView.repaint(rect);
                ElementGroup signalGroup = signalElement.getGroup();
                rect = new Rectangle(0, signalGroup.getYposition(), width, signalGroup.getHeight());
                channelLabelsView.repaint(rect);
            }
            if ((currentElement = model.getSignalElementManager().getDigitalSignalByChannelIndex(oldIndex)) != null) {
                rect = new Rectangle(0, currentElement.getYposition(), width, currentElement.getHeight());
                channelLabelsView.repaint(rect);
                ElementGroup currentGroup = currentElement.getGroup();
                rect = new Rectangle(0, currentGroup.getYposition(), width, currentGroup.getHeight());
                channelLabelsView.repaint(rect);
            }
        }
    }

    public void setSnapModeEnabled(boolean aSnapMode) {
        this.getSignalDiagramModel().setSnapCursorMode(aSnapMode);
    }

    public void smartJump(int aChannelIndex, SmartJumpAction.JumpType aType, SmartJumpAction.JumpDirection aDirection) {
        SmartJumpHelper jumpHelper = new SmartJumpHelper(this, aDirection, aType);
        long timestamp = jumpHelper.getSmartJumpPosition(aChannelIndex);
        if (timestamp >= 0L) {
            this.scrollToTimestamp(timestamp);
        }
    }

    final void setSignalDiagram(SignalDiagramComponent aComponent) {
        this.signalDiagram = aComponent;
    }

    final void setSignalDiagramModel(SignalDiagramModel aSignalDiagramModel) {
        this.signalDiagramModel = aSignalDiagramModel;
    }

    private ChannelLabelsView getChannelLabelsView() {
        JScrollPane scrollPane = (JScrollPane)SwingComponentUtils.getAncestorOfClass(JScrollPane.class, (Component)this.getSignalDiagram());
        if (scrollPane != null) {
            return (ChannelLabelsView)scrollPane.getRowHeader().getView();
        }
        return null;
    }

    private long locationToTimestamp(Point aPoint) {
        return this.signalDiagram.getModel().locationToTimestamp(aPoint);
    }
}

