/*
 * Decompiled with CFR 0.152.
 */
package nl.lxtreme.ols.client.signaldisplay;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.EventListener;
import java.util.concurrent.atomic.AtomicReference;
import javax.swing.JComponent;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.event.EventListenerList;
import nl.lxtreme.ols.client.signaldisplay.SignalDiagramComponent;
import nl.lxtreme.ols.client.signaldisplay.SignalDiagramController;
import nl.lxtreme.ols.client.signaldisplay.model.SignalDiagramModel;
import nl.lxtreme.ols.util.swing.SwingComponentUtils;

public final class ZoomController {
    static final int MAX_COMP_WIDTH = 0x7FFF0000;
    private static final double DEFAULT_ZOOM_FACTOR = 1.0;
    private static final double DEFAULT_ZOOM_RATIO = 2.0;
    private final SignalDiagramController controller;
    private final EventListenerList eventListeners;
    private final AtomicReference<ZoomStateHolder> zoomHolderRef;

    public ZoomController(SignalDiagramController aController) {
        this.controller = aController;
        this.eventListeners = new EventListenerList();
        this.zoomHolderRef = new AtomicReference<ZoomStateHolder>(new ZoomStateHolder());
    }

    public void addZoomListener(ZoomListener aListener) {
        this.eventListeners.add(ZoomListener.class, aListener);
    }

    public boolean canZoomIn() {
        double maxZoomLevel = this.getMaxZoomLevel();
        double zoomFactor = this.getFactor();
        return zoomFactor < maxZoomLevel;
    }

    public boolean canZoomOut() {
        double minZoomLevel = this.getMinZoomLevel();
        double zoomFactor = this.getFactor();
        return zoomFactor > minZoomLevel;
    }

    public double getFactor() {
        ZoomStateHolder zh = this.zoomHolderRef.get();
        double result = zh.factor;
        if (Double.isNaN(result)) {
            result = 1.0;
        }
        return result;
    }

    public boolean isZoomAll() {
        ZoomStateHolder zh = this.zoomHolderRef.get();
        ZoomAction value = zh.lastAction;
        return value == ZoomAction.ALL;
    }

    public boolean isZoomDefault() {
        ZoomStateHolder zh = this.zoomHolderRef.get();
        ZoomAction value = zh.lastAction;
        return value == ZoomAction.DEFAULT;
    }

    public void removeZoomListener(ZoomListener aListener) {
        this.eventListeners.remove(ZoomListener.class, aListener);
    }

    public void restoreZoomLevel() {
        ZoomAction action = ZoomAction.DEFAULT;
        double factor = 1.0;
        ZoomStateHolder zh = this.zoomHolderRef.get();
        if (zh != null) {
            action = zh.lastAction;
            factor = zh.factor;
        }
        if (action == null || ZoomAction.IN == action || ZoomAction.OUT == action) {
            action = ZoomAction.RESTORE;
        }
        this.performZoomAction(action, factor, null);
    }

    public void zoom(int aRotation, Point aPoint) {
        if (aRotation > 0) {
            double ratio = 1.0 / ((double)aRotation * 2.0);
            this.performZoomAction(ZoomAction.OUT, ratio, aPoint);
        } else if (aRotation < 0) {
            double ratio = (double)(-aRotation) * 2.0;
            this.performZoomAction(ZoomAction.IN, ratio, aPoint);
        }
    }

    public void zoomAll() {
        this.performZoomAction(ZoomAction.ALL, 0.0, null);
    }

    public void zoomDefault() {
        this.performZoomAction(ZoomAction.DEFAULT, 0.0, null);
    }

    public void zoomIn() {
        this.performZoomAction(ZoomAction.IN, 2.0, null);
    }

    public void zoomMaximum() {
        this.performZoomAction(ZoomAction.MAXIMUM, 0.0, null);
    }

    public void zoomOut() {
        this.performZoomAction(ZoomAction.OUT, 0.5, null);
    }

    public boolean zoomRegion(Point aPoint1, Point aPoint2) {
        return !(aPoint1.distance(aPoint2) < 10.0);
    }

    private ZoomStateHolder calculateNewZoomState(ZoomAction aAction, double aFactor) {
        double newFactor;
        double oldFactor = this.getFactor();
        double minZoomLevel = this.getMinZoomLevel();
        double maxZoomLevel = this.getMaxZoomLevel();
        double defaultZoomLevel = Math.max(minZoomLevel, 1.0);
        ZoomAction newValue = aAction;
        switch (aAction) {
            case IN: 
            case OUT: {
                newFactor = aFactor * oldFactor;
                break;
            }
            case ALL: {
                newFactor = minZoomLevel;
                break;
            }
            case MAXIMUM: {
                newFactor = maxZoomLevel;
                break;
            }
            case DEFAULT: {
                newFactor = defaultZoomLevel;
                break;
            }
            default: {
                newFactor = oldFactor;
            }
        }
        if (Math.abs(newFactor - defaultZoomLevel) < 1.0E-6) {
            newFactor = defaultZoomLevel;
            newValue = ZoomAction.DEFAULT;
        }
        if ((double)Double.compare(newFactor, minZoomLevel) <= 0.0) {
            newFactor = minZoomLevel;
            newValue = ZoomAction.ALL;
        } else if ((double)Double.compare(newFactor, maxZoomLevel) >= 0.0) {
            newFactor = maxZoomLevel;
            newValue = ZoomAction.MAXIMUM;
        }
        return new ZoomStateHolder(newValue, newFactor);
    }

    private Rectangle calculateVisibleViewRect(ZoomStateHolder aZoomState, Point aCenterPoint) {
        JScrollPane scrollPane;
        int minimumHeight;
        SignalDiagramComponent signalDiagram = this.getSignalDiagram();
        SignalDiagramModel model = this.getModel();
        Point currentLocation = signalDiagram.getLocation();
        Rectangle currentVisibleRect = signalDiagram.getVisibleRect();
        int mx = aCenterPoint != null ? aCenterPoint.x : (int)currentVisibleRect.getCenterX();
        Rectangle visibleRect = new Rectangle();
        double relFactor = aZoomState.factor / this.getFactor();
        switch (aZoomState.lastAction) {
            case IN: 
            case OUT: {
                Dimension viewSize = signalDiagram.getPreferredSize();
                visibleRect.width = (int)((double)viewSize.width * relFactor);
                visibleRect.height = currentVisibleRect.height;
                visibleRect.x = (int)Math.round((double)currentLocation.x - (double)mx * relFactor + (double)mx);
                visibleRect.y = currentLocation.y;
                break;
            }
            case ALL: {
                Dimension outerViewSize = this.getOuterViewSize(signalDiagram, true, true);
                visibleRect.width = outerViewSize.width;
                visibleRect.height = outerViewSize.height;
                visibleRect.x = 0;
                visibleRect.y = currentLocation.y;
                break;
            }
            case MAXIMUM: 
            case DEFAULT: {
                visibleRect.width = (int)((double)model.getAbsoluteLength() * aZoomState.factor);
                visibleRect.height = currentVisibleRect.height;
                visibleRect.x = (int)Math.round((double)currentLocation.x - (double)mx * relFactor + (double)mx);
                visibleRect.y = currentLocation.y;
                break;
            }
            default: {
                visibleRect.width = (int)((double)model.getAbsoluteLength() * aZoomState.factor);
                visibleRect.height = currentVisibleRect.height;
                visibleRect.x = currentLocation.x;
                visibleRect.y = currentLocation.y;
            }
        }
        int maxX = visibleRect.width - currentVisibleRect.width;
        if (Math.abs(visibleRect.x) > maxX) {
            visibleRect.x = -maxX;
        }
        if (visibleRect.x > 0) {
            visibleRect.x = -visibleRect.x;
        }
        if (visibleRect.height < (minimumHeight = model.getMinimumHeight())) {
            visibleRect.height = minimumHeight;
        }
        if (visibleRect.width > currentVisibleRect.width && (scrollPane = (JScrollPane)SwingComponentUtils.getAncestorOfClass(JScrollPane.class, (Component)signalDiagram)) != null) {
            JScrollBar horizontalScrollBar = scrollPane.getHorizontalScrollBar();
            int sbHeight = horizontalScrollBar.getHeight();
            if (!horizontalScrollBar.isVisible() && visibleRect.height > minimumHeight + sbHeight && visibleRect.height == currentVisibleRect.height) {
                visibleRect.height -= sbHeight;
            }
        }
        return visibleRect;
    }

    private ZoomEvent createZoomEvent(ZoomAction aAction, double aFactor, Rectangle aVisibleRect) {
        return new ZoomEvent(aAction, aFactor, aVisibleRect);
    }

    private void fireZoomEvent(ZoomEvent aEvent) {
        ZoomListener[] listeners;
        for (ZoomListener listener : listeners = (ZoomListener[])this.eventListeners.getListeners(ZoomListener.class)) {
            listener.notifyZoomChange(aEvent);
        }
    }

    private double getMaxZoomLevel() {
        SignalDiagramModel model = this.getModel();
        if (!model.hasData()) {
            return 1.0;
        }
        double length = model.getAbsoluteLength();
        return 2.147418112E9 / length;
    }

    private double getMinZoomLevel() {
        SignalDiagramComponent signalDiagram = this.getSignalDiagram();
        SignalDiagramModel model = signalDiagram.getModel();
        if (!model.hasData()) {
            return 1.0;
        }
        double width = this.getOuterViewSize((JComponent)signalDiagram, (boolean)true, (boolean)true).width;
        double length = model.getAbsoluteLength();
        double min = 4.656754985961486E-10;
        return Math.max(4.656754985961486E-10, width / length);
    }

    private SignalDiagramModel getModel() {
        return this.controller.getSignalDiagramModel();
    }

    private SignalDiagramComponent getSignalDiagram() {
        return this.controller.getSignalDiagram();
    }

    private void performZoomAction(ZoomAction aAction, double aFactor, Point aCenterPoint) {
        ZoomStateHolder oldState;
        ZoomStateHolder newState = this.calculateNewZoomState(aAction, aFactor);
        Rectangle visibleRect = this.calculateVisibleViewRect(newState, aCenterPoint);
        while (!this.zoomHolderRef.compareAndSet(oldState = this.zoomHolderRef.get(), newState)) {
        }
        this.fireZoomEvent(this.createZoomEvent(aAction, aFactor, visibleRect));
    }

    private Dimension getOuterViewSize(JComponent aComponent, boolean aIncludeVertScrollbar, boolean aIncludeHorzScrollbar) {
        Rectangle rect = aComponent.getVisibleRect();
        JScrollPane scrollPane = (JScrollPane)SwingComponentUtils.getAncestorOfClass(JScrollPane.class, (Component)aComponent);
        if (scrollPane != null) {
            JScrollBar scrollBar = scrollPane.getVerticalScrollBar();
            if (aIncludeVertScrollbar && scrollBar.isVisible()) {
                rect.width += scrollBar.getWidth();
            }
            scrollBar = scrollPane.getHorizontalScrollBar();
            if (aIncludeHorzScrollbar && scrollBar.isVisible()) {
                rect.height += scrollBar.getHeight();
            }
            Insets insets = scrollPane.getViewport().getInsets();
            rect.width -= insets.left + insets.right;
            rect.height -= insets.top + insets.bottom;
        }
        return rect.getSize();
    }

    private static class ZoomStateHolder {
        final double factor;
        final ZoomAction lastAction;

        public ZoomStateHolder() {
            this(ZoomAction.DEFAULT, 1.0);
        }

        public ZoomStateHolder(ZoomAction aAction, double aFactor) {
            this.lastAction = aAction;
            this.factor = aFactor;
        }
    }

    public static interface ZoomListener
    extends EventListener {
        public void notifyZoomChange(ZoomEvent var1);
    }

    public final class ZoomEvent {
        private final double factor;
        private final ZoomAction action;
        private final Rectangle visibleRect;

        public ZoomEvent(ZoomAction aAction, double aFactor, Rectangle aVisibleRect) {
            this.action = aAction;
            this.factor = aFactor;
            this.visibleRect = aVisibleRect;
        }

        public Dimension getDimension() {
            return this.visibleRect.getSize();
        }

        public double getFactor() {
            return this.factor;
        }

        public Point getLocation() {
            return this.visibleRect.getLocation();
        }

        public ZoomController getZoomController() {
            return ZoomController.this;
        }

        public String toString() {
            return String.format("ZoomEvent: (Action = %s, ZF = %f, Rect = %s)", new Object[]{this.action, this.getFactor(), this.visibleRect});
        }
    }

    public static enum ZoomAction {
        RESTORE,
        IN,
        OUT,
        DEFAULT,
        ALL,
        MAXIMUM;

    }
}

