/*
 * Decompiled with CFR 0.152.
 */
package nl.lxtreme.ols.client.signaldisplay.action;

import java.awt.AWTEvent;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.SpringLayout;
import nl.lxtreme.ols.api.data.Cursor;
import nl.lxtreme.ols.client.signaldisplay.SignalDiagramController;
import nl.lxtreme.ols.client.signaldisplay.action.EditSignalElementPropertiesAction;
import nl.lxtreme.ols.client.signaldisplay.model.SignalDiagramModel;
import nl.lxtreme.ols.util.swing.SpringLayoutUtils;
import nl.lxtreme.ols.util.swing.StandardActionFactory;
import nl.lxtreme.ols.util.swing.SwingComponentUtils;

public class EditCursorPropertiesAction
extends AbstractAction {
    private static final long serialVersionUID = 1L;
    private final SignalDiagramController controller;
    private final Cursor cursor;

    public EditCursorPropertiesAction(SignalDiagramController aController, Cursor aCursor) {
        super("Cursor Properties");
        this.controller = aController;
        this.cursor = aCursor;
    }

    @Override
    public void actionPerformed(ActionEvent aEvent) {
        EditCursorDialog dialog = new EditCursorDialog(SwingComponentUtils.getOwningWindow((AWTEvent)aEvent), this.cursor);
        if (dialog.showDialog()) {
            SignalDiagramModel model = this.controller.getSignalDiagramModel();
            model.setCursorLabel(this.cursor.getIndex(), dialog.getLabel());
            model.setCursorColor(this.cursor.getIndex(), dialog.getColor());
        }
    }

    static final class EditCursorDialog
    extends JDialog
    implements StandardActionFactory.StatusAwareCloseableDialog {
        private static final long serialVersionUID = 1L;
        private final String defaultLabel;
        private final Color defaultColor;
        private JTextField labelEditor;
        private EditSignalElementPropertiesAction.JColorEditor colorEditor;
        boolean dialogResult = false;

        public EditCursorDialog(Window aParent, Cursor aCursor) {
            super(aParent, Dialog.ModalityType.APPLICATION_MODAL);
            this.setResizable(false);
            this.defaultLabel = aCursor.getLabel();
            this.defaultColor = aCursor.getColor();
            this.initDialog(aCursor);
        }

        public void close() {
            this.setVisible(false);
            this.dispose();
        }

        public Color getColor() {
            return this.colorEditor.getColor();
        }

        public String getLabel() {
            return this.labelEditor.getText();
        }

        public boolean setDialogStatus(StandardActionFactory.DialogStatus aStatus) {
            this.dialogResult = aStatus == StandardActionFactory.DialogStatus.OK;
            return true;
        }

        public boolean showDialog() {
            this.dialogResult = false;
            this.setVisible(true);
            return this.dialogResult;
        }

        protected void applyDefaultProperties() {
            this.labelEditor.setText(this.defaultLabel);
            this.colorEditor.setColor(this.defaultColor);
        }

        private void initDialog(Cursor aCursor) {
            this.setTitle("Edit cursor properties");
            JLabel labelEditorLabel = SwingComponentUtils.createRightAlignedLabel((String)"Label");
            this.labelEditor = new JTextField(aCursor.getLabel(), 10);
            JLabel colorEditorLabel = SwingComponentUtils.createRightAlignedLabel((String)"Color");
            this.colorEditor = new EditSignalElementPropertiesAction.JColorEditor(aCursor.getColor());
            JButton okButton = StandardActionFactory.createOkButton();
            JButton cancelButton = StandardActionFactory.createCancelButton();
            JButton resetButton = new JButton("Reset to defaults");
            resetButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent aEvent) {
                    EditCursorDialog.this.applyDefaultProperties();
                }
            });
            JPanel resetButtonPanel = new JPanel();
            resetButtonPanel.add((Component)resetButton, "After");
            JPanel editorPane = new JPanel(new SpringLayout());
            editorPane.add(labelEditorLabel);
            editorPane.add(this.labelEditor);
            editorPane.add(colorEditorLabel);
            editorPane.add(this.colorEditor);
            editorPane.add(new JLabel(""));
            editorPane.add(resetButtonPanel);
            SpringLayoutUtils.makeEditorGrid((Container)editorPane, (int)10, (int)10);
            JComponent buttonPane = SwingComponentUtils.createButtonPane((JButton[])new JButton[]{okButton, cancelButton});
            JPanel contentPane = new JPanel(new BorderLayout(4, 4));
            contentPane.add((Component)editorPane, "Center");
            contentPane.add((Component)buttonPane, "Last");
            this.setContentPane(contentPane);
            this.pack();
        }
    }
}

